/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.j2eedt.ui.action;

import com.genuitec.eclipse.j2eedt.core.Messages;
import com.genuitec.eclipse.j2eedt.ui.J2EEUICore;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class ClearValidationMarkersAction
implements IWorkbenchWindowActionDelegate {
    private ISelection selection;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        if (this.selection instanceof IStructuredSelection && !this.selection.isEmpty()) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            try {
                workbench.getProgressService().run(false, true, (IRunnableWithProgress)new RemoveMarkersRunnable(((IStructuredSelection)this.selection).toArray()));
            }
            catch (InvocationTargetException e) {
                J2EEUICore.getDefault().log(e);
            }
            catch (InterruptedException e) {
                J2EEUICore.getDefault().log(e);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public static class RemoveMarkersRunnable
    implements IRunnableWithProgress {
        private final Object[] resources;

        public RemoveMarkersRunnable(Object[] resource) {
            this.resources = resource;
        }

        public void run(IProgressMonitor monitor) {
            monitor.beginTask(Messages.ClearValidationMarkersAction_taskname, this.resources.length);
            int i = 0;
            while (i < this.resources.length) {
                block7: {
                    IResource resource;
                    block6: {
                        Object object;
                        block5: {
                            if (monitor.isCanceled()) {
                                return;
                            }
                            object = this.resources[i];
                            if (!(object instanceof IResource)) break block5;
                            resource = (IResource)object;
                            break block6;
                        }
                        if (!(object instanceof IAdaptable) || (resource = (IResource)((IAdaptable)object).getAdapter(IResource.class)) == null) break block7;
                    }
                    this.removeAllTasks(resource);
                    monitor.worked(1);
                }
                ++i;
            }
            monitor.done();
        }

        private void removeAllTasks(IResource resource) {
            try {
                IMarker[] markers = RemoveMarkersRunnable.getValidationTasks(resource);
                ResourcesPlugin.getWorkspace().deleteMarkers(markers);
            }
            catch (CoreException e) {
                J2EEUICore.getDefault().log(e);
            }
        }

        private static IMarker[] getValidationTasks(IResource resource) throws CoreException {
            IMarker[] allMarkers = resource.findMarkers("org.eclipse.wst.validation.problemmarker", true, 2);
            if (allMarkers != null) {
                return allMarkers;
            }
            return new IMarker[0];
        }
    }
}

