/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.j2eedt.facet.ui;

import com.genuitec.eclipse.core.portability.wizard.DialogField;
import com.genuitec.eclipse.core.portability.wizard.IDialogFieldListener;
import com.genuitec.eclipse.core.ui.wizard.dialogfield.MESelectionButtonDialogFieldGroup;
import com.genuitec.eclipse.j2eedt.facet.ui.FacetConfigurationControl;
import com.genuitec.eclipse.j2eedt.ui.J2EEUICore;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class FacetConfigurationRadioGroup
extends FacetConfigurationControl {
    private MESelectionButtonDialogFieldGroup versionSelection;
    private String[] radioCaptions;
    private IProjectFacetVersion[] facetVersions;
    private int lastSelected;

    public FacetConfigurationRadioGroup(String caption, String dataModelFacetId, String[] radioCaptions, IProjectFacetVersion[] facetVersions, int defaultSelection) {
        super(caption, dataModelFacetId);
        this.radioCaptions = radioCaptions;
        this.facetVersions = facetVersions;
        this.lastSelected = defaultSelection;
    }

    public FacetConfigurationRadioGroup(String caption, IProjectFacet facet, String notSelectedCaption, boolean selectDefault) {
        super(caption, notSelectedCaption != null ? null : facet.getId());
        try {
            this.lastSelected = 0;
            boolean optional = notSelectedCaption != null;
            IProjectFacetVersion defaultFacet = facet.getDefaultVersion();
            List versions = facet.getSortedVersions(true);
            int shift = 0;
            if (optional) {
                shift = 1;
            }
            this.facetVersions = new IProjectFacetVersion[versions.size() + shift];
            this.radioCaptions = new String[this.facetVersions.length];
            if (optional) {
                this.facetVersions[0] = null;
                this.radioCaptions[0] = notSelectedCaption;
            }
            int i = shift;
            while (i < this.radioCaptions.length) {
                IProjectFacetVersion pf;
                this.facetVersions[i] = pf = (IProjectFacetVersion)versions.get(i - shift);
                this.radioCaptions[i] = pf.toString();
                if (selectDefault && defaultFacet == pf) {
                    this.lastSelected = i;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            J2EEUICore.getDefault().log(e.getStatus());
            this.facetVersions = new IProjectFacetVersion[0];
            this.radioCaptions = new String[0];
        }
    }

    @Override
    public IProjectFacetVersion getSelectedFacetVersion() {
        return this.versionSelection == null || this.versionSelection.getSelectedIndex() < 0 ? null : this.facetVersions[this.versionSelection.getSelectedIndex()];
    }

    @Override
    protected void createSelectionControl(Composite parent) {
        this.versionSelection = new MESelectionButtonDialogFieldGroup(16, this.radioCaptions, this.radioCaptions.length);
        Composite wrapper = new Composite(parent, 0);
        wrapper.setLayout((Layout)new GridLayout(3, false));
        wrapper.setLayoutData((Object)new GridData(4, 4, false, false));
        this.versionSelection.doFillIntoGrid(wrapper, 3);
        this.versionSelection.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                if (FacetConfigurationRadioGroup.this.versionSelection.getSelectedIndex() >= 0) {
                    FacetConfigurationRadioGroup.this.lastSelected = FacetConfigurationRadioGroup.this.versionSelection.getSelectedIndex();
                    FacetConfigurationRadioGroup.this.modified();
                }
            }
        });
    }

    @Override
    public void updateSelectionEnablement(Set<IProjectFacetVersion> configuredFacets) {
        if (this.versionSelection != null) {
            int bestCandidate = -1;
            int i = 0;
            while (i < this.radioCaptions.length) {
                boolean enable;
                this.versionSelection.setSelection(i, false);
                IProjectFacetVersion fv = this.facetVersions[i];
                boolean bl = enable = fv == null;
                if (configuredFacets != null && !enable) {
                    try {
                        enable = fv.getActionDefinition(configuredFacets, IFacetedProject.Action.Type.INSTALL) != null;
                        Iterator<IProjectFacetVersion> it = configuredFacets.iterator();
                        while (it.hasNext() && enable) {
                            boolean bl2 = enable = !it.next().conflictsWith(fv);
                        }
                    }
                    catch (CoreException coreException) {}
                }
                this.versionSelection.enableSelectionButton(i, enable);
                if (enable && bestCandidate < this.lastSelected) {
                    bestCandidate = i;
                }
                ++i;
            }
            if (bestCandidate >= 0) {
                this.versionSelection.setSelection(bestCandidate, true);
            }
        }
    }
}

