/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.j2eedt.facet.ui;

import com.genuitec.eclipse.j2eedt.facet.ui.FacetConfigurationControl;
import com.genuitec.eclipse.j2eedt.ui.J2EEUICore;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class FacetConfigurationCombo
extends FacetConfigurationControl {
    protected Combo combo;
    protected int[] itemsMap;
    private String[] comboItems;
    protected IProjectFacetVersion[] facetVersions;
    protected int lastSelected;
    private ArrayList<String> tmp;

    public FacetConfigurationCombo(String caption, String dataModelFacetId, String[] comboItems, IProjectFacetVersion[] facetVersions, int defaultSelection) {
        super(caption, dataModelFacetId);
        this.comboItems = comboItems;
        this.facetVersions = facetVersions;
        this.lastSelected = defaultSelection;
    }

    public FacetConfigurationCombo(String caption, IProjectFacet facet, String notSelectedCaption, boolean selectDefault) {
        super(caption, notSelectedCaption != null ? null : facet.getId());
        try {
            this.lastSelected = 0;
            boolean optional = notSelectedCaption != null;
            IProjectFacetVersion defaultFacet = facet.getDefaultVersion();
            List versions = facet.getSortedVersions(true);
            int shift = 0;
            if (optional) {
                shift = 1;
            }
            this.facetVersions = new IProjectFacetVersion[versions.size() + shift];
            this.comboItems = new String[this.facetVersions.length];
            if (optional) {
                this.facetVersions[0] = null;
                this.comboItems[0] = notSelectedCaption;
            }
            int i = shift;
            while (i < this.comboItems.length) {
                IProjectFacetVersion pf;
                this.facetVersions[i] = pf = (IProjectFacetVersion)versions.get(i - shift);
                this.comboItems[i] = pf.getVersionString();
                if (selectDefault && defaultFacet == pf) {
                    this.lastSelected = i;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            J2EEUICore.getDefault().log(e.getStatus());
            this.facetVersions = new IProjectFacetVersion[0];
            this.comboItems = new String[0];
        }
    }

    @Override
    protected void createSelectionControl(Composite parent) {
        this.combo = new Combo(parent, 8);
        this.combo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (FacetConfigurationCombo.this.combo.getSelectionIndex() >= 0) {
                    FacetConfigurationCombo.this.lastSelected = FacetConfigurationCombo.this.itemsMap[FacetConfigurationCombo.this.combo.getSelectionIndex()];
                    FacetConfigurationCombo.this.modified();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.itemsMap = new int[this.comboItems.length];
        this.tmp = new ArrayList(this.comboItems.length);
    }

    @Override
    public IProjectFacetVersion getSelectedFacetVersion() {
        return this.combo == null || this.combo.getSelectionIndex() < 0 ? null : this.facetVersions[this.itemsMap[this.combo.getSelectionIndex()]];
    }

    public int getSelectionIndex() {
        return this.lastSelected;
    }

    @Override
    public void updateSelectionEnablement(Set<IProjectFacetVersion> configuredFacets) {
        if (this.combo != null) {
            int j = 0;
            int bestCandidate = -1;
            int bestCandidateMapped = -1;
            this.tmp.clear();
            int i = 0;
            while (i < this.comboItems.length) {
                boolean enable;
                IProjectFacetVersion fv = this.facetVersions[i];
                boolean bl = enable = fv == null;
                if (configuredFacets != null && !enable) {
                    try {
                        enable = fv.getActionDefinition(configuredFacets, IFacetedProject.Action.Type.INSTALL) != null;
                        Iterator<IProjectFacetVersion> it = configuredFacets.iterator();
                        while (it.hasNext() && enable) {
                            boolean bl2 = enable = !it.next().conflictsWith(fv);
                        }
                    }
                    catch (CoreException coreException) {}
                }
                if (enable) {
                    this.tmp.add(this.comboItems[i]);
                    if (bestCandidate < this.lastSelected) {
                        bestCandidate = i;
                        bestCandidateMapped = j;
                    }
                    this.itemsMap[j++] = i;
                }
                ++i;
            }
            this.combo.setItems(this.tmp.toArray(new String[this.tmp.size()]));
            if (bestCandidateMapped >= 0) {
                this.combo.select(bestCandidateMapped);
            }
        }
    }
}

