/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core.sourcelookup;

import com.genuitec.eclipse.core.sourcelookup.UpdatableCompositeSourceContainer;
import com.genuitec.eclipse.server.core.sourcelookup.ProjectClasspathContainerSourceContainer;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.sourcelookup.containers.ClasspathVariableSourceContainer;
import org.eclipse.jdt.launching.sourcelookup.containers.PackageFragmentRootSourceContainer;

public class ModuleProjectSourceContainer
extends UpdatableCompositeSourceContainer {
    public static final String TYPE_ID = "com.genuitec.eclipse.server.core.containerType.moduleProject";
    private static String[] fgJavaExtensions = null;
    private IJavaProject fProject;
    private ISourceContainer[] fSourceFolders;
    private ISourceContainer[] fBuildPathEntries;
    private ISourceContainer[] fOthers;
    private long classpathTimestamp;

    static {
        String[] extensions = JavaCore.getJavaLikeExtensions();
        fgJavaExtensions = new String[extensions.length];
        int i = 0;
        while (i < extensions.length) {
            String ext = extensions[i];
            ModuleProjectSourceContainer.fgJavaExtensions[i] = String.valueOf('.') + ext;
            ++i;
        }
    }

    public ModuleProjectSourceContainer(IJavaProject project) {
        this.fProject = project;
    }

    protected ISourceContainer[] createSourceContainers() throws CoreException {
        ArrayList<Object> containers = new ArrayList<Object>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (this.fProject.getProject().isOpen()) {
            IClasspathEntry[] entries = this.fProject.getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry entry = entries[i];
                switch (entry.getEntryKind()) {
                    case 3: {
                        IPath path = entry.getPath();
                        IResource resource = root.findMember(path);
                        if (!(resource instanceof IContainer)) break;
                        containers.add(new FolderSourceContainer((IContainer)resource, false));
                    }
                }
                ++i;
            }
        }
        this.fSourceFolders = containers.toArray(new ISourceContainer[containers.size()]);
        ProjectSourceContainer theProject = new ProjectSourceContainer(this.fProject.getProject(), false);
        this.fBuildPathEntries = this.collectBuildPathEntries();
        containers.addAll(Arrays.asList(this.fBuildPathEntries));
        this.fOthers = new ISourceContainer[]{theProject};
        containers.add(theProject);
        return containers.toArray(new ISourceContainer[containers.size()]);
    }

    private ISourceContainer[] collectBuildPathEntries() throws JavaModelException {
        ArrayList<ClasspathVariableSourceContainer> result = new ArrayList<ClasspathVariableSourceContainer>();
        IClasspathEntry[] iClasspathEntryArray = this.fProject.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.isExported() || this.isEntryDeployed(entry)) {
                Object sourceContainer = null;
                switch (entry.getEntryKind()) {
                    case 5: {
                        IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)this.fProject);
                        sourceContainer = new ProjectClasspathContainerSourceContainer(this.fProject, container.getPath());
                        break;
                    }
                    case 1: {
                        IPackageFragmentRoot[] roots = this.fProject.findPackageFragmentRoots(entry);
                        if (roots == null || roots.length <= 0) break;
                        sourceContainer = new PackageFragmentRootSourceContainer(roots[0]);
                        break;
                    }
                    case 4: {
                        sourceContainer = new ClasspathVariableSourceContainer(entry.getPath());
                        break;
                    }
                }
                if (sourceContainer != null && !result.contains(sourceContainer)) {
                    result.add((ClasspathVariableSourceContainer)sourceContainer);
                }
            }
            ++n2;
        }
        return result.toArray(new ISourceContainer[result.size()]);
    }

    private boolean isEntryDeployed(IClasspathEntry entry) {
        IClasspathAttribute[] iClasspathAttributeArray = entry.getExtraAttributes();
        int n = iClasspathAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathAttribute attr = iClasspathAttributeArray[n2];
            if ("org.eclipse.jst.component.dependency".equals(attr.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public IJavaProject getJavaProject() {
        return this.fProject;
    }

    public Object[] findSourceElements(String name) throws CoreException {
        this.getSourceContainers();
        if (this.isJavaLikeFileName(name)) {
            Object[] result;
            Object[] objects = this.findSourceElements(name, this.fSourceFolders);
            ArrayList<Object> filtered = null;
            int i = 0;
            while (i < objects.length) {
                Object object = objects[i];
                if (object instanceof IResource && !this.getJavaProject().isOnClasspath((IResource)object)) {
                    if (filtered == null) {
                        filtered = new ArrayList<Object>(objects.length);
                        int j = 0;
                        while (j < objects.length) {
                            filtered.add(objects[j]);
                            ++j;
                        }
                    }
                    filtered.remove(object);
                }
                ++i;
            }
            if ((objects.length == 0 || filtered != null && filtered.isEmpty()) && (result = this.findSourceElements(name, this.fBuildPathEntries)).length > 0) {
                return result;
            }
            if (filtered == null) {
                return objects;
            }
            return filtered.toArray();
        }
        return this.findSourceElements(name, this.fOthers);
    }

    private boolean isJavaLikeFileName(String name) {
        int i = 0;
        while (i < fgJavaExtensions.length) {
            String ext = fgJavaExtensions[i];
            if (name.endsWith(ext)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void dispose() {
        this.fSourceFolders = null;
        this.fOthers = null;
        this.fBuildPathEntries = null;
        super.dispose();
    }

    public String getName() {
        return this.fProject.getElementName();
    }

    public ISourceContainerType getType() {
        return this.getSourceContainerType(TYPE_ID);
    }

    protected boolean needsUpdate() {
        long oldTimestamp = this.classpathTimestamp;
        this.classpathTimestamp = this.fProject.getProject().getFile(".classpath").getModificationStamp();
        return oldTimestamp != this.classpathTimestamp;
    }
}

