/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core.monitor;

import com.genuitec.eclipse.monitor.DataType;
import com.genuitec.eclipse.monitor.collector.IMetricsCollector;
import com.genuitec.eclipse.monitor.collector.IMetricsDataRecord;
import com.genuitec.eclipse.monitor.collector.IMetricsLongIntRecord;
import com.genuitec.eclipse.monitor.collector.IMetricsProvider;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRootDeployment;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerEvent;

public class ServerUsageMetricsProvider
implements IMetricsProvider {
    private static IPath PATH_SERVER = new Path("server");
    private static IPath PATH_DEPLOY_COUNT = new Path("deployCount");
    private static IPath PATH_DEPLOY_TIME = new Path("deployTime");
    private IMetricsCollector clientCollector;
    private IMetricsCollector serverCollector;
    private ServerLifecycleListener listener;

    public void startMonitoring(IMetricsCollector collector) {
        switch (collector.getDataTarget()) {
            case CLIENT: {
                this.clientCollector = collector;
                break;
            }
            case SERVER: {
                this.serverCollector = collector;
            }
        }
        if (this.listener == null) {
            this.listener = new ServerLifecycleListener();
        }
    }

    public void stopMonitoring(IMetricsCollector collector) {
        switch (collector.getDataTarget()) {
            case CLIENT: {
                this.clientCollector = null;
                break;
            }
            case SERVER: {
                this.serverCollector = null;
            }
        }
        if (this.clientCollector == null && this.serverCollector == null && this.listener != null) {
            try {
                this.listener.dispose();
            }
            finally {
                this.listener = null;
            }
        }
    }

    public void serverChanged(ServerEvent event) {
        if (event == null || event.getServer() == null || event.getServer().getId() == null || event.getServer().getServerType() == null) {
            return;
        }
        if (this.serverCollector != null && event.getServer().getServerState() == 1) {
            this.serverCollector.getMetricsLongIntRecord(PATH_SERVER.append(event.getServer().getServerType().getId())).inc(1L);
        }
        if (this.clientCollector != null && event.getModule() != null && (event.getKind() & 0x20) != 0 && (event.getKind() & 8) != 0) {
            if (event.getPublishState() == 0) {
                IRootDeployment[] deployments = event.getServer().getDeployments();
                boolean removeDeploymentCase = false;
                IRootDeployment[] iRootDeploymentArray = deployments;
                int n = deployments.length;
                int n2 = 0;
                while (n2 < n) {
                    IRootDeployment iRootDeployment = iRootDeploymentArray[n2];
                    if (event.getModule()[0].equals(iRootDeployment.getModule())) {
                        removeDeploymentCase = true;
                        break;
                    }
                    ++n2;
                }
                if (!removeDeploymentCase) {
                    this.deploymentStart(event.getServer(), event.getModule());
                }
            } else if (event.getPublishState() > 0 || event.getStatus() != null && event.getStatus().getSeverity() == 4) {
                this.deploymentFinish(event.getServer(), event.getModule());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deploymentFinish(IServer server, IModule[] module) {
        IMetricsLongIntRecord record;
        if (module.length > 1) {
            return;
        }
        this.clientCollector.getMetricsLongIntRecord(PATH_SERVER.append(server.getServerType().getId()).append(server.getId()).append(PATH_DEPLOY_COUNT)).inc(1L);
        IMetricsLongIntRecord iMetricsLongIntRecord = record = this.clientCollector.getMetricsLongIntRecord(PATH_SERVER.append(server.getServerType().getId()).append(server.getId()).append(PATH_DEPLOY_TIME));
        synchronized (iMetricsLongIntRecord) {
            Long startTime;
            Map module2startTime = (Map)record.getTemporaryData();
            if (module2startTime != null && (startTime = (Long)module2startTime.remove(module[0].getId())) != null) {
                record.inc(System.currentTimeMillis() - startTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deploymentStart(IServer server, IModule[] module) {
        IMetricsDataRecord record;
        IMetricsDataRecord iMetricsDataRecord = record = this.clientCollector.getMetricsDataRecord(PATH_SERVER.append(server.getServerType().getId()).append(server.getId()).append(PATH_DEPLOY_TIME), DataType.LONG_INT);
        synchronized (iMetricsDataRecord) {
            HashMap<String, Long> module2startTime = (HashMap<String, Long>)record.getTemporaryData();
            if (module2startTime == null) {
                module2startTime = new HashMap<String, Long>();
                record.setTemporaryData(module2startTime);
            }
            if (module2startTime.get(module[0].getId()) == null) {
                module2startTime.put(module[0].getId(), System.currentTimeMillis());
            }
        }
    }

    public void onDataStore(IMetricsCollector collector) {
    }

    private class ServerLifecycleListener
    implements IServerLifecycleListener,
    IServerListener {
        public ServerLifecycleListener() {
            IServer[] servers;
            ServerCore.addServerLifecycleListener((IServerLifecycleListener)this);
            IServer[] iServerArray = servers = ServerCore.getServers();
            int n = servers.length;
            int n2 = 0;
            while (n2 < n) {
                IServer server = iServerArray[n2];
                server.addServerListener((IServerListener)this);
                ++n2;
            }
        }

        public void dispose() {
            IServer[] servers;
            IServer[] iServerArray = servers = ServerCore.getServers();
            int n = servers.length;
            int n2 = 0;
            while (n2 < n) {
                IServer server = iServerArray[n2];
                server.removeServerListener((IServerListener)this);
                ++n2;
            }
            ServerCore.removeServerLifecycleListener((IServerLifecycleListener)this);
        }

        public void serverAdded(IServer server) {
            server.addServerListener((IServerListener)this);
        }

        public void serverChanged(IServer server) {
        }

        public void serverRemoved(IServer server) {
            server.removeServerListener((IServerListener)this);
        }

        public void serverChanged(ServerEvent event) {
            ServerUsageMetricsProvider.this.serverChanged(event);
        }
    }
}

