/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core.migration.internal;

import com.genuitec.eclipse.core.GenuitecCoreException;
import com.genuitec.eclipse.core.util.IndexedList;
import com.genuitec.eclipse.migration.core.MigratingObjectState;
import com.genuitec.eclipse.migration.core.MigrationPlugin;
import com.genuitec.eclipse.migration.core.internal.IMigrationManager;
import com.genuitec.eclipse.migration.core.internal.MigratingObject;
import com.genuitec.eclipse.migration.core.internal.MigratingObjectType;
import com.genuitec.eclipse.migration.core.internal.MigrationOperation;
import com.genuitec.eclipse.migration.core.internal.MigrationUtils;
import com.genuitec.eclipse.server.core.ServerCorePlugin;
import com.genuitec.eclipse.server.core.migration.ILegacyServer;
import com.genuitec.eclipse.server.core.migration.IMigratingServer;
import com.genuitec.eclipse.server.core.migration.internal.ServerMigrationManager;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.ServerType;

public class MigratingServer
extends MigratingObject<ILegacyServer>
implements IMigratingServer {
    static final String CONFIG_HASHES = "configHash";
    static final String USER_NOTIFIED_HASHES = "userInformed";
    private IServerWorkingCopy serverWorkingCopy;
    private IRuntimeWorkingCopy runtimeWorkingCopy;
    private boolean deleteRuntimeWorkingCopy;

    public MigratingServer(ILegacyServer object, boolean forceRefresh) {
        super((Object)object, (IMigrationManager)ServerMigrationManager.getInstance(), forceRefresh);
    }

    public MigratingServer(ILegacyServer object, MigratingObjectType<ILegacyServer> objectType) {
        super((Object)object, objectType);
    }

    public String getName() {
        return ((ILegacyServer)this.object).getName();
    }

    protected void setConfigHashes(String hashes, boolean userNotifiedHash) throws GenuitecCoreException {
        ((ILegacyServer)this.object).setMigrationProperty(userNotifiedHash ? USER_NOTIFIED_HASHES : CONFIG_HASHES, hashes);
    }

    protected String getConfigHashes(boolean userNotifiedHash) {
        return ((ILegacyServer)this.object).getMigrationProperty(userNotifiedHash ? USER_NOTIFIED_HASHES : CONFIG_HASHES, null);
    }

    public String getMigrationProperty(String key, String defaultValue) {
        return ((ILegacyServer)this.object).getMigrationProperty(key, defaultValue);
    }

    public void setMigrationProperty(String key, String value) {
        ((ILegacyServer)this.object).setMigrationProperty(key, value);
    }

    protected boolean isAccessible() {
        return ((ILegacyServer)this.object).getTargetServerType() != null;
    }

    protected void internalRevalidate(List<IStatus> result) {
        if (this.serverWorkingCopy == null || this.runtimeWorkingCopy == null) {
            ILegacyServer server = (ILegacyServer)this.object;
            IServerType serverType = server.getTargetServerType();
            if (serverType == null) {
                result.add(MigrationUtils.createCriticalError((String)"Connector for the server is not installed.", (Object[])new Object[0]));
                return;
            }
            IRuntimeType rt = serverType.getRuntimeType();
            if (rt == null) {
                result.add(MigrationUtils.createCriticalError((String)"Server Type {0} [{1}] does not have a runtime type assigned.", (Object[])new Object[]{serverType.getName(), serverType.getId()}));
                return;
            }
            IRuntime runtime = ServerCore.findRuntime((String)server.getTargetRuntimeId());
            if (!(runtime == null || runtime.getRuntimeType() != null && runtime.getRuntimeType().equals(rt))) {
                result.add(ServerCorePlugin.createErrorStatus("Server runtime {0}[{1}] is already defined, but it is of unsupported type. It needs to be removed before migration can be performed.", runtime.getName(), runtime.getId()));
                return;
            }
            if (ServerCore.findServer((String)this.serverWorkingCopy.getId()) != null) {
                result.add(MigrationUtils.createCriticalError((String)"Server with id {0} is already defined.", (Object[])new Object[]{this.serverWorkingCopy.getId()}));
            }
        }
    }

    protected void cleanupBeforeUpdate() {
    }

    protected void initializeObjectMigrOpsAdvSimulation() throws CoreException {
    }

    protected void internalDispose() {
    }

    protected void initOperationsRefresh() {
    }

    protected void simulateOperationChanges(MigrationOperation<ILegacyServer> operation) {
    }

    protected void initilizeMigrationProcessBeforeStateUpdate() {
    }

    protected void initilizeMigrationProcessStart() throws CoreException {
        this.serverWorkingCopy = null;
        this.runtimeWorkingCopy = null;
        ILegacyServer server = this.getLegacyServer();
        IServerType serverType = server.getTargetServerType();
        if (serverType == null) {
            return;
        }
        IRuntimeType rt = serverType.getRuntimeType();
        if (rt == null) {
            return;
        }
        IRuntime runtime = ServerCore.findRuntime((String)server.getTargetRuntimeId());
        if (!(runtime == null || runtime.getRuntimeType() != null && runtime.getRuntimeType().equals(rt))) {
            return;
        }
        if (runtime == null) {
            this.runtimeWorkingCopy = rt.createRuntime(server.getTargetRuntimeId(), null);
            this.runtimeWorkingCopy.save(true, null);
            this.deleteRuntimeWorkingCopy = true;
        } else {
            this.runtimeWorkingCopy = runtime.createWorkingCopy();
            this.deleteRuntimeWorkingCopy = false;
        }
        this.serverWorkingCopy = serverType.createServer(server.getTargetServerId(), null, this.runtimeWorkingCopy.getOriginal(), null);
        this.serverWorkingCopy.setName(String.valueOf(serverType.getName()) + " (migrated)");
    }

    protected void initilizeMigrationProcessFinish() {
    }

    @Override
    public ILegacyServer getLegacyServer() {
        return (ILegacyServer)this.getObject();
    }

    @Override
    public IServerWorkingCopy getServerWorkingCopy() {
        this.beginRead();
        try {
            MigratingObjectState state = this.getState();
            if (state != MigratingObjectState.MIGRATING && state != MigratingObjectState.MIGRATION_CONFIG) {
                throw new IllegalStateException(MessageFormat.format("Cannot acquire server working copy if project is not in the state of MIGRATION_CONFIG or MIGRATING. Error for server {0}.", this.getName()));
            }
            IServerWorkingCopy iServerWorkingCopy = this.serverWorkingCopy;
            return iServerWorkingCopy;
        }
        finally {
            this.endRead();
        }
    }

    @Override
    public IRuntimeWorkingCopy getRuntimeWorkingCopy() {
        this.beginRead();
        try {
            MigratingObjectState state = this.getState();
            if (state != MigratingObjectState.MIGRATING && state != MigratingObjectState.MIGRATION_CONFIG) {
                throw new IllegalStateException(MessageFormat.format("Cannot acquire runtime working copy if project is not in the state of MIGRATION_CONFIG or MIGRATING. Error for server {0}.", this.getName()));
            }
            IRuntimeWorkingCopy iRuntimeWorkingCopy = this.runtimeWorkingCopy;
            return iRuntimeWorkingCopy;
        }
        finally {
            this.endRead();
        }
    }

    protected void internalCancelMigration() {
        if (this.deleteRuntimeWorkingCopy && this.runtimeWorkingCopy != null) {
            try {
                this.runtimeWorkingCopy.getOriginal().delete();
            }
            catch (CoreException e) {
                ServerCorePlugin.getDefault().log(e);
            }
        }
    }

    protected void performCleanup(SubMonitor monitor) throws CoreException {
        IServer server = ServerCore.findServer((String)((ILegacyServer)this.object).getTargetServerId());
        if (server != null && !((ServerType)server.getServerType()).startBeforePublish()) {
            server.publish(2, null, null, null);
        }
    }

    protected void internalPostMigration() {
        this.deleteRuntimeWorkingCopy = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalPerformMigration(IndexedList<String, MigrationOperation<ILegacyServer>> operations, SubMonitor monitor) throws CoreException {
        monitor.beginTask(MessageFormat.format("Migrating server {0}", this.getName()), operations.getItemList().size() * 3 + 4);
        Object object = this.operationsLock;
        synchronized (object) {
            for (MigrationOperation op : operations.getItemList()) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                try {
                    monitor.subTask("");
                    op.perform(0, monitor.newChild(2, 6));
                }
                catch (Throwable t) {
                    throw new GenuitecCoreException("Operation \"{0}\" has failed to perform migration actions. Error for server {1}.", (Plugin)MigrationPlugin.getDefault(), t, new Object[]{op.getName(), ((ILegacyServer)this.object).getName()});
                }
                op.storePerformedOperationVersion();
            }
        }
    }
}

