/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core.legacy;

import com.genuitec.eclipse.core.util.Util;
import com.genuitec.eclipse.j2eedt.core.IJEEProject;
import com.genuitec.eclipse.j2eedt.core.IWebProject;
import com.genuitec.eclipse.j2eedt.core.J2EEProjectUtil;
import com.genuitec.eclipse.j2eedt.core.JEEProjectManager;
import com.genuitec.eclipse.j2eedt.core.version.JEEProjectType;
import com.genuitec.eclipse.server.core.GenuitecAppServerBehaviour;
import com.genuitec.eclipse.server.core.IGenuitecServerLaunchConfig;
import com.genuitec.eclipse.server.core.ServerCorePlugin;
import com.genuitec.eclipse.server.core.jsp.debug.ICompiledJspProducer;
import com.genuitec.eclipse.server.core.legacy.EASIEServer;
import com.genuitec.eclipse.server.core.legacy.EASIEServerManager;
import com.genuitec.eclipse.server.core.legacy.IAppServer2;
import com.genuitec.eclipse.server.core.legacy.LegacyGenuitecServer;
import com.genuitec.eclipse.server.core.legacy.LegacyGenuitecServerLaunchConfig;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.wst.server.core.model.DeployMode;
import org.eclipse.wst.server.core.model.IPublishedModuleDeployment;
import org.eclipse.wst.server.core.model.ModuleDeltaKind;
import org.eclipse.wst.server.core.model.PublishDeltaKind;

public class LegacyGenuitecServerBehaviour
extends GenuitecAppServerBehaviour
implements ICompiledJspProducer {
    public static int j2eeProjectTypeToDeploymentType(JEEProjectType theProjectType) {
        if (theProjectType == null) {
            return 0;
        }
        switch (theProjectType) {
            case EAR: {
                return 4;
            }
            case EJB: {
                return 2;
            }
            case APP_CLIENT: {
                return 8;
            }
            case WEB: {
                return 1;
            }
            case JCA: {
                return 16;
            }
            case WEB_FRAGMENT: {
                return 32;
            }
            case UTILITY: {
                return 64;
            }
        }
        return 0;
    }

    public EASIEServerManager getEASIEServerManager() {
        return this.getLegacyGenuitecServer().getEASIEServerManager(this);
    }

    public EASIEServer getEASIEServer() {
        return this.getLegacyGenuitecServer().getEASIEServer(this);
    }

    public LegacyGenuitecServer getLegacyGenuitecServer() {
        return (LegacyGenuitecServer)this.getServer().loadAdapter(LegacyGenuitecServer.class, null);
    }

    @Override
    protected String getDeploymentLocation(IPublishedModuleDeployment rootDeployment) throws CoreException {
        IJEEProject theProject = JEEProjectManager.create((IProject)rootDeployment.getModule().getProject());
        if (theProject == null) {
            if (rootDeployment.getModuleDeltaKind() == ModuleDeltaKind.REMOVED && rootDeployment.getLocation() != null) {
                return rootDeployment.getLocation();
            }
            throw new CoreException(ServerCorePlugin.createErrorStatus("Module {0} does not map to a JEE project", rootDeployment));
        }
        EASIEServer server = this.getEASIEServer();
        int serverProjectType = LegacyGenuitecServerBehaviour.j2eeProjectTypeToDeploymentType(theProject.getType());
        Path deployPath = null;
        boolean isExploded = rootDeployment.getDeployMode() != DeployMode.PACKAGED;
        deployPath = isExploded ? new Path(server.getExplodedDeploymentLocation(serverProjectType)) : new Path(server.getPackagedDeploymentLocation(serverProjectType));
        switch (theProject.getType()) {
            case EAR: 
            case EJB: 
            case APP_CLIENT: 
            case JCA: 
            case WEB_FRAGMENT: 
            case UTILITY: {
                boolean containsExtension;
                String projectName = theProject.getName();
                String archiveName = theProject.getArchiveName();
                deployPath = deployPath.append(isExploded || Util.isNullOrEmpty((String)archiveName) ? projectName : archiveName);
                boolean bl = containsExtension = !Util.isNullOrEmpty((String)deployPath.getFileExtension());
                if (containsExtension || (!isExploded || !server.useSuffixOnExplodedDirs()) && isExploded) break;
                deployPath = deployPath.addFileExtension(J2EEProjectUtil.getProjectTypeFileExtension((IJEEProject)theProject));
                break;
            }
            case WEB: {
                IWebProject webProject = (IWebProject)theProject;
                Path ctxRootPath = new Path(webProject.getContextRoot());
                if (ctxRootPath.isRoot()) {
                    String srvrRootCtx = server.getExplodedRootContextDirName();
                    if (srvrRootCtx == null || !isExploded) {
                        deployPath = deployPath.append(webProject.getName());
                        if (webProject.getName().indexOf(".") != -1 || isExploded) break;
                        deployPath = deployPath.addFileExtension(JEEProjectType.WEB.getArchiveExtension().substring(1));
                        break;
                    }
                    deployPath = deployPath.append(srvrRootCtx);
                    break;
                }
                if (ctxRootPath.segmentCount() != 1) {
                    deployPath = null;
                    break;
                }
                deployPath = deployPath.append(webProject.getContextRoot());
                if (!server.useSuffixOnExplodedDirs() && isExploded) break;
                deployPath = deployPath.addFileExtension(JEEProjectType.WEB.getArchiveExtension().substring(1));
            }
        }
        return deployPath.toOSString();
    }

    @Override
    protected IGenuitecServerLaunchConfig createServerLaunchConfig(boolean isShutdown) {
        return new LegacyGenuitecServerLaunchConfig(this, isShutdown);
    }

    @Override
    protected ILaunch internalStop() throws CoreException {
        return this.getEASIEServerManager().internalStop();
    }

    protected ILaunch normalStop() throws CoreException {
        return super.internalStop();
    }

    @Override
    public void publishDeployment(PublishDeltaKind publishDelta, IPublishedModuleDeployment rootDeployment, IProgressMonitor m) throws CoreException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)m, (int)1000);
        EASIEServer server = this.getEASIEServer();
        server.beforeDeploymentPublish(publishDelta, rootDeployment, monitor.newChild(50));
        if (server instanceof IAppServer2 && (rootDeployment.getModuleDeltaKind() == ModuleDeltaKind.REMOVED || rootDeployment.getModuleDeltaKind() == ModuleDeltaKind.DEPLOY_MODE_CHANGED || publishDelta == PublishDeltaKind.PUBLISH_CLEAN) && rootDeployment.getLocation() != null) {
            ((IAppServer2)((Object)server)).beforeUndeployment((IPath)new Path(rootDeployment.getLocation()), rootDeployment.getDeployMode() == DeployMode.EXPLODED, LegacyGenuitecServerBehaviour.j2eeProjectTypeToDeploymentType(JEEProjectType.forId((String)rootDeployment.getModule().getId())));
        }
        super.publishDeployment(publishDelta, rootDeployment, (IProgressMonitor)monitor.newChild(900));
        if (server instanceof IAppServer2 && rootDeployment.getModuleDeltaKind() != ModuleDeltaKind.REMOVED && (publishDelta == PublishDeltaKind.PUBLISH_CLEAN || publishDelta == PublishDeltaKind.PUBLISH_FULL || rootDeployment.getModuleDeltaKind() == ModuleDeltaKind.DEPLOY_MODE_CHANGED)) {
            ((IAppServer2)((Object)server)).afterDeployment((IPath)new Path(rootDeployment.getLocation()), rootDeployment.getDeployMode() == DeployMode.EXPLODED, LegacyGenuitecServerBehaviour.j2eeProjectTypeToDeploymentType(JEEProjectType.forId((String)rootDeployment.getModule().getId())));
        }
        server.afterDeploymentPublish(publishDelta, rootDeployment, monitor.newChild(50));
    }

    @Override
    protected void terminate() {
        super.terminate();
    }

    @Override
    public String javaClassnameNameForJspPath(String theJspPath) {
        return this.getEASIEServer().javaClassnameNameForJspPath(theJspPath);
    }

    @Override
    public String jspPathForJavaClassname(String theJavaClassName) {
        return this.getEASIEServer().jspPathForJavaClassname(theJavaClassName);
    }

    @Override
    public boolean isProducedBy(String theJavaFilename) {
        return this.getEASIEServer().isProducedBy(theJavaFilename);
    }

    @Override
    protected void publishServer(int kind, IProgressMonitor monitor) throws CoreException {
        this.getEASIEServer().publishServer(kind, monitor);
        super.publishServer(kind, monitor);
    }
}

