/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core.deployment;

import com.genuitec.eclipse.core.GenuitecCoreException;
import com.genuitec.eclipse.core.util.Util;
import com.genuitec.eclipse.server.core.ServerCorePlugin;
import com.genuitec.eclipse.server.core.deployment.IDeploymentProcessorFactory;
import com.genuitec.eclipse.server.core.deployment.ModuleArchiver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.server.core.model.IPublishedModuleDeployment;
import org.eclipse.wst.server.core.model.ModuleDeltaKind;
import org.eclipse.wst.server.core.model.ModulePublishState;
import org.eclipse.wst.server.core.model.PublishDeltaKind;

public class DeploymentUtils {
    public static File getModuleDeploymentPhysicalLocation(IPublishedModuleDeployment moduleDeployment) {
        String loc = moduleDeployment.getLocation();
        if (Util.isNullOrEmpty((String)loc)) {
            return null;
        }
        Path location = new Path("");
        do {
            location = Path.fromOSString((String)moduleDeployment.getLocation()).append((IPath)location);
        } while ((moduleDeployment = moduleDeployment.getParentDeployment()) != null);
        return location.toFile();
    }

    public static void deleteDeployment(IPublishedModuleDeployment deployment, SubMonitor monitor, MultiStatus status) {
        File location = DeploymentUtils.getModuleDeploymentPhysicalLocation(deployment);
        if (location == null) {
            return;
        }
        monitor.subTask("cleaning output location");
        if (location.isDirectory()) {
            try {
                FileUtils.deleteDirectory((File)location);
            }
            catch (IOException iOException) {
                status.add(ServerCorePlugin.createStatus(2, "Cannot delete {0} directory.", location.toString()));
            }
        } else if (location.isFile() && !location.delete()) {
            status.add(ServerCorePlugin.createStatus(2, "Cannot delete {0} file.", location.toString()));
        }
    }

    public static PublishDeltaKind processChildDeployment(PublishDeltaKind publishDelta, IPublishedModuleDeployment child, String expectedLocation, SubMonitor monitor, MultiStatus status) throws GenuitecCoreException {
        if (expectedLocation == null && child.getModuleDeltaKind() != ModuleDeltaKind.REMOVED) {
            throw new GenuitecCoreException("Cannot determine location for deployment {0}", (Plugin)ServerCorePlugin.getDefault(), new String[]{child.toString()});
        }
        if (child.getModuleDeltaKind() == ModuleDeltaKind.REMOVED && child.getLocation() == null) {
            return null;
        }
        if (child.getLocation() != null && !child.getLocation().equals(expectedLocation) && publishDelta != PublishDeltaKind.PUBLISH_CLEAN) {
            DeploymentUtils.deleteDeployment(child, monitor.newChild(100), status);
            publishDelta = PublishDeltaKind.PUBLISH_CLEAN;
        } else if (child.getLocation() == null && child.getModuleDeltaKind() != ModuleDeltaKind.ADDED) {
            publishDelta = PublishDeltaKind.PUBLISH_CLEAN;
        }
        child.setLocation(expectedLocation);
        child.storeDeployMode();
        switch (child.getModuleDeltaKind()) {
            case DEPLOY_MODE_CHANGED: {
                if (publishDelta != PublishDeltaKind.PUBLISH_CLEAN) {
                    DeploymentUtils.deleteDeployment(child, monitor.newChild(100), status);
                }
                publishDelta = PublishDeltaKind.PUBLISH_CLEAN;
                break;
            }
            case REMOVED: {
                DeploymentUtils.deleteDeployment(child, monitor.newChild(100), status);
                publishDelta = null;
            }
        }
        return publishDelta;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void publishZip(IDeploymentProcessorFactory factory, PublishDeltaKind publishDelta, IPublishedModuleDeployment deployment, File targetFile, List<IVirtualComponent> componentsArchived, SubMonitor monitor, MultiStatus status) throws GenuitecCoreException {
        if (deployment.getModuleDeltaKind() != ModuleDeltaKind.NO_CHANGE || publishDelta == PublishDeltaKind.PUBLISH_CLEAN || publishDelta == PublishDeltaKind.PUBLISH_FULL) {
            DeploymentUtils.createFolder(targetFile.getParentFile());
            try {
                File output;
                boolean canDelete;
                block19: {
                    Exception coughtEx;
                    block21: {
                        canDelete = targetFile.renameTo(targetFile);
                        output = targetFile;
                        if (canDelete && targetFile.exists() && (output = new File(String.valueOf(targetFile.toString()) + ".tmp")).exists() && !output.delete()) {
                            throw new IOException("Cannot delete file: " + output.toString());
                        }
                        FileOutputStream fso = new FileOutputStream(output);
                        coughtEx = null;
                        try {
                            try {
                                ModuleArchiver saver = factory.createModuleArchiver(deployment, fso, status);
                                saver.setArchivedComponents(componentsArchived);
                                saver.processDeployment(monitor);
                            }
                            catch (Exception ex) {
                                block18: {
                                    coughtEx = ex;
                                    try {
                                        fso.close();
                                    }
                                    catch (IOException ex2) {
                                        if (coughtEx == null) break block18;
                                        throw ex2;
                                    }
                                }
                                if (coughtEx != null) {
                                    throw coughtEx;
                                }
                                break block19;
                            }
                        }
                        catch (Throwable throwable) {
                            block20: {
                                try {
                                    fso.close();
                                }
                                catch (IOException ex) {
                                    if (coughtEx == null) break block20;
                                    throw ex;
                                }
                            }
                            if (coughtEx == null) throw throwable;
                            throw coughtEx;
                        }
                        try {
                            fso.close();
                        }
                        catch (IOException ex) {
                            if (coughtEx == null) break block21;
                            throw ex;
                        }
                    }
                    if (coughtEx != null) {
                        throw coughtEx;
                    }
                }
                if (!canDelete || output == targetFile) return;
                if (targetFile.exists() && !targetFile.delete()) {
                    throw new IOException("Cannot delete file: " + targetFile);
                }
                if (output.renameTo(targetFile)) return;
                throw new IOException(MessageFormat.format("Cannot rename {0} to {1}", output.toString(), targetFile.toString()));
            }
            catch (Exception ex) {
                throw new GenuitecCoreException((Plugin)ServerCorePlugin.getDefault(), (Throwable)ex);
            }
        }
        deployment.setModulePublishState(ModulePublishState.PUBLISH_STATE_NONE);
    }

    public static void createFolder(File folder) throws GenuitecCoreException {
        if (!folder.exists()) {
            if (!folder.mkdirs()) {
                throw new GenuitecCoreException("Cannot create directory {0}.", (Plugin)ServerCorePlugin.getDefault(), new String[]{folder.getAbsolutePath()});
            }
        } else if (folder.isFile()) {
            throw new GenuitecCoreException("Destination path {0}, which should be a folder, is actually a file.", (Plugin)ServerCorePlugin.getDefault(), new String[]{folder.getAbsolutePath()});
        }
    }
}

