/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core;

import com.genuitec.eclipse.core.util.Util;
import com.genuitec.eclipse.server.core.IGenuitecServer;
import com.genuitec.eclipse.server.core.IGenuitecServerLaunchConfig;
import com.genuitec.eclipse.server.core.IGenuitecServerLaunchConfigProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;

public class ServerUtils {
    public static IGenuitecServerLaunchConfig getLaunchConfig(ILaunchConfiguration configuration) throws CoreException {
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        if (server == null) {
            return null;
        }
        IGenuitecServerLaunchConfigProvider provider = (IGenuitecServerLaunchConfigProvider)server.loadAdapter(IGenuitecServerLaunchConfigProvider.class, null);
        if (provider == null) {
            return null;
        }
        return provider.getServerLaunchConfig(configuration);
    }

    public static IServer getTargetServer(IProject project) {
        block5: {
            IRuntime serverRuntime;
            block6: {
                IFacetedProject fProj;
                if (project == null || !FacetedProjectFramework.isFacetedProject((IProject)project) || (fProj = ProjectFacetsManager.create((IProject)project)) == null) break block5;
                serverRuntime = ServerCore.findRuntime((String)fProj.getPrimaryRuntime().getName());
                if (serverRuntime != null) break block6;
                return null;
            }
            try {
                IServer[] iServerArray = ServerCore.getServers();
                int n = iServerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IServer server = iServerArray[n2];
                    if (serverRuntime.equals(server.getRuntime())) {
                        return server;
                    }
                    ++n2;
                }
                return null;
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public static List<IServer> getServersWithRuntime(org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime) {
        if (runtime == null) {
            return Collections.emptyList();
        }
        IRuntime serverRuntime = ServerCore.findRuntime((String)runtime.getName());
        if (serverRuntime == null) {
            return Collections.emptyList();
        }
        ArrayList<IServer> servers = new ArrayList<IServer>();
        IServer[] iServerArray = ServerCore.getServers();
        int n = iServerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            if (serverRuntime.equals(server.getRuntime())) {
                servers.add(server);
            }
            ++n2;
        }
        return servers;
    }

    public static String escapeServerId(String serverId) {
        StringBuffer escapeServerId = new StringBuffer();
        if (!Util.isNullOrEmpty((String)serverId)) {
            char[] cArray = serverId.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                Character ch = Character.valueOf(cArray[n2]);
                if (!Character.isDigit(ch.charValue()) && !Character.isLetter(ch.charValue())) {
                    escapeServerId.append('_');
                    escapeServerId.append(Integer.toHexString(ch.charValue()));
                    escapeServerId.append('_');
                } else {
                    escapeServerId.append(ch);
                }
                ++n2;
            }
        }
        return escapeServerId.toString();
    }

    public static IServer getDuplicateConfiguredServer(IServerWorkingCopy workingCopy, String attribute, String value) {
        IServer[] servers = ServerCore.getServers();
        if (servers == null || workingCopy == null || workingCopy.getServerType() == null) {
            return null;
        }
        IServer[] iServerArray = servers;
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            String value2;
            IGenuitecServer genuitecServer;
            IServer server = iServerArray[n2];
            if (!server.getId().equals(workingCopy.getId()) && server.getServerType() != null && server.getServerType().getId().equals(workingCopy.getServerType().getId()) && (genuitecServer = (IGenuitecServer)server.loadAdapter(IGenuitecServer.class, null)) != null && value.equals(value2 = genuitecServer.getServerAttribute(attribute))) {
                return server;
            }
            ++n2;
        }
        return null;
    }
}

