/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core;

import com.genuitec.eclipse.server.core.IGenuitecServer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.model.ServerDelegate;

public abstract class GenuitecServer
extends ServerDelegate
implements IGenuitecServer {
    private PropertyChangeListener propertyChangeListener;
    private List<IServerAttrsProvider> attrProviders = new ArrayList<IServerAttrsProvider>();
    private IAttributeStorage attrStore = new IAttributeStorage(){

        @Override
        public String getAttribute(String attr, String defaultValue) {
            return GenuitecServer.this.getAttribute(attr, defaultValue);
        }
    };

    protected void createAttributeProviders(List<IServerAttrsProvider> providers) {
    }

    protected void initialize() {
        super.initialize();
        if (this.getServerWorkingCopy() != null) {
            this.propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ((evt.getOldValue() instanceof String || evt.getOldValue() == null) && (evt.getNewValue() instanceof String || evt.getNewValue() == null)) {
                        GenuitecServer.this.serverAttributeChanged(evt.getPropertyName(), (String)evt.getOldValue(), (String)evt.getNewValue());
                    }
                }
            };
            this.getServerWorkingCopy().addPropertyChangeListener(this.propertyChangeListener);
        }
        this.createAttributeProviders(this.attrProviders);
        this.attrProviders = new ArrayList<IServerAttrsProvider>(this.attrProviders);
        for (IServerAttrsProvider provider : this.attrProviders) {
            provider.initialize(this, this.attrStore);
        }
    }

    public void dispose() {
        if (this.propertyChangeListener != null && this.getServerWorkingCopy() != null) {
            this.getServerWorkingCopy().addPropertyChangeListener(this.propertyChangeListener);
        }
        super.dispose();
    }

    public ServerPort[] getServerPorts() {
        return new ServerPort[0];
    }

    @Override
    public IStatus[] validate() {
        return new IStatus[0];
    }

    @Override
    public String getServerAttribute(String attr) {
        for (IServerAttrsProvider provider : this.attrProviders) {
            String res = provider.getServerAttribute(attr);
            if (res == null) continue;
            return res;
        }
        String result = this.internalGetServerAttribute(attr);
        if (result != null) {
            return result;
        }
        return this.getAttribute(attr, null);
    }

    protected String internalGetServerAttribute(String attr) {
        return null;
    }

    @Override
    public void setServerAttribute(String attr, String value) {
        this.setAttribute(attr, value);
    }

    protected void serverAttributeChanged(String attribute, String oldValue, String newValue) {
    }

    public static interface IAttributeStorage {
        public String getAttribute(String var1, String var2);
    }

    public static interface IServerAttrsProvider {
        public void initialize(IGenuitecServer var1, IAttributeStorage var2);

        public String getServerAttribute(String var1);
    }
}

