/*
 * Decompiled with CFR 0.152.
 */
package com.skyway.licensing;

import com.skyway.licensing.License;
import java.util.Date;

public abstract class AbstractLicense
implements License {
    private static Boolean isLicenseValid = null;
    private static Date expirationDate = null;
    private static Boolean isTrialValid = null;
    private static Boolean isTrial = null;

    @Override
    public abstract void enableCapabilities();

    @Override
    public abstract void disableCapabilities();

    @Override
    public abstract void disableCapabilitiesAndNag();

    public abstract Boolean isLicenseValidInternal();

    public abstract Date getExpirationDateInternal();

    public abstract Boolean isTrialValidInternal();

    public abstract Boolean isTrialInternal();

    @Override
    public abstract void handleInvalidOperation(String var1);

    @Override
    public abstract void warnTrialInvalid();

    public void clearLicenseCache() {
        isLicenseValid = null;
        expirationDate = null;
        isTrialValid = null;
        isTrial = null;
    }

    @Override
    public Boolean isLicenseValid() {
        if (isLicenseValid == null) {
            isLicenseValid = this.isLicenseValidInternal();
        }
        return isLicenseValid;
    }

    @Override
    public Date getExpirationDate() {
        if (expirationDate == null) {
            expirationDate = this.getExpirationDateInternal();
        }
        return expirationDate;
    }

    public Boolean isTrialValid() {
        if (isTrialValid == null) {
            isTrialValid = this.isTrialValidInternal();
        }
        return isTrialValid;
    }

    @Override
    public Boolean isTrial() {
        if (isTrial == null) {
            isTrial = this.isTrialInternal();
        }
        return isTrial;
    }

    @Override
    public void onProductStart() {
        if (this.isLicenseValid().booleanValue()) {
            this.enableCapabilities();
        } else {
            this.disableCapabilities();
        }
    }

    @Override
    public void runLicensed(String id, License.LicensedOperation op) {
        if (this.isOperationLicensed(id).booleanValue()) {
            op.run();
        } else {
            this.handleInvalidOperation(id);
        }
    }

    @Override
    public Boolean isOperationLicensed(String operation) {
        if (this.isLicenseValid().booleanValue()) {
            if (this.isOperationValidForProduct(operation).booleanValue()) {
                this.enableCapabilities();
                return true;
            }
            this.handleInvalidOperation(operation);
            this.disableCapabilities();
        } else {
            this.disableCapabilitiesAndNag();
        }
        return false;
    }

    @Override
    public Boolean verifyPluginSignature(String pluginid) {
        return true;
    }
}

