/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.activation;

import com.genuitec.eclipse.core.ActivationValidator;
import com.genuitec.eclipse.core.GenuitecCoreException;
import com.genuitec.eclipse.core.GenuitecCoreLicenseDialog;
import com.genuitec.eclipse.core.LicenseUtil;
import com.genuitec.eclipse.core.ViperCore;
import com.genuitec.eclipse.core.activation.ActivationCode;
import com.genuitec.eclipse.core.activation.InvalidSystemDataException;
import com.genuitec.eclipse.core.activation.ProductRegistrar;
import com.genuitec.eclipse.core.gsdc.GSDCController;
import com.genuitec.eclipse.core.util.PlatformUIUtil;
import com.genuitec.eclipse.core.util.PlatformUtil;
import com.genuitec.eclipse.core.util.StatusInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.runtime.IStatus;

public class ProductActivator {
    public static final int NETWORK_TIMEOUT_MILLIS = 30000;
    private static final char D = '|';
    public static final int ACT_METHOD_AUTO = 1;
    public static final int ACT_METHOD_MANUAL = 2;
    public static final int ACT_METHOD_DIRECT_ENTRY = 3;
    public static final int ACT_RESPONSE_SUCCESS = 0;
    public static final int ACT_NETWORK_CONNECT_ERROR = 1;
    public static final int ACT_NETWORK_DATA_ERROR = 2;
    public static final int ACT_STATE_ERROR = 3;
    public static final int ACT_RESPONSE_COUNTERFIET = 4;
    private static ProductActivator C = new ProductActivator();
    private int A;
    private String E;
    private IStatus B = PlatformUtil.getOKStatus();

    protected ProductActivator() {
    }

    public static ProductActivator getDefault() {
        return C;
    }

    public void clear() {
        this.A = 0;
        this.E = null;
        this.B = PlatformUtil.getOKStatus();
    }

    public void setup(int n) {
        this.A = n;
        this.E = null;
        this.B = PlatformUtil.getOKStatus();
    }

    protected String B(String string) {
        return MessageFormat.format(string, "Activation", "activation");
    }

    public IStatus doAutoActivation(String string, String string2) {
        StatusInfo statusInfo;
        block15: {
            statusInfo = null;
            boolean bl = false;
            IProxyData iProxyData = null;
            URL uRL = null;
            this.setup(1);
            if (PlatformUtil.isNullOrEmpty((String)string)) {
                statusInfo = new StatusInfo(4, "No subscription or product code available", 3);
                this.A((IStatus)statusInfo);
                return statusInfo;
            }
            if (PlatformUtil.isNullOrEmpty((String)string2)) {
                statusInfo = new StatusInfo(4, "No system identifier available", 3);
                this.A((IStatus)statusInfo);
                return statusInfo;
            }
            try {
                String string3 = ProductActivator.createURL(this.A(), string, string2, 1);
                uRL = new URL(string3);
                iProxyData = ViperCore.getDefault().getProxyData();
                if (iProxyData != null) {
                    ViperCore.getDefault().log(this.B("Attempting {1} using the configured proxy (" + iProxyData.toString() + ") \nwith URL (" + string3 + ")"), 1);
                } else {
                    ViperCore.getDefault().log(this.B("Attempting {1} using a direct connection with URL (" + string3 + ")"), 1);
                }
                statusInfo = this.A((URLConnection)this.openConnection(uRL, iProxyData));
                if (iProxyData != null) {
                    if (statusInfo.isOK()) {
                        ViperCore.getDefault().log(this.B("{0} successful using the configured proxy."), 1);
                    } else {
                        bl = true;
                        ViperCore.getDefault().log(this.B("{0} via the configured proxy failed: " + statusInfo.getMessage() + ".\nNow attempting {1} using a direct connection with URL (" + string3 + ")"), 4);
                        IStatus iStatus = this.A((URLConnection)this.openConnection(uRL, null));
                        if (iStatus.isOK()) {
                            ViperCore.getDefault().log(this.B("{0} successful using a direct connection after failure using the configured proxy."), 1);
                            statusInfo = iStatus;
                        }
                    }
                }
            }
            catch (Exception exception) {
                if (iProxyData == null) {
                    if (!(this instanceof ProductRegistrar)) {
                        ViperCore.getDefault().log(this.B("Direct {0}: The server at " + uRL.getAuthority() + " could not be reached using a direct network connection; \n" + exception.toString() + " exception occurred.\nIf the server is down or you''re not connected to the SDC network then {1} can occur at a later time. However, if the indicated IP address is incorrect then the server administrator will likely need to reconfigure the license packs so they contain the correct address."), 4);
                    }
                    statusInfo = new StatusInfo(2, this.B("Direct {0}: The {1} server at " + uRL.getAuthority() + " could not be reached using a direct network connection. Please see the MyEclipse log for more information."), 1);
                    this.A((IStatus)statusInfo);
                }
                if (statusInfo != null && statusInfo.isOK() || bl) break block15;
                ViperCore.getDefault().log(this.B("{0} via Proxy: Proxy does not appear to exist or is not configured properly. Will attempt {1} using a direct connection. Proxy data was (" + iProxyData.toString() + ")"), exception, 2);
                statusInfo = new StatusInfo(2, this.B("{0} via Proxy: Proxy does not appear to exist or is not configured properly. Will attempt {1} using a direct connection.  Please see the log for more details."), 1);
                this.A((IStatus)statusInfo);
                try {
                    bl = true;
                    IStatus iStatus = this.A((URLConnection)this.openConnection(uRL, null));
                    if (iStatus.isOK()) {
                        ViperCore.getDefault().log(this.B("{0} successful using a direct connection after failure using the configured proxy."), 1);
                        statusInfo = iStatus;
                    }
                }
                catch (Exception exception2) {
                    ViperCore.getDefault().log(this.B("{0} error using a direct connection after proxy {1} failure"), exception2, 4);
                    statusInfo = new StatusInfo(4, this.B("{0} error using a direct connection due to " + exception2.getMessage() + "."), 1);
                }
            }
        }
        return statusInfo;
    }

    public IStatus doManualActivation(String string, String string2) {
        this.setup(2);
        if (PlatformUtil.isNullOrEmpty((String)string)) {
            StatusInfo statusInfo = new StatusInfo(4, "No subscription or product code available");
            this.A((IStatus)statusInfo);
            return statusInfo;
        }
        if (PlatformUtil.isNullOrEmpty((String)string2)) {
            StatusInfo statusInfo = new StatusInfo(4, "No system identifier available");
            this.A((IStatus)statusInfo);
            return statusInfo;
        }
        String string3 = ProductActivator.createURL(GenuitecCoreLicenseDialog.getManualActivationURL(), string, string2, 2);
        Object object = PlatformUIUtil.openLink((String)string3) ? PlatformUtil.getOKStatus() : new StatusInfo(4, "Unable to automatically open your web browser. \nPlease open your web browser to the following URL:\n\n" + string3);
        this.A((IStatus)object);
        return object;
    }

    public static String createURL(String string, String string2, String string3, int n) {
        String string4 = "subCode=" + string2 + "&systemId=" + string3 + "&mode=" + n + "&version=" + PlatformUtil.getBundle((String)"com.genuitec.eclipse.core").getVersion();
        String string5 = String.valueOf(string) + "?" + string4;
        return string5;
    }

    public IStatus installActivationCode() {
        IStatus iStatus = this.validateActivationCode();
        if (!iStatus.isOK()) {
            ViperCore.getDefault().log("Activation Error(" + iStatus.getCode() + " - " + iStatus.getMessage() + "):" + this.E);
            this.A(iStatus);
            return iStatus;
        }
        iStatus = this.A(this.E);
        this.A(iStatus);
        return iStatus;
    }

    private IStatus A(String string) {
        GSDCController gSDCController = GSDCController.getInstance();
        if (gSDCController.isActive()) {
            ActivationCode activationCode = null;
            String string2 = LicenseUtil.getCurrentLicenseCode();
            try {
                activationCode = ActivationCode.fromCode(string);
                string2 = activationCode.getLicenseCode();
            }
            catch (InvalidSystemDataException invalidSystemDataException) {
                ViperCore.getDefault().log("GSDC ERROR: Activation data contains no returned code. Using old license code from configuration file: " + string2);
            }
            LicenseUtil.storeKey(LicenseUtil.getCurrentLicensee(), string2, string);
        } else {
            LicenseUtil.storeActivationData(string);
        }
        return PlatformUtil.getOKStatus();
    }

    public IStatus validateActivationCode() {
        return ProductActivator.validateActivationCode(this.E);
    }

    public static IStatus validateActivationCode(String string) {
        ActivationValidator activationValidator = new ActivationValidator(string, LicenseUtil.getCurrentLicenseCode());
        return activationValidator.validate();
    }

    protected String A(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "Network error - unable to connect to server";
                break;
            }
            case 2: {
                string = "Network error - incomplete data";
                break;
            }
            case 4: {
                string = "Potential counterfeit subscription code detected. Please contact sales@genuitec.com to resolve this matter.";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public boolean isAutoMethod() {
        return this.A == 1;
    }

    public boolean isManualMethod() {
        return this.A == 2;
    }

    public IStatus getStatus() {
        return this.B;
    }

    void A(IStatus iStatus) {
        this.B = iStatus;
    }

    public boolean isOKStatus() {
        return this.getStatus() != null ? this.getStatus().isOK() : false;
    }

    public void setManuallyEnteredActivationCode(ActivationCode activationCode) {
        this.E = activationCode.getActivationServerResponse();
    }

    public HttpURLConnection openConnection(URL uRL, IProxyData iProxyData) throws IOException {
        HttpURLConnection httpURLConnection = ViperCore.getDefault().createURLConnection(uRL, iProxyData);
        httpURLConnection.setConnectTimeout(30000);
        httpURLConnection.setReadTimeout(30000);
        this.A(httpURLConnection);
        httpURLConnection.connect();
        return httpURLConnection;
    }

    protected void A(HttpURLConnection httpURLConnection) {
    }

    protected IStatus A(URLConnection uRLConnection) {
        StatusInfo statusInfo = null;
        String string = null;
        if (uRLConnection == null) {
            statusInfo = new StatusInfo(4, "Assertion error: No connection passed to auto-activate.", 3);
            this.A((IStatus)statusInfo);
            return statusInfo;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            string = bufferedReader.readLine();
            bufferedReader.close();
            if (PlatformUtil.isNullOrEmpty((String)string) || string.length() < 3 || string.charAt(1) != '|') {
                statusInfo = new StatusInfo(4, this.A(2), 2);
                this.A((IStatus)statusInfo);
                throw new GenuitecCoreException("Server response invalid");
            }
            int n = Integer.parseInt(string.substring(0, 1), 16);
            String string2 = string.substring(2);
            if (n != 0) {
                ViperCore.getDefault().log("Activation Error - serverResponseCode=" + n + ", actCode=" + this.E);
                statusInfo = new StatusInfo(4, string2, n);
                this.A((IStatus)statusInfo);
                return statusInfo;
            }
            this.E = string2;
            statusInfo = PlatformUtil.getOKStatus();
            this.A((IStatus)statusInfo);
        }
        catch (Exception exception) {
            ViperCore.getDefault().log("Activation Error", exception);
            statusInfo = new StatusInfo(4, "Network error - Unable to access activation server. " + exception.getMessage(), 1);
            this.A((IStatus)statusInfo);
        }
        return statusInfo;
    }

    protected String A() {
        GSDCController gSDCController = GSDCController.getInstance();
        return gSDCController.isActive() ? gSDCController.getActivationServerURL() : GenuitecCoreLicenseDialog.getAutoActivationURL();
    }
}

