local _, core = ...;

core.poisons = {
  -- INSTANT POISONS
  ["速效药膏 VI"] = {
    ["堕落之尘"] = 4,
    ["水晶瓶"] = 1
  },
  ["速效药膏 V"] = {
    ["堕落之尘"] = 3,
    ["水晶瓶"] = 1
  },
  ["速效药膏 IV"] = {
    ["堕落之尘"] = 2,
    ["水晶瓶"] = 1
  },
  ["速效药膏 III"] = {
    ["堕落之尘"] = 1,
    ["铅瓶"] = 1
  },
  ["速效药膏 II"] = {
    ["蚀骨灰"] = 3,
    ["铅瓶"] = 1
  },
  ["速效药膏"] = {
    ["蚀骨灰"] = 1,
    ["空瓶"] = 1
  },
  -- CRIPPLING POISONS
  ["减速药膏 II"] = {
    ["苦楚精华"] = 3,
    ["水晶瓶"] = 1
  },
  ["减速药膏"] = {
    ["痛苦精华"] = 1,
    ["空瓶"] = 1
  },
  -- DEADLY POISONS
  ["致命药膏 V"] = {
    ["丧命草"] = 7,
    ["水晶瓶"] = 1
  },
  ["致命药膏 IV"] = {
    ["丧命草"] = 5,
    ["水晶瓶"] = 1
  },
  ["致命药膏 III"] = {
    ["丧命草"] = 3,
    ["水晶瓶"] = 1
  },
  ["致命药膏 II"] = {
    ["丧命草"] = 2,
    ["铅瓶"] = 1
  },
  ["致命药膏"] = {
    ["丧命草"] = 1,
    ["铅瓶"] = 1
  },
  -- MIND-NUMBING POISONS
  ["麻痹药膏 III"] = {
    ["堕落之尘"] = 2,
    ["苦楚精华"] = 2,
    ["水晶瓶"] = 1
  },
  ["麻痹药膏 II"] = {
    ["蚀骨灰"] = 4,
    ["痛苦精华"] = 4,
    ["铅瓶"] = 1
  },
  ["麻痹药膏"] = {
    ["蚀骨灰"] = 1,
    ["痛苦精华"] = 1,
    ["空瓶"] = 1
  },
  -- WOUND POISONS
  ["致伤药膏 IV"] = {
    ["苦楚精华"] = 2,
    ["丧命草"] = 2,
    ["水晶瓶"] = 1
  },
  ["致伤药膏 III"] = {
    ["苦楚精华"] = 1,
    ["丧命草"] = 2,
    ["水晶瓶"] = 1
  },
  ["致伤药膏 II"] = {
    ["痛苦精华"] = 1,
    ["丧命草"] = 2,
    ["铅瓶"] = 1
  },
  ["致伤药膏"] = {
    ["痛苦精华"] = 1,
    ["丧命草"] = 1,
    ["铅瓶"] = 1
  }
}


function core:getPoisonReagents()
  local T = {}
  for _, item in ipairs(Restocker.profiles[Restocker.currentProfile]) do
    if string.find(item.itemName, "Poison") then
      local poisonName = item.itemName
      local poisonRestockAmount = item.amount
      local inPossesion = GetItemCount(item.itemID, true)
      local inBags = GetItemCount(item.itemID, false)
      local poisonsMissing = poisonRestockAmount - inPossesion
      local minDifference

      local inBank = inPossesion - inBags
      if inBank == 0 then
        minDifference = 1
      else
        minDifference = poisonRestockAmount/2
      end


      if poisonsMissing >= minDifference and poisonsMissing > 0 then
        for reagent, amount in pairs(core.poisons[poisonName]) do
          local amountToGet = amount * poisonsMissing
          T[reagent] = T[reagent] and T[reagent] + amountToGet or amountToGet
        end
      end
    end
  end

  return T
end
