
-- Unit testing starts
require('Wow_Mockup')
require('MiDKP_Mockup')
require('MiDKPData')

require('src/locale')
require('localize/cn')
require('localize/tw')

require('src/constants')
require('src/util')
require('src/core')
require('src/sys')
require('src/event')
require('src/do')
require('src/ui')

require('luaunit')
----------------------
--- OO unit test -----
----------------------
function resetData()
	MiDKP_Config ={}
	MiDKP_Config.raids = {
		["Raid12312244"] = {name = "testRaid1",
			dkp = 1, 
			active = true,
			creator = "Momumomu", 
			ctime="2010-12-2 12:12" ,
			status = 1,
			entities = {
					["Member22313155"]={type = "Member", name = "TestMember1", class = "DRUID"},
					["Member22313223"]={type = "Member", name = "TestMember2", class = "MAGE"},
					["Event22314223"]={type = "Event", item = true, auto = false, players ={"Member22313155","Member22313223"}, itemID = "Item22314223",point = 20, name = "TestEvent"},
					["Item22314223"]={type = "Item", player = "Member22313155",event = "Event22314223",name ="TestItem", point = 20},
			}
		},
		["Raid12312245"] = {name = "testRaid2",
			dkp = 2, 
			creator = "Momumomu", 
			active = false,
			ctime="2010-12-3 12:12" ,
			status = 1,
			entities = {
					["Member12314155"]={type = "Member", name = "TestMember1", class = "DRUID"},
					["Member12314223"]={type = "Member", name = "TestMember2", class = "MAGE"},
					["Event12314223"]={type = "Event", item = false, auto = false, players ={}, point = 20, name = "TestEvent"},
					["Item12314223"]={type = "Item", player = "Member12314155",name ="TestItem", point = 20},
			}
		},
		["Raid12312246"] = {name = "testRaid3",
			dkp = 3, 
			creator = "Momumomu", 
			active = false,
			ctime="2010-12-4 12:12" ,
			status = 1,
			entities = {
					["Member32314155"]={type = "Member", name = "TestMember1", class = "DRUID"},
					["Member32314223"]={type = "Member", name = "TestMember2", class = "MAGE"},
					["Event32314223"]={type = "Event", item = false, auto = false, players ={}, point = 20, name = "TestEvent"},
					["Item32314223"]={type = "Item", player = "Member32314155",name ="TestItem", point = 20},
			}},
		["Raid12312247"] = {name = "testRaid4",
			dkp = 2, 
			creator = "Momumomu", 
			active = false,
			ctime="2010-12-5 12:12" ,
			status = 1,
			entities = {
				["Member42314155"]={type = "Member", name = "TestMember1", class = "DRUID"},
				["Member42314223"]={type = "Member", name = "TestMember2", class = "MAGE"},
				["Event42314223"]={type = "Event", item = false, auto = false, players ={}, point = 20, name = "TestEvent"},
				["Item42314223"]={type = "Item", player = "Member42314155",name ="TestItem", point = 20},
			}
		},
	}
	MiDKP.Data ={}
end

TestMiDKPCoreEntity={}
-- 测试创建Entity
function TestMiDKPCoreEntity:testCreateEntity()
	local newEntity = MiDKP.OO.Entity:new("test")
	assertEquals( type(newEntity), 'table' )
	assertEquals( newEntity:GetType(), 'test' )
	
end
--测试Entity相等条件
function TestMiDKPCoreEntity:testEntityEqual()
	local newEntity1 = MiDKP.OO.Entity:new("test")
	local newEntity2 = MiDKP.OO.Entity:new("test")
	assertEquals( newEntity1:GetType(), newEntity2:GetType() )
	newEntity1.id = newEntity2:GetID()
	assertEquals( newEntity1, newEntity2)

end
--测试Entity Type和缺省Type
function TestMiDKPCoreEntity:testGetEntityType()
	local newEntity1=MiDKP.OO.Entity:new()
	assertEquals( type(newEntity1), 'table' )
	assertEquals( newEntity1:GetType(), 'Entity' )
	local newEntity2=MiDKP.OO.Entity:new("Test")
	assertEquals( newEntity2:GetType(), 'Test' )

end
--[[
function TestMiDKPCoreEntity:testGenerateID()
	assertEquals(1,1)
end

function TestMiDKPCoreEntity:testSaveEntity()
	assertEquals(1,1)
end
]]

TestMiDKPCoreRaid={
	setUp = function()
		MiDKP_Config ={}
		MiDKP_Config.raids={}
	end
}

-- 测试创建Raid Object
function TestMiDKPCoreRaid:testRaidCreate()
	local newRaid=MiDKP.OO.Raid:Create("testRaid",1)
	assertEquals( newRaid:GetType(), 'Raid' )
	assertEquals( newRaid:GetName(),'testRaid')
	assertEquals( newRaid:GetDKP(),1)
	assertEquals( newRaid:GetMemberList():GetType(),'MemberList')
	assertEquals( newRaid:GetEventList():GetType(),'EventList')
	assertEquals( newRaid:GetItemList():GetType(),'ItemList')

end
--测试开始Raid
function TestMiDKPCoreRaid:testRaidStartEnd()
	local newRaid=MiDKP.OO.Raid:Create()
	assertEquals( newRaid:GetStatus(), 1 )	
	newRaid:Start()
	assertEquals( newRaid:GetStatus(), 2 )	
	newRaid:End()
	assertEquals( newRaid:GetStatus(), 3 )	
	
end
--测试激活Raid
function TestMiDKPCoreRaid:testRaidActivate()
	local newRaid=MiDKP.OO.Raid:Create()
	assertEquals( newRaid:IsActivated(), false )	
	newRaid:Activate()
	assertEquals( newRaid:IsActivated(), true )	
	newRaid:Activate()
	assertEquals( newRaid:IsActivated(), true )	
	newRaid:Deactivate()
	assertEquals( newRaid:IsActivated(), false )	
	newRaid:Deactivate()
	assertEquals( newRaid:IsActivated(), false )	
end


TestMiDKPCoreMember = {}
--测试创建Member
function TestMiDKPCoreMember:testMemberCreate()
	local newMember1=MiDKP.OO.Member:Create("testMember1",MiDKP.OO.Class.MAGE)
	local newMember2=MiDKP.OO.Member:Create("testMember2",MiDKP.OO.Class.PRIEST)
	assertEquals(newMember1:GetClass(),MiDKP.OO.Class.MAGE)
	assertEquals(newMember2:GetClass(),MiDKP.OO.Class.PRIEST)
	assertEquals(newMember2:GetName(),"testMember2")
	assertEquals(newMember1:GetName(),"testMember1")
	assertEquals(newMember2:GetClass():GetArmor(),newMember1:GetClass():GetArmor())
end
--测试修改Member
function TestMiDKPCoreMember:testMemberModify()
	local newMember1=MiDKP.OO.Member:Create("testMember1",MiDKP.OO.Class.MAGE)
	local newMember2=MiDKP.OO.Member:Create("testMember2",MiDKP.OO.Class.PRIEST)
	newMember1:Modify("testMember3",MiDKP.OO.Class.PRIEST)
	assertEquals(newMember1:GetClass(),newMember2:GetClass())
end


TestMiDKPCoreItem={}
--测试创建Item
function TestMiDKPCoreItem:testItemCreate()
	local newItem1=MiDKP.OO.Item:Create("testItem1",10)
	assertEquals(newItem1:GetPoint(),10)
	assertEquals(newItem1:GetName(),"testItem1")
end
--测试修改Item
function TestMiDKPCoreItem:testItemModify()
	local newMember1=MiDKP.OO.Member:Create("testMember1",MiDKP.OO.Class.PRIEST)
	local newItem1=MiDKP.OO.Item:Create("testItem1",10)
	newItem1:SetMember(newMember1)
	assertEquals(newItem1:GetPoint(),10)
	assertEquals(newItem1:GetName(),"testItem1")
end

TestMiDKPCoreList={}

function TestMiDKPCoreList:testListCreate()
	local newList=MiDKP.OO.List:Create()
	local newItem1=MiDKP.OO.Item:Create("testItem1",10)
	local newItem2=MiDKP.OO.Item:Create("testItem2",10)
	assertEquals(newList:Count(),0)
	newList:Add(newItem1)
	newList:Add(newItem2)
	assertEquals(newList:Count(),2)
	newList:Delete(newItem2)
	assertEquals(newList:Count(),1)
	assertTrue(newList:Find(newItem1))
	newList:Clear()
	assertEquals(newList:Count(),0)
end

TestMiDKPCoreClass={}

function TestMiDKPCoreClass:testClass()
	assertEquals(MiDKP.OO.Class.UNKNOWN:GetArmor(),MiDKP.OO.Armor.Unknown)
	assertTrue(MiDKP.OO.Armor.Unknown:GetClasses():Find(MiDKP.OO.Class.UNKNOWN))
	assertEquals(MiDKP.OO.Class.DRUID:GetArmor(),MiDKP.OO.Armor.Leather)
	assertTrue(MiDKP.OO.Armor.Leather:GetClasses():Find(MiDKP.OO.Class.DRUID))
	assertTrue(MiDKP.OO.Armor:GetByName("Leather"):GetClasses():Find(MiDKP.OO.Class.DRUID))
end
TestMiDKPCoreEvent={}

function TestMiDKPCoreEvent:testAddEvent()
	local newMember1=MiDKP.OO.Member:Create("testMember1",MiDKP.OO.Class.MAGE)
	local newMember2=MiDKP.OO.Member:Create("testMember2",MiDKP.OO.Class.PRIEST)
	local newMember3=MiDKP.OO.Member:Create("testMember3",MiDKP.OO.Class.PRIEST)
	local memberList = MiDKP.OO.MemberList:Create()
	memberList:Add(newMember1)
	memberList:Add(newMember2)
	memberList:Add(newMember3)
	local itemList = MiDKP.OO.ItemList:Create()
	local eventList = MiDKP.OO.ItemList:Create()


	local event1 = MiDKP.OO.Event:Create(false,false,10,"testEvent")
	event1:SetMemberList(memberList)

	local event2 = MiDKP.OO.Event:Create(false,false,10,"testEvent2")
	event2:AddMember(newMember3)

	eventList:Add(event1)
	eventList:Add(event2)
	
	local item1 = MiDKP.OO.Item:Create("testItem",10)
	item1:SetMember(newMember2)
	itemList:Add(item1)
	
	
	memberList:UpdatePoint(eventList,itemList)
	assertEquals(memberList:Get(1):GetPoint(),10)
	assertEquals(memberList:Get(2):GetPoint(),0)
	assertEquals(memberList:Get(3):GetPoint(),20)
end

function TestMiDKPCoreEvent:testSplitEvent()
	local newMember1=MiDKP.OO.Member:Create("testMember1",MiDKP.OO.Class.MAGE)
	local newMember2=MiDKP.OO.Member:Create("testMember2",MiDKP.OO.Class.PRIEST)
	local newMember3=MiDKP.OO.Member:Create("testMember3",MiDKP.OO.Class.PRIEST)
	local memberList = MiDKP.OO.MemberList:Create()
	memberList:Add(newMember1)
	memberList:Add(newMember2)
	memberList:Add(newMember3)
	local itemList = MiDKP.OO.ItemList:Create()
	local eventList = MiDKP.OO.ItemList:Create()

	local item1 = MiDKP.OO.Item:Create("testItem",21)
	item1:SetMember(newMember2)

	local item2 = MiDKP.OO.Item:Create("testItem",18)
	item2:SetMember(newMember3)
	
	
	local event1 = MiDKP.OO.Event:Create(false,true,item1)
	event1:SetMemberList(memberList)
	eventList:Add(event1)

	local event2 = MiDKP.OO.Event:Create(false,true,item2)
	event2:SetMemberList(memberList)
	eventList:Add(event2)

	local event3 = MiDKP.OO.Event:Create(false,false,10,"testEvent2")
	event3:AddMember(newMember3)
	eventList:Add(event3)

	
	itemList:Add(item1)
	itemList:Add(item2)
	
	memberList:UpdatePoint(eventList,itemList)
	assertEquals(memberList:Get(1):GetPoint(),13)
	assertEquals(memberList:Get(2):GetPoint(),-8)
	assertEquals(memberList:Get(3):GetPoint(),5)
	
	event3:Modify(5)
	memberList:UpdatePoint(eventList,itemList)
	assertEquals(memberList:Get(3):GetPoint(),0)
	
	item2:Modify(24)
	item2:GetEvent():Caculate()
	memberList:UpdatePoint(eventList,itemList)
	assertEquals(memberList:Get(3):GetPoint(),-4)

	event2:DeleteMember(newMember2)
	memberList:UpdatePoint(eventList,itemList)
	assertEquals(event2:GetMemberList():Count(),2)
	assertEquals(memberList:Count(),3)
	assertEquals(memberList:Get(3):GetPoint(),0)
	assertEquals(memberList:Get(2):GetPoint(),-14)
	assertEquals(memberList:Get(1):GetPoint(),19)

end

-----------------------
-- OO unit test ends --
-----------------------

-----------------------
---  event test--------
-----------------------
TestMiDKPEvent = {}

function TestMiDKPCoreEvent:testRegisterEvent()
	local testTemp ={}
	local plusone=function (a)
		table.insert(testTemp,a)
	end
	MiDKP.E:RegisterEvent("TEST_VAR_ADD",plusone)
	MiDKP.E:FireEvent("TEST_VAR_ADD",1)
	assertEquals(testTemp[1],1)
	MiDKP.E:FireEvent("TEST_VAR_ADD",2)
	assertEquals(testTemp[2],2)
	MiDKP.E:FireEvent("TEST_VAR_ADD",3)
	assertEquals(testTemp[3],3)
end
-----------------------
---  event test end----
-----------------------
-----------------------
------ Do Layer Test --
-----------------------

TestMiDKPHelpDB = {setUp =resetData ,
	tearDown=function()
		MiDKP_Config=nil
	end
}

function TestMiDKPHelpDB:testLoad()
	tempTable= {
		["Member12314155"]={type = "Member", name = "TestMember1", class = "DRUID"},
		["Member12314223"]={type = "Member", name = "TestMember2", class = "MAGE"},
		["Event12314223"]={type = "Event", item = false, auto = false, players ={}, point = 20, name = "TestEvent"},
		["Item12314223"]={type = "Item", player = "Member12314223",event = "Event12314223",name ="TestItem", point = 20},
	}
	local raid = {}
	raid.entities = tempTable
	setmetatable(raid.entities,{__index = MiDKP.U.DB})
	local memberList = MiDKP.OO.MemberList:Create()
	local eventList = MiDKP.OO.EventList:Create()
	local itemList = MiDKP.OO.ItemList:Create()
	for _id,_ in pairs(raid.entities) do
		local entity = raid.entities:Load(_id)
		if entity:GetType() == "Member" then
			memberList:Add(entity)
		elseif entity:GetType() == "Item" then
			itemList:Add(entity)
		elseif entity:GetType() =="Event" then
			eventList:Add(entity)
		end 
	end
	assertEquals(memberList:Count(),2)
	assertEquals(memberList:Get(1):GetClass(),MiDKP.OO.Class.MAGE)
	assertEquals(memberList:Get(2):GetClass(),MiDKP.OO.Class.DRUID)

	assertEquals(eventList:Count(),1)
	assertEquals(eventList:Get(1):GetPoint(),20)

	assertEquals(itemList:Count(),1)
	assertEquals(itemList:Get(1):GetPoint(),20)

end

function TestMiDKPHelpDB:testLoadRaid()
	local raids =  MiDKP.OO.RaidList:Create()
	for _raid_id,_raid in pairs( MiDKP_Config.raids) do
		setmetatable(_raid.entities,{__index = MiDKP.U.DB})
		local raid = MiDKP.OO.Raid:Build(_raid_id)
		raids:Add(raid)
		for _id,_ in pairs(_raid.entities) do		
			local entity = _raid.entities:Load(_id)
			if entity then
				if entity:GetType() == "Member" then
					raid:AddMember(entity)
				elseif entity:GetType() == "Item" then
					raid:AddItem(entity)
				elseif entity:GetType() =="Event" then
					raid:AddEvent(entity)
				end
			end			
		end
	end
	
	assertEquals(raids:Count(),4)
	raids:Sort("name",true)
	assertEquals(raids:Get(1):GetName(),"testRaid1")
	assertEquals(raids:Get(2):GetName(),"testRaid2")
	assertEquals(raids:Get(3):GetName(),"testRaid3")
	assertEquals(raids:Get(4):GetName(),"testRaid4")
	
	local raid  = raids:Get(1)
	local item  = raid:GetItemList():Get(1)
	local event  = raid:GetEventList():Get(1)
	assertEquals(raid:GetItemList():Get(1):GetName(),"TestItem")
	assertEquals(raid:GetEventList():Get(1):GetName(),"TestEvent")
	item:DeepLoad()
	event:DeepLoad()
	assertEquals(item:GetEvent(),event)
	assertEquals(event:GetItem(),item)
	
	
end

TestMiDKPDoRaid = {setUp = function() 
 	resetData()
	MiDKP.DO.Raid:Init()
end
}

function TestMiDKPDoRaid:testInitRaid()
	
	assertTrue(MiDKP.Data.Raid:IsActivated())
	assertEquals(MiDKP.Data.Events:Get(1):GetID(),"Event22314223")
	assertEquals(MiDKP.Data.Items:Get(1):GetID(),"Item22314223")
	assertEquals(MiDKP.Data.Events:Get(1):GetItem(),MiDKP.Data.Items:Get(1))
	assertEquals(MiDKP.Data.Items:Get(1):GetEvent(),MiDKP.Data.Events:Get(1))
	assertEquals(MiDKP.Data.Items:Get(1):GetMember(),MiDKP.Data.Members:Get(2))
	assertEquals(MiDKP.Data.Events:Get(1):GetMemberList():Get(1),MiDKP.Data.Members:Get(2))
	assertEquals(MiDKP.Data.Events:Get(1):GetMemberList():Get(2),MiDKP.Data.Members:Get(1))
	MiDKP.DO.Member:UpdateMemberPoint()
	assertEquals(MiDKP.Data.Members:Get(1):GetItems():Count(),0)
	assertEquals(MiDKP.Data.Members:Get(1):GetEvents():Count(),1)
	assertEquals(MiDKP.Data.Members:Get(2):GetItems():Count(),1)
	assertEquals(MiDKP.Data.Members:Get(2):GetEvents():Count(),1)

	assertEquals(MiDKP.Data.Members:Get(1):GetEvents():Get(1),MiDKP.Data.Events:Get(1))
	assertEquals(MiDKP.Data.Members:Get(2):GetItems():Get(1),MiDKP.Data.Items:Get(1))
	assertEquals(MiDKP.Data.Members:Get(2):GetEvents():Get(1),MiDKP.Data.Events:Get(1))
end

function TestMiDKPDoRaid:testRaidCreate()
	local raid = MiDKP.OO.Raid:Create("TestRaid5",2)
	MiDKP.DO.Raid:AddRaid(raid)
	local raid = MiDKP.Data.Raids:Get(4)
	assertEquals(raid:GetEventList():Count(),1)
	assertEquals(raid:GetItemList():Count(),1)
	local raid = MiDKP.Data.Raids:Get(5)
	MiDKP.DO.Raid:ActivateRaid(raid)
	print (MiDKP.Data.Raids:GetActive():GetName())
	assertEquals(raid,MiDKP.Data.Raids:GetActive())
	assertEquals(raid:GetEventList():Count(),0)
	assertEquals(raid:GetItemList():Count(),0)
end

function TestMiDKPDoRaid:testRaidModify()
	local raid = MiDKP.Data.Raids:Get(4)
	MiDKP.DO.Raid:ModifyRaid(raid,"TestRaidModified",2)
	assertEquals(raid:GetName(),"TestRaidModified")
	assertEquals(raid:GetDKP(),2)
end

function TestMiDKPDoRaid:testRaidDelete()
	local raid = MiDKP.Data.Raids:Get(4)
	MiDKP.DO.Raid:DeleteRaid(raid)
	assertEquals(MiDKP.Data.Raids:Count(),3)
	local raid = MiDKP.Data.Raids:Get(3)
	MiDKP.DO.Raid:DeleteRaid(raid)
	assertEquals(MiDKP.Data.Raids:Count(),2)
	local raid = MiDKP.Data.Raids:Get(2)
	MiDKP.DO.Raid:DeleteRaid(raid)
	assertEquals(MiDKP.Data.Raids:Count(),1)
	local raid = MiDKP.Data.Raids:Get(1)
	MiDKP.DO.Raid:DeleteRaid(raid)
	assertEquals(MiDKP.Data.Raids:Count(),0)
	
end

function TestMiDKPDoRaid:testRaidListing()
	assertEquals(MiDKP.Data.Raids:Count(),4)
end


TestMiDKPDoMember = {
setUp = function() 
	resetData()
	MiDKP.DO.Raid:Init()	
	MiDKP.DO.Raid:StartRaid(MiDKP.Data.Raid)
end,
tearDown = function()
	
end
}

function TestMiDKPDoMember:testMemberCreate()
	local member = MiDKP.OO.Member:Create("TestMember","Mage")
	MiDKP.DO.Member:AddMember(member)
	assertEquals(MiDKP.Data.Members:Count(),6)
	assertEquals(MiDKP.Data.Raid:GetMemberList():Get(6),member)
end

function TestMiDKPDoMember:testMemberModify()
	local member = MiDKP.Data.Raid:GetMemberList():Get(5)
	MiDKP.DO.Member:ModifyMember(member,"TestMemberModified",MiDKP.OO.Class.DRUID )
	assertEquals(MiDKP.Data.Members:Get(5),MiDKP.OO.Member:Create("TestMemberModified",MiDKP.OO.Class.DRUID))
	
end

function TestMiDKPDoMember:testMemberDelete()
	local member = MiDKP.Data.Raid:GetMemberList():Get(1)
	MiDKP.DO.Member:DelMember(member)
	assertEquals(MiDKP.Data.Members:Count(),4)
	
end

function TestMiDKPDoMember:testMemberListing()
end


TestMiDKPDoEvent = {
	setUp = function()
		resetData()
		MiDKP.DO.Raid:Init()
		MiDKP.DO.Raid:StartRaid(MiDKP.Data.Raid)
	end,
	tearDown = function()
		MiDKP.DO.Raid:EndRaid(MiDKP.Data.Raid)
	end
}

function TestMiDKPDoEvent:testEventCreate()
	local event = MiDKP.OO.Event:Create(false,false,20,"TestEvent 3")
	event:SetMemberList(MiDKP.Data.Members)
	MiDKP.DO.Event:AddEvent(event)
	assertEquals(MiDKP.Data.Events:Count(),2)
	assertEquals(MiDKP.Data.Events:Get(2):GetName(),"TestEvent 3")

end

function TestMiDKPDoEvent:testEventModify()
	local event = MiDKP.OO.Event:Create(false,false,20,"TestEvent 3")
	event:SetMemberList(MiDKP.Data.Members)
	MiDKP.DO.Event:AddEvent(event)
	assertEquals(MiDKP.Data.Events:Get(2):GetPoint(),20)
	MiDKP.DO.Event:ModifyEvent(MiDKP.Data.Events:Get(2),"TestEventModified", MiDKP.Data.Members,true,30)
	assertEquals(MiDKP.Data.Events:Get(2):GetName(),"TestEventModified")
	assertEquals(MiDKP.Data.Events:Get(2):GetPoint(),30)
end

function TestMiDKPDoEvent:testEventDelete()
	local event = MiDKP.OO.Event:Create(false,false,20,"TestEvent 3")
	event:SetMemberList(MiDKP.Data.Members)
	MiDKP.DO.Event:AddEvent(event)
	assertEquals(MiDKP.Data.Events:Get(2):GetPoint(),20)
	MiDKP.DO.Event:DelEvent(MiDKP.Data.Events:Get(2))
	assertEquals(MiDKP.Data.Events:Count(),1)
	
end

function TestMiDKPDoEvent:testEventListing()
end


TestMiDKPDoItem= {
	setUp = function()
		resetData()
		MiDKP.DO.Raid:Init()
		MiDKP.DO.Raid:StartRaid(MiDKP.Data.Raid)
	end,
	tearDown = function()
		MiDKP.DO.Raid:EndRaid(MiDKP.Data.Raid)
	end}

function TestMiDKPDoItem:testItemCreate()
	local item = MiDKP.OO.Item:Create("TestItem 3",20)
	item:SetMember(MiDKP.Data.Members:Get(1))
	MiDKP.DO.Item:AddItem(item)
	assertEquals(MiDKP.Data.Items:Get(2):GetPoint(),20)
	assertEquals(MiDKP.Data.Items:Count(),2)
end

function TestMiDKPDoItem:testItemModify()
	local item = MiDKP.OO.Item:Create("TestItem 3",20)
	item:SetMember(MiDKP.Data.Members:Get(1))
	MiDKP.DO.Item:AddItem(item)

	assertEquals(MiDKP.Data.Items:Get(2):GetPoint(),20)
	assertEquals(MiDKP.Data.Items:Get(2):GetName(),"TestItem 3")
	assertEquals(MiDKP.Data.Items:Get(2):GetMember(),MiDKP.Data.Members:Get(1))
	assertEquals(MiDKP.Data.Items:Count(),2)
	MiDKP.DO.Item:ModifyItem(MiDKP.Data.Items:Get(2),"TestItem 2",10,MiDKP.Data.Members:Get(2),false)
	assertEquals(MiDKP.Data.Items:Get(2):GetPoint(),10)
	assertEquals(MiDKP.Data.Items:Get(2):GetName(),"TestItem 2")
	assertEquals(MiDKP.Data.Items:Get(2):GetMember(),MiDKP.Data.Members:Get(2))
end

function TestMiDKPDoItem:testItemDelete()

	local item = MiDKP.OO.Item:Create("TestItem 3",20)
	item:SetMember(MiDKP.Data.Members:Get(1))
	MiDKP.DO.Item:AddItem(item)

	assertEquals(MiDKP.Data.Items:Get(2):GetPoint(),20)
	assertEquals(MiDKP.Data.Items:Get(2):GetName(),"TestItem 3")
	assertEquals(MiDKP.Data.Items:Get(2):GetMember(),MiDKP.Data.Members:Get(1))
	assertEquals(MiDKP.Data.Items:Count(),2)
	local item = MiDKP.Data.Items:Get(2)
	MiDKP.DO.Item:DelItem(item)
	assertEquals(MiDKP.Data.Items:Count(),1)
	MiDKP.DO.Item:DelItem(item)
	assertEquals(MiDKP.Data.Items:Count(),1)
end

function TestMiDKPDoItem:testItemListing()
end

TestMiDKPDoItemAndEvent= {
setUp = function() 
	resetData()
	MiDKP.E:Init()
	MiDKP.DO.Raid:Init()
	MiDKP.Data.Raid.status = 2
	--do not start raid, it will clean all members
end,

tearDown = function()
	MiDKP.E:ClearEvents()
end

}

function TestMiDKPDoItemAndEvent:testItemCreate()

	MiDKP.DO.Member:UpdateMemberPoint()
	assertEquals(MiDKP.Data.Members:Get(1):GetPoint(),10)
	assertEquals(MiDKP.Data.Members:Get(2):GetPoint(),-10)
	--check init points
	local item = MiDKP.OO.Item:Create("TestItem 3",30)
	item:SetMember(MiDKP.Data.Members:Get(1))
	item:SetSplit(true)
	MiDKP.DO.Item:AddItem(item)
	MiDKP.DO.Member:UpdateMemberPoint()
	assertEquals(MiDKP.Data.Items:Get(2):GetPoint(),30)
	assertEquals(MiDKP.Data.Items:Count(),2)
	assertEquals(MiDKP.Data.Events:Count(),2)
	assertEquals(MiDKP.Data.Events:Get(2):GetPoint(),15)	
	assertEquals(MiDKP.Data.Members:Get(1):GetPoint(),-5)
	assertEquals(MiDKP.Data.Members:Get(2):GetPoint(),5)
	--check adding a split item

end


function TestMiDKPDoItemAndEvent:testItemModify()

	--check init points
	local item = MiDKP.OO.Item:Create("TestItem 3",30)
	item:SetMember(MiDKP.Data.Members:Get(1))
	item:SetSplit(true)
	MiDKP.DO.Item:AddItem(item)

	assertEquals(MiDKP.Data.Items:Get(2):GetPoint(),30)
	assertEquals(MiDKP.Data.Items:Count(),2)
	assertEquals(MiDKP.Data.Events:Count(),2)
	assertEquals(MiDKP.Data.Events:Get(2):GetPoint(),15)
	--adding a split point item

	local item = MiDKP.Data.Items:Get(2)
	MiDKP.DO.Item:ModifyItem(item,item:GetName(),20,MiDKP.Data.Members:Get(2),true)
	MiDKP.DO.Member:UpdateMemberPoint()	
	assertEquals(MiDKP.Data.Members:Get(1):GetPoint(),20)
	assertEquals(MiDKP.Data.Members:Get(2):GetPoint(),-20)
	--modify a split point item, modify the points
	
	MiDKP.DO.Item:ModifyItem(item,item:GetName(),20,MiDKP.Data.Members:Get(2),false)
	MiDKP.DO.Member:UpdateMemberPoint()
	assertEquals(MiDKP.Data.Members:Get(1):GetPoint(),10)
	assertEquals(MiDKP.Data.Members:Get(2):GetPoint(),-30)
	assertEquals(MiDKP.Data.Events:Count(),1)
	--delete the split event
	MiDKP.DO.Item:ModifyItem(item,item:GetName(),20,MiDKP.Data.Members:Get(2),true)
	MiDKP.DO.Member:UpdateMemberPoint()
	assertEquals(MiDKP.Data.Members:Get(1):GetPoint(),20)
	assertEquals(MiDKP.Data.Members:Get(2):GetPoint(),-20)
	assertEquals(MiDKP.Data.Events:Count(),2)
	--adding the split event
end

function TestMiDKPDoItemAndEvent:testEventModify()
	
	local item = MiDKP.OO.Item:Create("TestItem 3",30)
	item:SetMember(MiDKP.Data.Members:Get(1))
	item:SetSplit(true)
	MiDKP.DO.Item:AddItem(item)
	--adding a split item
	MiDKP.DO.Member:UpdateMemberPoint()
	assertEquals(MiDKP.Data.Events:Count(),2)
	assertEquals(MiDKP.Data.Members:Get(1):GetPoint(),-5)
	assertEquals(MiDKP.Data.Members:Get(2):GetPoint(),5)

	local event = MiDKP.Data.Events:Get(2)
	local member =  MiDKP.OO.Member:Create("TestMember3",MiDKP.OO.Class.DRUID)
	MiDKP.DO.Member:AddMember(member) 
	
	MiDKP.DO.Event:ModifySplitEvent(event,MiDKP.Data.Members)
	MiDKP.DO.Member:UpdateMemberPoint()
	assertEquals(MiDKP.Data.Events:Count(),2)
	assertEquals(MiDKP.Data.Members:Get(1):GetPoint(),-10)
	assertEquals(MiDKP.Data.Members:Get(2):GetPoint(),0)
	assertEquals(MiDKP.Data.Members:Get(3):GetPoint(),10)
end

function TestMiDKPDoItemAndEvent:testEventDelete()

	---events: 	10 to testmember1
	---			10 to testmember2
	---item: -20 to testmember1
	
	--check init points
	local item = MiDKP.OO.Item:Create("TestItem 3",30)
	item:SetMember(MiDKP.Data.Members:Get(1))
	item:SetSplit(true)
	MiDKP.DO.Item:AddItem(item)
	--adding a split item
	---events: 	10 to testmember1
	---			10 to testmember2
	--			15 to testmember1
	--			15 to testmember2
	---item: 	-20 to testmember1
	--			-30 to testmember2
	MiDKP.DO.Member:UpdateMemberPoint()
	assertEquals(MiDKP.Data.Events:Count(),2)
	assertEquals(MiDKP.Data.Members:Get(1):GetPoint(),-5)
	assertEquals(MiDKP.Data.Members:Get(2):GetPoint(),5)

	local event = MiDKP.Data.Events:Get(2)
	MiDKP.DO.Event:DelEvent(event)
	MiDKP.DO.Member:UpdateMemberPoint()
	assertEquals(MiDKP.Data.Events:Count(),1)
	assertEquals(MiDKP.Data.Members:Get(1):GetPoint(),-20)
	assertEquals(MiDKP.Data.Members:Get(2):GetPoint(),-10)
	
	assertEquals(MiDKP.Data.Members:Get(1):GetItems():Count(),1) --member 1 get testitem 3
	assertEquals(MiDKP.Data.Members:Get(1):GetEvents():Count(),1) --member 1 get init item split point
	assertEquals(MiDKP.Data.Members:Get(2):GetItems():Count(),1) --member 2 get init item
	assertEquals(MiDKP.Data.Members:Get(2):GetEvents():Count(),1) --member 2 get init item split point
	assertEquals(MiDKP.Data.Members:Get(1):GetItems():Get(1),MiDKP.Data.Items:Get(2))
	assertEquals(MiDKP.Data.Members:Get(2):GetItems():Get(1),MiDKP.Data.Items:Get(1))
	assertEquals(MiDKP.Data.Members:Get(2):GetEvents():Get(1),MiDKP.Data.Events:Get(1))
	assertEquals(MiDKP.Data.Members:Get(1):GetEvents():Get(1),MiDKP.Data.Events:Get(1))
end


TestMiDKPDoDKP = {
	setUp = function()
		MiDKP.DO.DKP:Init()
	end

}

function TestMiDKPDoDKP:testDKPInit()

	local member = MiDKP.DO.DKP:GetSuite(1):FindByName("Momumomu")
	assertEquals(member:GetPoint(),84)
	local member = MiDKP.DO.DKP:GetSuite(2):FindByName("Momumomu")
	assertEquals(member:GetPoint(),7)
	assertEquals(member:GetClass():GetName(),'Mage')
end

TestMiDKPDoConfig = {
	setUp = function()
		MiDKP.DO.Config:Init()
	end
}

function TestMiDKPDoConfig:testConfig()
	assertEquals(MiDKP.DO.Config:GetConfig('default_member_filter'),3)
	MiDKP.DO.Config:SetConfig('default_member_filter',5)
	assertEquals(MiDKP.DO.Config:GetConfig('default_member_filter'),5)
end

LuaUnit:run()