MiDKP=MiDKP or {}

local M  = MiDKP

M.Widget = {}
--[[ widgets are classes that can be used directly by UI
	after properly set, you can pass params to a widget 
	and let it handle details like display styles, or simple logics.

]]


M.Widget.Entity = inheri(M.OO.Entity)

function M.Widget.Entity:Bind(ui)
	self.ui = ui
	if self.ui then
		self.ui.widget = self
	end
end

function M.Widget.Entity:GetUI()
	return self.ui
end

function M.Widget.Entity:Show()
	if self.ui then
		self.ui:Show()
	end
end

function M.Widget.Entity:Hide()
	if self.ui then
		self.ui:Hide()
	end
end

function M.Widget.Entity:SetParent(parent)
	self.parent = parent
end


M.Widget.DDList = inheri(M.Widget.Entity)

function M.Widget.DDList:Create(dtype,ui)
	local dd = self:class():new()
	dd:Bind(ui)
	dd.type = dtype
	UIDropDownMenu_Initialize(dd.ui, dd[dtype.."Init"])
	return dd	
end

function M.Widget.DDList.addButton(text,id,func,keepShow,checked)
	local button = {}
	button.keepShownOnClick=keepShow--1
	button.text = text
	button.id = id
	button.checked=checked and 1
	button.func=function()
		-- can we use this?
		func(id)
	end
	UIDropDownMenu_AddButton(button)
end

function M.Widget.DDList.ClassInit(frame)
	local self = frame.widget
	UIDropDownMenu_SetText(self.ui,M.L.CLASS)
	self.selectedGroup = self.selectedGroup or M.OO.Armor:ToArray()

	--[[
	{[1] = {check=true},
	[2] = {check=true},
	[3] = {check= true},

	}
	
	]]
	local setButtonVal = function (id,val)
		self.selectedGroup[id] = val
	end
	
	local toggleButtonVal = function (id)
		self.selectedGroup[id] = not self.selectedGroup[id]
	end
	
	local isButtonChecked = function (id)
		return self.selectedGroup[id]
	end
	
	local toggleAll = function (toggle)
		for _i in pairs(self.selectedGroup) do
			setButtonVal(_i,toggle)
		end
	end

	local toggleChildClasses = function (id, toggle)
		M.OO.Armor:GetByID(id):GetClasses():RunList(function(entity) setButtonVal(entity:GetID(),toggle) end)
	end
	
	local checkArmor = function (id)
		local armor =M.OO.Class:GetByID(id):GetArmor()
		local tag = true
		armor:GetClasses():RunList( function(class)
			if not isButtonChecked(class:GetID()) then
				setButtonVal(armor:GetID(),false)
				tag = false
			end
		end)
		if tag then setButtonVal(armor:GetID(),true) end
	end	

	local checkRoot = function ()
		for _i = 2, getn(self.selectedGroup) do
			if not isButtonChecked(_i) then
				setButtonVal(1,false)
				return
			end
		end
		setButtonVal(1,true)
	end	
	
	local updatePanel = function ()
		
		self.parent:SetClassFilter(self:GetVal())
		self.parent:ResetPage()
		self.parent:Update()
	end
	
	local onRootChecked = function(id)
		toggleButtonVal(id)
		toggleAll(isButtonChecked(id))
		--toggle all sub class buttons
		updatePanel()
	end
	
	local onArmorChecked = function(id)
		toggleButtonVal(id)
		toggleChildClasses(id,isButtonChecked(id))
		--toggle all classes that belongs to same armor
		checkRoot()
		--check if root should be checked or not
		updatePanel()
	end
	
	local onClassChecked = function (id)
		toggleButtonVal(id)
		checkArmor(id)
		checkRoot()
		updatePanel()
	end
	
	local onButtonClicked = function (ui)
		if not MiDKP3MainFrame:IsShown() then return end
		local buttonName = ui:GetParent():GetName().."Button"
		for _i,_ in pairs(self.selectedGroup) do
			if isButtonChecked(_i) then
				_G[buttonName.._i.."Check"]:Show()
			else
				_G[buttonName.._i.."Check"]:Hide()
			end
		end
	end
	
	self.addButton(M.L.ALL ,1, onRootChecked,1,isButtonChecked(1))
	
	for _, _armor in pairs(M.OO.Armor.ArmorTable) do
		self.addButton(_armor:GetLocale(),_armor:GetID(), onArmorChecked, 1, isButtonChecked(_armor:GetID()))
		_armor:GetClasses():RunList(function(class) 
			self.addButton(M.L.SPACE..class:GetRenderName(), class:GetID(), onClassChecked, 1, isButtonChecked(class:GetID()))
		end)
	end

	hooksecurefunc("UIDropDownMenuButton_OnClick",onButtonClicked)
end

function M.Widget.DDList.DKPInit(frame)
	local self =frame.widget
	self.selected = self.selected or 0
	local dkp = M.DO.DKP:GetNameArray()
	if not dkp then return end
	local onButtonClicked = function (ui)
		if not MiDKP3MainFrame:IsShown() then return end

		local buttonName = ui:GetParent():GetName().."Button"
		for _i = 0, dkp:Count() do
			if _i == self.selected then
				_G[buttonName..(_i + 1).."Check"]:Show()
			else
				_G[buttonName..(_i + 1).."Check"]:Hide()
			end
		end
		if self.selected == 0 then 
			UIDropDownMenu_SetText(frame,M.L.DKP_PAGE_TITLE )
		else 
			UIDropDownMenu_SetText(frame,M.DO.DKP:GetSuiteName(self.selected) ) 
		end
	end
	
	local updatePanel = function ()
		self.parent:SetDKP(self:GetVal())
		self.parent:ResetPage()
		self.parent:Update()
	end
	
	local onDkpCheck = function(id)
		self.selected = id
		updatePanel()
	end
	self.addButton(M.L.DKP_PAGE_CURRENT_DKP,0,onDkpCheck,nil,self:GetVal() == 0)
	
	for _i = 1, dkp:Count() do
		self.addButton(dkp:Get(_i):GetName(),_i,onDkpCheck,nil,self:GetVal() == _i)
	end
	
	hooksecurefunc("UIDropDownMenuButton_OnClick",onButtonClicked)

end

function M.Widget.DDList:SetSingle(single)
	self.single = single
end

function M.Widget.DDList:GetVal()

	if self.single then
		return self.selected
	else
		return self.selectedGroup
	end
end


M.Widget.Menu = inheri(M.Widget.Entity)

function M.Widget.Menu:Create(dtype,panel)
	local menu =self:class():new()
	menu.dtype = dtype
	menu.panel = panel
	if dtype == "Raid" then
		menu.list ={
			{
				text = M.L.RAID_MODIFY,
				func = M.UI.Raid.OnMenuModifyButtonClick
			},
			{
				text = M.L.RAID_DELETE,
				func = M.UI.Raid.OnMenuDeleteButtonClick
			},
		}
	
	elseif dtype == "Event" then
		menu.list ={
			{
				text = M.L.EVENT_MODIFY,
				func = M.UI.Event.OnMenuModifyButtonClick},
			{
				text = M.L.EVENT_DELETE,
				func = M.UI.Event.OnMenuDeleteButtonClick},
		}
	elseif dtype == "Item" then
		menu.list ={
			{
				text = M.L.ITEM_MODIFY,
				func = M.UI.Item.OnMenuModifyButtonClick},
			{
				text = M.L.ITEM_DELETE,
				func = M.UI.Item.OnMenuDeleteButtonClick},
			{
				text = M.L.ITEM_ADD_TO_IITEM,
				func = M.UI.Item.OnMenuAddToIIListClick},
		}
	elseif dtype == "DKP" then
		menu.list ={
			{
				text = M.L.DKP_ANNOUNCE_PERSON,
				func = M.UI.DKP.OnSendToPersonClick},
			{
				text = M.L.DKP_ANNOUNCE_PARTY,
				func = M.UI.DKP.OnSendToPartyClick},
			{
				text = M.L.DKP_ANNOUNCE_GUILD,
				func = M.UI.DKP.OnSendToGuildClick},
			{
				text = M.L.DKP_ANNOUNCE_RAID,
				func = M.UI.DKP.OnSendToRaidClick},
		}

	end
	return menu
end

function M.Widget.Menu:Show()
	if self.dtype == "Member" then
		if self.panel:GetCurrent():HasMinor() then
			self.list ={
				{
					text = M.L.MEMBER_ADDEVENT,
					func = M.UI.Member.OnMenuCreateEventButtonClick
				},
				{
					text = M.L.MEMBER_DELETE,
					func = M.UI.Member.OnMenuDeleteButtonClick
				},
			}
		elseif self.panel:GetCurrent():GetMain() then
			self.list ={
				{
					text = M.L.MEMBER_ADDEVENT,
					func = M.UI.Member.OnMenuCreateEventButtonClick
				},
				{
					text = M.L.MEMBER_DELETE,
					func = M.UI.Member.OnMenuDeleteButtonClick
				},
				{
					text = M.L.MEMBER_CANCEL_MAIN,
					func = M.UI.Member.CancelMainMenuFuc
				},
				
			}
		else
			self.list ={
				{
					text = M.L.MEMBER_ADDEVENT,
					func = M.UI.Member.OnMenuCreateEventButtonClick
				},
				{
					text = M.L.MEMBER_DELETE,
					func = M.UI.Member.OnMenuDeleteButtonClick
				},
				{
					text = M.L.MEMBER_SET_MAIN,
					hasArrow = true,
					menuList = M.DO.Member:GetSetMainMemberList(self.panel:GetCurrent())
				},
				
			}
		end

	end
	EasyMenu(self.list,MiDKP3RightMouseMenuFrame,"cursor",0,0,"MENU")
end


M.Widget.Panel = inheri(M.Widget.Entity)

function M.Widget.Panel:Create(t)
	local panel = self:class():new()
	panel.uitype = t
	panel:SetPageSize(MIDKP_PAGE_SIZE[t])
	panel.offset = 0
	return panel
end

function M.Widget.Panel:BindUI(ui)
	self:Bind(ui)
	self:BindButtons()
end

function M.Widget.Panel:BindButtons()
	self.buttonList = {}
	local panelType = self.uitype
	for _i = 1, self.pageSize do
		local button = _G["MiDKP3"..panelType.."Button".._i] or 
			CreateFrame("CheckButton","MiDKP3"..panelType.."Button".._i,self.ui,"MiDKP3"..panelType.."ButtonTemplate")
		self.buttonList[_i] = M.Widget.Button:Create(panelType)
		self.buttonList[_i]:BindUI(button,self)
	end
	self.scrollFrame = CreateFrame("ScrollFrame",self.ui:GetName().."ScrollFrame",self.ui,"FauxScrollFrameTemplate")
	self.scrollFrame:EnableMouseWheel(true)
	self.scrollFrame:Hide()
	if self.uitype == 'Member' or self.uitype == 'DKP' then
		self.scrollFrame:SetPoint("TOPRIGHT",self.ui,"TOPRIGHT",-38,-84)
		self.scrollFrame:SetWidth(400)
		self.scrollFrame:SetHeight(446)
	elseif self.uitype == 'IItem' then
		self.scrollFrame:SetPoint("TOPRIGHT",self.ui,"TOPRIGHT",-38,-62)
		self.scrollFrame:SetWidth(400)
		self.scrollFrame:SetHeight(275)
	else
		self.scrollFrame:SetPoint("TOPRIGHT",self.ui,"TOPRIGHT",-38,-62)
		self.scrollFrame:SetWidth(400)
		self.scrollFrame:SetHeight(468)
	end
	self.scrollFrame.panel = self
	self.scrollFrame:SetScript("OnVerticalScroll",function (ui,offset)
		FauxScrollFrame_OnVerticalScroll(ui, offset, 200, M.Widget.Panel.ScrollUpdate)
	end)
	
end

function M.Widget.Panel.ScrollUpdate(ui)
	local self = ui.panel
	self.offset = FauxScrollFrame_GetOffset(ui)
	self:Update()
	
end

function M.Widget.Panel:Update()
	local function hideButtons(s,e)
		for _i = s, e do
			self.buttonList[_i]:ClearEntity()
			self.buttonList[_i]:Hide()
		end
	end
	
	local function showButtons(s,e,list)
		for _i = s, e do
			self.buttonList[_i]:SetEntity(list:Get(_i))
			self.buttonList[_i]:Show()
		end
	end

	if not self.entityList then
		hideButtons(1,self.pageSize)
		return
	end
	local list = self.entityList:GetByOffset(self.offset,self.pageSize)
	
	showButtons(1,list:Count(),list)
	hideButtons(list:Count()+1, self.pageSize)


	FauxScrollFrame_Update(self.scrollFrame,self.entityList:Count(),self.pageSize,200)

	self:Arrange()
end

function M.Widget.Panel:Arrange()
	local offx,offy = 25 ,-65

	if self.uitype == "Member" or  self.uitype == "DKP" then
		offx, offy = 25, -85
	end	
	self.buttonList[1].ui:SetPoint("TOPLEFT",self.ui:GetName(),"TOPLEFT",offx,offy)
	for _i = 2, self.pageSize do
		self.buttonList[_i].ui:SetPoint("TOP",self.buttonList[_i-1].ui:GetName(),"BOTTOM",0,0)
	end
end

function M.Widget.Panel:GetCurrent()
	return self.selected 
end

function M.Widget.Panel:SetCurrent(entity)
	self.selected = entity
end

function M.Widget.Panel:ClearCurrent()
	self.selected = nil
end

function M.Widget.Panel:SetList(entityList)
	self.entityList = entityList
	if not entityList then 
		self.selected = nil
	end
end

function M.Widget.Panel:GetList()
	return self.entityList
end

function M.Widget.Panel:SetPageSize(size)
	self.pageSize = size
end

function M.Widget.Panel:GetType()
	return self.uitype
end

function M.Widget.Panel:Collapse()
	for _i = 1, self.pageSize do
		self.buttonList[_i]:Collapse()
	end
end

function M.Widget.Panel:OnSelectedButtonChange(button)
	self:SetCurrent(button.entity)
	self:Collapse()
	button:Expand()
	if self.parent.pageType~="IItem" then
		M.E:FireEvent("BUTTON_TOGGLED",self.parent,true)
	end
end

function M.Widget.Panel:OnButtonDeleted()
	self:ClearCurrent()
	if self.parent.pageType~="IItem" then
		M.E:FireEvent("BUTTON_TOGGLED",self.parent,false)
	end
end


M.Widget.Button = inheri(M.Widget.Entity)

function M.Widget.Button:Create(uitype)
	local button = self:class():new()
	if uitype == "Raid" then
		button.uitype = uitype
	elseif uitype == "Member" then
		button.uitype = uitype
	elseif uitype == "Event" then
		button.uitype = uitype
	elseif uitype == "Item" then
		button.uitype = uitype
	elseif uitype == "IItem" then
		button.uitype = uitype
	elseif uitype == "DKP" then
		button.uitype = uitype
	end
	return button
end

function M.Widget.Button:ShowHighLightEdge(ui)
	for __k,__edge in pairs(MIDKP_LOCATIONS) do
		_G[ui:GetName()..__edge]:SetVertexColor(1,1,1);
		_G[ui:GetName()..__edge]:Show()
	end
end

function M.Widget.Button:ShowMouseOverEdge(ui)
	for __k,__edge in pairs(MIDKP_LOCATIONS) do
		_G[ui:GetName()..__edge]:SetVertexColor(0.5,0.5,0.5);
		_G[ui:GetName()..__edge]:Show()
	end
end

function M.Widget.Button:HideEdge(ui)
	for __k,__edge in pairs(MIDKP_LOCATIONS) do
		_G[ui:GetName()..__edge]:Hide()
	end
end

function M.Widget.Button:BindUI(ui,parent)
	self:Bind(ui)
	self.parent = parent
	self.ui:RegisterForClicks("LeftButtonUp","RightButtonUp")

	local buttonEnter=function(ui)
		if (ui.widget.entity ==ui.widget.parent:GetCurrent()) then
			self:ShowHighLightEdge(ui)
		else
			self:ShowMouseOverEdge(ui)
		end
		
	end
	
	local buttonLeave=function(ui)
		if (ui.widget.entity ==ui.widget.parent:GetCurrent()) then
			self:ShowHighLightEdge(ui)
		else
			self:HideEdge(ui)
		end
	end

	self.nameText = _G[self.ui:GetName().."Name"]
	if self.uitype ~= "IItem" then
		self.ui:SetScript("OnEnter",buttonEnter)
		self.ui:SetScript("OnLeave",buttonLeave)
	end
	self.ui:SetScript("OnClick",function(_,button)
		M.E:FireEvent("BUTTON_SELECTED",self.parent,self)
		if button =="RightButton" then
			GameTooltip:Hide()
			self.parent.parent.menu:Show()
		end
	end)
	
	if self.uitype == "Raid" then
		self.dkpText = _G[self.ui:GetName().."DKP"]
		self.placesText = _G[self.ui:GetName().."Places"]
		self.statusText = _G[self.ui:GetName().."Status"]
		self.infoText = _G[self.ui:GetName().."Info"]
		self.activeButton = _G[self.ui:GetName().."ActiveButton"]
		self.activeButton:SetScript("OnEnter",function(ui)
			buttonEnter(ui:GetParent())
		end)
		self.activeButton:HookScript("OnClick",function(b)
			b:Disable()
			M.E:FireEvent("RAID_SELECTED",self.entity)
			M.E:FireEvent("BUTTON_SELECTED",self.parent,self)
		end)
		self.ui:HookScript("OnClick",function(ui)
			--throw selected raid change event
			M.E:FireEvent("RAID_SELECTED",self.entity)
		end)
		self.collapsey = 65
		self.expandy = 65

	elseif self.uitype == "Member" then
		self.classText = _G[self.ui:GetName().."Class"]
		self.tipText = _G[self.ui:GetName().."Tip"]
		self.totalBonusText = _G[self.ui:GetName().."TotalBonus"]
		self.bonusText = _G[self.ui:GetName().."Bonus"]
		self.classIcon = _G[self.ui:GetName().."ClassIcon"]
		self.collapsey = 44
		self.expandy = 44

	elseif self.uitype == "Event" then
		self.tipText = _G[self.ui:GetName().."Tip"]
		self.bonusText = _G[self.ui:GetName().."Bonus"]
		self.memberCountText = _G[self.ui:GetName().."MemberCount"]
		self.collapsey = 44
		self.expandy = 44
		self.icon= _G[self.ui:GetName().."Icon"]
	elseif self.uitype == "Item" then
		self.icon = _G[self.ui:GetName().."Icon"]
		self.ui:HookScript("OnClick",function(ui)
			HandleModifiedItemClick(ui.widget.entity:GetLink())
		end)
		self.icon:HookScript("OnClick",function(ui)
			HandleModifiedItemClick(ui:GetParent().widget.entity:GetLink())
		end)

		self.icon:HookScript("OnEnter",function(ui)
			if ui:GetParent().widget.entity:GetLink() then
				GameTooltip:SetOwner(ui,"ANCHOR_LEFT")
				GameTooltip:SetHyperlink(ui:GetParent().widget.entity:GetLink())
				GameTooltip:Show()
			end
		end)
		self.icon:HookScript("OnLeave",function(ui)
			GameTooltip:Hide()
		end)
		
		self.tipText = _G[self.ui:GetName().."Tip"]
		self.bonusText = _G[self.ui:GetName().."Bonus"]
		self.looterText = _G[self.ui:GetName().."Looter"]
		self.collapsey = 44
		self.expandy = 44
	elseif self.uitype == "DKP" then
		self.classText = _G[self.ui:GetName().."Class"]
		self.classIcon = _G[self.ui:GetName().."ClassIcon"]
		self.tipText = _G[self.ui:GetName().."Tip"]
		self.totalBonusText = _G[self.ui:GetName().."TotalBonus"]
		self.bonusText = _G[self.ui:GetName().."Bonus"]
		self.collapsey = 44
		self.expandy = 44
	end

end

function M.Widget.Button:SetEntity(entity)
	self.entity = entity
end

function M.Widget.Button:ClearEntity()
	self.entity = nil
end

function M.Widget.Button:GetEntity()
	return self.entity
end

function M.Widget.Button:GetType()
	return self.uitype
end

function M.Widget.Button:Show()
	self.nameText:SetText(self.entity:GetName())

	if self.uitype == "IItem" then
		
	elseif self.uitype == "Raid" then
		self.dkpText:SetText(self.entity:GetDKP() and self.entity:GetDKP():GetName())
		self.placesText:SetText(self.entity:GetPlaces())
		self.statusText:SetText(self.entity:GetStatusText())
		self.infoText:SetText(self.entity:GetInfoText())--self.entity:GetInfo())
		if(self.entity:IsActivated()) then
			self.nameText:SetTextColor(0,1,1)
			self.activeButton:Disable()
			self.activeButton:SetText(M.L.RAID_PAGE_ACTIVED)
			
		else
			self.nameText:SetTextColor(NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b);
			self.activeButton:Enable()
			self.activeButton:SetText(M.L.RAID_PAGE_ACTIVE)

		end		
	elseif self.uitype == "Member" then
		self.classText:SetText(self.entity:GetClass():GetRenderName())
		if self.entity:GetClass():GetCoord() then
			self.classIcon:SetTexCoord(unpack(self.entity:GetClass():GetCoord()))
			self.classIcon:Show()
			if self.entity:GetStatus() and self.entity:GetInRaid() then
				self.classIcon:SetDesaturated(false)
			else
				self.classIcon:SetDesaturated(true)
			end
		else
			self.classIcon:Hide()
		end
		if self.entity:GetMain() then
			self.nameText:SetTextColor(0.5,0.5,0.5)
			self.totalBonusText:SetText(string.format(M.L.MEMBER_PAGE_MINOR,self.entity:GetMain():GetName()))
			self.bonusText:SetText("")
		else
			self.nameText:SetTextColor(NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b)
			self.tipText:SetText(self.entity:GetSETimeText()) 	
			self.totalBonusText:SetText(string.format(M.L.MEMBER_PAGE_TOTAL_POINT,self.entity:GetTotalPoint()))
			self.bonusText:SetText(string.format(M.L.MEMBER_PAGE_POINT2,self.entity:GetPoint()))
		end

	elseif self.uitype == "Event" then
		self.tipText:SetText(self.entity:GetTip())
		self.icon:SetTexture(self.entity:GetIcon())
		self.icon:Show()
		
		self.bonusText:SetText(string.format(M.L.MEMBER_PAGE_POINT,self.entity:GetPoint()))
		self.memberCountText:SetText(string.format(M.L.EVENT_PAGE_TOTAL_MEMBER ,self.entity:GetRealMemberList():Count()))		
		self.memberCountText:Show()
	elseif self.uitype == "Item" then
		self.icon:SetNormalTexture(self.entity:GetIcon() or  MIDKP_DEFAULT_ITEM_ICON)
		self.icon:Show()
		
		self.tipText:SetText(self.entity:GetTip())
		if self.entity:GetMember():GetMain() then
			self.looterText:SetText(
				string.format(
					M.L.ITEM_PAGE_ACCQUIRE,
					self.entity:GetMember():GetName()..string.format(
						M.L.MEMBER_PAGE_MINOR,
						self.entity:GetMember():GetMain():GetName()
					)
				)
			)
		else
			self.looterText:SetText(
				string.format(
					M.L.ITEM_PAGE_ACCQUIRE,
					self.entity:GetMember():GetName()
				)
			)
		end
		
		self.looterText:Show()
		self.bonusText:SetText(string.format(M.L.MEMBER_PAGE_POINT,self.entity:GetPoint()))
	elseif self.uitype == "DKP" then
		self.classText:SetText(self.entity:GetClass():GetRenderName())
		if self.entity:GetClass():GetCoord() then
			self.classIcon:SetTexCoord(unpack(self.entity:GetClass():GetCoord()))
			self.classIcon:Show()
		else
			self.classIcon:Hide()
		end
		self.tipText:SetText("")
		if self.parent.parent.dkp and self.parent.parent.dkp > 0 then
			self.totalBonusText:SetText("")
			self.bonusText:SetText(string.format(M.L.MEMBER_PAGE_POINT,self.entity:GetHistoryPoint(self.parent.parent.dkp)))
		else
			if M.DO.Config:GetConfig("use_history") then
				self.totalBonusText:SetText(string.format(M.L.MEMBER_PAGE_TOTAL_POINT,self.entity:GetTotalPoint()))
				self.bonusText:SetText(string.format(M.L.DKP_PAGE_HISTORY_LEFT,self.entity:GetLeftPoint()))
			else
				self.totalBonusText:SetText(string.format(M.L.MEMBER_PAGE_POINT2,self.entity:GetPoint()))
				self.bonusText:SetText(string.format(M.L.MEMBER_PAGE_TOTAL_POINT,self.entity:GetTotalPoint()))
			end
			self.tipText:SetText(self.entity:GetSETimeText()) 	
		end
	end
	if self.parent:GetCurrent() and self.parent:GetCurrent() == self.entity then
		self:Expand()
	else
		self:Collapse()
	end
	self.ui:Show()
end

function M.Widget.Button:Hide()
	self.ui:Hide()
end

function M.Widget.Button:Expand()
	if self.uitype == 'IItem' then 
		self.ui:LockHighlight()
		return
	end
	if self.uitype == 'Raid' then
	
		self.placesText:Show()
		self.infoText:Show()
	elseif self.uitype == 'Member'or self.uitype == 'Event'or self.uitype == 'Item' then
		self.tipText:Show()
	elseif self.uitype == 'DKP' then

		self.totalBonusText:Show()
		self.tipText:Show()

	end
	self.ui:SetHeight(self.expandy)
	self:ShowHighLightEdge(self.ui)
	self.parent:Arrange()
end

function M.Widget.Button:Collapse()
	if self.uitype == 'IItem' then 
		self.ui:UnlockHighlight()
		return
	end
	if self.uitype == 'Raid' then
		self.placesText:Hide()
		self.infoText:Hide()
	elseif self.uitype == 'Member'or self.uitype == 'Event'or self.uitype == 'Item' then
		self.tipText:Hide()
	elseif self.uitype == 'DKP' then
		self.totalBonusText:Hide()
		self.tipText:Hide()
	end

	self:HideEdge(self.ui)

	self.ui:SetHeight(self.collapsey)
	self.parent:Arrange()
end


M.Widget.CheckButtonGroup = inheri(M.Widget.Entity)

function M.Widget.CheckButtonGroup:Create(list,single,parent,utype)
	local new_ins = self:class():new()
	new_ins.uiList ={}
	for _i,_t in pairs(list) do
		local checkButton = _G["MiDKP3CheckButtonWidget"..utype.._i]
		if not checkButton then
			checkButton = CreateFrame("CheckButton","MiDKP3CheckButtonWidget"..utype.._i, parent, "MiDKP3CheckButtonTemplate");
			checkButton:SetFrameLevel(parent:GetFrameLevel()+1)
		end
		
		_G[checkButton:GetName().."Text"]:SetText(_t[1])
		
		checkButton.text = _t[1]
		checkButton.check = false
		checkButton:SetChecked(false)
		if _t[3] and type(_t[3]) == 'table' then
			checkButton.entity = _t[3]
		end
		checkButton.id = _i
		table.insert(new_ins.uiList,checkButton)
	end
	
	new_ins:SetSingle(single)
	return new_ins
end

function M.Widget.CheckButtonGroup:ToCheckButtonText(s)
	--check text length and cut if needed
	return s
end

function M.Widget.CheckButtonGroup:ArrayToCheckListFormat(array)
	local t = {}
	for _i,_val in pairs(array) do
		local tbl ={}
		if type(_val)=='table' then
			if _val:GetType()=='Class'  then
				tbl[1] =_val:GetRenderName()
				tbl[2] = false
				tbl[3] =_val
			elseif _val:GetType()=='Member' then
				tbl[1] =_val:GetRenderName()
				tbl[2] = false
				tbl[3] =_val
			elseif _val:GetType() == 'Suite' then
				tbl[1] = _val:GetName()
				tbl[2] = false
				tbl[3] = _val
			end
		else
			tbl = {_val,false}
		end
		table.insert(t, tbl)

	end
	return t
end

-- always start from the topleft corner
function M.Widget.CheckButtonGroup:SetPoint(rel,x,y,width,numRow)
	local row , column = 0 , 0
	for _i,_button in pairs(self.uiList) do
		if not _button.set then
			_button:ClearAllPoints()
			_button:SetWidth(width)
			_button:SetHeight(36)
			_G[_button:GetName().."Text"]:SetWidth(width)
			_button:SetPoint("TOPLEFT",rel,"TOPLEFT",x+column*(width+30),y-row*30)
			_button.set = true
		end
		column = mod(_i,numRow)
		row = floor(_i/numRow)
	end
end

function M.Widget.CheckButtonGroup:Show()
	for _i,_button in pairs(self.uiList) do
		_button:Show()
	end
end

function M.Widget.CheckButtonGroup:Hide()
	for _i,_button in pairs(self.uiList) do
		_button:Hide()
	end
end

function M.Widget.CheckButtonGroup:SetSingle(single)
	self.single = single
	if self.single then
		for _i,_button in pairs(self.uiList) do
			_button:SetScript("OnClick",function(button)
				for _j,otherButton in pairs(self.uiList) do
					if otherButton.id == _button.id then
						otherButton:SetChecked(true)
					else
						otherButton:SetChecked(false)
					end
				end
			end)
			
		end
	else
		for _i,_button in pairs(self.uiList) do
			_button:SetScript("OnClick",function(button)
				if button.check then
					button:SetChecked(false)
				else
					button:SetChecked(true)

				end
				button.check =  button:GetChecked()
			end)
		end
	end
end

function M.Widget.CheckButtonGroup:GetSingle()
	return self.single
end

function M.Widget.CheckButtonGroup:SetCheckButtons(val,disableTag)

	local setButton= function (button,val,t)
		if t then
			if val then
				button:Enable()
				button.disabled = false
				_G[button:GetName().."DisableText"]:Hide()
			else
				button:Disable()
				button.disabled = true
				_G[button:GetName().."DisableText"]:Show()
			end
		else
			if val then
				button:SetChecked(true)
				button.check = true
			else
				button:SetChecked(false)
				button.check = false
			end
		end
	end
	
	local setFromMemberList = function (val)
		for _i,_button in pairs(self.uiList) do
		
			if val:Find(_button.entity) then
				setButton(_button,true,disableTag)
			else
				setButton(_button,false,disableTag)
			end
		end
	end

	local setFromMember = function(val)
		for _i,_button in pairs(self.uiList) do
			if val ==_button.entity then
				setButton(_button,true,disableTag)
			else
				setButton(_button,false,disableTag)

			end
		end
	end
	
	local setFromValList = function (val)
		for _i,_button in pairs(self.uiList) do
			setButton(_button,val[_i],disableTag)
		end
	end	
	
	local setFromNumber = function (val)
		for _i,_button in pairs(self.uiList) do
			if _button.id == val then
				setButton(_button,true,disableTag)
			else
				setButton(_button,false,disableTag)		
			end
		end
	end
	
	local setFromString = function (val)
		for _i,_button in pairs(self.uiList) do
			if _button.text == val then
				setButton(_button,true,disableTag)
			else
				setButton(_button,false,disableTag)		
			end
		end
	end

	if self:GetSingle() then
		if type(val) =='table' then
			if val:GetType() == 'Member' then
			setFromMember(val)
			elseif val:GetType() == 'MemberList' then
				setFromMemberList(val)
			end
		elseif type(val) =='string' then
			setFromString(val)
		elseif type(val) == 'number' then
			setFromNumber(val)
		end
	else
		if type(val) =='table' then
		
			if val.GetType and val:GetType() == 'MemberList' then
				 setFromMemberList(val)
			else
				 setFromValList(val)
			end
		
		end
	end

end

function M.Widget.CheckButtonGroup:GetVal()
	
	local getSingleVal = function()
		for _i,_button in pairs(self.uiList) do
			if _button:GetChecked() then
				return _button.id,_button.text,_button.entity
			end
		end
	end
	
	local getMultiVal = function ()
		local t= {}
		for _i,_button in pairs(self.uiList) do
			if _button:GetChecked() then
				t[_i]={ true,_button.id,_button.text,_button.entity}
			else
				t[_i]={ false,_button.id,_button.text,_button.entity}
			end
		end
		return t
	end

	if self:GetSingle() then
		return getSingleVal()
	else
		return getMultiVal()
	end
	
end

function M.Widget.CheckButtonGroup:ReverseChecks()
	for _i,_button in pairs(self.uiList) do
		if not _button.disabled then
			_button.check = not _button.check
			_button:SetChecked(_button.check)
		end
	end
end

function M.Widget.CheckButtonGroup:SetClickScript(func)
	for _i,_button in pairs(self.uiList) do
		_button:HookScript("OnClick",func)
	end
end


M.Widget.SingleCheckButton = inheri(M.Widget.Entity)

function M.Widget.SingleCheckButton:Create(ui)
	local news = self:class():new()
	news.ui = ui
	return news
end

function M.Widget.SingleCheckButton:HookConfig(val)
	self.val = val
	self.ui:SetScript("OnClick",function(ui)
		M.DO.Config:SetConfig(self.val,not M.DO.Config:GetConfig(self.val) )
		if (M.DO.Config:GetConfig(self.val)) then
			ui:SetChecked(true)
		else
			ui:SetChecked(false)
		end
	end)
end

function M.Widget.SingleCheckButton:Show()
	if (M.DO.Config:GetConfig(self.val)) then
		self.ui:SetChecked(true)
	else
		self.ui:SetChecked(false)
	end
	self.ui:Show()
end

function M.Widget.SingleCheckButton:HookScript(func)
	self.ui:HookScript("OnClick",func)
end

function M.Widget.SingleCheckButton:Disable()
	self.ui:Disable()
end

function M.Widget.SingleCheckButton:Enable()
	self.ui:Enable()
end

M.Widget.Tab = inheri(M.Widget.Entity)

function M.Widget.Tab:Create()
	return self:class():new()
end

function M.Widget.Tab:SetRaise()
	local tab = self.ui
	local left = getglobal(tab:GetName().."Left");
	local right = getglobal(tab:GetName().."Right");
	local center = getglobal(tab:GetName().."Center");
	local back = getglobal(tab:GetName().."Background");
	local text = getglobal(tab:GetName().."Text");

	tab:SetHeight(50);

	left:SetWidth(18);
	left:SetHeight(50);
	left:SetTexCoord(0.25390625, 0.3203125, 0.28515625, 0.4765625);

	right:SetWidth(13);
	right:SetHeight(50);
	right:SetTexCoord(0.49609375, 0.54296875, 0.28515625, 0.4765625);

	center:SetWidth(44);
	center:SetHeight(50);
	center:SetTexCoord(0.32421875, 0.4921875, 0.28515625, 0.4765625);

	back:ClearAllPoints();
	back:SetPoint("TOPLEFT", left, "TOPLEFT", 9, 2);
	back:SetPoint("BOTTOMRIGHT", right, "BOTTOMRIGHT", -4, 9);

	text:SetPoint("CENTER", tab, "CENTER", 2, 0);

	local id = tab:GetID();
	if (id == 1) then
		tab:SetPoint("BOTTOMLEFT", tab:GetParent(), "BOTTOMLEFT", 20, -24);
	else
		local last_id = id - 1;
		local last_tab = getglobal(tab:GetParent():GetName().."Tab"..last_id);
		if (last_tab) then
			if (last_tab.raise) then
				tab:ClearAllPoints();
				tab:SetPoint("BOTTOMLEFT", last_tab, "BOTTOMRIGHT", 0, 0);
			else
				tab:ClearAllPoints();
				tab:SetPoint("BOTTOMLEFT", last_tab, "BOTTOMRIGHT", 0, -2);
			end
		end
	end

	tab.raise = true;
		
end

function M.Widget.Tab:SetLower()
	local tab = self.ui
	local left = getglobal(tab:GetName().."Left");
	local right = getglobal(tab:GetName().."Right");
	local center = getglobal(tab:GetName().."Center");
	local back = getglobal(tab:GetName().."Background");
	local text = getglobal(tab:GetName().."Text");
	tab:SetHeight(31);

	left:SetWidth(19);
	left:SetHeight(31);
	left:SetTexCoord(0.69921875, 0.76953125, 0.87890625, 0.99609375);

	right:SetWidth(14);
	right:SetHeight(31);
	right:SetTexCoord(0.94140625, 0.9921875, 0.87890625, 0.99609375);

	center:SetWidth(43);
	center:SetHeight(31);
	center:SetTexCoord(0.7734375, 0.9375, 0.87890625, 0.99609375);

	back:ClearAllPoints();
	back:SetPoint("TOPLEFT", left, "TOPLEFT", 11, 0);
	back:SetPoint("BOTTOMRIGHT", right, "BOTTOMRIGHT", -6, 10);

	text:SetPoint("CENTER", tab, "CENTER", 2, 5);

	local id = tab:GetID();
	if (id == 1) then
		tab:ClearAllPoints();
		tab:SetPoint("BOTTOMLEFT", tab:GetParent(), "BOTTOMLEFT", 20, -22);
	else
		local last_id = id - 1;
		local last_tab = getglobal(tab:GetParent():GetName().."Tab"..last_id);
		if (last_tab) then
			if (last_tab.raise) then
				tab:ClearAllPoints();
				tab:SetPoint("BOTTOMLEFT", last_tab, "BOTTOMRIGHT", 0, 2);
			else
				tab:ClearAllPoints();
				tab:SetPoint("BOTTOMLEFT", last_tab, "BOTTOMRIGHT", 0, 0);
			end
		end
	end

	tab.raise = nil;
end

