MiDKP=MiDKP or {}

local M  = MiDKP

string.twodigitfloat = function(__number)
	if math.abs(__number)<0.01 then return 0 end
	return string.format("%d",__number*100)/100
end
string.iequal = function(s1,s2)
	return s1:upper() == s2:upper()
end
table.copy = function(object)
	local lookup_table = {}
		local function _copy(object)
			if type(object) ~= "table" then
				return object
			elseif lookup_table[object] then
				return lookup_table[object]
			end
			local new_table = {}
			lookup_table[object] = new_table
			for index, value in pairs(object) do
				new_table[_copy(index)] = _copy(value)
			end
			return setmetatable(new_table, getmetatable(object))
		end
    return _copy(object)
end
table.append = function (t1,t2)
	if not t2 then return end
	for _,_v in pairs(t2) do
		table.insert(t1,_v)
	end
end
M.U={}

function M.U:Init()
	if M.Debug then
		DEFAULT_CHAT_FRAME:SetMaxResize(600,1000)
		DEFAULT_CHAT_FRAME:SetMaxLines(2000)
	end
	M.U:Debug("Util Class Inited")
	M.U.LOOT_ITEM = self:String2Pattern(LOOT_ITEM)
	M.U.LOOT_ITEM_MULTIPLE = self:String2Pattern(LOOT_ITEM_MULTIPLE)

	M.U.LOOT_ITEM_SELF = self:String2Pattern(LOOT_ITEM_SELF)
	M.U.LOOT_ITEM_SELF_MULTIPLE = self:String2Pattern(LOOT_ITEM_SELF_MULTIPLE)

	M.U.LOOT_ITEM_PUSHED_SELF = self:String2Pattern(LOOT_ITEM_PUSHED_SELF)
	M.U.LOOT_ITEM_PUSHED_SELF_MULTIPLE = self:String2Pattern(LOOT_ITEM_PUSHED_SELF_MULTIPLE)
	
end

function M.U:PrintColor()
	DEFAULT_CHAT_FRAME:SetMaxLines(1000)
	local color ={"00","11","22","33","44","55","66","77","88","99","aa","bb","cc","dd","ee","ff"}
	count = 0
	local s = ""
	for _i,_r in pairs(color) do
		for _j,_g in pairs(color) do
			for _i,_b in pairs(color) do
				s = s .."|cff".._r.._g.._b .."[".._r.._g.._b.."]|r"
				count = count + 1
				if count % 8 ==0 then
					print(s)
					s = ""
				end
			end
		end	
	end
end

function M.U:ParsePoint(point, noinfo)
	if (type(point) == "string") then
		if (not string.find(point, "^([%+%-%.0-9]+)$")) then
			if (not noinfo) then
				M.E:ThrowError("EDIT_INVALID_POINT")
			end
			return
		end
		point = tonumber(point)
	elseif (type(point) ~= "number") then
		return
	end
	return point
end
	
function M.U:SplitString(szFullString, szSeparator)
	local nFindStartIndex = 1
	local nSplitIndex = 1
	local nSplitArray = {}
	while true do
		local nFindLastIndex = string.find(szFullString, szSeparator, nFindStartIndex)
		if not nFindLastIndex then
			nSplitArray[nSplitIndex] = string.sub(szFullString, nFindStartIndex, string.len(szFullString))
			break
		end
		nSplitArray[nSplitIndex] = string.sub(szFullString, nFindStartIndex, nFindLastIndex - 1)
		nFindStartIndex = nFindLastIndex + string.len(szSeparator)
		nSplitIndex = nSplitIndex + 1
	end
	return nSplitArray
end
	
function M.U:String2Pattern(__str)
	__str = string.gsub(__str, "%(", "%%(")
	__str = string.gsub(__str, "%)", "%%)")
	__str = string.gsub(__str, "%%s", "(.-)")
	__str = string.gsub(__str, "%%d", "(%%d+)")
	return __str
end
	
function M.U:GetTimeStamp()
	local _, month, day, year = CalendarGetDate()
	local hour,minute = GetGameTime()
	if not month or not day or not year or not hour or not minute then
		return 
	end

	local t1,timevalue = pcall(function() return (year - 2000) * 60 * 60 * 365 + month * tonumber(string.format("%04d%02d%02d%02d%02d", year, month, day, hour, minute)) end)
	local t2,timestring = pcall(function()return string.format("%04d.%02d.%02d %02d:%02d", year, month, day, hour, minute)end)
	if t1 and t2 then
		return {timestring, timevalue}
	end
	return nil
end
	
function M.U:JoinString(tbl, sep)
	if (not sep) then
		sep = " "
	end

	local __str = ""
	local i, __v
	if (tbl) then
		for i, __v in ipairs(tbl) do
			__str = __str .. __v .. sep
		end
	end

	if (string.len(__str) > 0) then
		return string.sub(__str, 1, string.len(__str) - string.len(sep))
	end
end

function M.U:GetTimeString(interval)
	local day, hour, minute, second
	local ret = ""

	day = floor(interval/86400)
	interval = interval - day * 86400
	hour = floor(interval/3600)
	interval = interval - hour * 3600
	minute = floor(interval/60)
	interval = interval - minute * 60
	second = floor(interval)

	if (day > 0) then
		ret = ret .. day .. MIDKP_TEXT_DAY
	end

	if (hour > 0) then
		ret = ret .. hour .. MIDKP_TEXT_HOUR
	end

	if (minute > 0) then
		ret = ret .. minute .. MIDKP_TEXT_MINUTE
	end

	if (second > 0) then
		ret = ret .. second .. MIDKP_TEXT_SECOND
	end

	return ret
end

function M.U:ParseHTMLText(__text)
	__text = string.gsub(__text, "<", "&lt;")
	__text = string.gsub(__text, ">", "&gt;")
	__text = string.gsub(__text, "|", "$")
	return __text
end
	
function M.U:FindString(__str, __pattern)
	local __parseFind=function(s, e, ...)
		if (s and e) then
			return ...
		end	
	end

	return __parseFind(string.find(__str, __pattern))
end
	
function M.U:FindItemLink(__str)
--	return __str
--return first item link
	local __e,__f,__val
	__e,__f,__val= string.find(__str,"(|c%x+|Hitem:%d+:%-?%d+:%-?%d+:%-?%d+:%-?%d+:%-?%d+:%-?%d+:%-?%d+:%-?%d+|h%[.+%]|h|r).*")
	if(__e and __f)then
		return __val
	end
end

function M.U:ParseItemLink(link)
	if (link) then
		for id, name in string.gmatch(link, "|c%x+|Hitem:(%d+):%-?%d+:%-?%d+:%-?%d+:%-?%d+:%-?%d+:%-?%d+:%-?%d+:%-?%d+|h%[(.+)%]|h|r") do
			return tonumber(id), name
		end
	end
end

function M.U:GetItemLink(arg1)
	local __player,__itemLink,__count
	if (not __itemLink) then
			__player, __itemLink, __count = self:FindString(arg1, M.U.LOOT_ITEM_MULTIPLE)
		end
		
		if (not __itemLink) then
			__player, __itemLink = self:FindString(arg1, M.U.LOOT_ITEM)
		end
				
		if (not __itemLink) then
			__itemLink, __count = self:FindString(arg1, M.U.LOOT_ITEM_SELF_MULTIPLE)
		end
		if (not __itemLink) then
			__itemLink = self:FindString(arg1, M.U.LOOT_ITEM_SELF)
		end
		
		if (not __itemLink) then
			__itemLink = self:FindString(arg1, M.U.LOOT_ITEM_PUSHED_SELF)
		end
		if (not __itemLink) then
			__itemLink,__count  = self:FindString(arg1, M.U.LOOT_ITEM_PUSHED_SELF_MULTIPLE)
		end
		
	
		if (not __player or  __player == M.L.YOU) then
			__player = UnitName("player")
		end

		if (not __itemLink) then
			return
		end
		 __count = __count or 1
		return __player,__itemLink,(__count == 1 and __itemLink) or __itemLink.."x"..__count
end

function M.U:Print(__type, msg, ...)
	local message = string.format(msg, ...)
	local color = {}

	if (message) then
		message = M.L["MESSAGE_"..(string.upper(__type) or "INFO")]..message
	end

	if (message) then
		DEFAULT_CHAT_FRAME:AddMessage(message, 1.0, 0.82, 0.0)
	end
end

function M.U:Debug(msg,...)
	if M.Debug then
		if type(msg) ~='table' and type(msg) ~='function' then
			self:Print('debug',msg,...)
		elseif type(msg) == 'table' then
			self:Dump(msg)
		end
	end
end

function M.U:Dump(...)
	
	local function isScalar(arg)
		if (type(arg) == "table" or type(arg) == "function" or type(arg) == "userdata") then
			return nil;
		else
			return true;
		end
	end
		
	local function getScalarValue(arg)
		if(type(arg)=='boolean') then
			if arg then 
				return 'true'
			else
				return 'false'
			end
		elseif (not arg) then
			arg = "(nil)";
		elseif (not isScalar(arg)) then
			arg = "("..type(arg)..")";
		end

		return arg;
	end
	
	local function getIndent(lvl)
		local s = ""
		for _i = 0,lvl do
			s = s .. M.L.SPACE
		end
		return s
	end
	
	local function getPrintableValue(arg,level)
		if (type(arg) == "table" and level <3) then
			local string = "{\n"..getIndent(level);
			local seperator = "";
			local key, value;

			for key, value in pairs(arg) do
				string = string .. seperator .. getPrintableValue(key,level+1) .. " = " .. getPrintableValue(value,level+1);
				seperator = ",\n"..getIndent(level);
			end
			string = string .. "\n"..getIndent(level - 1).."}";

			return string;
		else
			return getScalarValue(arg);
		end
	end
	local args = {...};
	local msg = "Table:\n";

	for i = 1, getn(args), 1 do
		msg = msg .. getPrintableValue(args[i],0);
	end

	if (msg == "") then
		msg = "(empty)";
	end

	print(msg);
end

function M.U:RenderText(text, color)
	if(not color) or (not text) or type(text)=='table' or type(color)=='table' then return "" end
	return "|"..color..text.."|r"
end	

function M.U:Size(__table)
	local __count = 0
	local __k, __v
	for __k, __v in ipairs(__table) do
		__count = __count + 1
	end
	
	if(__count==0)then
		for __k, __v in pairs(__table) do
			__count = __count + 1
		end
	end
	return __count
	
end

function M.U:IsValidName(__name)
	if string.find(__name,"-") then return false	

	elseif string.len(__name)<2 then return false
	else
		return true
	end
end

function M.U:SafePopup_Show(__name,...)
	 if not UnitIsDeadOrGhost(UnitName("player")) then
		StaticPopup_Show(__name,...)
		M.UI.Util:SetMainFrameEnable(false)
	else
		self:Print("error",M.L.DEAD)
	 end
end

function M.U:AppendTable(t,t2)
	table.concat(t,t2)
end

function M.U:PlayerNameFormat(player)
	return ">"..player:GetName().."<"
end

function M.U:Whisper(member,msgList,hideReply)
	for _,_msg in pairs(msgList)do
		local id = _msg .. ":" .. member:GetName()
		if  hideReply then
			MiDKP_HiddenWhisper[id] = true
			MiDKP_AFKDND[member:GetName()] = GetTime()
		end
		SendChatMessage(_msg, "WHISPER", nil, member:GetName())
	end
end

function M.U:Send(msgList,channel)
	
	for _,_msg in pairs(msgList)do
		SendChatMessage(_msg,channel)
	end
end

M.U.DB = {}

function M.U.DB:Load(id)
	local t = self[id]
	if not t then return nil end
	local entity = M.OO[t.type]:Load(t,id)
	return entity
end

