MiDKP=MiDKP or {}

local M = MiDKP

M.DO={}

M.DO.Raid={}

M.Data={}
--------------------
------  raid -------
--------------------
function M.DO.Raid:AddRaid(raid)
	if M.Data.Raids:Find(raid) then
		M.E:FireEvent("RAID_MODIFIED",raid)
		return
	end
	M.Data.Raids:Add(raid)
	M.E:FireEvent("RAID_CREATED",raid)
	
end

function M.DO.Raid:DeleteRaid(raid)
	if raid:IsActivated() then
		self:Deactivate()
	end
	M.Data.Raids:Delete(raid)
	M.E:FireEvent("RAID_DELETED",raid)
	M.DB[raid:GetID()] = nil
end

function M.DO.Raid:StartRaid(raid)
	self:ActivateRaid(raid)
	raid:Start()
	M.DO.Member:UpdateMembersDKP()
end

function M.DO.Raid:EndRaid(raid)
	raid:End()
	M.E:FireEvent("RAID_ENDED",raid)
	
end

function M.DO.Raid:ModifyRaid(raid,name,suite)
	raid:Modify(name,suite)
end

function M.DO.Raid:IsRunning()
	if M.Data.Raid and M.Data.Raid:IsRunning() then
		return true
	else
		return false
	end	
	
end

function M.DO.Raid:IsStarted()
	if M.Data.Raid and M.Data.Raid:GetStatus()~=MIDKP_STAT_INITED then
		return true
	else
		return false
	end	
end

function M.DO.Raid:Deactivate()
	M.Data.Raids:Deactivate()
	M.Data.Raid = nil
	M.Data.Events = nil
	M.Data.Members = nil
	M.Data.Items = nil
	M.Data.DKPs = nil
end

function M.DO.Raid:ActivateRaid(raid)
	if raid then 
		M.Data.Raids:SetActivate(raid)	
	end
	M.E:FireEvent("RAID_ACTIVATED",raid)
	self:SetShortCuts()
	M.E.H:RaidUpdate()		

end

function M.DO.Raid:SetShortCuts()
	if M.Data.Raids:GetActive() then
		M.Data.Raid = M.Data.Raids:GetActive()
		M.Data.Events = M.Data.Raid:GetEventList()
		M.Data.Members = M.Data.Raid:GetMemberList()
		M.Data.Items = M.Data.Raid:GetItemList()
		M.Data.DKPs = M.Data.Members
		M.DO.Member:UpdateMembersDKP()
		M.DO.Member:UpdateMemberPoint()
	end
end

function M.DO.Raid.SaveAll()
	M.Data.Raids:RunList("SaveAll")
end

function M.DO.Raid:ShallowLoad()
	--load raid from MiDKP3_Config.raids to M.Data.Raids
	M.U:Debug("Shallow Load")
	for _raid_id,_raid in pairs( M.DB) do
		if _raid.entities then 
			setmetatable(_raid.entities,{__index = M.U.DB})
			local raid = M.OO.Raid:Load(_raid_id)
			M.Data.Raids:Add(raid)
			for _id,_t in pairs(_raid.entities) do	
				local entity = _raid.entities:Load(_id)
				if entity then
					if entity:GetType() == "Member" then
						raid:AddMember(entity)
					elseif entity:GetType() == "Item" then
						raid:AddItem(entity)
					elseif entity:GetType() =="Event" then
						raid:AddEvent(entity)
					end
				end			
			end
		end
	end
	-- for each raid, load events and members and items
end

function M.DO.Raid:DeepLoad()
	M.U:Debug("Deep Load")
	M.Data.Raids:RunList("DeepLoad")
end

function M.DO.Raid:OldLoad()
	for _,_raid in pairs(M.OldDB) do
		local raid = M.OO.Raid:Create(_raid.name,M.Data.Suites:Find(_raid.dkp))
		M.Data.Raids:Add(raid)
		pcall(function()
			if _raid["end"]  and  _raid["start"] then
				raid.status = MIDKP_STAT_ENDED
				raid.startTime = _raid["start"].time
				raid.endTime = _raid["end"].time
			elseif _raid["start"] then
				raid.status = MIDKP_STAT_STARTED
				raid.startTime = _raid['start'].time
			else
				raid.status = MIDKP_STAT_INITED
			end
		end)
		if _raid.members then
			for _name,_tbl in pairs(_raid.members) do
				pcall(function()
					local member = M.OO.Member:Create(_name,_tbl.class)
					member.startTime = _tbl.join
					member.endTime = _tbl.endTime
					raid:AddMember(member)
				end)
			end
		end
		if _raid.events then
			for _,_tbl in pairs(_raid.events) do
				pcall(function()
					local event = M.OO.Event:Create(false,false,_tbl.point,_tbl.desc)
					event.ctime = _tbl.time
					event.players = _tbl.players
					for _,_name in pairs(event.players) do
						event:AddMember(raid:GetMemberList():Find(_name))
					end
					raid:AddEvent(event)
				end)
			end
		end
		if _raid.items then
			for _,_tbl in pairs(_raid.items) do
				pcall(function()
					local item = M.OO.Item:Create(_tbl.item,_tbl.point)
					item.ctime = _tbl.time
					item.player = _tbl.players[1]
					item:SetMember(raid:GetMemberList():Find(item.player))
					raid:AddItem(item)
				end)
			end
		end
	end
end



function M.DO.Raid:Init()
	
	M.U:Debug("Raid Inited")
	M.S:DoRaidHook()
	M.Data.Raids =  M.OO.RaidList:Create()
	
	local function loadConfig()
		MiDKP3_Config = MiDKP3_Config or{}
		MiDKP3_Config.raids = MiDKP3_Config.raids or {}
		M.DB = MiDKP3_Config.raids
	end

	local function loadOldConfig()
		M.OldDB = MiDKP_Config.raids 
		M.DB = {}
		MiDKP3_Config = MiDKP3_Config or {}
		MiDKP3_Config.raids = M.DB
	end
	
	if MiDKP_Config and MiDKP_Config.raids then
		loadOldConfig()
		--init raid list
	
		self:OldLoad()
		
		MiDKP_Config = nil
	else
		loadConfig()
		-- load MiDKP_Config3

		self:ShallowLoad()
		--load event, item and member 
		
		self:DeepLoad()
		--load relations here
	end


	
	self:SetShortCuts()
	--set current raid


end

function M.DO.Raid:UpdateMembers(checkLeave)
	if checkLeave then
		local updatedList = M.OO.MemberList:GetCurrentRaidMembers()
		local _leaveList,_joinList,_updateList= M.Data.Raid:CompareMember(updatedList)
		--do compare here
		M.DO.Member:UpdateLeaveMemberList(_leaveList)
		M.DO.Member:UpdateNewMemberList(_joinList)
		M.DO.Member:UpdateExistMemberList(_updateList)	
	else
		local updatedList = M.OO.MemberList:GetCurrentRaidMembers()
		M.DO.Member:UpdateExistMemberList(updatedList)	
	end
end

---------------------
------ member -------
---------------------
M.DO.Member = {}
function M.DO.Member:AddMember(member,checkAltData)
	local oldMember = M.Data.Members:Find(member) 
	if oldMember then 
		oldMember:SetDeleted(false)
		oldMember:Modify(oldMember:GetName(),member:GetClass())
		M.E:FireEvent("MEMBER_CREATED",oldMember)
		M.Data.Events:OnAddMember(oldMember)
		self:UpdateMemberPoint()
		return
	end
	if checkAltData then
		M.DO.Alt:CheckMember(member)		
	end
	if M.Data.Raid:AddMember(member) then M.E:FireEvent("MEMBER_CREATED",member) end
end

function M.DO.Member:DelMember(member)
	M.E:Assert(not member:HasMinor(),"MEMBER_HAS_MINOR")
	M.E:Assert(not M.Data.Items:HasMember(member),"MEMBER_HAS_ITEM")
	member:SetDeleted(true)
--	M.Data.Raid:DeleteMember(member)
	M.Data.Events:DeleteMember(member)
	M.E:FireEvent("MEMBER_DELETED",member)
	self:UpdateMemberPoint()
end

function M.DO.Member:ModifyMember(member,name,class)
	member:Modify(name,class)
end

function M.DO.Member:GetDefaultMemberList()

	if M.DO.Config:GetConfig("default_group") == 1 then
		return M.Data.Members:GetInFirstFive(M.DO.Config:GetConfig("member_record_disconnected"))
	elseif M.DO.Config:GetConfig("default_group") == 2 then
		return M.Data.Members:GetInRaid(M.DO.Config:GetConfig("member_record_disconnected"))
	elseif M.DO.Config:GetConfig("default_group") == 3 then
		return M.Data.Members:GetMainMemberList()
	end	
	--return the default member list
end

function M.DO.Member:UpdateMemberPoint(entity,type)
	if not entity then
		M.Data.Members:ClearMemberPoint()
		M.Data.Events:UpdateMemberPoint()
		M.Data.Items:UpdateMemberPoint()
	elseif type == 'Add' then
		entity:OnAdded()
	elseif type == 'Delete' then
		entity:OnDelete()		
	elseif type == 'Modify' then
		entity:OnModify()		
	end
end


function M.DO.Member:UpdateMembersDKP()
	M.Data.Members:UpdateMembersDKP()
end

function M.DO.Member:UpdateNewMemberList(list)
	list:SetStartTime()
	list:RunList(function(entity) M.Data.Raid:AddMember(entity,true) end)

end

function M.DO.Member:UpdateExistMemberList(list)
	list:RunList(function(entity) M.Data.Members:UpdateMemberStatus(entity) end)
end

function M.DO.Member:UpdateLeaveMemberList(list)
	list:SetEndTime()
	list:RunList(function(entity)
		entity:SetStatus(nil,false,nil)
		entity:SetInRaid(false)
	end)
end

function M.DO.Member:FindPlayer(name)
	return M.Data.Members and M.Data.Members:Find(name) or M.Data.DKP and M.Data.DKP:Find(name)
end

function M.DO.Member:SetMain(minorMember,mainMember)
	minorMember:SetMain(mainMember)
	M.DO.Alt:AddMain(minorMember,mainMember)
	M.E:FireEvent("POINT_MODIFIED")
end

function M.DO.Member:CancelMinor(minor)
	minor:ClearMain()
	M.DO.Alt:ClearMain(minor)
	M.E:FireEvent("POINT_MODIFIED")
end

function M.DO.Member:GetSetMainMemberList(current)
	local menuList = {}
	M.Data.Members:GetUndeleted():RunList(function(entity)
		if entity~=current and not entity:GetMain() then
			tinsert(menuList,{
				text = entity:GetName(),
				value = entity,
				func = M.UI.Member.SetMainMenuFunc
			})
		end
	end)
	return menuList
end

---------------------
------- event -------
---------------------

--manually add event
M.DO.Event = {}

function M.DO.Event:AddEvent(event)
	M.E:Assert(M.Data.Raid:GetStatus() ~= MIDKP_STAT_INITED,"RAID_NOT_STARTED")
	M.E:Assert(event:GetMemberList():Count()>0,"EVENT_EMPTY_MEMBERS")
	if not M.Data.Events:Find(event) then
		M.Data.Raid:AddEvent(event)
		M.E:FireEvent("EVENT_CREATED",event)
		M.E:FireEvent("POINT_MODIFIED",M.DO.Member,event,"Add")
	else
		M.E:FireEvent("EVENT_MODIFIED",event)
	end	
	return event	
end
--manually modify event point
function M.DO.Event:ModifyEvent(event,name,memberList,isBoss,point)
	event.oldPoint = event:GetPoint()
	event.oldMemberList = event:GetRealMemberList()
	event:Modify(point,name)
	event:SetBoss(isBoss)
	M.E:Assert(memberList:Count()>0,"EVENT_EMPTY_MEMBERS")
	event:SetMemberList(memberList)
	if M.Data.Events:Find(event) then
		M.E:FireEvent("POINT_MODIFIED",M.DO.Member,event,"Modify")
	end

end

function M.DO.Event:DelEvent(event)
	M.Data.Raid:DeleteEvent(event)
	M.E:FireEvent("EVENT_DELETED",event)
	if event:IsItemDrive() then
		M.E:FireEvent("EVENT_DELETE_SPLIT",event)
	end
	M.E:FireEvent("POINT_MODIFIED",M.DO.Member,event,"Delete")

end

--modify split events (only to member here)

--called when splited item created
function M.DO.Event.OnNewSplitItem(item)
	local event = M.OO.Event:Create(false,true,item)
	event:SetMemberList(M.DO.Member:GetDefaultMemberList())
	M.DO.Event:AddEvent(event)
end

--called when splited item deleted
function M.DO.Event.OnDelSplitItem(item)
	M.DO.Event:DelEvent(item:GetEvent())
end

----------------------
------  item ---------
----------------------
M.DO.Item = {}

function M.DO.Item:AddItem(item)
	M.E:Assert(M.Data.Raid:GetStatus() ~= MIDKP_STAT_INITED,"RAID_NOT_STARTED")
	if not M.Data.Items:Find(item) then
		M.Data.Raid:AddItem(item)
		M.E:FireEvent("ITEM_CREATED",item)
		M.E:FireEvent("POINT_MODIFIED",M.DO.Member,item,"Add")
	else
		M.E:FireEvent("ITEM_MODIFIED",item)
	end	

end

function M.DO.Item:DelItem(item)
	M.Data.Raid:DeleteItem(item)
	M.E:FireEvent("ITEM_DELETED",item)
	if item:GetEvent() then
		M.E:FireEvent("ITEM_DELETE_SPLIT",item)
	end
	M.E:FireEvent("POINT_MODIFIED",M.DO.Member,item,"Delete")

end

function M.DO.Item:ModifyItem(item, name,point, member, split)
	item.oldPoint = item:GetPoint()
	item.oldMember = item:GetMember() and item:GetMember() :GetRealMember()
	if item:GetEvent() then
		local event = item:GetEvent()
		event.oldMemberList = event:GetRealMemberList()
		event.oldPoint = event:GetPoint()
	end
	item:Modify(point,name)
	
	M.E:Assert(member,"ITEM_NOMEMBER")
	item:SetMember(member)
	if item:GetEvent() and not split then
		M.E:FireEvent("ITEM_DELETE_SPLIT",item)
	elseif not item:GetEvent() and split then
		if M.DO.Member:GetDefaultMemberList():Count()>0 then
			M.E:FireEvent("ITEM_NEW_SPLIT",item)
		else
			M.E:ThrowError("DEFAULT_MEMBER_EMPTY")
		end
	elseif item:GetEvent() and split then
		item:GetEvent():OnModify()
	end
	if M.Data.Items:Find(item) then
		M.E:FireEvent("POINT_MODIFIED",M.DO.Member,item,"Modify")
	end
end

function M.DO.Item.OnDelSplitEvent(event)
	event:GetItem():ClearEvent()
end


M.DO.Config = {}

function M.DO.Config:Init()
	M.U:Debug("Config Class Inited")
	local function loadOption()
		M.Options = MiDKP3B_Options or {}
		MiDKP3B_Options = M.Options
	end
	loadOption()
	self.iitems  = M.OO.IItemList:Create()
	if M.Options.iitems then
		self.iitems:Load(M.Options.iitems)
	else
		M.Options.iitems={}
		self:ResetIgnoredItems()
	end
	self.init =true
end

function M.DO.Config:GetConfig(name)
	if not M.Options then
		self:Init()
	end
	if M.Options[name]==nil then 
		M.Options[name] = MiDKP3B_Options and MiDKP3B_Options[name];
		if M.Options[name] == nil then
			M.Options[name] =  M.DefaultOptions[name]
		end
	end
	
	if M.Options[name] and  type(M.Options[name]) ~= "table"  then
		return M.Options[name]
	end
	if M.Options[name] and type(M.Options[name]) == "table" then
		return unpack(M.Options[name])
	end
	-- get config by name
end

function M.DO.Config:SetConfig(name,val)
	if M.Options then
		M.Options[name] = val
	end
	--set config value
end

function M.DO.Config:GetIgnoredItems()
	return self.iitems
end

function M.DO.Config:ResetIgnoredItems()
	self.iitems:Reset()
	self.iitems:Save(M.Options.iitems)
end

function M.DO.Config:IsIgnoredItem(item)
	return self.iitems:Find(item)
end

function M.DO.Config:AddIgnoredItem(item)
	self.iitems:Add(item)
	self.iitems:Save(M.Options.iitems)
end

function M.DO.Config:DeleteIgnoredItem(item)
	self.iitems:Delete(item)
	self.iitems:Save(M.Options.iitems)
end

M.DO.DKP={}

function M.DO.DKP:Init()

	M.U:Debug("DKPData inited")
	-- load dkp points
	--list of DKPmember created
	M.Data.Suites = M.OO.List:Create()
	M.Data.DKP = M.OO.DKPMemberList:Create()
	if not MiDKPData then 
		--throw no data error
		return 
	end
	for _i, _dkp in pairs (MiDKPData.dkp) do
		M.Data.Suites:Add(M.OO.DKPSuite:Create(_dkp.name,_i))
	end
	
	
	for _i, _dkp in pairs(MiDKPData.dkp) do
		for _name,_data in pairs(_dkp.members) do
			local member = M.Data.DKP:Find(_name) 
			if not member then
				member = M.OO.DKPMember:Create(_name,M.OO.Class:GetByName(_data.class))
				M.Data.DKP:Add(member)
			end
			member:SetPoint(M.Data.Suites:Get(_i),_data.score)
		end
	end
end

function M.DO.DKP:GetSuite(i)
	if not i or i == 0 then return M.Data.Members and M.Data.Members:GetUndeleted():GetMainMemberList() end
	return M.Data.DKP:GetSuite(i)
end

function M.DO.DKP:GetSuiteName(i)
	if not i then return "" end
	return M.Data.Suites:Get(i) and M.Data.Suites:Get(i):GetName()
end

function M.DO.DKP:GetNameArray()
	return M.Data.Suites
end


M.DO.Notify = {}

function M.DO.Notify:AddBossEvent(boss)
	local event = M.OO.Event:Create(true,false,M.OO.Event.tempScore or 0,string.format(M.L.EVENT_PAGE_FINISH , boss:GetName()))
	M.DO.Raid:UpdateMembers()
	event:SetMemberList(M.DO.Member:GetDefaultMemberList())
	event:SetBoss(true)
	M.DO.Event:AddEvent(event)
	M.E:FireEvent("EVENT_NEW_SYS",event)
	
end

function M.DO.Notify:AddItemEvent(itemString,member)
	local item = M.OO.Item:Create(itemString, 0)
	M.DO.Item:ModifyItem(item, itemString,0, member, M.DO.Config:GetConfig("default_split"))
	M.DO.Item:AddItem(item)
	M.E:FireEvent("ITEM_NEW_SYS",item)
	
end

M.DO.Chat = {}

function M.DO.Chat:ParseCommand(msg)
	msg = string.lower(msg) or ""
	if msg == string.lower(M.DO.Config:GetConfig("whisper_command")) then
		return 'SelfAll' 
	end
	if (msg and msg ~= 'dkp') then
		local param = select(3,string.find(msg, "^dkp ([^ ]+)"))
		if not param then return end
		local point =M.U:ParsePoint(param, true)
		if param =='help' then
			return 'Help'
		elseif point and point> 0 and point <=M.Data.Suites:Count() and M.DO.DKP:GetSuite(point) then
			return 'SelfHistory',point					
		elseif M.OO.Class:GetByName(param) then
			return 'Class',M.OO.Class:GetByName(param)
		else
			return 'Invalid'
		end
	end
end

function M.DO.Chat:CheckChannel(target)
	if target =='RAID' and GetNumRaidMembers() <= 1 then 
		M.U:Print("error",M.L.DKP_NOT_IN_A_RAID)
		return false
	end
	if target =='PARTY' and GetNumPartyMembers() < 1 then 
		M.U:Print("error",M.L.DKP_NOT_IN_A_PARTY)
		return false
	end
	if target =='GUILD' and not IsInGuild() then
		M.U:Print("error",M.L.DKP_NOT_IN_A_GUILD)
		return false
	end
	return true
end

function M.DO.Chat:DoMakeReport(reportType,target,showReply,dataList,paramList)
	local report =  M.OO.Report:Create(reportType,not showReply)
	report:SetTarget(target)
	if dataList then report:SetData(unpack(dataList)) end
	if paramList then report:SetParam(unpack(paramList)) end
	report:Report()
end

function M.DO.Chat:DoSend(printType,target,showReply,...)
	if not self:CheckChannel(target) then return end
	if printType == 'SelfHistory' then
		local val1,point = ...
		point  = point or val1
		self:DoMakeReport('SelfHistory',target,showReply,{target,M.Data.Suites},{point})
	elseif printType == 'MemberHistory' then
		local member, point = ...
		self:DoMakeReport('MemberHistory',target,showReply,{member,M.Data.Suites},{point})
	elseif printType =='Class' then
		local class = ...
		if not M.Data.Raid then return end
		if M.Data.Raid:GetDKP() then
			if  M.DO.Config:GetConfig("use_history") then
				self:DoMakeReport("ClassCurrentAndHis",target,showReply,{class,M.Data.Members:GetMainMemberList():FilterClass({[class:GetID()] = true})})
			else
				self:DoMakeReport('ClassCurrentBinded',target,showReply,{class,M.Data.Members:GetMainMemberList():FilterClass({[class:GetID()] = true})})
			end
		else
			self:DoMakeReport('ClassCurrentNotBinded',target,showReply,{class,M.Data.Members:GetMainMemberList():FilterClass({[class:GetID()] = true})})
		end
	elseif printType =='SelfAll' then
		if target:GetType()=='Member' then
			self:DoSend('SelfCurrent',target,showReply,target)
		end
		M.Data.Suites:RunList(function (suite,i)
			if select(i,M.DO.Config:GetConfig('dkpsuite_announced')) then
				self:DoMakeReport("SelfHistory",target.GetHistory and target:GetHistory() or target,showReply,{target.GetRealMember and target:GetRealMember() or target,M.Data.Suites},{i})
			end
		end)
	elseif printType =='SelfCurrent' then
		if select(1,M.DO.Config:GetConfig("whisper_content")) then
			self:DoMakeReport("SelfEvents",target,showReply,{target:GetRealMember()}) 
		end
		if select(2,M.DO.Config:GetConfig("whisper_content")) then
			self:DoMakeReport("SelfItems",target,showReply,{target:GetRealMember()}) 
		end
		if select(3,M.DO.Config:GetConfig("whisper_content")) then
			if target:GetRaid():GetDKP() then
				if M.DO.Config:GetConfig("use_history") then
					self:DoMakeReport("SelfCurrentAndHis",target,showReply,{target:GetRealMember()}) 
				else
					self:DoMakeReport("SelfCurrentBinded",target,showReply,{target:GetRealMember()}) 
				end
			else
				self:DoMakeReport("SelfCurrentNotBinded",target,showReply,{target:GetRealMember()}) 
			end
		end
	elseif printType =='MemberCurrent' then
		local member = ...
		if select(1,M.DO.Config:GetConfig("whisper_content")) then
			self:DoMakeReport("MemberEvents",target,showReply,{member}) 
		end
		if select(2,M.DO.Config:GetConfig("whisper_content")) then
			self:DoMakeReport("MemberItems",target,showReply,{member}) 
		end
		if select(3,M.DO.Config:GetConfig("whisper_content")) then
			if member:GetRaid():GetDKP() then
				if M.DO.Config:GetConfig("use_history") then
					self:DoMakeReport("MemberCurrentAndHis",target,showReply,{member}) 
				else
					self:DoMakeReport("MemberCurrentBinded",target,showReply,{member}) 
				end
			else
				self:DoMakeReport("MemberCurrentNotBinded",target,showReply,{member}) 
			end			
		end
	elseif printType =='Members' then
		if select(1,M.DO.Config:GetConfig("announce_content")) then
			self:DoMakeReport("Events",target,showReply,{M.Data.Raid})
		end
		if select(2,M.DO.Config:GetConfig("announce_content")) then
			self:DoMakeReport("Items",target,showReply,{M.Data.Raid})
		end
		if select(3,M.DO.Config:GetConfig("announce_content")) then
			if M.Data.Raid:GetDKP() then
				if M.DO.Config:GetConfig("use_history") then
					self:DoMakeReport("MembersCurrentAndHis",target,showReply,{...})

				else
					self:DoMakeReport("MembersCurrentBinded",target,showReply,{...})
				end
			else
				self:DoMakeReport("MembersCurrentNotBinded",target,showReply,{...})
			end
		end
	elseif printType =='MembersHistory' then
		local members,point =...
		self:DoMakeReport("MembersHistory",target,showReply,{members,M.Data.Suites},{point})
	elseif printType == 'EventDetail' then
		self:DoMakeReport("EventDetail",target,showReply,{...})	
	end
end

function M.DO.Chat:OnEventModified(entity)
	if entity:GetType()=="Event" then
		if M.DO.Config:GetConfig("event_notify") == 1 then
			self:DoSend("EventDetail","RAID",false,entity)
		elseif M.DO.Config:GetConfig("event_notify") == 2 then
			self:DoSend("EventDetail",entity:GetMemberList(),false,entity)
		end
	end
end

M.DO.Alt={}

function M.DO.Alt:Init()
	MiDKP3_Config = MiDKP3_Config or{}
	MiDKP3_Config.AltMinor = MiDKP3_Config.AltMinor or {}
	MiDKP3_Config.AltMain = MiDKP3_Config.AltMain or {}
	M.Data.AltMinorDB = MiDKP3_Config.AltMinor 
	M.Data.AltMainDB = MiDKP3_Config.AltMain
end

function M.DO.Alt:GetMain(member)
	if M.Data.AltMinorDB[member:GetName()] then
		return M.OO.Member:Create(unpack(M.Data.AltMinorDB[member:GetName()] ))
	end
end

function M.DO.Alt:AddMain(minor,main)
	if M.Data.AltMainDB[minor:GetName()] then
		for _name, tag in pairs(M.Data.AltMainDB[minor:GetName()]) do
			if tag then
				M.Data.AltMinorDB[_name] = nil
			end
		end
	end
	M.Data.AltMainDB[minor:GetName()] = nil
	M.Data.AltMinorDB[minor:GetName()] = {main:GetName(),main:GetClass():GetName()}
	M.Data.AltMainDB[main:GetName()] = M.Data.AltMainDB[main:GetName()] or {}
	M.Data.AltMainDB[main:GetName()][minor:GetName()] = true
	self:ClearMain(main)
end



function M.DO.Alt:ClearMain(minor)
	if M.Data.AltMinorDB[minor:GetName()] then
		local name = M.Data.AltMinorDB[minor:GetName()][1] 
		M.Data.AltMinorDB[minor:GetName()] = nil
		if M.Data.AltMainDB[name] then
			M.Data.AltMainDB[name] [minor:GetName()] = false
		end
	end
end

function M.DO.Alt:CheckMember(member)
	local main = self:GetMain(member) 
	if main then
		if not M.Data.Members:Find(main) then
			M.DO.Member:AddMember(main)
		else
			main = M.Data.Members:Find(main)
		end
		M.DO.Member:SetMain(member,main)
	end
end