
-- 区域名称表
local __BigFootQuest_ZoneNames = {};

local __BigFootQuest_NodeData = {};

local __BigFootQuest_CurrentQuestInfo = nil;
local __BigFootQuestWatch_QueryButtons = {};
local __BigFootQuestWatch_QuestInfo = {};
local __BigFootQuest_Tree;
local __BigFootQuest_DeleteButton;
local __BigFootQuest_ReturnButton;

local __BigFootQuest_QueryButton;

local __BigFootQuest_QuestPushButton;

if GetInterfaceInfo()==30100 then
	__BigFootQuest_QuestPushButton = QuestFramePushQuestButton
else
	__BigFootQuest_QuestPushButton = QuestLogFramePushQuestButton
end

if (GetLocale() == "zhCN") then
	BFQ_QUEST_LOCATION = "任务地点";
	BFQ_DELETE_BUTTON = "删除查询标记";
	BFQ_RETURN = "返回";
	BFQ_START_POS = "任务起始";
	BFQ_END_POS = "任务结束";
	BFQ_INSTANCE_TEXT = "(副本)";
elseif (GetLocale() == "zhTW") then
	BFQ_QUEST_LOCATION = "任務地點";
	BFQ_DELETE_BUTTON = "刪除查詢標記";
	BFQ_RETURN = "返回";
	BFQ_START_POS = "任務起始";
	BFQ_END_POS = "任務結束";
	BFQ_INSTANCE_TEXT = "(副本)";
end

-- 初始化区域名称表
function __BigFootQuest_InitZoneNames()
	for __i = 1, 3, 1 do
		__BigFootQuest_ZoneNames[__i] = {GetMapZones(__i)};
	end
end

-- 获得区域名称
function __BigFootQuest_GetZoneName(__continent, __zone)
	if (__BigFootQuest_ZoneNames[__continent]) then
		return __BigFootQuest_ZoneNames[__continent][__zone];
	end
end

function __BigFootQuest_ParseQuestLink(__link)
	if (__link) then
		local __color, __id, __level, __name;
		for __color, __id, __level, __name in string.gmatch(__link, "|c(%x+)|Hquest:(%d+):(-?%d+)|h%[(.+)%]|h|r") do
			return tonumber(__id), tonumber(__level), __name;
		end
	end
end

function __BigFootQuest_ParseFind(__s, __e, ...)
	if (not __s) then
		return;
	end

	return ...;
end

------------------------------------------------------------------------
-- 抓换格式化字符串为字符串匹配模板
------------------------------------------------------------------------
function __BigFootQuest_ParseString(__template, __str)
	if (not __template or not __str) then
		return nil;
	end

	__template = string.gsub(__template, "%(", "%%(");
	__template = string.gsub(__template, "%)", "%%)");
	__template = string.gsub(__template, "%%s", "(.+)");
	__template = string.gsub(__template, "%%d", "(%%d+)");
	return __BigFootQuest_ParseFind(string.find(__str, __template));
end

function __BigFootQuest_ParseWatchMsg(__msg)
	local __name = __BigFootQuest_ParseString(ERR_QUEST_ADD_KILL_SII, __msg);

	if (not __name) then
		__name = __BigFootQuest_ParseString(ERR_QUEST_ADD_FOUND_SII, __msg);
	end

	if (not __name) then
		__name = __BigFootQuest_ParseString(ERR_QUEST_ADD_ITEM_SII, __msg);
	end

	if (not __name) then
		__name = __BigFootQuest_ParseString(ERR_QUEST_OBJECTIVE_COMPLETE_S, __msg);
	end

	return __name;
end

function __BigFootQuest_GetLocations(__type, __idx)
	local __location;
	local __info;

	if (__type == "creature") then
		__location = __BQCL[__idx];
	elseif (__type == "object") then
		__location = __BQOL[__idx];
	elseif (__type == "event") then
		__location = __BQEL[__idx];
	end

	if (__location) then
		local __zones = {__BigFootQuest_SplitString(__location, "&")};
		for __i, __zone in ipairs(__zones) do
			local __z, __c = __BigFootQuest_SplitString(__zone, "@");
			if (__z and __c) then
				local __continent, __zone = __BigFootQuest_SplitString(__z, "%.");
				local __xs = {__BigFootQuest_SplitString(__c, ",")};

				if (__continent and __zone and table.maxn(__xs) > 0) then
					__continent = tonumber(__continent);
					__zone = tonumber(__zone);
					
					if (__BQZT and __BQZT[__continent]) then
						__zone = __BQZT[__continent][__zone];
					end
					
					local __x, __y;
					local __k = 0;
					for	__j, __v in ipairs(__xs) do
						if (not __x) then
							__x = tonumber(__v);
						else
							__y = tonumber(__v);
						end

						if (__x and __y) then
							if (not __info) then
								__info = {};
							end

							local __name;

							if (__continent == 0) then
								__name = __BQTN[__zone];
							else
								__name = __BigFootQuest_GetZoneName(__continent, __zone);
							end
							if __name then
								table.insert(__info, {["name"] = __name, ["continent"] = __continent, ["zone"] = __zone, ["x"] = __x, ["y"] = __y});
							end
							__x = nil;
							__y = nil;
						end
					end
				end
			end
		end
	end

	return __info;
end

function __BigFootQuest_GetItemSource(__id)
	local __text = __BQIS[__id];
	local __info;

	if (__text) then
		local __targets = {__BigFootQuest_SplitString(__text, ",")};
		for __i, __target in ipairs(__targets) do
			local __t = __BigFootQuest_GetTargetInfo(__target);
			if (__t) then
				if (not __info) then
					__info = {};
				end

				table.insert(__info, __t);
			end
		end
	end

	return __info;
end

function __BigFootQuest_GetTargetInfo(__id)
	local __info;

	local __type, __idx = __BigFootQuest_ParseTarget(__id);
	if (__type and __idx) then
		local __name;
		local __locations;
		local __sources;
		if (__type == "creature") then
			__name = __BQCN[__idx];
			__locations = __BigFootQuest_GetLocations(__type, __idx);
		elseif (__type == "object") then
			__name = __BQON[__idx];

			__locations = __BigFootQuest_GetLocations(__type, __idx);
		elseif (__type == "item") then
			__name = __BQIN[__idx];
			__sources = __BigFootQuest_GetItemSource(__idx);
		elseif (__type == "event") then
			__locations = __BigFootQuest_GetLocations(__type, __idx);
		end
		
		if (__name or __locations or __sources) then
			local __data = {};
			__data["name"] = __name;
			__data["locations"] = __locations;
			__data["sources"] = __sources;
			__data["type"] = __type;

			__info = __data;
		else
			__info = {};
		end
	end

	return __info;
end

function __BigFootQuest_GetQuestInfo(__id)
	local __info;

	if (not __BQQ[__id]) then
		return;
	end

	local __s, __e, __givers, __receivers, __objectives = string.find(__BQQ[__id], "([^:]*):([^:]*):([^:]*)");
	if (__givers) then
		__givers = {__BigFootQuest_SplitString(__givers, ",")};
		
		local __giver;
		for __i, __giver in ipairs(__givers) do
			if (not __info) then
				__info = {};
			end

			if (not __info["givers"]) then
				__info["givers"] = {};
			end

			table.insert(__info["givers"], __BigFootQuest_GetTargetInfo(__giver));
		end
	end

	if (__receivers) then
		__receivers = {__BigFootQuest_SplitString(__receivers, ",")};

		local __receiver;
		for __i, __receiver in ipairs(__receivers) do
			if (not __info) then
				__info = {};
			end

			if (not __info["receivers"]) then
				__info["receivers"] = {};
			end

			table.insert(__info["receivers"], __BigFootQuest_GetTargetInfo(__receiver));
		end
	end

	if (__objectives) then
		__objectives = {__BigFootQuest_SplitString(__objectives, ",")};

		local __objective;
		for __i, __objective in ipairs(__objectives) do
			if (not __info) then
				__info = {};
			end

			if (not __info["objectives"]) then
				__info["objectives"] = {};
			end

			table.insert(__info["objectives"], __BigFootQuest_GetTargetInfo(__objective));
		end
	end

	if (__info) then
		return __info;
	end
end

function __BigFootQuest_ParseFind(__s, __e, ...)
	if (not __s) then
		return;
	end

	return ...;
end

function __BigFootQuest_ParseString(__template, __str)
	if (not __template or not __str) then
		return nil;
	end

	__template = string.gsub(__template, "%%s", "(.+)");
	__template = string.gsub(__template, "%%d", "(%%d+)");

	return __BigFootQuest_ParseFind(string.find(__str, __template));
end

function __BigFootQuest_SetSelection()
	__BigFootQuest_ShowList(false);

	__BigFootQuest_QuestLog_UpdateQuestDetails();
end

function __BigFootQuest_ShowList(show)
	if (show) then
		if (__BigFootQuest_Tree) then
			__BigFootQuest_Tree:Show();
		end

		__BigFootQuest_ReturnButton:Show();
		QuestLogFrameAbandonButton:Hide();
		__BigFootQuest_QuestPushButton:Hide();
	else
		if (__BigFootQuest_Tree) then
			__BigFootQuest_Tree:Hide();
		end

		__BigFootQuest_ReturnButton:Hide();
		QuestLogFrameAbandonButton:Show();
		__BigFootQuest_QuestPushButton:Show();
	end

	__BigFootQuest_ShowingList = show;
end

function __BigFootQuest_QuestLog_UpdateQuestDetails()
	if (not __BFQ_ENABLED) then
		return;
	end

	if (__BigFootQuest_ShowingList) then
		QuestLogDetailScrollFrame:Hide();
		if (__BigFootQuest_Tree) then
			__BigFootQuest_Tree:Show();
		end

		__BigFootQuest_ReturnButton:Show();
		QuestLogFrameAbandonButton:Hide();
		__BigFootQuest_QuestPushButton:Hide();
	else
		local __questInfo;
		local __questID;

		local __questIndex = GetQuestLogSelection();
		local __questTitle = GetQuestLogTitle(__questIndex);	
		local __questLink = GetQuestLink and GetQuestLink(__questIndex);
		if (__questLink) then
			__questID = __BigFootQuest_ParseQuestLink(__questLink);
			if (__questID) then
				__questInfo = __BigFootQuest_GetQuestInfo(__questID);
			end
		end

		if (__questInfo) then
			__BigFootQuest_CurrentQuestInfo = __questInfo;
			__BigFootQuest_CurrentQuestInfo["name"] = __questTitle;
			__BigFootQuest_CurrentQuestInfo["id"] = __questID;

			local __numObjectives = GetNumQuestLeaderBoards(__questIndex) or 0;
			local __i;

			for __i = 1, __numObjectives, 1 do
				local __text, __type, __finished = GetQuestLogLeaderBoard(__i);
				
				local __name = __BigFootQuest_ParseString(ERR_QUEST_ADD_KILL_SII, __text);

				if (not __name) then
					__name = __BigFootQuest_ParseString(ERR_QUEST_ADD_FOUND_SII, __text);
				end

				if (not __name) then
					__name = __BigFootQuest_ParseString(ERR_QUEST_ADD_ITEM_SII, __text);
				end

				if (not __name) then
					__name = __text;
				end

				if (__questInfo["objectives"] and __questInfo["objectives"][__i]) then
					if (not __questInfo["objectives"][__i]["name"]) then
						__questInfo["objectives"][__i]["name"] = __name;
					end
				end

				local __button = getglobal("BigFootQuestObjectiveButton" .. __i);
				local __frame = getglobal("QuestLogObjective" .. __i);

				__button:ClearAllPoints();
				__button:SetAllPoints(__frame);
				__button:Show();
			end

			for __i = __numObjectives + 1, 8, 1 do
				local __button = getglobal("BigFootQuestObjectiveButton" .. __i);
				__button:Hide();
			end
		else
			__BigFootQuest_CurrentQuestInfo = nil;

			for __i = 1, 8, 1 do
				local __button = getglobal("BigFootQuestObjectiveButton" .. __i);
				__button:Hide();
			end
		end

		if (__BigFootQuest_Tree) then
			__BigFootQuest_Tree:Hide();
		end

		__BigFootQuest_ReturnButton:Hide();
		QuestLogFrameAbandonButton:Show();
		__BigFootQuest_QuestPushButton:Show();
	end
end

function __BigFootQuest_SplitString(__text, __delimiter)
	local __list = {}
	local __pos = 1;
	if (string.find("", __delimiter, 1)) then
		error("delimiter matches empty string!");
	end
	
	while (1) do
		local __first, __last = string.find(__text, __delimiter, __pos);
		if (__first) then
			table.insert(__list, string.sub(__text, __pos, __first - 1));
			__pos = __last + 1;
		else
			table.insert(__list, string.sub(__text, __pos));
			break;
		end
	end
	
	return unpack(__list);
end

function __BigFootQuest_ShowQueryButton()
	if (not __BigFootQuest_QueryButton) then
		__BigFootQuest_QueryButton = CreateFrame("Button", "BigFootQuest_QueryButton", QuestLogDetailScrollFrame);
		local __texture = __BigFootQuest_QueryButton:CreateTexture(nil, "BACKGROUND");
		__texture:SetTexture("Interface\\WorldMap\\WorldMap-MagnifyingGlass");
		__texture:SetWidth(20);
		__texture:SetHeight(20);
		__texture:SetPoint("LEFT", __BigFootQuest_QueryButton, "LEFT", 0, -2);

		__BigFootQuest_QueryButton:SetHighlightTexture("Interface\\QuestFrame\\UI-QuestTitleHighlight", "ADD");
		
		if (not BFQUEST_QUERY_FONT) then
			BFQUEST_QUERY_FONT = CreateFont("BFQUEST_QUERY_BUTTON_FONT");

			BFQUEST_QUERY_FONT:SetFont(STANDARD_TEXT_FONT, 14);
			BFQUEST_QUERY_FONT:SetTextColor(0.0, 0.0, 0.0);
		end

		__BigFootQuest_QueryButton:SetNormalFontObject(BFQUEST_QUERY_FONT);
		__BigFootQuest_QueryButton:SetHighlightFontObject(BFQUEST_QUERY_FONT);
		__BigFootQuest_QueryButton:SetText(BFQ_QUEST_LOCATION);
		__BigFootQuest_QueryButton:GetFontString():SetShadowColor(0, 0, 0, 0);
		__BigFootQuest_QueryButton:SetWidth(90);
		__BigFootQuest_QueryButton:SetHeight(16);
		__BigFootQuest_QueryButton:GetFontString():SetPoint("LEFT", __BigFootQuest_QueryButton, "LEFT", 20, 0);
		__BigFootQuest_QueryButton:SetPushedTextOffset(1, -1);
		__BigFootQuest_QueryButton:SetScript("OnClick", function(self, __button)
			if (__BigFootQuest_CurrentQuestInfo) then
				local __info = {};

				if (__BigFootQuest_CurrentQuestInfo["givers"]) then
					local __data = {};
					__data.text = BFQ_START_POS;
					__data.child = {};
					__data.color = {r = 0.0, g = 0.0, b = 0.0};
					__data.highlight_color = {r = 0.0, g = 0.0, b = 0.0};

					local __i, __target;
					for __i, __target in ipairs(__BigFootQuest_CurrentQuestInfo["givers"]) do
						table.insert(__data.child, __BigFootQuest_GenerateTargetItem(__target));
					end

					table.insert(__info, __data);
				end

				if (__BigFootQuest_CurrentQuestInfo["receivers"]) then
					local __data = {};
					__data.text = BFQ_END_POS;
					__data.child = {};
					__data.color = {r = 0.0, g = 0.0, b = 0.0};
					__data.highlight_color = {r = 0.0, g = 0.0, b = 0.0};

					local __i, __target;
					for __i, __target in ipairs(__BigFootQuest_CurrentQuestInfo["receivers"]) do
						table.insert(__data.child, __BigFootQuest_GenerateTargetItem(__target));
					end

					table.insert(__info, __data);
				end

				local __tree = __BigFootQuest_GetTreeCtrl();
				__tree:DeleteAllItems();

				__tree:BeginTransaction();
				__tree:InsertItem(__info);
				__tree:EndTransaction();

				__tree:SetPoint("TOPLEFT", QuestLogDetailScrollFrame, "TOPLEFT", 5, -5);

				__tree:ExpandAllItems();

				QuestLogDetailScrollFrame:Hide();
				__tree:Show();

				__BigFootQuest_ReturnButton:Show();
				QuestLogFrameAbandonButton:Hide();
				__BigFootQuest_QuestPushButton:Hide();
				
				__BigFootQuest_ShowList(true);

				collectgarbage("collect");
			end
		end);
	end

	__BigFootQuest_QueryButton:SetPoint("TOPLEFT", QuestLogDetailScrollFrame, "TOPRIGHT", -104, -8);
	__BigFootQuest_QueryButton:Show();
end

function __BigFootQuest_HideQueryButton()
	__BigFootQuest_QueryButton:Hide();
end

function __BigFootQuest_ParseTarget(__target)
	local __s, __e, __index = string.find(__target, "c(%d+)");
	if (__index) then
		return "creature", tonumber(__index);
	end

	__s, __e, __index = string.find(__target, "o(%d+)");
	if (__index) then
		return "object", tonumber(__index);
	end

	__s, __e, __index = string.find(__target, "i(%d+)");
	if (__index) then
		return "item", tonumber(__index);
	end

	__s, __e, __index = string.find(__target, "e(%d+)");
	if (__index) then
		return "event", tonumber(__index);
	end
end

function __BigFootQuest_GenerateTargetItem(__target)
	local __info = type(__target) == "table" and __target or {};

	if (__target["type"] == "creature" or __target["type"] == "object" or __target["type"] == "event") then
		__info.text = __target["name"];

		if (__target["locations"]) then
			__info.child = {};
			__info.color = {r = 0.0, g = 0.0, b = 0.0};
			__info.highlight_color = {r = 0.0, g = 0.0, b = 0.0};

			local __locations = {};

			for __i, __l in ipairs(__target["locations"]) do
				__key = __l["continent"] .. "." .. __l["zone"];

				if (not __locations[__key]) then
					__locations[__key] = {};

					__locations[__key]["name"] = __l["name"];
					__locations[__key]["continent"] = __l["continent"];
					__locations[__key]["zone"] = __l["zone"];
					__locations[__key]["data"] = {};
				end
				
				table.insert(__locations[__key]["data"], __l);
			end

			for __i, __l in pairs(__locations) do
				local __name;

				if (__l["name"]) then
					__name = __l["name"];
				else
					__name = __target["name"];
				end

				local __data = {};

				if (__l["continent"] == 0) then
					__data.text = __name .. BFQ_INSTANCE_TEXT;
					__data.color = {r = 0.0, g = 0.0, b = 0.0};
					__data.highlight_color = {r = 0.0, g = 0.0, b = 0.0};
				else
					__data.text = "|TInterface\\WorldMap\\WorldMap-MagnifyingGlass:20|t" .. __name .. string.format("(%d)", table.maxn(__l["data"]));
					__data.color = {r = 0.0, g = 0.0, b = 0.0};
					__data.highlight_color = {r = 1.0, g = 0.0, b = 0.0};
				end
				__data.data = {["title"] = __target["name"], ["lines"] = __target["lines"], ["locations"] = __l["data"]};

				table.insert(__info.child, __data);
			end
		end
	elseif (__target["type"] == "item") then
		__info.text = __target["name"];
		if (__target["sources"]) then
			__info.child = {};
			__info.color = {r = 0.0, g = 0.0, b = 0.0};
			__info.highlight_color = {r = 0.0, g = 0.0, b = 0.0};

			for __i, __t in ipairs(__target["sources"]) do
				table.insert(__info.child, __BigFootQuest_GenerateTargetItem(__t));
			end
		end
	end

	return __info;
end

function __BigFootQuest_GetTreeCtrl()
	if (not __BigFootQuest_Tree) then
		__BigFootQuest_Tree = BLibrary("BFTreeCtrl", QuestLogFrame, 290, 250);

		__BigFootQuest_Tree.OnClick = function(__tree, __item)
			if (__tree:GetFirstChildItem(__item)) then
				-- It's header
				if (__item:GetStatus() == "expanded") then
					__tree:CollapseItem(__item);
				else
					__tree:ExpandItem(__item);
				end
			else
				local __info = __item:GetData();
				local __show;

				if (__info) then
					__BigFootQuest_ResetNodeData();

					local __title = __info["title"];
					local __lines = __info["lines"];
					local __locations = __info["locations"];
					local __continent;
					local __zone;

					for __i, __location in ipairs(__locations) do
						__continent = __location["continent"];
						__zone = __location["zone"];
						__x = __location["x"];
						__y = __location["y"];

						if (__continent ~= 0) then
							__BigFootQuest_AddNode(__title, __lines, __continent, __zone, __x, __y);
							__show = true;
						end
					end
					
					if (__show) then
						if (not IsShiftKeyDown()) then
							HideUIPanel(QuestLogFrame);
							ShowUIPanel(WorldMapFrame);
							SetMapZoom(__continent, __zone);
						end
					end
				end
			end
		end
	end

	return __BigFootQuest_Tree;
end

function __BigFootQuest_GenerateTree(...)
	local __data = {};
	local __target;
	for __i=1, select("#", ...) do
		__target = select(__i, ...);
		table.insert(__data, __BigFootQuest_GenerateTargetItem(__target));
	end	

	local __tree = __BigFootQuest_GetTreeCtrl();
	__tree:DeleteAllItems();

	__tree:BeginTransaction();
	__tree:InsertItem(__data);
	__tree:EndTransaction();

	__tree:SetPoint("TOPLEFT", QuestLogDetailScrollFrame, "TOPLEFT", 5, -5);

	__tree:ExpandAllItems();

	QuestLogDetailScrollFrame:Hide();
	__tree:Show();
	
	__BigFootQuest_ReturnButton:Show();
	QuestLogFrameAbandonButton:Hide();
	__BigFootQuest_QuestPushButton:Hide();

	__BigFootQuest_ShowList(true);

	collectgarbage("collect");
end

function BigFootQuestObjectiveButton_OnClick(self, __button)
	local __index = self:GetID();
	local __continent, __zone;
	local __x, __y;

	if (__BigFootQuest_CurrentQuestInfo and __BigFootQuest_CurrentQuestInfo["objectives"] and __BigFootQuest_CurrentQuestInfo["objectives"][__index] and (__BigFootQuest_CurrentQuestInfo["objectives"][__index]["sources"] or __BigFootQuest_CurrentQuestInfo["objectives"][__index]["locations"])) then
		__BigFootQuest_GenerateTree(__BigFootQuest_CurrentQuestInfo["objectives"][__index]);
	end
end

function __BigFootQuest_WorldMapFrame_Update()
	if (not __BFQ_ENABLED) then
		return;
	end

	local __continent = GetCurrentMapContinent();
	local __zone = GetCurrentMapZone();

	__BigFootQuest_DeleteAllNodes();

	if (__BigFootQuest_NodeData and __continent and __zone and __BigFootQuest_NodeData[__continent] and __BigFootQuest_NodeData[__continent][__zone]) then
		local __i, __node;
		for __i, __node_data in ipairs(__BigFootQuest_NodeData[__continent][__zone]) do
			local __node = __BigFootQuest_GetFreeNode();
			__node.data = __node_data;

			local __width = WorldMapButton:GetWidth();
			local __height = WorldMapButton:GetHeight();
			local __x = __node_data.x * __width / 100;
			local __y = -__node_data.y * __height / 100;
			__node:ClearAllPoints();
			__node:SetPoint("CENTER", "WorldMapDetailFrame", "TOPLEFT", __x, __y);
			__node:Show();
		end
	end
end

function BigFootQuest_Toggle(__switch)
	if (__switch) then
		if (not __BFQ_INITED) then
			__BigFootQuest_InitZoneNames();
			hooksecurefunc("QuestLog_UpdateQuestDetails", __BigFootQuest_QuestLog_UpdateQuestDetails);
--			hooksecurefunc("WatchFrame_Update", __BigFootQuestWatch_Update);
			hooksecurefunc("QuestLog_OnShow", __BigFootQuest_QuestLog_OnShow);
			hooksecurefunc("WorldMapFrame_Update", __BigFootQuest_WorldMapFrame_Update);
			if (BigFootMapFrame)then
				hooksecurefunc("BigFootMapFrame_Update", __BigFootQuest_WorldMapFrame_Update);
			end
			hooksecurefunc("QuestLog_SetSelection", __BigFootQuest_SetSelection);
			QuestLogDetailScrollFrame:SetScript("OnShow", function()
				if (__BigFootQuest_Tree and __BigFootQuest_Tree:IsShown()) then
					QuestLogDetailScrollFrame:Hide();

					__BigFootQuest_ReturnButton:Show();
					QuestLogFrameAbandonButton:Hide();
					__BigFootQuest_QuestPushButton:Hide();
				end
			end);

			__BigFootQuest_DeleteButton = BLibrary("BFButton", WorldMapFrame, 112, 28);
			__BigFootQuest_DeleteButton:SetPoint("TOPRIGHT", WorldMapPositioningGuide, "TOPRIGHT", -25, -34);
			__BigFootQuest_DeleteButton:SetText(BFQ_DELETE_BUTTON);
			__BigFootQuest_DeleteButton.OnClick = function()
				__BigFootQuest_NodeData = {};
				__BigFootQuest_WorldMapFrame_Update();
			end
			__BigFootQuest_DeleteButton:Show();
			if GetInterfaceInfo()==30100 then 
				__BigFootQuest_ReturnButton = BLibrary("BFButton", QuestLogFrame, 244, 23);
				__BigFootQuest_ReturnButton:SetPoint("BOTTOMLEFT", QuestLogFrame, "BOTTOMLEFT", 17, 54);
			else
				__BigFootQuest_ReturnButton = BLibrary("BFButton", QuestLogFrame, 158, 22);
				__BigFootQuest_ReturnButton:SetPoint("BOTTOMLEFT", QuestLogFrame, "BOTTOMLEFT", 19, 15);
			end
			__BigFootQuest_ReturnButton:SetText(BFQ_RETURN);
			__BigFootQuest_ReturnButton.OnClick = function()
				local __tree = __BigFootQuest_GetTreeCtrl();
				if (__tree) then
					__tree:Hide();
				end
				QuestLogDetailScrollFrame:Show();

				__BigFootQuest_ReturnButton:Hide();
				QuestLogFrameAbandonButton:Show();
				__BigFootQuest_QuestPushButton:Show();

				__BigFootQuest_ShowList(false);
			end
			__BigFootQuest_ReturnButton:Hide();

			__BFQ_INITED = true;
		end

		__BigFootQuest_ShowQueryButton();
		__BigFootQuest_DeleteButton:Show();

		__BFQ_ENABLED = true;
--		__BigFootQuestWatch_Update();
	else
		QuestLogDetailScrollFrame:SetScript("OnShow", nil);

		__BigFootQuest_HideQueryButton();

		__BigFootQuest_ResetNodeData();
		__BigFootQuest_DeleteAllNodes();

		BigFootQuestObjectiveButton1:Hide();
		BigFootQuestObjectiveButton2:Hide();
		BigFootQuestObjectiveButton3:Hide();
		BigFootQuestObjectiveButton4:Hide();
		BigFootQuestObjectiveButton5:Hide();
		BigFootQuestObjectiveButton6:Hide();
		BigFootQuestObjectiveButton7:Hide();
		BigFootQuestObjectiveButton8:Hide();

		local __tree = __BigFootQuest_GetTreeCtrl();
		if (__tree) then
			__tree:Hide();
		end

		__BigFootQuest_DeleteButton:Hide();
		__BigFootQuest_ReturnButton:Hide();
		QuestLogFrameAbandonButton:Show();
		__BigFootQuest_QuestPushButton:Show();
		
		__BigFootQuestWatch_QuestInfo = {};
		for k, b in pairs(__BigFootQuestWatch_QueryButtons) do
			b:Hide();
		end
		__BFQ_ENABLED = false;
	end
end

function __BigFootQuest_QuestLog_OnShow()
	if (__BigFootQuest_Tree) then
		__BigFootQuest_Tree:Hide();
	end

	QuestLogDetailScrollFrame:Show();

	__BigFootQuest_ReturnButton:Hide();
	QuestLogFrameAbandonButton:Show();
	__BigFootQuest_QuestPushButton:Show();

	__BigFootQuest_ShowingList = false;
end

function __BigFootQuest_AddNode(__title, __lines, __continent, __zone, __x, __y)
	local __data = {};

	__data.title = __title;
	__data.lines = __lines;
	__data.x = __x;
	__data.y = __y;

	if (not __BigFootQuest_NodeData) then
		__BigFootQuest_NodeData = {};
	end

	if (not __BigFootQuest_NodeData[__continent]) then
		__BigFootQuest_NodeData[__continent] = {};
	end

	if (not __BigFootQuest_NodeData[__continent][__zone]) then
		__BigFootQuest_NodeData[__continent][__zone] = {};
	end

	table.insert(__BigFootQuest_NodeData[__continent][__zone], __data);
end

function __BigFootQuest_MapNode_OnEnter(self)
	if (self.data) then
		WorldMapTooltip:ClearLines();
		WorldMapTooltip:SetOwner(self, "ANCHOR_LEFT");
		if self.data.title then
			WorldMapTooltip:SetText(self.data.title);
		end
		if (self.data.lines) then
			for __i, __line in ipairs(self.data.lines) do
				WorldMapTooltip:AddLine(self.data.line);
			end
		end
		WorldMapTooltip:Show();
	end
end

function __BigFootQuest_MapNode_OnLeave(self)
	WorldMapTooltip:Hide();
end

function __BigFootQuest_GetFreeNode()
	local __index = 1;

	while (1) do
		local __node = getglobal("BigFootQuest_MapNode"..__index);
		if (__node) then
			if (not __node:IsShown()) then
				return __node;
			end
		else
			__node = CreateFrame("Button", "BigFootQuest_MapNode" .. __index, WorldMapButton);
			__node:SetScript("OnEnter", __BigFootQuest_MapNode_OnEnter);
			__node:SetScript("OnLeave", __BigFootQuest_MapNode_OnLeave);
			__node:SetWidth(16);
			__node:SetHeight(16);
			__node:SetFrameLevel(__node:GetFrameLevel() + 2);
			__node:EnableMouse(true);

			local __texture = __node:CreateTexture("", "ARTWORK");
			__texture:SetAllPoints();
			__texture:SetTexture("Interface\\AddOns\\BigFootQuest\\node");
			
			return __node;
		end

		__index = __index + 1;
	end
end

function __BigFootQuest_ResetNodeData()
	__BigFootQuest_NodeData = {};
end

function __BigFootQuest_DeleteAllNodes()
	local __index = 1;
	while (1) do
		local __node = getglobal("BigFootQuest_MapNode"..__index);
		if (__node) then
			if (__node:IsShown()) then
				__node:Hide();
			end
		else
			return;
		end

		__index = __index + 1;
	end
end
-------------------
-- BigFoot Quest Watch Button -- by dugu@bigfoot 2008-11-26
-------------------
local lastIndex;
local function __BigFootQuestWatch_CreateQueryButton(__index, __qid, __bid)
	if (not __BigFootQuestWatch_QueryButtons[__index]) then
		local __button = CreateFrame("Button", "BigFootQuestWatch_QueryButton" .. __index, QuestWatchFrame);
		__button:SetWidth(20); __button:SetHeight(20);
		__button:SetPoint("RIGHT", "WatchFrameLine" .. __index, "LEFT", -1, 0);
		__button.__texture = __button:CreateTexture(__button:GetName() .. "Texture", "BACKGROUND");
		__button.__texture:SetTexture("Interface\\TUTORIALFRAME\\TutorialFrame-QuestionMark");		
		__button.__texture:SetAllPoints(__button);
		__button:SetHighlightTexture("Interface\\TUTORIALFRAME\\TutorialFrame-QuestionMark", "ADD");
		__button.__index = __index;
		__button:SetScript("OnMouseDown", function(self, __button)	
			if (self.__qid) then
				local __qInfo = __BigFootQuest_GetQuestInfo(self.__qid);
				local __info;

				if (not __qInfo) then
					return;
				end

				-- 如果没有__bid值，代表查询的是任务给予人和任务完成人
				if (self.__bid) then
					
					if (__qInfo["objectives"] and __qInfo["objectives"][self.__bid]) then
						local __data = __qInfo["objectives"][self.__bid];
						if (not __data["name"]) then
							local __questIndex = GetQuestIndexForWatch(self.__index - self.__bid);
							local __text = GetQuestLogLeaderBoard(self.__bid, __questIndex);
							__data["name"] = __BigFootQuest_ParseWatchMsg(__text);
						end

						if (not __info) then
							__info = {};
						end
						table.insert(__info, __data);
					end
				else
					-- 创建任务起始和结束NPC位置数据
					if (__qInfo["givers"]) then
						local __data = {};
						__data.text = BFQ_START_POS;
						__data.child = {};
						__data.color = {r = 0.0, g = 0.0, b = 0.0};
						__data.highlight_color = {r = 0.0, g = 0.0, b = 0.0};
						
						local __j, __target;
						for __j, __target in ipairs(__qInfo["givers"]) do
							table.insert(__data.child, __BigFootQuest_GenerateTargetItem(__target));
						end
						
						if (not __info) then
							__info = {};
						end
						table.insert(__info, __data);
					end

					if (__qInfo["receivers"]) then
						local __data = {};
						__data.text = BFQ_END_POS;
						__data.child = {};
						__data.color = {r = 0.0, g = 0.0, b = 0.0};
						__data.highlight_color = {r = 0.0, g = 0.0, b = 0.0};

						local __j, __target;
						for __j, __target in ipairs(__qInfo["receivers"]) do
							table.insert(__data.child, __BigFootQuest_GenerateTargetItem(__target));
						end

						if (not __info) then
							__info = {};
						end
						table.insert(__info, __data);
					end
				end

				if (__info) then
					if (lastIndex and lastIndex == self.__index and QuestLogFrame:IsShown()) then
						HideUIPanel(QuestLogFrame);
					else
						ShowUIPanel(QuestLogFrame);	
						__BigFootQuest_GenerateTree(unpack(__info));		
					end						
					lastIndex = self.__index;
					self.__texture:SetTexCoord(0, 1, 0, 1);
				end
			end
		end);
		__button:SetScript("OnMouseUp", function(self, __button)
			self.__texture:SetTexCoord(0.075, 0.925, 0.075, 0.925);
		end);

		__BigFootQuestWatch_QueryButtons[__index] = __button;
	end

	__BigFootQuestWatch_QueryButtons[__index].__index = __index;
	__BigFootQuestWatch_QueryButtons[__index].__qid = __qid;
	__BigFootQuestWatch_QueryButtons[__index].__bid = __bid;
	__BigFootQuestWatch_QueryButtons[__index]:Show();
end

function __BigFootQuestWatch_Update()
	if (not __BFQ_ENABLED) then
		return;
	end

	local __index = 1;
	local __qIndex, __oNum, __qLink, __qID, __qInfo, __button;	
	__BigFootQuestWatch_QuestInfo = {};
	for __i = 1, GetNumQuestWatches(), 1 do
		local __qIndex = GetQuestIndexForWatch(__i);
		if (__qIndex) then
			local __qLink = GetQuestLink and GetQuestLink(__qIndex);
			if (__qLink) then
				__qID = __BigFootQuest_ParseQuestLink(__qLink);
				if (__qID) then
					__BigFootQuestWatch_CreateQueryButton(__index, __qID);
				end
			end

			__index = __index + 1;

			-- 任务物品位置数据
			__oNum = GetNumQuestLeaderBoards(__qIndex);
			for __i = 1, __oNum, 1 do
				if (__qID) then
					__BigFootQuestWatch_CreateQueryButton(__index, __qID, __i);
				end
				__index = __index + 1;
			end
		end
	end

	for j = __index,  #(__BigFootQuestWatch_QueryButtons), 1 do
		if (__BigFootQuestWatch_QueryButtons[j]) then
			__BigFootQuestWatch_QueryButtons[j]:Hide();
		end
	end	
end