local C = LibStub("AceAddon-3.0"):NewAddon("BFTargetFrame","AceHook-3.0")

local config = {
	self = 23,
	other = 17,
	row = 3,
	rowWidth = 125
}

function AdjustBuffSize(isMine, size)
	if isMine then 
		config.self = size  or config.self 
		BFCH_MYBUFF_SIZE = size
	else
		config.other = size or config.other
		BFCH_OTHERBUFF_SIZE = size
	end
	TargetFrame_UpdateAuras(TargetFrame)
end

function C:TargetFrame_UpdateAuraPositions(...)
	local auraName, numAuras, numOppositeAuras, largeAuraList, updateFunc, maxRowWidth, offsetX
	local frame
	if not C.isChina then
		frame = ...
		auraName, numAuras, numOppositeAuras, largeAuraList, updateFunc, maxRowWidth, offsetX = select(2,...)
	else
		frame = _G["TargetFrame"]
		auraName, numAuras, numOppositeAuras, largeAuraList, updateFunc, maxRowWidth, offsetX = ...
	end
	local offsetY = config.self-config.other
	local size;
	local rowWidth = 0;
	local firstBuffOnRow = 1;
	for i=1, numAuras do
		if ( largeAuraList[i] ) then
			size = config.self
		else
			size = config.other
		end

		if ( i == 1 ) then
			rowWidth = size;
			frame.auraRows = frame.auraRows + 1;
		else
			rowWidth = rowWidth + size + offsetX;
		end
		if ( rowWidth > maxRowWidth ) then
			if C.isChina then
				updateFunc(auraName, i, numOppositeAuras, firstBuffOnRow, size, offsetX, 0);
			else
				updateFunc(frame,auraName, i, numOppositeAuras, firstBuffOnRow, size, offsetX, 0);
			end

			rowWidth = size;
			frame.auraRows = frame.auraRows + 1;
			firstBuffOnRow = i;

			if ( frame.auraRows > config.row ) then
				maxRowWidth = config.rowWidth;
			end
		else
			if C.isChina then
				updateFunc(auraName, i, numOppositeAuras, i - 1, size, offsetX, 0);
			else
				updateFunc(frame,auraName, i, numOppositeAuras, i - 1, size, offsetX, 0);
			end
		end
	end
end

function C:OnEnable()
	local _,_,_,version =  GetBuildInfo()
	if version == 30200 then
		C.isChina = true
	else
		C.isChina = false
	end
	C:RawHook("TargetFrame_UpdateAuraPositions",true)
end


function C:OnDisable()
end