local _, namespace = ...
local GetSpellInfo = _G.GetSpellInfo

-- List of spells and their cast times.
-- Value[1] is the cast time in miliseconds, and value[2] is the spell ID (needed to get spell icon later on).
-- Blizzard removed spell ID payload from the combat log so now we're stuck using localized spell names instead :(
namespace.castedSpells = {
    [GetSpellInfo(17745)] = { 3000, 17745 }, -- Diseased Spit
    [GetSpellInfo(3960)] = { 12500, 3960 }, -- Portable Bronze Mortar
    [GetSpellInfo(21954)] = { 2000, 21954 }, -- Dispel Poison
    [GetSpellInfo(18440)] = { 60000, 18440 }, -- Mooncloth Leggings
    [GetSpellInfo(28165)] = { 4000, 28165 }, -- Shadow Guard
    [GetSpellInfo(17204)] = { 2000, 17204 }, -- Summon Skeleton
    [GetSpellInfo(18403)] = { 60000, 18403 }, -- Frostweave Tunic
    [GetSpellInfo(9781)] = { 3000, 9781 }, -- Mithril Shield Spike
    [GetSpellInfo(9478)] = { 2000, 9478 }, -- Invis Placing Bear Trap
    [GetSpellInfo(9972)] = { 60000, 9972 }, -- Ornate Mithril Breastplate
    [GetSpellInfo(16641)] = { 8000, 16641 }, -- Dense Sharpening Stone
    [GetSpellInfo(3173)] = { 3000, 3173 }, -- Lesser Mana Potion
    [GetSpellInfo(19755)] = { 1000, 19755 }, -- Frightalon
    [GetSpellInfo(19102)] = { 60000, 19102 }, -- Runic Leather Armor
    [GetSpellInfo(13228)] = { 3000, 13228 }, -- Wound Poison II
    [GetSpellInfo(28397)] = { 1000, 28397 }, -- Reputation - Gadgetzan +500
    [GetSpellInfo(18452)] = { 60000, 18452 }, -- Mooncloth Circlet
    [GetSpellInfo(19048)] = { 60000, 19048 }, -- Heavy Scorpid Bracers
    [GetSpellInfo(29332)] = { 1000, 29332 }, -- Fire-toasted Bun
    [GetSpellInfo(25177)] = { 5000, 25177 }, -- Fire Weakness
    [GetSpellInfo(22566)] = { 2000, 22566 }, -- Hex
    [GetSpellInfo(17196)] = { 1000, 17196 }, -- Seeping Willow
    [GetSpellInfo(9575)] = { 7000, 9575 }, -- Self Detonation
    [GetSpellInfo(25166)] = { 3000, 25166 }, -- Call Glyphs of Warding
    [GetSpellInfo(19050)] = { 60000, 19050 }, -- Green Dragonscale Breastplate
    [GetSpellInfo(12585)] = { 8000, 12585 }, -- Solid Blasting Powder
    [GetSpellInfo(28297)] = { 500, 28297 }, -- Lightning Totem
    [GetSpellInfo(24165)] = { 4000, 24165 }, -- Hoodoo Hex
    [GetSpellInfo(13692)] = { 1000, 13692 }, -- Dire Growl
    [GetSpellInfo(12093)] = { 45000, 12093 }, -- Tuxedo Jacket
    [GetSpellInfo(3978)] = { 8000, 3978 }, -- Standard Scope
    [GetSpellInfo(16060)] = { 3000, 16060 }, -- Golden Sabercat
    [GetSpellInfo(18442)] = { 60000, 18442 }, -- Felcloth Hood
    [GetSpellInfo(12053)] = { 60000, 12053 }, -- Black Mageweave Gloves
    [GetSpellInfo(2164)] = { 8000, 2164 }, -- Fine Leather Gloves
    [GetSpellInfo(3170)] = { 3000, 3170 }, -- Weak Troll's Blood Potion
    [GetSpellInfo(10840)] = { 3000, 10840 }, -- Mageweave Bandage
    [GetSpellInfo(2666)] = { 8000, 2666 }, -- Runed Copper Belt
    [GetSpellInfo(21544)] = { 1000, 21544 }, -- Create Shredder
    [GetSpellInfo(24093)] = { 60000, 24093 }, -- Bloodvine Boots
    [GetSpellInfo(5270)] = { 2000, 5270 }, -- Stonesplinter Disguise
    [GetSpellInfo(20890)] = { 60000, 20890 }, -- Dark Iron Reaver
    [GetSpellInfo(10703)] = { 1000, 10703 }, -- Summon Wood Frog
    [GetSpellInfo(8365)] = { 2000, 8365 }, -- Enlarge
    [GetSpellInfo(12511)] = { 5000, 12511 }, -- Torch Combine
    [GetSpellInfo(28305)] = { 2000, 28305 }, -- Copy of Great Heal
    [GetSpellInfo(3324)] = { 12500, 3324 }, -- Runed Copper Pants
    [GetSpellInfo(3760)] = { 12500, 3760 }, -- Hillman's Cloak
    [GetSpellInfo(16726)] = { 60000, 16726 }, -- Runic Plate Helm
    [GetSpellInfo(9435)] = { 5000, 9435 }, -- Detonation
    [GetSpellInfo(11988)] = { 3000, 11988 }, -- Fireball Volley
    [GetSpellInfo(2661)] = { 8000, 2661 }, -- Copper Chain Belt
    [GetSpellInfo(1916)] = { 1000, 1916 }, -- Sacrifice (NSE)
    [GetSpellInfo(24655)] = { 60000, 24655 }, -- Green Dragonscale Gauntlets
    [GetSpellInfo(3635)] = { 2000, 3635 }, -- Crystal Gaze
    [GetSpellInfo(23214)] = { 3000, 23214 }, -- Summon Charger
    [GetSpellInfo(9195)] = { 25000, 9195 }, -- Dusky Leather Leggings
    [GetSpellInfo(13230)] = { 3000, 13230 }, -- Wound Poison IV
    [GetSpellInfo(11535)] = { 5000, 11535 }, -- Opening Safe
    [GetSpellInfo(11895)] = { 1000, 11895 }, -- Healing Wave of Antu'sul
    [GetSpellInfo(16658)] = { 60000, 16658 }, -- Imperial Plate Helm
    [GetSpellInfo(17951)] = { 3000, 17951 }, -- Create Firestone
    [GetSpellInfo(2337)] = { 3000, 2337 }, -- Lesser Healing Potion
    [GetSpellInfo(18406)] = { 60000, 18406 }, -- Runecloth Robe
    [GetSpellInfo(15861)] = { 3000, 15861 }, -- Jungle Stew
    [GetSpellInfo(16656)] = { 60000, 16656 }, -- Radiant Boots
    [GetSpellInfo(18763)] = { 3500, 18763 }, -- Freeze
    [GetSpellInfo(3861)] = { 45000, 3861 }, -- Long Silken Cloak
    [GetSpellInfo(27721)] = { 1000, 27721 }, -- Very Berry Cream
    [GetSpellInfo(19087)] = { 60000, 19087 }, -- Frostsaber Gloves
    [GetSpellInfo(22905)] = { 1000, 22905 }, -- Place Unfired Blade
    [GetSpellInfo(24263)] = { 2000, 24263 }, -- UNUSED Quest - Create Empowered Mojo Bundle
    [GetSpellInfo(12198)] = { 2000, 12198 }, -- Marksman Hit
    [GetSpellInfo(28738)] = { 1000, 28738 }, -- Summon Speedy
    [GetSpellInfo(7673)] = { 3000, 7673 }, -- Nether Gem
    [GetSpellInfo(27829)] = { 60000, 27829 }, -- Titanic Leggings
    [GetSpellInfo(3605)] = { 3000, 3605 }, -- Summon Remote-Controlled Golem
    [GetSpellInfo(17573)] = { 3000, 17573 }, -- Greater Arcane Elixir
    [GetSpellInfo(3176)] = { 3000, 3176 }, -- Strong Troll's Blood Potion
    [GetSpellInfo(3872)] = { 25000, 3872 }, -- Rich Purple Silk Shirt
    [GetSpellInfo(23639)] = { 60000, 23639 }, -- Blackfury
    [GetSpellInfo(24006)] = { 3000, 24006 }, -- Bounty of the Harvest
    [GetSpellInfo(12907)] = { 25000, 12907 }, -- Gnomish Mind Control Cap
    [GetSpellInfo(22704)] = { 60000, 22704 }, -- Field Repair Bot 74A
    [GetSpellInfo(26265)] = { 4000, 26265 }, -- Create Elune Stone
    [GetSpellInfo(16195)] = { 2000, 16195 }, -- Create Knucklebone Pouch
    [GetSpellInfo(12248)] = { 2000, 12248 }, -- Amplify Damage
    [GetSpellInfo(19719)] = { 3000, 19719 }, -- Use Bauble
    [GetSpellInfo(11923)] = { 44500, 11923 }, -- Repair the Blade of Heroes
    [GetSpellInfo(7720)] = { 5000, 7720 }, -- Ritual of Summoning Effect
    [GetSpellInfo(3370)] = { 3000, 3370 }, -- Crocolisk Steak
    [GetSpellInfo(3854)] = { 25000, 3854 }, -- Azure Silk Gloves
    [GetSpellInfo(9957)] = { 60000, 9957 }, -- Orcish War Leggings
    [GetSpellInfo(20565)] = { 1000, 20565 }, -- Magma Blast
    [GetSpellInfo(17707)] = { 1000, 17707 }, -- Summon Panda
    [GetSpellInfo(26069)] = { 1500, 26069 }, -- Silence
    [GetSpellInfo(7636)] = { 12500, 7636 }, -- Green Woolen Robe
    [GetSpellInfo(2829)] = { 3000, 2829 }, -- Sharpen Blade II
    [GetSpellInfo(9068)] = { 5125, 9068 }, -- Light Leather Pants
    [GetSpellInfo(23638)] = { 60000, 23638 }, -- Black Amnesty
    [GetSpellInfo(3844)] = { 12500, 3844 }, -- Heavy Woolen Cloak
    [GetSpellInfo(7147)] = { 45000, 7147 }, -- Guardian Pants
    [GetSpellInfo(6358)] = { 1500, 6358 }, -- Seduction
    [GetSpellInfo(12851)] = { 2000, 12851 }, -- Release the Hounds
    [GetSpellInfo(18418)] = { 60000, 18418 }, -- Cindercloth Cloak
    [GetSpellInfo(9954)] = { 60000, 9954 }, -- Truesilver Gauntlets
    [GetSpellInfo(3939)] = { 25000, 3939 }, -- Lovingly Crafted Boomstick
    [GetSpellInfo(3936)] = { 25000, 3936 }, -- Deadly Blunderbuss
    [GetSpellInfo(6671)] = { 5000, 6671 }, -- Create Scroll
    [GetSpellInfo(17453)] = { 3000, 17453 }, -- Green Mechanostrider
    [GetSpellInfo(10696)] = { 1000, 10696 }, -- Summon Azure Whelpling
    [GetSpellInfo(3657)] = { 5000, 3657 }, -- Summon Spell Guard
    [GetSpellInfo(9193)] = { 12500, 9193 }, -- Heavy Quiver
    [GetSpellInfo(6366)] = { 3000, 6366 }, -- Create Firestone (Lesser)
    [GetSpellInfo(29467)] = { 5000, 29467 }, -- Power of the Scourge
    [GetSpellInfo(22725)] = { 3000, 22725 }, -- Defense +3
    [GetSpellInfo(19790)] = { 8000, 19790 }, -- Thorium Grenade
    [GetSpellInfo(3849)] = { 25000, 3849 }, -- Reinforced Woolen Shoulders
    [GetSpellInfo(3263)] = { 1500, 3263 }, -- Touch of Ravenclaw
    [GetSpellInfo(7121)] = { 2000, 7121 }, -- Anti-Magic Shield
    [GetSpellInfo(15575)] = { 1500, 15575 }, -- Flame Cannon
    [GetSpellInfo(2740)] = { 12500, 2740 }, -- Bronze Mace
    [GetSpellInfo(2881)] = { 5125, 2881 }, -- Light Leather
    [GetSpellInfo(11466)] = { 3000, 11466 }, -- Gift of Arthas
    [GetSpellInfo(16652)] = { 60000, 16652 }, -- Thorium Boots
    [GetSpellInfo(3567)] = { 10000, 3567 }, -- Teleport: Orgrimmar
    [GetSpellInfo(28327)] = { 8000, 28327 }, -- Steam Tonk Controller
    [GetSpellInfo(25145)] = { 2000, 25145 }, -- Merithra's Wake
    [GetSpellInfo(8240)] = { 3000, 8240 }, -- Elixir of Giant Growth
    [GetSpellInfo(16058)] = { 3000, 16058 }, -- Primal Leopard
    [GetSpellInfo(9654)] = { 3000, 9654 }, -- Jumping Lightning
    [GetSpellInfo(17637)] = { 25000, 17637 }, -- Flask of Supreme Power
    [GetSpellInfo(24179)] = { 1000, 24179 }, -- Create Seal of the Dawn
    [GetSpellInfo(15095)] = { 2000, 15095 }, -- Molten Blast
    [GetSpellInfo(3870)] = { 25000, 3870 }, -- Dark Silk Shirt
    [GetSpellInfo(4165)] = { 3000, 4165 }, -- Throw Rock II
    [GetSpellInfo(3565)] = { 10000, 3565 }, -- Teleport: Darnassus
    [GetSpellInfo(3515)] = { 45000, 3515 }, -- Golden Scale Boots
    [GetSpellInfo(3966)] = { 25000, 3966 }, -- Craftsman's Monocle
    [GetSpellInfo(18560)] = { 60000, 18560 }, -- Mooncloth
    [GetSpellInfo(6215)] = { 1500, 6215 }, -- Fear
    [GetSpellInfo(23249)] = { 3000, 23249 }, -- Great Brown Kodo
    [GetSpellInfo(20685)] = { 1000, 20685 }, -- Storm Bolt
    [GetSpellInfo(25149)] = { 2000, 25149 }, -- Arygos's Vengeance
    [GetSpellInfo(23652)] = { 60000, 23652 }, -- Blackguard
    [GetSpellInfo(20916)] = { 3000, 20916 }, -- Mithril Headed Trout
    [GetSpellInfo(19566)] = { 25000, 19566 }, -- Salt Shaker
    [GetSpellInfo(22480)] = { 3000, 22480 }, -- Tender Wolf Steak
    [GetSpellInfo(3325)] = { 12500, 3325 }, -- Gemmed Copper Gauntlets
    [GetSpellInfo(30047)] = { 3000, 30047 }, -- Crystal Throat Lozenge
    [GetSpellInfo(9200)] = { 3000, 9200 }, -- Create Sapta
    [GetSpellInfo(16600)] = { 1000, 16600 }, -- Might of Shahram
    [GetSpellInfo(7120)] = { 3000, 7120 }, -- Proudmoore's Defense
    [GetSpellInfo(16744)] = { 60000, 16744 }, -- Enchanted Thorium Leggings
    [GetSpellInfo(12908)] = { 25000, 12908 }, -- Goblin Dragon Gun
    [GetSpellInfo(19058)] = { 12500, 19058 }, -- Rugged Armor Kit
    [GetSpellInfo(20848)] = { 60000, 20848 }, -- Flarecore Mantle
    [GetSpellInfo(25123)] = { 3000, 25123 }, -- Brilliant Mana Oil
    [GetSpellInfo(3500)] = { 45000, 3500 }, -- Shadow Crescent Axe
    [GetSpellInfo(3862)] = { 45000, 3862 }, -- Icy Cloak
    [GetSpellInfo(3264)] = { 1000, 3264 }, -- Blood Howl
    [GetSpellInfo(23709)] = { 60000, 23709 }, -- Corehound Belt
    [GetSpellInfo(19512)] = { 1300, 19512 }, -- Apply Salve
    [GetSpellInfo(3636)] = { 2000, 3636 }, -- Crystalline Slumber
    [GetSpellInfo(27571)] = { 500, 27571 }, -- Cascade of Roses
    [GetSpellInfo(12709)] = { 4000, 12709 }, -- Collecting Fallout
    [GetSpellInfo(12063)] = { 60000, 12063 }, -- Stormcloth Gloves
    [GetSpellInfo(10707)] = { 1000, 10707 }, -- Summon Great Horned Owl
    [GetSpellInfo(8467)] = { 12500, 8467 }, -- White Woolen Dress
    [GetSpellInfo(22720)] = { 3000, 22720 }, -- Black War Ram
    [GetSpellInfo(23308)] = { 2000, 23308 }, -- Incinerate
    [GetSpellInfo(3506)] = { 45000, 3506 }, -- Green Iron Leggings
    [GetSpellInfo(24815)] = { 10000, 24815 }, -- Draw Ancient Glyphs
    [GetSpellInfo(7125)] = { 500, 7125 }, -- Toxic Saliva
    [GetSpellInfo(28396)] = { 1000, 28396 }, -- Reputation - Everlook +500
    [GetSpellInfo(1002)] = { 2000, 1002 }, -- Eyes of the Beast
    [GetSpellInfo(15833)] = { 3000, 15833 }, -- Dreamless Sleep Potion
    [GetSpellInfo(10711)] = { 1000, 10711 }, -- Summon Snowshoe Rabbit
    [GetSpellInfo(10790)] = { 3000, 10790 }, -- Tiger
    [GetSpellInfo(28271)] = { 1500, 28271 }, -- Polymorph
    [GetSpellInfo(12584)] = { 25000, 12584 }, -- Gold Power Core
    [GetSpellInfo(10554)] = { 60000, 10554 }, -- Tough Scorpid Boots
    [GetSpellInfo(9818)] = { 45000, 9818 }, -- Barbaric Iron Boots
    [GetSpellInfo(3132)] = { 1000, 3132 }, -- Chilling Breath
    [GetSpellInfo(16473)] = { 1000, 16473 }, -- Summoned Urok
    [GetSpellInfo(24963)] = { 1000, 24963 }, -- Honor Points +228
    [GetSpellInfo(18363)] = { 3000, 18363 }, -- Riding Kodo
    [GetSpellInfo(2739)] = { 5125, 2739 }, -- Copper Shortsword
    [GetSpellInfo(21160)] = { 44500, 21160 }, -- Eye of Sulfuras
    [GetSpellInfo(7408)] = { 12500, 7408 }, -- Heavy Copper Maul
    [GetSpellInfo(16032)] = { 500, 16032 }, -- Merging Oozes
    [GetSpellInfo(23180)] = { 2000, 23180 }, -- Release Imp
    [GetSpellInfo(23219)] = { 3000, 23219 }, -- Swift Mistsaber
    [GetSpellInfo(7213)] = { 3000, 7213 }, -- Giant Clam Scorcho
    [GetSpellInfo(21370)] = { 5000, 21370 }, -- Planting Jeztor's Beacon
    [GetSpellInfo(10687)] = { 1000, 10687 }, -- Summon White Plymouth Rock
    [GetSpellInfo(25119)] = { 3000, 25119 }, -- Lesser Wizard Oil
    [GetSpellInfo(13528)] = { 2000, 13528 }, -- Decayed Strength
    [GetSpellInfo(24997)] = { 4000, 24997 }, -- Greater Dispel
    [GetSpellInfo(12587)] = { 45000, 12587 }, -- Bright-Eye Goggles
    [GetSpellInfo(3722)] = { 1000, 3722 }, -- Summon Syndicate Spectre
    [GetSpellInfo(6530)] = { 1000, 6530 }, -- Sling Dirt
    [GetSpellInfo(24912)] = { 60000, 24912 }, -- Darkrune Gauntlets
    [GetSpellInfo(23704)] = { 60000, 23704 }, -- Timbermaw Brawlers
    [GetSpellInfo(11478)] = { 3000, 11478 }, -- Elixir of Detect Demon
    [GetSpellInfo(7295)] = { 2000, 7295 }, -- Soul Drain
    [GetSpellInfo(29134)] = { 10000, 29134 }, -- Maypole
    [GetSpellInfo(18476)] = { 500, 18476 }, -- Summon Minion
    [GetSpellInfo(21181)] = { 10000, 21181 }, -- Summon Shadowstrike
    [GetSpellInfo(2833)] = { 3000, 2833 }, -- Armor +24
    [GetSpellInfo(16447)] = { 2000, 16447 }, -- Spawn Challenge to Urok
    [GetSpellInfo(6653)] = { 3000, 6653 }, -- Dire Wolf
    [GetSpellInfo(7136)] = { 250, 7136 }, -- Shadow Port
    [GetSpellInfo(27832)] = { 60000, 27832 }, -- Sageblade
    [GetSpellInfo(18423)] = { 60000, 18423 }, -- Runecloth Boots
    [GetSpellInfo(9974)] = { 60000, 9974 }, -- Truesilver Breastplate
    [GetSpellInfo(3447)] = { 3000, 3447 }, -- Healing Potion
    [GetSpellInfo(4096)] = { 45000, 4096 }, -- Raptor Hide Harness
    [GetSpellInfo(23204)] = { 3000, 23204 }, -- Place Scryer
    [GetSpellInfo(17738)] = { 1500, 17738 }, -- Curse of the Plague Rat
    [GetSpellInfo(4950)] = { 3000, 4950 }, -- Summon Helcular's Puppets
    [GetSpellInfo(19095)] = { 60000, 19095 }, -- Living Breastplate
    [GetSpellInfo(12758)] = { 12500, 12758 }, -- Goblin Rocket Helmet
    [GetSpellInfo(3451)] = { 5000, 3451 }, -- Mighty Troll's Blood Potion
    [GetSpellInfo(17635)] = { 25000, 17635 }, -- Flask of the Titans
    [GetSpellInfo(12586)] = { 8000, 12586 }, -- Solid Dynamite
    [GetSpellInfo(3973)] = { 5125, 3973 }, -- Silver Contact
    [GetSpellInfo(25186)] = { 6000, 25186 }, -- Super Crystal
    [GetSpellInfo(9156)] = { 4000, 9156 }, -- Create Mage's Orb
    [GetSpellInfo(8465)] = { 5125, 8465 }, -- Simple Dress
    [GetSpellInfo(16996)] = { 5000, 16996 }, -- Incendia Powder
    [GetSpellInfo(10572)] = { 60000, 10572 }, -- Wild Leather Leggings
    [GetSpellInfo(2393)] = { 5125, 2393 }, -- White Linen Shirt
    [GetSpellInfo(16661)] = { 60000, 16661 }, -- Storm Gauntlets
    [GetSpellInfo(22949)] = { 3000, 22949 }, -- Seal Felvine Shard
    [GetSpellInfo(3942)] = { 5125, 3942 }, -- Whirring Bronze Gizmo
    [GetSpellInfo(10436)] = { 2200, 10436 }, -- Attack
    [GetSpellInfo(23221)] = { 3000, 23221 }, -- Swift Frostsaber
    [GetSpellInfo(19772)] = { 1000, 19772 }, -- Summon Lifelike Toad
    [GetSpellInfo(24847)] = { 60000, 24847 }, -- Spitfire Gauntlets
    [GetSpellInfo(26420)] = { 5125, 26420 }, -- Large Blue Rocket
    [GetSpellInfo(3400)] = { 3000, 3400 }, -- Soothing Turtle Bisque
    [GetSpellInfo(7223)] = { 25000, 7223 }, -- Golden Scale Bracers
    [GetSpellInfo(25813)] = { 10000, 25813 }, -- Conjure Dream Rift
    [GetSpellInfo(28745)] = { 2000, 28745 }, -- Quest - Prepare Field Duty Papers
    [GetSpellInfo(17009)] = { 1000, 17009 }, -- Voodoo
    [GetSpellInfo(2165)] = { 5125, 2165 }, -- Medium Armor Kit
    [GetSpellInfo(7179)] = { 3000, 7179 }, -- Elixir of Water Breathing
    [GetSpellInfo(4141)] = { 10000, 4141 }, -- Summon Myzrael
    [GetSpellInfo(23637)] = { 60000, 23637 }, -- Dark Iron Gauntlets
    [GetSpellInfo(6630)] = { 5000, 6630 }, -- Set NG-5 Charge (Red)
    [GetSpellInfo(10340)] = { 5000, 10340 }, -- Uldaman Boss Agro
    [GetSpellInfo(29331)] = { 1000, 29331 }, -- Copy of Dark Desire
    [GetSpellInfo(13227)] = { 3000, 13227 }, -- Wound Poison
    [GetSpellInfo(7845)] = { 3000, 7845 }, -- Elixir of Firepower
    [GetSpellInfo(12720)] = { 25000, 12720 }, -- Goblin "Boom" Box
    [GetSpellInfo(20051)] = { 30000, 20051 }, -- Runed Arcanite Rod
    [GetSpellInfo(5567)] = { 1000, 5567 }, -- Miring Mud
    [GetSpellInfo(3813)] = { 25000, 3813 }, -- Small Silk Pack
    [GetSpellInfo(12905)] = { 12500, 12905 }, -- Gnomish Rocket Boots
    [GetSpellInfo(27658)] = { 45000, 27658 }, -- Enchanted Mageweave Pouch
    [GetSpellInfo(9933)] = { 60000, 9933 }, -- Heavy Mithril Pants
    [GetSpellInfo(24356)] = { 60000, 24356 }, -- Bloodvine Goggles
    [GetSpellInfo(16651)] = { 60000, 16651 }, -- Thorium Shield Spike
    [GetSpellInfo(23247)] = { 3000, 23247 }, -- Great White Kodo
    [GetSpellInfo(9055)] = { 2000, 9055 }, -- Create Witherbark Totem Bundle
    [GetSpellInfo(3949)] = { 25000, 3949 }, -- Silver-plated Shotgun
    [GetSpellInfo(13900)] = { 1500, 13900 }, -- Fiery Burst
    [GetSpellInfo(35)] = { 2000, 35 }, -- Teleport Elwynn
    [GetSpellInfo(1403)] = { 3000, 1403 }, -- Summon Succubus
    [GetSpellInfo(2157)] = { 3000, 2157 }, -- Light Winter Boots
    [GetSpellInfo(23122)] = { 1000, 23122 }, -- Jaina's Autograph
    [GetSpellInfo(3840)] = { 5125, 3840 }, -- Heavy Linen Gloves
    [GetSpellInfo(14928)] = { 1000, 14928 }, -- Nagmara's Love Potion
    [GetSpellInfo(3492)] = { 45000, 3492 }, -- Hardened Iron Shortsword
    [GetSpellInfo(23708)] = { 60000, 23708 }, -- Chromatic Gauntlets
    [GetSpellInfo(26373)] = { 5000, 26373 }, -- Lunar Invititation
    [GetSpellInfo(15596)] = { 30000, 15596 }, -- Smoking Heart of the Mountain
    [GetSpellInfo(10771)] = { 2000, 10771 }, -- Soul Shatter
    [GetSpellInfo(19561)] = { 3000, 19561 }, -- Summon Gnashjaw
    [GetSpellInfo(12903)] = { 45000, 12903 }, -- Gnomish Harm Prevention Belt
    [GetSpellInfo(17463)] = { 3000, 17463 }, -- Blue Skeletal Horse
    [GetSpellInfo(12802)] = { 3000, 12802 }, -- Getting Tide Pool Sample #1
    [GetSpellInfo(16868)] = { 1500, 16868 }, -- Banshee Wail
    [GetSpellInfo(19070)] = { 60000, 19070 }, -- Heavy Scorpid Belt
    [GetSpellInfo(6419)] = { 3000, 6419 }, -- Lean Venison
    [GetSpellInfo(17529)] = { 1000, 17529 }, -- Vitreous Focuser
    [GetSpellInfo(30732)] = { 1000, 30732 }, -- Worm Sweep
    [GetSpellInfo(8138)] = { 3000, 8138 }, -- Mirkfallon Fungus
    [GetSpellInfo(12895)] = { 25000, 12895 }, -- Inlaid Mithril Cylinder Plans
    [GetSpellInfo(9583)] = { 3000, 9583 }, -- Water Sample
    [GetSpellInfo(24168)] = { 4000, 24168 }, -- Animist's Caress
    [GetSpellInfo(458)] = { 3000, 458 }, -- Brown Horse
    [GetSpellInfo(19819)] = { 8000, 19819 }, -- Voice Amplification Modulator
    [GetSpellInfo(6918)] = { 2000, 6918 }, -- Summon Snufflenose
    [GetSpellInfo(8764)] = { 45000, 8764 }, -- Earthen Vest
    [GetSpellInfo(5761)] = { 3000, 5761 }, -- Mind-numbing Poison
    [GetSpellInfo(10912)] = { 3000, 10912 }, -- Mind Control
    [GetSpellInfo(9482)] = { 1000, 9482 }, -- Amplify Flames
    [GetSpellInfo(10789)] = { 3000, 10789 }, -- Spotted Frostsaber
    [GetSpellInfo(12805)] = { 3000, 12805 }, -- Getting Tide Pool Sample #2
    [GetSpellInfo(16986)] = { 60000, 16986 }, -- Blood Talon
    [GetSpellInfo(3335)] = { 5000, 3335 }, -- Dark Sludge
    [GetSpellInfo(23208)] = { 4000, 23208 }, -- Exorcise Spirits
    [GetSpellInfo(9950)] = { 60000, 9950 }, -- Ornate Mithril Gloves
    [GetSpellInfo(3607)] = { 4000, 3607 }, -- Yenniku's Release
    [GetSpellInfo(10683)] = { 1000, 10683 }, -- Summon Green Wing Macaw
    [GetSpellInfo(14930)] = { 25000, 14930 }, -- Quickdraw Quiver
    [GetSpellInfo(5666)] = { 3000, 5666 }, -- Summon Timberling
    [GetSpellInfo(28526)] = { 2000, 28526 }, -- Icebolt
    [GetSpellInfo(2149)] = { 5125, 2149 }, -- Handstitched Leather Boots
    [GetSpellInfo(3920)] = { 5125, 3920 }, -- Crafted Light Shot
    [GetSpellInfo(24334)] = { 2000, 24334 }, -- Acid Spit
    [GetSpellInfo(25167)] = { 7000, 25167 }, -- Call Ancients
    [GetSpellInfo(2538)] = { 3000, 2538 }, -- Charred Wolf Meat
    [GetSpellInfo(6617)] = { 3000, 6617 }, -- Rage Potion
    [GetSpellInfo(11453)] = { 3000, 11453 }, -- Magic Resistance Potion
    [GetSpellInfo(6500)] = { 3000, 6500 }, -- Goblin Deviled Clams
    [GetSpellInfo(10647)] = { 60000, 10647 }, -- Feathered Breastplate
    [GetSpellInfo(12091)] = { 25000, 12091 }, -- White Wedding Dress
    [GetSpellInfo(12089)] = { 45000, 12089 }, -- Tuxedo Pants
    [GetSpellInfo(12890)] = { 1000, 12890 }, -- Deep Slumber
    [GetSpellInfo(20531)] = { 2000, 20531 }, -- Bind Chapter 3
    [GetSpellInfo(15998)] = { 2500, 15998 }, -- Capture Worg Pup
    [GetSpellInfo(16528)] = { 1500, 16528 }, -- Numbing Pain
    [GetSpellInfo(27291)] = { 2000, 27291 }, -- Summon Magic Staff
    [GetSpellInfo(16654)] = { 60000, 16654 }, -- Radiant Gloves
    [GetSpellInfo(16588)] = { 3500, 16588 }, -- Dark Mending
    [GetSpellInfo(27287)] = { 1500, 27287 }, -- Energy Siphon
    [GetSpellInfo(17458)] = { 3000, 17458 }, -- Fluorescent Green Mechanostrider
    [GetSpellInfo(27860)] = { 1500, 27860 }, -- Engulfing Shadows
    [GetSpellInfo(28472)] = { 60000, 28472 }, -- Bramblewood Helm
    [GetSpellInfo(6305)] = { 3000, 6305 }, -- Flame Burst
    [GetSpellInfo(6469)] = { 5000, 6469 }, -- Skeletal Miner Explode
    [GetSpellInfo(26588)] = { 5000, 26588 }, -- Opening Greater Scarab Coffer
    [GetSpellInfo(27590)] = { 60000, 27590 }, -- Obsidian Mail Tunic
    [GetSpellInfo(26636)] = { 500, 26636 }, -- Elune's Candle
    [GetSpellInfo(17432)] = { 5000, 17432 }, -- Opening Stratholme Postbox
    [GetSpellInfo(7222)] = { 25000, 7222 }, -- Iron Counterweight
    [GetSpellInfo(20529)] = { 2000, 20529 }, -- Bind Chapter 1
    [GetSpellInfo(9594)] = { 2000, 9594 }, -- Attach Medallion to Shaft
    [GetSpellInfo(580)] = { 3000, 580 }, -- Large Timber Wolf
    [GetSpellInfo(11209)] = { 10000, 11209 }, -- Summon Smithing Hammer
    [GetSpellInfo(23510)] = { 3000, 23510 }, -- Stormpike Battle Charger
    [GetSpellInfo(25117)] = { 3000, 25117 }, -- Minor Wizard Oil
    [GetSpellInfo(24851)] = { 60000, 24851 }, -- Sandstalker Breastplate
    [GetSpellInfo(15128)] = { 1000, 15128 }, -- Mark of Flames
    [GetSpellInfo(11479)] = { 25000, 11479 }, -- Transmute: Iron to Gold
    [GetSpellInfo(8693)] = { 3000, 8693 }, -- Mind-numbing Poison II
    [GetSpellInfo(25122)] = { 3000, 25122 }, -- Brilliant Wizard Oil
    [GetSpellInfo(23252)] = { 3000, 23252 }, -- Swift Gray Wolf
    [GetSpellInfo(23679)] = { 3000, 23679 }, -- Elementals Deck
    [GetSpellInfo(18414)] = { 60000, 18414 }, -- Brightcloth Robe
    [GetSpellInfo(17727)] = { 5000, 17727 }, -- Create Spellstone (Greater)
    [GetSpellInfo(25853)] = { 2000, 25853 }, -- Empty Festive Mug
    [GetSpellInfo(13143)] = { 10000, 13143 }, -- Summon Razelikh
    [GetSpellInfo(25465)] = { 500, 25465 }, -- Firework
    [GetSpellInfo(24973)] = { 5000, 24973 }, -- Clean Up Stink Bomb
    [GetSpellInfo(10698)] = { 1000, 10698 }, -- Summon Emerald Whelpling
    [GetSpellInfo(15491)] = { 3000, 15491 }, -- Collect Blessed Water
    [GetSpellInfo(8895)] = { 12500, 8895 }, -- Goblin Rocket Boots
    [GetSpellInfo(17565)] = { 25000, 17565 }, -- Transmute: Life to Earth
    [GetSpellInfo(12616)] = { 45000, 12616 }, -- Parachute Cloak
    [GetSpellInfo(11356)] = { 3000, 11356 }, -- Deadly Poison IV
    [GetSpellInfo(17460)] = { 3000, 17460 }, -- Frost Ram
    [GetSpellInfo(19049)] = { 60000, 19049 }, -- Wicked Leather Gauntlets
    [GetSpellInfo(24420)] = { 5000, 24420 }, -- Zandalar Signet of Serenity
    [GetSpellInfo(1842)] = { 2000, 1842 }, -- Disarm Trap
    [GetSpellInfo(17579)] = { 3000, 17579 }, -- Greater Holy Protection Potion
    [GetSpellInfo(15261)] = { 3500, 15261 }, -- Holy Fire
    [GetSpellInfo(7929)] = { 3000, 7929 }, -- Heavy Silk Bandage
    [GetSpellInfo(2166)] = { 12500, 2166 }, -- Toughened Leather Armor
    [GetSpellInfo(2549)] = { 3000, 2549 }, -- Seasoned Wolf Kabob
    [GetSpellInfo(11418)] = { 10000, 11418 }, -- Portal: Undercity
    [GetSpellInfo(25018)] = { 1000, 25018 }, -- Summon Murki
    [GetSpellInfo(8517)] = { 5000, 8517 }, -- Opening Strongbox
    [GetSpellInfo(13978)] = { 2000, 13978 }, -- Summon Aquementas
    [GetSpellInfo(20904)] = { 3000, 20904 }, -- Aimed Shot
    [GetSpellInfo(4983)] = { 5000, 4983 }, -- Create Cleansing Totem
    [GetSpellInfo(6805)] = { 5000, 6805 }, -- Dousing
    [GetSpellInfo(16741)] = { 60000, 16741 }, -- Stronghold Gauntlets
    [GetSpellInfo(21188)] = { 2000, 21188 }, -- Stun Bomb Attack
    [GetSpellInfo(2964)] = { 5125, 2964 }, -- Bolt of Woolen Cloth
    [GetSpellInfo(18246)] = { 3000, 18246 }, -- Mightfish Steak
    [GetSpellInfo(10487)] = { 5125, 10487 }, -- Thick Armor Kit
    [GetSpellInfo(1112)] = { 3000, 1112 }, -- Shadow Nova II
    [GetSpellInfo(12056)] = { 60000, 12056 }, -- Red Mageweave Vest
    [GetSpellInfo(21736)] = { 1000, 21736 }, -- Winterax Wisdom
    [GetSpellInfo(10556)] = { 60000, 10556 }, -- Turtle Scale Leggings
    [GetSpellInfo(7126)] = { 5125, 7126 }, -- Handstitched Leather Vest
    [GetSpellInfo(8339)] = { 5125, 8339 }, -- EZ-Thro Dynamite
    [GetSpellInfo(898)] = { 3000, 898 }, -- Create Fervor Potion
    [GetSpellInfo(2795)] = { 3000, 2795 }, -- Beer Basted Boar Ribs
    [GetSpellInfo(8607)] = { 3000, 8607 }, -- Smoked Bear Meat
    [GetSpellInfo(3611)] = { 2500, 3611 }, -- Minion of Morganth
    [GetSpellInfo(18163)] = { 4000, 18163 }, -- Strength of Arko'narin
    [GetSpellInfo(27891)] = { 1500, 27891 }, -- Disease Buffet
    [GetSpellInfo(7978)] = { 2000, 7978 }, -- Throw Dynamite
    [GetSpellInfo(10009)] = { 60000, 10009 }, -- Runed Mithril Hammer
    [GetSpellInfo(14871)] = { 2000, 14871 }, -- Shadow Bolt Misfire
    [GetSpellInfo(19029)] = { 5000, 19029 }, -- Create Coagulated Rot
    [GetSpellInfo(5272)] = { 2000, 5272 }, -- Dalaran Wizard Disguise
    [GetSpellInfo(17562)] = { 25000, 17562 }, -- Transmute: Water to Air
    [GetSpellInfo(444)] = { 2000, 444 }, -- Teleport Lighthouse
    [GetSpellInfo(7962)] = { 2000, 7962 }, -- Break Big Stuff
    [GetSpellInfo(3513)] = { 45000, 3513 }, -- Polished Steel Boots
    [GetSpellInfo(8283)] = { 1500, 8283 }, -- Snufflenose Command
    [GetSpellInfo(23787)] = { 3000, 23787 }, -- Powerful Anti-Venom
    [GetSpellInfo(7754)] = { 3000, 7754 }, -- Loch Frenzy Delight
    [GetSpellInfo(6661)] = { 25000, 6661 }, -- Barbaric Harness
    [GetSpellInfo(17577)] = { 3000, 17577 }, -- Greater Arcane Protection Potion
    [GetSpellInfo(11067)] = { 3000, 11067 }, -- Perm. Illusion Tyrion
    [GetSpellInfo(24214)] = { 2000, 24214 }, -- Heart of Hakkar - Molthor chucks the heart
    [GetSpellInfo(10180)] = { 3000, 10180 }, -- Frostbolt
    [GetSpellInfo(23123)] = { 1000, 23123 }, -- Cairne's Hoofprint
    [GetSpellInfo(19073)] = { 60000, 19073 }, -- Chimeric Leggings
    [GetSpellInfo(6405)] = { 2000, 6405 }, -- Furbolg Form
    [GetSpellInfo(16031)] = { 5000, 16031 }, -- Releasing Corrupt Ooze
    [GetSpellInfo(1452)] = { 1000, 1452 }, -- Arcane Spirit IV
    [GetSpellInfo(23710)] = { 60000, 23710 }, -- Molten Belt
    [GetSpellInfo(7817)] = { 8000, 7817 }, -- Rough Bronze Boots
    [GetSpellInfo(12047)] = { 5125, 12047 }, -- Colorful Kilt
    [GetSpellInfo(3292)] = { 12500, 3292 }, -- Heavy Copper Broadsword
    [GetSpellInfo(22372)] = { 500, 22372 }, -- Demon Portal
    [GetSpellInfo(18992)] = { 3000, 18992 }, -- Teal Kodo
    [GetSpellInfo(7655)] = { 2000, 7655 }, -- Hex of Ravenclaw
    [GetSpellInfo(19484)] = { 1000, 19484 }, -- Majordomo Teleport Visual
    [GetSpellInfo(10574)] = { 60000, 10574 }, -- Wild Leather Cloak
    [GetSpellInfo(16725)] = { 60000, 16725 }, -- Radiant Leggings
    [GetSpellInfo(8778)] = { 25000, 8778 }, -- Boots of Darkness
    [GetSpellInfo(22711)] = { 45000, 22711 }, -- Shadowskin Gloves
    [GetSpellInfo(7751)] = { 3000, 7751 }, -- Brilliant Smallfish
    [GetSpellInfo(17728)] = { 5000, 17728 }, -- Create Spellstone (Major)
    [GetSpellInfo(12459)] = { 3000, 12459 }, -- Deadly Scope
    [GetSpellInfo(28219)] = { 60000, 28219 }, -- Polar Tunic
    [GetSpellInfo(22757)] = { 8000, 22757 }, -- Elemental Sharpening Stone
    [GetSpellInfo(9072)] = { 12500, 9072 }, -- Red Whelp Gloves
    [GetSpellInfo(3847)] = { 12500, 3847 }, -- Red Woolen Boots
    [GetSpellInfo(23152)] = { 5000, 23152 }, -- Summon Xorothian Dreadsteed
    [GetSpellInfo(17578)] = { 3000, 17578 }, -- Greater Shadow Protection Potion
    [GetSpellInfo(14804)] = { 10000, 14804 }, -- Copy of Release Rageclaw
    [GetSpellInfo(19052)] = { 60000, 19052 }, -- Wicked Leather Bracers
    [GetSpellInfo(23008)] = { 5000, 23008 }, -- Powerful Seaforium Charge
    [GetSpellInfo(12059)] = { 60000, 12059 }, -- White Bandit Mask
    [GetSpellInfo(17554)] = { 3000, 17554 }, -- Elixir of Superior Defense
    [GetSpellInfo(28299)] = { 1000, 28299 }, -- Ball Lightning
    [GetSpellInfo(21935)] = { 25000, 21935 }, -- SnowMaster 9000
    [GetSpellInfo(24252)] = { 3000, 24252 }, -- Swift Zulian Tiger
    [GetSpellInfo(885)] = { 3000, 885 }, -- Invisibility
    [GetSpellInfo(17555)] = { 3000, 17555 }, -- Elixir of the Sages
    [GetSpellInfo(6415)] = { 3000, 6415 }, -- Fillet of Frenzy
    [GetSpellInfo(16622)] = { 3000, 16622 }, -- Enhance Blunt Weapon V
    [GetSpellInfo(442)] = { 2000, 442 }, -- Teleport Northshire Abbey
    [GetSpellInfo(23254)] = { 10000, 23254 }, -- Redeeming the Soul
    [GetSpellInfo(12754)] = { 12500, 12754 }, -- The Big One
    [GetSpellInfo(7023)] = { 3000, 7023 }, -- Goblin Camera Connection
    [GetSpellInfo(4982)] = { 5000, 4982 }, -- Pillar Delving
    [GetSpellInfo(10708)] = { 1000, 10708 }, -- Summon Snowy Owl
    [GetSpellInfo(10934)] = { 2500, 10934 }, -- Smite
    [GetSpellInfo(7081)] = { 2000, 7081 }, -- Encage
    [GetSpellInfo(21885)] = { 500, 21885 }, -- Heal Vylestem Vine
    [GetSpellInfo(19825)] = { 60000, 19825 }, -- Master Engineer's Goggles
    [GetSpellInfo(16533)] = { 5000, 16533 }, -- Emberseer Start
    [GetSpellInfo(10562)] = { 60000, 10562 }, -- Big Voodoo Cloak
    [GetSpellInfo(18243)] = { 3000, 18243 }, -- Nightfin Soup
    [GetSpellInfo(25804)] = { 1000, 25804 }, -- Rumsey Rum Black Label
    [GetSpellInfo(15627)] = { 4000, 15627 }, -- Applying the Lure
    [GetSpellInfo(17566)] = { 25000, 17566 }, -- Transmute: Earth to Life
    [GetSpellInfo(17464)] = { 3000, 17464 }, -- Brown Skeletal Horse
    [GetSpellInfo(12537)] = { 3000, 12537 }, -- Quest - Summon Treant
    [GetSpellInfo(9903)] = { 3000, 9903 }, -- Enhance Blunt Weapon IV
    [GetSpellInfo(22662)] = { 1500, 22662 }, -- Wither
    [GetSpellInfo(22876)] = { 4000, 22876 }, -- Summon Netherwalker
    [GetSpellInfo(5099)] = { 3000, 5099 }, -- Disruption
    [GetSpellInfo(10548)] = { 60000, 10548 }, -- Nightscape Pants
    [GetSpellInfo(12060)] = { 60000, 12060 }, -- Red Mageweave Pants
    [GetSpellInfo(9813)] = { 25000, 9813 }, -- Barbaric Iron Breastplate
    [GetSpellInfo(7836)] = { 5000, 7836 }, -- Blackmouth Oil
    [GetSpellInfo(12080)] = { 45000, 12080 }, -- Pink Mageweave Shirt
    [GetSpellInfo(17559)] = { 25000, 17559 }, -- Transmute: Air to Fire
    [GetSpellInfo(12048)] = { 60000, 12048 }, -- Black Mageweave Vest
    [GetSpellInfo(15734)] = { 1000, 15734 }, -- Summon
    [GetSpellInfo(25118)] = { 3000, 25118 }, -- Minor Mana Oil
    [GetSpellInfo(10721)] = { 1000, 10721 }, -- Summon Elven Wisp
    [GetSpellInfo(3658)] = { 5000, 3658 }, -- Summon Theurgist
    [GetSpellInfo(3925)] = { 8000, 3925 }, -- Rough Boomstick
    [GetSpellInfo(18456)] = { 60000, 18456 }, -- Truefaith Vestments
    [GetSpellInfo(22027)] = { 1000, 22027 }, -- Remove Insignia
    [GetSpellInfo(12615)] = { 45000, 12615 }, -- Spellpower Goggles Xtreme
    [GetSpellInfo(9952)] = { 60000, 9952 }, -- Ornate Mithril Shoulders
    [GetSpellInfo(6234)] = { 5000, 6234 }, -- Incineration
    [GetSpellInfo(12622)] = { 45000, 12622 }, -- Green Lens
    [GetSpellInfo(606)] = { 2000, 606 }, -- Mind Rot
    [GetSpellInfo(24889)] = { 2000, 24889 }, -- Create Signet of Beckoning: Fire
    [GetSpellInfo(10738)] = { 5000, 10738 }, -- Unlocking
    [GetSpellInfo(8800)] = { 1000, 8800 }, -- Dynamite
    [GetSpellInfo(28505)] = { 1000, 28505 }, -- Summon Poley
    [GetSpellInfo(24888)] = { 1500, 24888 }, -- Create Crest of Beckoning: Water
    [GetSpellInfo(10621)] = { 60000, 10621 }, -- Wolfshead Helm
    [GetSpellInfo(18166)] = { 4000, 18166 }, -- Summon Magram Ravager
    [GetSpellInfo(18629)] = { 3000, 18629 }, -- Runecloth Bandage
    [GetSpellInfo(30152)] = { 1000, 30152 }, -- Summon White Tiger Cub
    [GetSpellInfo(10098)] = { 3000, 10098 }, -- Smelt Truesilver
    [GetSpellInfo(1366)] = { 3000, 1366 }, -- Summon Imp
    [GetSpellInfo(8153)] = { 5000, 8153 }, -- Owl Form
    [GetSpellInfo(8368)] = { 12500, 8368 }, -- Ironforge Gauntlets
    [GetSpellInfo(15746)] = { 1000, 15746 }, -- Disturb Rookery Egg
    [GetSpellInfo(5414)] = { 3000, 5414 }, -- Balance of Nature
    [GetSpellInfo(3759)] = { 12500, 3759 }, -- Embossed Leather Pants
    [GetSpellInfo(28800)] = { 5000, 28800 }, -- Word of Thawing
    [GetSpellInfo(2331)] = { 3000, 2331 }, -- Minor Mana Potion
    [GetSpellInfo(23161)] = { 3000, 23161 }, -- Summon Dreadsteed
    [GetSpellInfo(23705)] = { 60000, 23705 }, -- Dawn Treaders
    [GetSpellInfo(9997)] = { 60000, 9997 }, -- Wicked Mithril Blade
    [GetSpellInfo(6651)] = { 3000, 6651 }, -- Instant Toxin
    [GetSpellInfo(2005)] = { 3000, 2005 }, -- Bombard
    [GetSpellInfo(6413)] = { 3000, 6413 }, -- Scorpid Surprise
    [GetSpellInfo(10854)] = { 1000, 10854 }, -- Flames of Chaos
    [GetSpellInfo(16650)] = { 60000, 16650 }, -- Wildthorn Mail
    [GetSpellInfo(12076)] = { 60000, 12076 }, -- Shadoweave Shoulders
    [GetSpellInfo(11820)] = { 500, 11820 }, -- Electrified Net
    [GetSpellInfo(10733)] = { 1700, 10733 }, -- Flame Spray
    [GetSpellInfo(11568)] = { 5000, 11568 }, -- Uldaman Sub-Boss Agro
    [GetSpellInfo(20364)] = { 2000, 20364 }, -- Bury Samuel's Remains
    [GetSpellInfo(2167)] = { 8000, 2167 }, -- Dark Leather Boots
    [GetSpellInfo(23232)] = { 5000, 23232 }, -- Binding Volume II
    [GetSpellInfo(16601)] = { 1000, 16601 }, -- Fist of Shahram
    [GetSpellInfo(9970)] = { 60000, 9970 }, -- Heavy Mithril Helm
    [GetSpellInfo(3113)] = { 3000, 3113 }, -- Enhance Blunt Weapon II
    [GetSpellInfo(24167)] = { 4000, 24167 }, -- Prophetic Aura
    [GetSpellInfo(5408)] = { 3000, 5408 }, -- Quest - Sergra Darkthorn Spell
    [GetSpellInfo(14807)] = { 10000, 14807 }, -- Greater Magic Wand
    [GetSpellInfo(7256)] = { 3000, 7256 }, -- Shadow Protection Potion
    [GetSpellInfo(20756)] = { 3000, 20756 }, -- Create Soulstone (Greater)
    [GetSpellInfo(13819)] = { 3000, 13819 }, -- Summon Warhorse
    [GetSpellInfo(24801)] = { 3000, 24801 }, -- Smoked Desert Dumplings
    [GetSpellInfo(23632)] = { 60000, 23632 }, -- Girdle of the Dawn
    [GetSpellInfo(12618)] = { 45000, 12618 }, -- Rose Colored Goggles
    [GetSpellInfo(23066)] = { 5125, 23066 }, -- Red Firework
    [GetSpellInfo(12084)] = { 60000, 12084 }, -- Red Mageweave Headband
    [GetSpellInfo(22598)] = { 5000, 22598 }, -- Arcane Mantle of the Dawn
    [GetSpellInfo(3766)] = { 25000, 3766 }, -- Dark Leather Belt
    [GetSpellInfo(12052)] = { 60000, 12052 }, -- Shadoweave Pants
    [GetSpellInfo(23703)] = { 60000, 23703 }, -- Might of the Timbermaw
    [GetSpellInfo(17708)] = { 1000, 17708 }, -- Summon Diablo
    [GetSpellInfo(11399)] = { 3000, 11399 }, -- Mind-numbing Poison III
    [GetSpellInfo(3443)] = { 3000, 3443 }, -- Enchanted Quickness
    [GetSpellInfo(15794)] = { 5000, 15794 }, -- Summon Blackhand Dreadweaver
    [GetSpellInfo(26419)] = { 2000, 26419 }, -- Acid Spray
    [GetSpellInfo(28612)] = { 3000, 28612 }, -- Conjure Food
    [GetSpellInfo(18454)] = { 60000, 18454 }, -- Gloves of Spell Mastery
    [GetSpellInfo(20716)] = { 2000, 20716 }, -- Sand Breath
    [GetSpellInfo(4209)] = { 1000, 4209 }, -- Healing Tongue
    [GetSpellInfo(19077)] = { 60000, 19077 }, -- Blue Dragonscale Breastplate
    [GetSpellInfo(9959)] = { 60000, 9959 }, -- Heavy Mithril Breastplate
    [GetSpellInfo(8768)] = { 5125, 8768 }, -- Iron Buckle
    [GetSpellInfo(17048)] = { 3000, 17048 }, -- Soul Claim
    [GetSpellInfo(6741)] = { 10000, 6741 }, -- Identify Brood
    [GetSpellInfo(3670)] = { 5000, 3670 }, -- Unlock Maury's Foot
    [GetSpellInfo(8395)] = { 3000, 8395 }, -- Emerald Raptor
    [GetSpellInfo(15255)] = { 8000, 15255 }, -- Mechanical Repair Kit
    [GetSpellInfo(9983)] = { 8000, 9983 }, -- Copper Claymore
    [GetSpellInfo(3644)] = { 5000, 3644 }, -- Speak with Heads
    [GetSpellInfo(12085)] = { 45000, 12085 }, -- Tuxedo Shirt
    [GetSpellInfo(27586)] = { 60000, 27586 }, -- Jagged Obsidian Shield
    [GetSpellInfo(3143)] = { 1000, 3143 }, -- Glacial Roar
    [GetSpellInfo(2841)] = { 3000, 2841 }, -- Creeping Torment
    [GetSpellInfo(3857)] = { 45000, 3857 }, -- Enchanter's Cowl
    [GetSpellInfo(23129)] = { 8000, 23129 }, -- World Enlarger
    [GetSpellInfo(9461)] = { 2500, 9461 }, -- Summon Swamp Ooze
    [GetSpellInfo(3537)] = { 1000, 3537 }, -- Minions of Malathrom
    [GetSpellInfo(11473)] = { 3000, 11473 }, -- Ghost Dye
    [GetSpellInfo(8089)] = { 5000, 8089 }, -- Aquadynamic Fish Attractor
    [GetSpellInfo(19792)] = { 45000, 19792 }, -- Thorium Rifle
    [GetSpellInfo(3377)] = { 3000, 3377 }, -- Gooey Spider Cake
    [GetSpellInfo(27738)] = { 2000, 27738 }, -- Right Piece of Lord Valthalak's Amulet
    [GetSpellInfo(4093)] = { 3000, 4093 }, -- Reconstruction
    [GetSpellInfo(22331)] = { 8000, 22331 }, -- Rugged Leather
    [GetSpellInfo(3448)] = { 3000, 3448 }, -- Lesser Invisibility Potion
    [GetSpellInfo(24164)] = { 4000, 24164 }, -- Presence of Sight
    [GetSpellInfo(12609)] = { 5000, 12609 }, -- Catseye Elixir
    [GetSpellInfo(691)] = { 10000, 691 }, -- Summon Felhunter
    [GetSpellInfo(19588)] = { 1500, 19588 }, -- Place Ghost Magnet
    [GetSpellInfo(25992)] = { 1000, 25992 }, -- Brood of Nozdormu Factoin +1000
    [GetSpellInfo(18240)] = { 3000, 18240 }, -- Grilled Squid
    [GetSpellInfo(10623)] = { 2500, 10623 }, -- Chain Heal
    [GetSpellInfo(6470)] = { 5000, 6470 }, -- Tiny Bronze Key
    [GetSpellInfo(15999)] = { 1000, 15999 }, -- Summon Worg Pup
    [GetSpellInfo(8016)] = { 2000, 8016 }, -- Spirit Decay
    [GetSpellInfo(26102)] = { 2000, 26102 }, -- Sand Blast
    [GetSpellInfo(2394)] = { 5125, 2394 }, -- Blue Linen Shirt
    [GetSpellInfo(3934)] = { 12500, 3934 }, -- Flying Tiger Goggles
    [GetSpellInfo(7753)] = { 3000, 7753 }, -- Longjaw Mud Snapper
    [GetSpellInfo(13714)] = { 2000, 13714 }, -- Create Samophlange Manual
    [GetSpellInfo(16730)] = { 60000, 16730 }, -- Imperial Plate Leggings
    [GetSpellInfo(6618)] = { 3000, 6618 }, -- Great Rage Potion
    [GetSpellInfo(24149)] = { 4000, 24149 }, -- Presence of Might
    [GetSpellInfo(6925)] = { 5000, 6925 }, -- Gift of the Xavian
    [GetSpellInfo(30156)] = { 1000, 30156 }, -- Summon Hippogryph Hatchling
    [GetSpellInfo(18448)] = { 60000, 18448 }, -- Mooncloth Shoulders
    [GetSpellInfo(27585)] = { 60000, 27585 }, -- Heavy Obsidian Belt
    [GetSpellInfo(28099)] = { 1000, 28099 }, -- Shock
    [GetSpellInfo(17456)] = { 3000, 17456 }, -- Red & Blue Mechanostrider
    [GetSpellInfo(24901)] = { 60000, 24901 }, -- Runed Stygian Leggings
    [GetSpellInfo(23078)] = { 12500, 23078 }, -- Goblin Jumper Cables XL
    [GetSpellInfo(3775)] = { 45000, 3775 }, -- Guardian Belt
    [GetSpellInfo(23678)] = { 3000, 23678 }, -- Warlord Deck
    [GetSpellInfo(8256)] = { 3000, 8256 }, -- Lethal Toxin
    [GetSpellInfo(126)] = { 5000, 126 }, -- Eye of Kilrogg
    [GetSpellInfo(27739)] = { 2000, 27739 }, -- Top Piece of Lord Valthalak's Amulet
    [GetSpellInfo(10630)] = { 60000, 10630 }, -- Gauntlets of the Sea
    [GetSpellInfo(19085)] = { 60000, 19085 }, -- Black Dragonscale Breastplate
    [GetSpellInfo(6461)] = { 5000, 6461 }, -- Pick Lock
    [GetSpellInfo(3777)] = { 45000, 3777 }, -- Guardian Leather Bracers
    [GetSpellInfo(11726)] = { 3000, 11726 }, -- Enslave Demon
    [GetSpellInfo(7629)] = { 12500, 7629 }, -- Red Linen Vest
    [GetSpellInfo(2951)] = { 3000, 2951 }, -- Hellfire III
    [GetSpellInfo(24726)] = { 1000, 24726 }, -- Deputize Agent of Nozdormu
    [GetSpellInfo(20814)] = { 3000, 20814 }, -- Collect Dire Water
    [GetSpellInfo(18415)] = { 60000, 18415 }, -- Brightcloth Gloves
    [GetSpellInfo(9901)] = { 1500, 9901 }, -- Soothe Animal
    [GetSpellInfo(3768)] = { 25000, 3768 }, -- Hillman's Shoulders
    [GetSpellInfo(10678)] = { 1000, 10678 }, -- Summon Silver Tabby
    [GetSpellInfo(2332)] = { 3000, 2332 }, -- Minor Rejuvenation Potion
    [GetSpellInfo(7481)] = { 5000, 7481 }, -- Howling Rage
    [GetSpellInfo(472)] = { 3000, 472 }, -- Pinto Horse
    [GetSpellInfo(3963)] = { 25000, 3963 }, -- Compact Harvest Reaper Kit
    [GetSpellInfo(3860)] = { 45000, 3860 }, -- Boots of the Enchanter
    [GetSpellInfo(15067)] = { 1000, 15067 }, -- Summon Sprite Darter Hatchling
    [GetSpellInfo(21957)] = { 7000, 21957 }, -- Create Amulet of Union
    [GetSpellInfo(8087)] = { 5000, 8087 }, -- Shiny Bauble
    [GetSpellInfo(3453)] = { 5000, 3453 }, -- Elixir of Detect Lesser Invisibility
    [GetSpellInfo(7919)] = { 1000, 7919 }, -- Shoot Crossbow
    [GetSpellInfo(19053)] = { 60000, 19053 }, -- Chimeric Gloves
    [GetSpellInfo(22979)] = { 250, 22979 }, -- Shadow Flame
    [GetSpellInfo(3323)] = { 8000, 3323 }, -- Runed Copper Gauntlets
    [GetSpellInfo(23222)] = { 3000, 23222 }, -- Swift Yellow Mechanostrider
    [GetSpellInfo(25180)] = { 5000, 25180 }, -- Nature Weakness
    [GetSpellInfo(9853)] = { 1500, 9853 }, -- Entangling Roots
    [GetSpellInfo(12596)] = { 8000, 12596 }, -- Hi-Impact Mithril Slugs
    [GetSpellInfo(26587)] = { 5000, 26587 }, -- Opening Scarab Coffer
    [GetSpellInfo(28270)] = { 1500, 28270 }, -- Polymorph: Cow
    [GetSpellInfo(12070)] = { 60000, 12070 }, -- Dreamweave Vest
    [GetSpellInfo(16028)] = { 500, 16028 }, -- Freeze Rookery Egg - Prototype
    [GetSpellInfo(8367)] = { 12500, 8367 }, -- Ironforge Breastplate
    [GetSpellInfo(9577)] = { 5000, 9577 }, -- Uldaman Key Staff
    [GetSpellInfo(7827)] = { 3000, 7827 }, -- Rainbow Fin Albacore
    [GetSpellInfo(9945)] = { 60000, 9945 }, -- Ornate Mithril Pants
    [GetSpellInfo(12258)] = { 5000, 12258 }, -- Summon Shadowcaster
    [GetSpellInfo(818)] = { 10000, 818 }, -- Basic Campfire
    [GetSpellInfo(17180)] = { 12500, 17180 }, -- Enchanted Thorium
    [GetSpellInfo(3146)] = { 1000, 3146 }, -- Daunting Growl
    [GetSpellInfo(2838)] = { 3000, 2838 }, -- Creeping Pain
    [GetSpellInfo(18422)] = { 60000, 18422 }, -- Cloak of Fire
    [GetSpellInfo(12617)] = { 45000, 12617 }, -- Deepdive Helmet
    [GetSpellInfo(16378)] = { 2000, 16378 }, -- Temperature Reading
    [GetSpellInfo(5403)] = { 2000, 5403 }, -- Crash of Waves
    [GetSpellInfo(7156)] = { 25000, 7156 }, -- Guardian Gloves
    [GetSpellInfo(3359)] = { 3000, 3359 }, -- Drink Potion
    [GetSpellInfo(759)] = { 3000, 759 }, -- Conjure Mana Agate
    [GetSpellInfo(8686)] = { 3000, 8686 }, -- Instant Poison II
    [GetSpellInfo(7277)] = { 3000, 7277 }, -- Harvest Swarm
    [GetSpellInfo(20855)] = { 60000, 20855 }, -- Black Dragonscale Boots
    [GetSpellInfo(6510)] = { 3000, 6510 }, -- Blinding Powder
    [GetSpellInfo(8789)] = { 45000, 8789 }, -- Crimson Silk Cloak
    [GetSpellInfo(3361)] = { 20000, 3361 }, -- Dummy NPC Summon
    [GetSpellInfo(12066)] = { 60000, 12066 }, -- Red Mageweave Gloves
    [GetSpellInfo(20773)] = { 10000, 20773 }, -- Redemption
    [GetSpellInfo(12243)] = { 1000, 12243 }, -- Summon Mechanical Chicken
    [GetSpellInfo(15958)] = { 500, 15958 }, -- Collect Rookery Egg
    [GetSpellInfo(24966)] = { 1000, 24966 }, -- Honor Points +2388
    [GetSpellInfo(16247)] = { 2000, 16247 }, -- Curse of Thorns
    [GetSpellInfo(18887)] = { 1500, 18887 }, -- Create Nimboya's Laden Pike
    [GetSpellInfo(7818)] = { 8000, 7818 }, -- Silver Rod
    [GetSpellInfo(16653)] = { 60000, 16653 }, -- Thorium Helm
    [GetSpellInfo(28161)] = { 4000, 28161 }, -- Savage Guard
    [GetSpellInfo(22458)] = { 3000, 22458 }, -- Healing Circle
    [GetSpellInfo(1451)] = { 1000, 1451 }, -- Arcane Spirit III
    [GetSpellInfo(29475)] = { 5000, 29475 }, -- Resilience of the Scourge
    [GetSpellInfo(17133)] = { 1500, 17133 }, -- Create Pamela's Doll
    [GetSpellInfo(15120)] = { 1000, 15120 }, -- Cenarion Beacon
    [GetSpellInfo(17638)] = { 25000, 17638 }, -- Flask of Chromatic Resistance
    [GetSpellInfo(15792)] = { 5000, 15792 }, -- Summon Blackhand Veteran
    [GetSpellInfo(9097)] = { 5000, 9097 }, -- Summon Demon of the Orb
    [GetSpellInfo(3477)] = { 2000, 3477 }, -- Spirit Steal
    [GetSpellInfo(19831)] = { 8000, 19831 }, -- Arcane Bomb
    [GetSpellInfo(4320)] = { 3000, 4320 }, -- Trelane's Freezing Touch
    [GetSpellInfo(3336)] = { 25000, 3336 }, -- Green Iron Gauntlets
    [GetSpellInfo(12938)] = { 4000, 12938 }, -- Fel Curse
    [GetSpellInfo(11643)] = { 45000, 11643 }, -- Golden Scale Gauntlets
    [GetSpellInfo(3114)] = { 3000, 3114 }, -- Enhance Blunt Weapon III
    [GetSpellInfo(8980)] = { 3000, 8980 }, -- Skeletal Horse
    [GetSpellInfo(26072)] = { 1500, 26072 }, -- Dust Cloud
    [GetSpellInfo(4629)] = { 3000, 4629 }, -- Rain of Fire
    [GetSpellInfo(16640)] = { 8000, 16640 }, -- Dense Weightstone
    [GetSpellInfo(2334)] = { 3000, 2334 }, -- Elixir of Minor Fortitude
    [GetSpellInfo(22797)] = { 60000, 22797 }, -- Force Reactive Disk
    [GetSpellInfo(2645)] = { 3000, 2645 }, -- Ghost Wolf
    [GetSpellInfo(10053)] = { 3000, 10053 }, -- Conjure Mana Citrine
    [GetSpellInfo(7359)] = { 10000, 7359 }, -- Bright Campfire
    [GetSpellInfo(25247)] = { 500, 25247 }, -- Longsight
    [GetSpellInfo(3955)] = { 8000, 3955 }, -- Explosive Sheep
    [GetSpellInfo(8688)] = { 3000, 8688 }, -- Instant Poison III
    [GetSpellInfo(16667)] = { 60000, 16667 }, -- Demon Forged Breastplate
    [GetSpellInfo(10011)] = { 60000, 10011 }, -- Blight
    [GetSpellInfo(3174)] = { 3000, 3174 }, -- Elixir of Poison Resistance
    [GetSpellInfo(21730)] = { 5000, 21730 }, -- Planting Vipore's Beacon
    [GetSpellInfo(19106)] = { 60000, 19106 }, -- Onyxia Scale Breastplate
    [GetSpellInfo(5274)] = { 2000, 5274 }, -- Syndicate Disguise
    [GetSpellInfo(3852)] = { 25000, 3852 }, -- Gloves of Meditation
    [GetSpellInfo(6490)] = { 3000, 6490 }, -- Sarilus's Elementals
    [GetSpellInfo(11447)] = { 3000, 11447 }, -- Elixir of Waterwalking
    [GetSpellInfo(11338)] = { 3000, 11338 }, -- Instant Poison IV
    [GetSpellInfo(24895)] = { 3000, 24895 }, -- Create Scepter of Beckoning: Fire
    [GetSpellInfo(578)] = { 3000, 578 }, -- Black Wolf
    [GetSpellInfo(11434)] = { 500, 11434 }, -- Gong Zul'Farrak Gong
    [GetSpellInfo(22719)] = { 3000, 22719 }, -- Black Battlestrider
    [GetSpellInfo(21144)] = { 3000, 21144 }, -- Egg Nog
    [GetSpellInfo(10552)] = { 60000, 10552 }, -- Turtle Scale Helm
    [GetSpellInfo(18502)] = { 2500, 18502 }, -- Curse of Hakkar
    [GetSpellInfo(17536)] = { 4500, 17536 }, -- Awaken Kerlonian
    [GetSpellInfo(10787)] = { 3000, 10787 }, -- Panther
    [GetSpellInfo(6728)] = { 2000, 6728 }, -- Enveloping Winds
    [GetSpellInfo(21729)] = { 5000, 21729 }, -- Planting Slidore's Beacon
    [GetSpellInfo(22928)] = { 60000, 22928 }, -- Shifting Cloak
    [GetSpellInfo(3956)] = { 12500, 3956 }, -- Green Tinted Goggles
    [GetSpellInfo(19082)] = { 60000, 19082 }, -- Runic Leather Headband
    [GetSpellInfo(16396)] = { 1500, 16396 }, -- Flame Breath
    [GetSpellInfo(23664)] = { 60000, 23664 }, -- Argent Boots
    [GetSpellInfo(14932)] = { 25000, 14932 }, -- Thick Leather Ammo Pouch
    [GetSpellInfo(17634)] = { 25000, 17634 }, -- Flask of Petrification
    [GetSpellInfo(7755)] = { 3000, 7755 }, -- Bristle Whisker Catfish
    [GetSpellInfo(11729)] = { 3000, 11729 }, -- Create Healthstone (Greater)
    [GetSpellInfo(6297)] = { 3000, 6297 }, -- Fiery Blaze
    [GetSpellInfo(6690)] = { 12500, 6690 }, -- Lesser Wizard's Robe
    [GetSpellInfo(8386)] = { 5000, 8386 }, -- Attacking
    [GetSpellInfo(2406)] = { 8000, 2406 }, -- Gray Woolen Shirt
    [GetSpellInfo(2395)] = { 12500, 2395 }, -- Barbaric Linen Vest
    [GetSpellInfo(22840)] = { 4000, 22840 }, -- Arcanum of Rapidity
    [GetSpellInfo(23442)] = { 10000, 23442 }, -- Everlook Transporter
    [GetSpellInfo(8376)] = { 500, 8376 }, -- Earthgrab Totem
    [GetSpellInfo(5967)] = { 5000, 5967 }, -- Pickpocket (PT)
    [GetSpellInfo(23054)] = { 3000, 23054 }, -- Igniting Kroshius
    [GetSpellInfo(6619)] = { 3000, 6619 }, -- Cowardly Flight Potion
    [GetSpellInfo(3397)] = { 3000, 3397 }, -- Big Bear Steak
    [GetSpellInfo(17293)] = { 1000, 17293 }, -- Burning Winds
    [GetSpellInfo(28210)] = { 60000, 28210 }, -- Gaea's Embrace
    [GetSpellInfo(27659)] = { 60000, 27659 }, -- Enchanted Runecloth Bag
    [GetSpellInfo(19078)] = { 60000, 19078 }, -- Living Leggings
    [GetSpellInfo(7162)] = { 3000, 7162 }, -- First Aid
    [GetSpellInfo(19796)] = { 45000, 19796 }, -- Dark Iron Rifle
    [GetSpellInfo(17575)] = { 3000, 17575 }, -- Greater Frost Protection Potion
    [GetSpellInfo(19060)] = { 60000, 19060 }, -- Green Dragonscale Leggings
    [GetSpellInfo(19797)] = { 1000, 19797 }, -- Conjure Torch of Retribution
    [GetSpellInfo(24195)] = { 2000, 24195 }, -- Grom's Tribute
    [GetSpellInfo(7739)] = { 3000, 7739 }, -- Inferno Shell
    [GetSpellInfo(12735)] = { 5000, 12735 }, -- Fill the Egg of Hakkar
    [GetSpellInfo(12280)] = { 1000, 12280 }, -- Acid of Hakkar
    [GetSpellInfo(24850)] = { 60000, 24850 }, -- Sandstalker Gauntlets
    [GetSpellInfo(18439)] = { 60000, 18439 }, -- Brightcloth Pants
    [GetSpellInfo(6777)] = { 3000, 6777 }, -- Gray Ram
    [GetSpellInfo(6704)] = { 45000, 6704 }, -- Thick Murloc Armor
    [GetSpellInfo(9879)] = { 7000, 9879 }, -- Self Destruct
    [GetSpellInfo(9082)] = { 500, 9082 }, -- Create Containment Coffer
    [GetSpellInfo(3755)] = { 8000, 3755 }, -- Linen Bag
    [GetSpellInfo(23399)] = { 25000, 23399 }, -- Barbaric Bracers
    [GetSpellInfo(4942)] = { 5000, 4942 }, -- Lesser Stoneshield Potion
    [GetSpellInfo(26418)] = { 5125, 26418 }, -- Small Red Rocket
    [GetSpellInfo(24245)] = { 2000, 24245 }, -- String Together Heads
    [GetSpellInfo(10688)] = { 1000, 10688 }, -- Summon Cockroach
    [GetSpellInfo(4539)] = { 2000, 4539 }, -- Strength of the Ages
    [GetSpellInfo(4974)] = { 2000, 4974 }, -- Wither Touch
    [GetSpellInfo(12253)] = { 1000, 12253 }, -- Dowse Eternal Flame
    [GetSpellInfo(3931)] = { 5125, 3931 }, -- Coarse Dynamite
    [GetSpellInfo(6950)] = { 2000, 6950 }, -- Faerie Fire
    [GetSpellInfo(11836)] = { 2500, 11836 }, -- Freeze Solid
    [GetSpellInfo(16969)] = { 60000, 16969 }, -- Ornate Thorium Handaxe
    [GetSpellInfo(4131)] = { 1000, 4131 }, -- Banish Cresting Exile
    [GetSpellInfo(19669)] = { 8000, 19669 }, -- Arcanite Skeleton Key
    [GetSpellInfo(9062)] = { 5125, 9062 }, -- Small Leather Ammo Pouch
    [GetSpellInfo(4064)] = { 1000, 4064 }, -- Rough Copper Bomb
    [GetSpellInfo(22722)] = { 3000, 22722 }, -- Red Skeletal Warhorse
    [GetSpellInfo(14293)] = { 10000, 14293 }, -- Lesser Magic Wand
    [GetSpellInfo(12065)] = { 60000, 12065 }, -- Mageweave Bag
    [GetSpellInfo(20604)] = { 2000, 20604 }, -- Dominate Mind
    [GetSpellInfo(18409)] = { 60000, 18409 }, -- Runecloth Cloak
    [GetSpellInfo(22866)] = { 60000, 22866 }, -- Belt of the Archmage
    [GetSpellInfo(24125)] = { 60000, 24125 }, -- Blood Tiger Shoulders
    [GetSpellInfo(6202)] = { 3000, 6202 }, -- Create Healthstone (Lesser)
    [GetSpellInfo(16497)] = { 2000, 16497 }, -- Stun Bomb
    [GetSpellInfo(15783)] = { 2000, 15783 }, -- Blizzard
    [GetSpellInfo(20762)] = { 3000, 20762 }, -- Soulstone Resurrection
    [GetSpellInfo(8758)] = { 25000, 8758 }, -- Azure Silk Pants
    [GetSpellInfo(22596)] = { 5000, 22596 }, -- Shadow Mantle of the Dawn
    [GetSpellInfo(690)] = { 3000, 690 }, -- Firebolt II
    [GetSpellInfo(19107)] = { 60000, 19107 }, -- Black Dragonscale Leggings
    [GetSpellInfo(17953)] = { 3000, 17953 }, -- Create Firestone (Major)
    [GetSpellInfo(18445)] = { 60000, 18445 }, -- Mooncloth Bag
    [GetSpellInfo(3278)] = { 3000, 3278 }, -- Heavy Wool Bandage
    [GetSpellInfo(10788)] = { 3000, 10788 }, -- Leopard
    [GetSpellInfo(6296)] = { 3000, 6296 }, -- Enchant: Fiery Blaze
    [GetSpellInfo(3501)] = { 25000, 3501 }, -- Green Iron Bracers
    [GetSpellInfo(579)] = { 3000, 579 }, -- Red Wolf
    [GetSpellInfo(447)] = { 2000, 447 }, -- Teleport Treant
    [GetSpellInfo(12595)] = { 45000, 12595 }, -- Mithril Blunderbuss
    [GetSpellInfo(2544)] = { 3000, 2544 }, -- Crab Cake
    [GetSpellInfo(10682)] = { 1000, 10682 }, -- Summon Hyacinth Macaw
    [GetSpellInfo(22563)] = { 10000, 22563 }, -- Recall
    [GetSpellInfo(19088)] = { 60000, 19088 }, -- Heavy Scorpid Helm
    [GetSpellInfo(3502)] = { 25000, 3502 }, -- Green Iron Helm
    [GetSpellInfo(17162)] = { 2000, 17162 }, -- Summon Water Elemental
    [GetSpellInfo(16587)] = { 3000, 16587 }, -- Dark Whispers
    [GetSpellInfo(23223)] = { 3000, 23223 }, -- Swift White Mechanostrider
    [GetSpellInfo(11082)] = { 2000, 11082 }, -- Megavolt
    [GetSpellInfo(17571)] = { 3000, 17571 }, -- Elixir of the Mongoose
    [GetSpellInfo(18960)] = { 10000, 18960 }, -- Teleport: Moonglade
    [GetSpellInfo(23429)] = { 1000, 23429 }, -- Summon Loggerhead Snapjaw
    [GetSpellInfo(7398)] = { 2000, 7398 }, -- Birth
    [GetSpellInfo(19833)] = { 60000, 19833 }, -- Flawless Arcanite Rifle
    [GetSpellInfo(14809)] = { 10000, 14809 }, -- Lesser Mystic Wand
    [GetSpellInfo(26086)] = { 60000, 26086 }, -- Felcloth Bag
    [GetSpellInfo(19083)] = { 60000, 19083 }, -- Wicked Leather Pants
    [GetSpellInfo(2742)] = { 12500, 2742 }, -- Bronze Shortsword
    [GetSpellInfo(28311)] = { 2500, 28311 }, -- Slime Bolt
    [GetSpellInfo(21027)] = { 2000, 21027 }, -- Spark
    [GetSpellInfo(8791)] = { 25000, 8791 }, -- Crimson Silk Vest
    [GetSpellInfo(5140)] = { 2000, 5140 }, -- Detonate
    [GetSpellInfo(20649)] = { 8000, 20649 }, -- Heavy Leather
    [GetSpellInfo(8856)] = { 1500, 8856 }, -- Bending Shinbone
    [GetSpellInfo(2541)] = { 3000, 2541 }, -- Coyote Steak
    [GetSpellInfo(6717)] = { 2500, 6717 }, -- Place Lion Carcass
    [GetSpellInfo(3295)] = { 25000, 3295 }, -- Deadly Bronze Poniard
    [GetSpellInfo(7132)] = { 1000, 7132 }, -- Summon Lupine Delusions
    [GetSpellInfo(15853)] = { 3000, 15853 }, -- Lean Wolf Steak
    [GetSpellInfo(9149)] = { 25000, 9149 }, -- Heavy Earthen Gloves
    [GetSpellInfo(10518)] = { 60000, 10518 }, -- Turtle Scale Bracers
    [GetSpellInfo(16796)] = { 2500, 16796 }, -- Summon Shy-Rotam
    [GetSpellInfo(9273)] = { 12500, 9273 }, -- Goblin Jumper Cables
    [GetSpellInfo(12083)] = { 60000, 12083 }, -- Stormcloth Headband
    [GetSpellInfo(24849)] = { 60000, 24849 }, -- Sandstalker Bracers
    [GetSpellInfo(15779)] = { 3000, 15779 }, -- White Mechanostrider
    [GetSpellInfo(23227)] = { 3000, 23227 }, -- Swift Palomino
    [GetSpellInfo(4960)] = { 3000, 4960 }, -- Create Fervor Potion (New)
    [GetSpellInfo(15750)] = { 500, 15750 }, -- Rookery Whelp Spawn-in Spell
    [GetSpellInfo(3503)] = { 45000, 3503 }, -- Golden Scale Coif
    [GetSpellInfo(3013)] = { 3000, 3013 }, -- Volley II
    [GetSpellInfo(7078)] = { 2000, 7078 }, -- Simple Teleport Group
    [GetSpellInfo(7896)] = { 1000, 7896 }, -- Exploding Shot
    [GetSpellInfo(19667)] = { 8000, 19667 }, -- Golden Skeleton Key
    [GetSpellInfo(3866)] = { 12500, 3866 }, -- Stylish Red Shirt
    [GetSpellInfo(24902)] = { 60000, 24902 }, -- Runed Stygian Belt
    [GetSpellInfo(10700)] = { 1000, 10700 }, -- Summon Faeling
    [GetSpellInfo(7383)] = { 1000, 7383 }, -- Water Bubble
    [GetSpellInfo(25262)] = { 2500, 25262 }, -- Abomination Spit
    [GetSpellInfo(26407)] = { 45000, 26407 }, -- Festive Red Pant Suit
    [GetSpellInfo(30174)] = { 3000, 30174 }, -- Riding Turtle
    [GetSpellInfo(16598)] = { 1000, 16598 }, -- Will of Shahram
    [GetSpellInfo(6422)] = { 2000, 6422 }, -- Ashcrombe's Teleport
    [GetSpellInfo(6501)] = { 3000, 6501 }, -- Clam Chowder
    [GetSpellInfo(17564)] = { 25000, 17564 }, -- Transmute: Water to Undeath
    [GetSpellInfo(16993)] = { 60000, 16993 }, -- Masterwork Stormhammer
    [GetSpellInfo(9147)] = { 25000, 9147 }, -- Earthen Leather Shoulders
    [GetSpellInfo(2158)] = { 8000, 2158 }, -- Fine Leather Boots
    [GetSpellInfo(9616)] = { 3000, 9616 }, -- Wild Regeneration
    [GetSpellInfo(4520)] = { 4000, 4520 }, -- Wide Sweep
    [GetSpellInfo(27290)] = { 1000, 27290 }, -- Increase Reputation
    [GetSpellInfo(9966)] = { 60000, 9966 }, -- Mithril Scale Shoulders
    [GetSpellInfo(11460)] = { 3000, 11460 }, -- Elixir of Detect Undead
    [GetSpellInfo(1698)] = { 2000, 1698 }, -- Shockwave
    [GetSpellInfo(16081)] = { 3000, 16081 }, -- Arctic Wolf
    [GetSpellInfo(13484)] = { 5000, 13484 }, -- Plant Gor'tesh Head
    [GetSpellInfo(16059)] = { 3000, 16059 }, -- Tawny Sabercat
    [GetSpellInfo(15664)] = { 2500, 15664 }, -- Venom Spit
    [GetSpellInfo(16594)] = { 2000, 16594 }, -- Crypt Scarabs
    [GetSpellInfo(10511)] = { 60000, 10511 }, -- Turtle Scale Breastplate
    [GetSpellInfo(10258)] = { 5000, 10258 }, -- Awaken Vault Warder
    [GetSpellInfo(581)] = { 3000, 581 }, -- Winter Wolf
    [GetSpellInfo(16745)] = { 60000, 16745 }, -- Enchanted Thorium Breastplate
    [GetSpellInfo(25688)] = { 3000, 25688 }, -- Narain!
    [GetSpellInfo(7960)] = { 1000, 7960 }, -- Scry on Azrethoc
    [GetSpellInfo(3818)] = { 12500, 3818 }, -- Cured Heavy Hide
    [GetSpellInfo(7101)] = { 7000, 7101 }, -- Flame Blast
    [GetSpellInfo(22597)] = { 5000, 22597 }, -- Nature Mantle of the Dawn
    [GetSpellInfo(10799)] = { 3000, 10799 }, -- Violet Raptor
    [GetSpellInfo(27724)] = { 60000, 27724 }, -- Cenarion Herb Bag
    [GetSpellInfo(7430)] = { 8000, 7430 }, -- Arclight Spanner
    [GetSpellInfo(10676)] = { 1000, 10676 }, -- Summon Orange Tabby
    [GetSpellInfo(22999)] = { 4000, 22999 }, -- Defibrillate
    [GetSpellInfo(3868)] = { 25000, 3868 }, -- Phoenix Gloves
    [GetSpellInfo(21048)] = { 2000, 21048 }, -- Curse of the Tribes
    [GetSpellInfo(16599)] = { 1000, 16599 }, -- Blessing of Shahram
    [GetSpellInfo(1050)] = { 1000, 1050 }, -- Sacrifice
    [GetSpellInfo(10520)] = { 60000, 10520 }, -- Big Voodoo Robe
    [GetSpellInfo(8137)] = { 2000, 8137 }, -- Silithid Pox
    [GetSpellInfo(16051)] = { 2000, 16051 }, -- Barrier of Light
    [GetSpellInfo(23313)] = { 2000, 23313 }, -- Corrosive Acid
    [GetSpellInfo(16570)] = { 7000, 16570 }, -- Charged Arcane Bolt
    [GetSpellInfo(23124)] = { 1000, 23124 }, -- Human Orphan Whistle
    [GetSpellInfo(25146)] = { 25000, 25146 }, -- Transmute: Elemental Fire
    [GetSpellInfo(12075)] = { 45000, 12075 }, -- Lavender Mageweave Shirt
    [GetSpellInfo(18437)] = { 60000, 18437 }, -- Felcloth Boots
    [GetSpellInfo(22779)] = { 3000, 22779 }, -- Biznicks 247x128 Accurascope
    [GetSpellInfo(10650)] = { 60000, 10650 }, -- Dragonscale Breastplate
    [GetSpellInfo(19564)] = { 3000, 19564 }, -- Draw Water Sample
    [GetSpellInfo(15591)] = { 2500, 15591 }, -- Revive Ringo
    [GetSpellInfo(12684)] = { 2000, 12684 }, -- Kadrak's Flag
    [GetSpellInfo(18416)] = { 60000, 18416 }, -- Ghostweave Vest
    [GetSpellInfo(1450)] = { 1000, 1450 }, -- Arcane Spirit II
    [GetSpellInfo(12904)] = { 25000, 12904 }, -- Gnomish Ham Radio
    [GetSpellInfo(17117)] = { 1300, 17117 }, -- Magatha Incendia Powder
    [GetSpellInfo(9811)] = { 45000, 9811 }, -- Barbaric Iron Shoulders
    [GetSpellInfo(13258)] = { 250, 13258 }, -- Summon Goblin Bomb
    [GetSpellInfo(23041)] = { 1000, 23041 }, -- Call Anathema
    [GetSpellInfo(17501)] = { 1000, 17501 }, -- Cannon Fire
    [GetSpellInfo(27722)] = { 1000, 27722 }, -- Sweet Surprise
    [GetSpellInfo(26422)] = { 5125, 26422 }, -- Large Red Rocket
    [GetSpellInfo(23228)] = { 3000, 23228 }, -- Swift White Steed
    [GetSpellInfo(17459)] = { 3000, 17459 }, -- Icy Blue Mechanostrider
    [GetSpellInfo(24161)] = { 4000, 24161 }, -- Death's Embrace
    [GetSpellInfo(19090)] = { 60000, 19090 }, -- Stormshroud Shoulders
    [GetSpellInfo(28244)] = { 60000, 28244 }, -- Icebane Bracers
    [GetSpellInfo(10695)] = { 1000, 10695 }, -- Summon Dark Whelpling
    [GetSpellInfo(25704)] = { 3000, 25704 }, -- Smoked Sagefish
    [GetSpellInfo(12072)] = { 60000, 12072 }, -- Black Mageweave Headband
    [GetSpellInfo(24092)] = { 60000, 24092 }, -- Bloodvine Leggings
    [GetSpellInfo(10677)] = { 1000, 10677 }, -- Summon Siamese
    [GetSpellInfo(28133)] = { 2500, 28133 }, -- Cure Disease
    [GetSpellInfo(19799)] = { 8000, 19799 }, -- Dark Iron Bomb
    [GetSpellInfo(23248)] = { 3000, 23248 }, -- Great Gray Kodo
    [GetSpellInfo(9552)] = { 2000, 9552 }, -- Searing Flames
    [GetSpellInfo(12055)] = { 60000, 12055 }, -- Shadoweave Robe
    [GetSpellInfo(7054)] = { 2500, 7054 }, -- Forsaken Skills
    [GetSpellInfo(23430)] = { 1000, 23430 }, -- Summon Olive Snapjaw
    [GetSpellInfo(11757)] = { 1500, 11757 }, -- Digging for Cobalt
    [GetSpellInfo(8782)] = { 25000, 8782 }, -- Truefaith Gloves
    [GetSpellInfo(16057)] = { 500, 16057 }, -- Place Unforged Seal
    [GetSpellInfo(2330)] = { 3000, 2330 }, -- Minor Healing Potion
    [GetSpellInfo(11456)] = { 3000, 11456 }, -- Goblin Rocket Fuel
    [GetSpellInfo(556)] = { 10000, 556 }, -- Astral Recall
    [GetSpellInfo(19793)] = { 8000, 19793 }, -- Lifelike Mechanical Toad
    [GetSpellInfo(16991)] = { 60000, 16991 }, -- Annihilator
    [GetSpellInfo(2817)] = { 1000, 2817 }, -- Teach Bark of Doom
    [GetSpellInfo(9888)] = { 3500, 9888 }, -- Healing Touch
    [GetSpellInfo(12590)] = { 8000, 12590 }, -- Gyromatic Micro-Adjustor
    [GetSpellInfo(10876)] = { 3000, 10876 }, -- Mana Burn
    [GetSpellInfo(16071)] = { 2000, 16071 }, -- Curse of the Firebrand
    [GetSpellInfo(10947)] = { 1500, 10947 }, -- Mind Blast
    [GetSpellInfo(11365)] = { 10000, 11365 }, -- Bly's Band's Escape
    [GetSpellInfo(28785)] = { 3000, 28785 }, -- Locust Swarm
    [GetSpellInfo(21912)] = { 2000, 21912 }, -- Dummy Nuke
    [GetSpellInfo(23663)] = { 60000, 23663 }, -- Mantle of the Timbermaw
    [GetSpellInfo(16801)] = { 1000, 16801 }, -- Warosh's Transform
    [GetSpellInfo(9612)] = { 1000, 9612 }, -- Ink Spray
    [GetSpellInfo(23233)] = { 5000, 23233 }, -- Binding Volume III
    [GetSpellInfo(2663)] = { 5125, 2663 }, -- Copper Bracers
    [GetSpellInfo(3507)] = { 45000, 3507 }, -- Golden Scale Leggings
    [GetSpellInfo(7901)] = { 2000, 7901 }, -- Decayed Agility
    [GetSpellInfo(16645)] = { 60000, 16645 }, -- Radiant Belt
    [GetSpellInfo(8784)] = { 45000, 8784 }, -- Green Silk Armor
    [GetSpellInfo(28089)] = { 3000, 28089 }, -- Polarity Shift
    [GetSpellInfo(24914)] = { 60000, 24914 }, -- Darkrune Breastplate
    [GetSpellInfo(19104)] = { 60000, 19104 }, -- Frostsaber Tunic
    [GetSpellInfo(12050)] = { 60000, 12050 }, -- Black Mageweave Robe
    [GetSpellInfo(28995)] = { 6000, 28995 }, -- Stoneskin
    [GetSpellInfo(18149)] = { 2000, 18149 }, -- Volatile Infection
    [GetSpellInfo(20853)] = { 60000, 20853 }, -- Corehound Boots
    [GetSpellInfo(18413)] = { 60000, 18413 }, -- Ghostweave Gloves
    [GetSpellInfo(6306)] = { 1000, 6306 }, -- Acid Splash
    [GetSpellInfo(10003)] = { 60000, 10003 }, -- The Shatterer
    [GetSpellInfo(1536)] = { 4000, 1536 }, -- Longshot II
    [GetSpellInfo(11763)] = { 2000, 11763 }, -- Firebolt
    [GetSpellInfo(18407)] = { 60000, 18407 }, -- Runecloth Tunic
    [GetSpellInfo(6249)] = { 5000, 6249 }, -- Opening
    [GetSpellInfo(3566)] = { 10000, 3566 }, -- Teleport: Thunder Bluff
    [GetSpellInfo(9481)] = { 2500, 9481 }, -- Holy Smite
    [GetSpellInfo(23068)] = { 5125, 23068 }, -- Green Firework
    [GetSpellInfo(3945)] = { 5125, 3945 }, -- Heavy Blasting Powder
    [GetSpellInfo(6417)] = { 3000, 6417 }, -- Dig Rat Stew
    [GetSpellInfo(22421)] = { 1500, 22421 }, -- Massive Geyser
    [GetSpellInfo(19061)] = { 60000, 19061 }, -- Living Shoulders
    [GetSpellInfo(28280)] = { 1000, 28280 }, -- Bombard Slime
    [GetSpellInfo(12082)] = { 60000, 12082 }, -- Shadoweave Boots
    [GetSpellInfo(16073)] = { 3000, 16073 }, -- Filling
    [GetSpellInfo(18540)] = { 10000, 18540 }, -- Ritual of Doom
    [GetSpellInfo(29335)] = { 1000, 29335 }, -- Elderberry Pie
    [GetSpellInfo(16072)] = { 5000, 16072 }, -- Purify and Place Food
    [GetSpellInfo(10348)] = { 7000, 10348 }, -- Tune Up
    [GetSpellInfo(2161)] = { 8000, 2161 }, -- Embossed Leather Boots
    [GetSpellInfo(3116)] = { 5125, 3116 }, -- Coarse Weightstone
    [GetSpellInfo(7752)] = { 3000, 7752 }, -- Slitherskin Mackerel
    [GetSpellInfo(22478)] = { 1000, 22478 }, -- Intense Pain
    [GetSpellInfo(5208)] = { 2000, 5208 }, -- Poisoned Harpoon
    [GetSpellInfo(6705)] = { 45000, 6705 }, -- Murloc Scale Bracers
    [GetSpellInfo(15400)] = { 4000, 15400 }, -- Lesser Arcane Amalgamation
    [GetSpellInfo(16007)] = { 2000, 16007 }, -- Draco-Incarcinatrix 900
    [GetSpellInfo(4286)] = { 2000, 4286 }, -- Poisonous Spit
    [GetSpellInfo(2543)] = { 3000, 2543 }, -- Westfall Stew
    [GetSpellInfo(12722)] = { 25000, 12722 }, -- Goblin Radio
    [GetSpellInfo(3495)] = { 45000, 3495 }, -- Golden Iron Destroyer
    [GetSpellInfo(13240)] = { 25000, 13240 }, -- The Mortar: Reloaded
    [GetSpellInfo(18630)] = { 3000, 18630 }, -- Heavy Runecloth Bandage
    [GetSpellInfo(21728)] = { 5000, 21728 }, -- Planting Ichman's Beacon
    [GetSpellInfo(21332)] = { 1000, 21332 }, -- Aspect of Neptulon
    [GetSpellInfo(3780)] = { 5125, 3780 }, -- Heavy Armor Kit
    [GetSpellInfo(10632)] = { 60000, 10632 }, -- Helm of Fire
    [GetSpellInfo(3497)] = { 45000, 3497 }, -- Frost Tiger Blade
    [GetSpellInfo(3971)] = { 45000, 3971 }, -- Gnomish Cloaking Device
    [GetSpellInfo(10714)] = { 1000, 10714 }, -- Summon Black Kingsnake
    [GetSpellInfo(2668)] = { 12500, 2668 }, -- Rough Bronze Leggings
    [GetSpellInfo(12045)] = { 5125, 12045 }, -- Simple Linen Boots
    [GetSpellInfo(4978)] = { 10000, 4978 }, -- Cleanse Wildmane Well
    [GetSpellInfo(19051)] = { 60000, 19051 }, -- Heavy Scorpid Vest
    [GetSpellInfo(3494)] = { 45000, 3494 }, -- Solid Iron Maul
    [GetSpellInfo(12067)] = { 60000, 12067 }, -- Dreamweave Gloves
    [GetSpellInfo(4164)] = { 3000, 4164 }, -- Throw Rock
    [GetSpellInfo(8088)] = { 5000, 8088 }, -- Nightcrawlers
    [GetSpellInfo(11452)] = { 3000, 11452 }, -- Restorative Potion
    [GetSpellInfo(17454)] = { 3000, 17454 }, -- Unpainted Mechanostrider
    [GetSpellInfo(16082)] = { 3000, 16082 }, -- Palomino Stallion
    [GetSpellInfo(11339)] = { 3000, 11339 }, -- Instant Poison V
    [GetSpellInfo(16379)] = { 2000, 16379 }, -- Ozzie Explodes
    [GetSpellInfo(12591)] = { 8000, 12591 }, -- Unstable Trigger
    [GetSpellInfo(3452)] = { 5000, 3452 }, -- Mana Potion
    [GetSpellInfo(12078)] = { 60000, 12078 }, -- Red Mageweave Shoulders
    [GetSpellInfo(28221)] = { 60000, 28221 }, -- Polar Bracers
    [GetSpellInfo(17639)] = { 2000, 17639 }, -- Wail of the Banshee
    [GetSpellInfo(10704)] = { 1000, 10704 }, -- Summon Tree Frog
    [GetSpellInfo(12740)] = { 2000, 12740 }, -- Summon Infernal Servant
    [GetSpellInfo(20629)] = { 2500, 20629 }, -- Corrosive Venom Spit
    [GetSpellInfo(7255)] = { 3000, 7255 }, -- Holy Protection Potion
    [GetSpellInfo(3652)] = { 4000, 3652 }, -- Summon Spirit of Old
    [GetSpellInfo(5017)] = { 5000, 5017 }, -- Divining Trance
    [GetSpellInfo(27723)] = { 1000, 27723 }, -- Dark Desire
    [GetSpellInfo(2830)] = { 3000, 2830 }, -- Sharpen Blade III
    [GetSpellInfo(22789)] = { 1000, 22789 }, -- Gordok Green Grog
    [GetSpellInfo(3015)] = { 3000, 3015 }, -- Bombard II
    [GetSpellInfo(7934)] = { 3000, 7934 }, -- Anti-Venom
    [GetSpellInfo(10955)] = { 1500, 10955 }, -- Shackle Undead
    [GetSpellInfo(22989)] = { 1000, 22989 }, -- The Breaking
    [GetSpellInfo(10716)] = { 1000, 10716 }, -- Summon Brown Snake
    [GetSpellInfo(10712)] = { 1000, 10712 }, -- Summon Spotted Rabbit
    [GetSpellInfo(21979)] = { 1500, 21979 }, -- Create The Pariah's Instructions
    [GetSpellInfo(18762)] = { 5000, 18762 }, -- Hand of Iruxos
    [GetSpellInfo(22844)] = { 4000, 22844 }, -- Arcanum of Focus
    [GetSpellInfo(11016)] = { 2000, 11016 }, -- Soul Bite
    [GetSpellInfo(14292)] = { 1000, 14292 }, -- Fling Torch
    [GetSpellInfo(2545)] = { 3000, 2545 }, -- Cooked Crab Claw
    [GetSpellInfo(20849)] = { 60000, 20849 }, -- Flarecore Gloves
    [GetSpellInfo(11454)] = { 3000, 11454 }, -- Inlaid Mithril Cylinder
    [GetSpellInfo(3376)] = { 3000, 3376 }, -- Curiously Tasty Omelet
    [GetSpellInfo(3229)] = { 2000, 3229 }, -- Quick Bloodlust
    [GetSpellInfo(3769)] = { 25000, 3769 }, -- Dark Leather Shoulders
    [GetSpellInfo(3368)] = { 3000, 3368 }, -- Drink Minor Potion
    [GetSpellInfo(18989)] = { 3000, 18989 }, -- Gray Kodo
    [GetSpellInfo(27624)] = { 1500, 27624 }, -- Lesser Healing Wave
    [GetSpellInfo(3772)] = { 45000, 3772 }, -- Green Leather Armor
    [GetSpellInfo(3007)] = { 4000, 3007 }, -- Longshot III
    [GetSpellInfo(3120)] = { 3000, 3120 }, -- Sol L
    [GetSpellInfo(3237)] = { 2000, 3237 }, -- Curse of Thule
    [GetSpellInfo(23225)] = { 3000, 23225 }, -- Swift Green Mechanostrider
    [GetSpellInfo(28242)] = { 60000, 28242 }, -- Icebane Breastplate
    [GetSpellInfo(17229)] = { 3000, 17229 }, -- Winterspring Frostsaber
    [GetSpellInfo(10254)] = { 1500, 10254 }, -- Stone Dwarf Awaken Visual
    [GetSpellInfo(3974)] = { 3000, 3974 }, -- Crude Scope
    [GetSpellInfo(9968)] = { 60000, 9968 }, -- Heavy Mithril Boots
    [GetSpellInfo(8760)] = { 12500, 8760 }, -- Azure Silk Hood
    [GetSpellInfo(11355)] = { 3000, 11355 }, -- Deadly Poison III
    [GetSpellInfo(3108)] = { 3000, 3108 }, -- Touch of Death
    [GetSpellInfo(10710)] = { 1000, 10710 }, -- Summon Cottontail Rabbit
    [GetSpellInfo(22686)] = { 1500, 22686 }, -- Bellowing Roar
    [GetSpellInfo(23765)] = { 1000, 23765 }, -- Darkmoon Faire Fortune
    [GetSpellInfo(13463)] = { 2000, 13463 }, -- Summon Bloodpetal Mini Pests
    [GetSpellInfo(27642)] = { 1000, 27642 }, -- Copy of Increase Reputation
    [GetSpellInfo(5174)] = { 2000, 5174 }, -- Cookie's Cooking
    [GetSpellInfo(12071)] = { 60000, 12071 }, -- Shadoweave Gloves
    [GetSpellInfo(10550)] = { 60000, 10550 }, -- Nightscape Cloak
    [GetSpellInfo(6499)] = { 3000, 6499 }, -- Boiled Clams
    [GetSpellInfo(4961)] = { 2000, 4961 }, -- Resupply
    [GetSpellInfo(6907)] = { 2000, 6907 }, -- Diseased Slime
    [GetSpellInfo(23250)] = { 3000, 23250 }, -- Swift Brown Wolf
    [GetSpellInfo(17161)] = { 3000, 17161 }, -- Taking Moon Well Sample
    [GetSpellInfo(6974)] = { 3000, 6974 }, -- Gnome Camera Connection
    [GetSpellInfo(9202)] = { 45000, 9202 }, -- Green Whelp Bracers
    [GetSpellInfo(7920)] = { 3000, 7920 }, -- Mebok Smart Drink
    [GetSpellInfo(11402)] = { 4500, 11402 }, -- Shay's Bell
    [GetSpellInfo(15745)] = { 2000, 15745 }, -- Summon Rookery Whelp
    [GetSpellInfo(7762)] = { 2000, 7762 }, -- Summon Gunther's Visage
    [GetSpellInfo(3373)] = { 3000, 3373 }, -- Crocolisk Gumbo
    [GetSpellInfo(22869)] = { 60000, 22869 }, -- Mooncloth Gloves
    [GetSpellInfo(22867)] = { 60000, 22867 }, -- Felcloth Gloves
    [GetSpellInfo(24696)] = { 1000, 24696 }, -- Summon Murky
    [GetSpellInfo(22921)] = { 60000, 22921 }, -- Girdle of Insight
    [GetSpellInfo(8363)] = { 2000, 8363 }, -- Parasite
    [GetSpellInfo(16973)] = { 60000, 16973 }, -- Enchanted Battlehammer
    [GetSpellInfo(16657)] = { 60000, 16657 }, -- Imperial Plate Boots
    [GetSpellInfo(21267)] = { 10000, 21267 }, -- Conjure Altar of Summoning
    [GetSpellInfo(23304)] = { 1000, 23304 }, -- Manna-Enriched Horse Feed
    [GetSpellInfo(4055)] = { 1000, 4055 }, -- Mechanical Squirrel
    [GetSpellInfo(17928)] = { 2000, 17928 }, -- Howl of Terror
    [GetSpellInfo(12655)] = { 2000, 12655 }, -- Enlightenment
    [GetSpellInfo(3869)] = { 12500, 3869 }, -- Bright Yellow Shirt
    [GetSpellInfo(24422)] = { 5000, 24422 }, -- Zandalar Signet of Might
    [GetSpellInfo(10792)] = { 3000, 10792 }, -- Spotted Panther
    [GetSpellInfo(19100)] = { 60000, 19100 }, -- Heavy Scorpid Shoulders
    [GetSpellInfo(19571)] = { 10000, 19571 }, -- Destroy Ghost Magnet
    [GetSpellInfo(23633)] = { 60000, 23633 }, -- Gloves of the Dawn
    [GetSpellInfo(22759)] = { 60000, 22759 }, -- Flarecore Wraps
    [GetSpellInfo(11465)] = { 3000, 11465 }, -- Elixir of Greater Intellect
    [GetSpellInfo(5219)] = { 2000, 5219 }, -- Draw of Thistlenettle
    [GetSpellInfo(11024)] = { 1500, 11024 }, -- Call of Thund
    [GetSpellInfo(22868)] = { 60000, 22868 }, -- Inferno Gloves
    [GetSpellInfo(9198)] = { 45000, 9198 }, -- Frost Leather Cloak
    [GetSpellInfo(15856)] = { 3000, 15856 }, -- Hot Wolf Ribs
    [GetSpellInfo(5401)] = { 2000, 5401 }, -- Lizard Bolt
    [GetSpellInfo(19877)] = { 3000, 19877 }, -- Tranquilizing Shot
    [GetSpellInfo(21249)] = { 10000, 21249 }, -- Call of the Nether
    [GetSpellInfo(3331)] = { 25000, 3331 }, -- Silvered Bronze Boots
    [GetSpellInfo(16055)] = { 3000, 16055 }, -- Nightsaber
    [GetSpellInfo(12902)] = { 25000, 12902 }, -- Gnomish Net-o-Matic Projector
    [GetSpellInfo(1084)] = { 3000, 1084 }, -- Firebolt III
    [GetSpellInfo(12760)] = { 25000, 12760 }, -- Goblin Sapper Charge
    [GetSpellInfo(3188)] = { 3000, 3188 }, -- Elixir of Ogre's Strength
    [GetSpellInfo(3177)] = { 3000, 3177 }, -- Elixir of Defense
    [GetSpellInfo(15295)] = { 45000, 15295 }, -- Dark Iron Shoulders
    [GetSpellInfo(15863)] = { 3000, 15863 }, -- Carrion Surprise
    [GetSpellInfo(16056)] = { 3000, 16056 }, -- Frostsaber
    [GetSpellInfo(7224)] = { 25000, 7224 }, -- Steel Weapon Chain
    [GetSpellInfo(711)] = { 3000, 711 }, -- Hellfire
    [GetSpellInfo(26218)] = { 1000, 26218 }, -- Mistletoe
    [GetSpellInfo(14929)] = { 1000, 14929 }, -- Fill Nagmara's Vial
    [GetSpellInfo(3112)] = { 3000, 3112 }, -- Enhance Blunt Weapon
    [GetSpellInfo(3328)] = { 12500, 3328 }, -- Rough Bronze Shoulders
    [GetSpellInfo(16197)] = { 4000, 16197 }, -- Empty Charm Pouch
    [GetSpellInfo(8362)] = { 2000, 8362 }, -- Renew
    [GetSpellInfo(24138)] = { 60000, 24138 }, -- Bloodsoul Gauntlets
    [GetSpellInfo(21848)] = { 1500, 21848 }, -- Snowman
    [GetSpellInfo(10059)] = { 10000, 10059 }, -- Portal: Stormwind
    [GetSpellInfo(23239)] = { 3000, 23239 }, -- Swift Gray Ram
    [GetSpellInfo(16746)] = { 60000, 16746 }, -- Invulnerable Mail
    [GetSpellInfo(15441)] = { 4000, 15441 }, -- Greater Arcane Amalgamation
    [GetSpellInfo(17176)] = { 5000, 17176 }, -- Panther Cage Key
    [GetSpellInfo(3816)] = { 5125, 3816 }, -- Cured Light Hide
    [GetSpellInfo(471)] = { 3000, 471 }, -- Palamino Stallion
    [GetSpellInfo(446)] = { 2000, 446 }, -- Teleport Cemetary
    [GetSpellInfo(4508)] = { 3000, 4508 }, -- Discolored Healing Potion
    [GetSpellInfo(6421)] = { 4000, 6421 }, -- Ashcrombe's Unlock
    [GetSpellInfo(12199)] = { 2000, 12199 }, -- Summon Ishamuhale
    [GetSpellInfo(26426)] = { 5125, 26426 }, -- Large Blue Rocket Cluster
    [GetSpellInfo(10140)] = { 3000, 10140 }, -- Conjure Water
    [GetSpellInfo(20627)] = { 2000, 20627 }, -- Lightning Breath
    [GetSpellInfo(15294)] = { 45000, 15294 }, -- Dark Iron Sunderer
    [GetSpellInfo(26443)] = { 12500, 26443 }, -- Firework Cluster Launcher
    [GetSpellInfo(26105)] = { 500, 26105 }, -- Glare
    [GetSpellInfo(23242)] = { 3000, 23242 }, -- Swift Olive Raptor
    [GetSpellInfo(24201)] = { 1000, 24201 }, -- Create Rune of the Dawn
    [GetSpellInfo(9820)] = { 25000, 9820 }, -- Barbaric Iron Gloves
    [GetSpellInfo(3276)] = { 3000, 3276 }, -- Heavy Linen Bandage
    [GetSpellInfo(13630)] = { 5000, 13630 }, -- Scraping
    [GetSpellInfo(3398)] = { 3000, 3398 }, -- Hot Lion Chops
    [GetSpellInfo(6688)] = { 25000, 6688 }, -- Red Woolen Bag
    [GetSpellInfo(3304)] = { 3000, 3304 }, -- Smelt Tin
    [GetSpellInfo(9918)] = { 5125, 9918 }, -- Solid Sharpening Stone
    [GetSpellInfo(16450)] = { 1000, 16450 }, -- Summon Smolderweb
    [GetSpellInfo(17506)] = { 2000, 17506 }, -- Soul Breaker
    [GetSpellInfo(25347)] = { 3000, 25347 }, -- Deadly Poison V
    [GetSpellInfo(3320)] = { 5125, 3320 }, -- Rough Grinding Stone
    [GetSpellInfo(23677)] = { 3000, 23677 }, -- Beasts Deck
    [GetSpellInfo(21067)] = { 2500, 21067 }, -- Poison Bolt
    [GetSpellInfo(10490)] = { 45000, 10490 }, -- Comfortable Leather Hat
    [GetSpellInfo(27)] = { 5000, 27 }, -- Goldshire Portal
    [GetSpellInfo(3387)] = { 1500, 3387 }, -- Rage of Thule
    [GetSpellInfo(15743)] = { 2500, 15743 }, -- Flamecrack
    [GetSpellInfo(3926)] = { 5125, 3926 }, -- Copper Modulator
    [GetSpellInfo(28243)] = { 60000, 28243 }, -- Icebane Gauntlets
    [GetSpellInfo(16648)] = { 60000, 16648 }, -- Radiant Breastplate
    [GetSpellInfo(21175)] = { 3000, 21175 }, -- Spider Sausage
    [GetSpellInfo(27587)] = { 60000, 27587 }, -- Thick Obsidian Breastplate
    [GetSpellInfo(12521)] = { 1000, 12521 }, -- Teleport from Azshara Tower
    [GetSpellInfo(28023)] = { 3000, 28023 }, -- Create Healthstone
    [GetSpellInfo(5110)] = { 2000, 5110 }, -- Summon Living Flame
    [GetSpellInfo(3293)] = { 12500, 3293 }, -- Copper Battle Axe
    [GetSpellInfo(7079)] = { 1000, 7079 }, -- Simple Teleport Other
    [GetSpellInfo(22430)] = { 25000, 22430 }, -- Refined Scale of Onyxia
    [GetSpellInfo(26056)] = { 3000, 26056 }, -- Summon Green Qiraji Battle Tank
    [GetSpellInfo(7828)] = { 3000, 7828 }, -- Rockscale Cod
    [GetSpellInfo(17461)] = { 3000, 17461 }, -- Black Ram
    [GetSpellInfo(25162)] = { 1000, 25162 }, -- Summon Disgusting Oozeling
    [GetSpellInfo(11459)] = { 30000, 11459 }, -- Philosophers' Stone
    [GetSpellInfo(3855)] = { 45000, 3855 }, -- Spidersilk Boots
    [GetSpellInfo(29163)] = { 1500, 29163 }, -- Copy of Frostbolt
    [GetSpellInfo(12715)] = { 25000, 12715 }, -- Goblin Rocket Fuel Recipe
    [GetSpellInfo(14008)] = { 2000, 14008 }, -- Miblon's Bait
    [GetSpellInfo(3843)] = { 12500, 3843 }, -- Heavy Woolen Gloves
    [GetSpellInfo(29483)] = { 5000, 29483 }, -- Might of the Scourge
    [GetSpellInfo(4975)] = { 10000, 4975 }, -- Cleanse Winterhoof Well
    [GetSpellInfo(20589)] = { 500, 20589 }, -- Escape Artist
    [GetSpellInfo(16781)] = { 1300, 16781 }, -- Combining Charms
    [GetSpellInfo(6416)] = { 3000, 6416 }, -- Strider Stew
    [GetSpellInfo(14327)] = { 1500, 14327 }, -- Scare Beast
    [GetSpellInfo(17709)] = { 1000, 17709 }, -- Summon Zergling
    [GetSpellInfo(25840)] = { 1000, 25840 }, -- Full Heal
    [GetSpellInfo(3841)] = { 8000, 3841 }, -- Green Linen Bracers
    [GetSpellInfo(17405)] = { 1000, 17405 }, -- Domination
    [GetSpellInfo(2159)] = { 8000, 2159 }, -- Fine Leather Cloak
    [GetSpellInfo(9986)] = { 12500, 9986 }, -- Bronze Greatsword
    [GetSpellInfo(6521)] = { 12500, 6521 }, -- Pearl-clasped Cloak
    [GetSpellInfo(6686)] = { 12500, 6686 }, -- Red Linen Bag
    [GetSpellInfo(12304)] = { 7000, 12304 }, -- Drawing Kit
    [GetSpellInfo(24136)] = { 60000, 24136 }, -- Bloodsoul Breastplate
    [GetSpellInfo(3778)] = { 60000, 3778 }, -- Gem-studded Leather Belt
    [GetSpellInfo(10713)] = { 1000, 10713 }, -- Summon Albino Snake
    [GetSpellInfo(3508)] = { 60000, 3508 }, -- Green Iron Hauberk
    [GetSpellInfo(28481)] = { 60000, 28481 }, -- Sylvan Crown
    [GetSpellInfo(12718)] = { 25000, 12718 }, -- Goblin Construction Helmet
    [GetSpellInfo(2480)] = { 1000, 2480 }, -- Shoot Bow
    [GetSpellInfo(28146)] = { 10000, 28146 }, -- Copy of Portal: Undercity
    [GetSpellInfo(18458)] = { 60000, 18458 }, -- Robe of the Void
    [GetSpellInfo(21050)] = { 1000, 21050 }, -- Melodious Rapture
    [GetSpellInfo(11417)] = { 10000, 11417 }, -- Portal: Orgrimmar
    [GetSpellInfo(19065)] = { 60000, 19065 }, -- Runic Leather Bracers
    [GetSpellInfo(6272)] = { 2000, 6272 }, -- Eye of Yesmur (PT)
    [GetSpellInfo(23063)] = { 1000, 23063 }, -- Dense Dynamite
    [GetSpellInfo(10969)] = { 3000, 10969 }, -- Blue Mechanostrider
    [GetSpellInfo(3330)] = { 25000, 3330 }, -- Silvered Bronze Shoulders
    [GetSpellInfo(22593)] = { 5000, 22593 }, -- Flame Mantle of the Dawn
    [GetSpellInfo(698)] = { 5000, 698 }, -- Ritual of Summoning
    [GetSpellInfo(8275)] = { 2000, 8275 }, -- Poisoned Shot
    [GetSpellInfo(18991)] = { 3000, 18991 }, -- Green Kodo
    [GetSpellInfo(184)] = { 1000, 184 }, -- Fire Shield II
    [GetSpellInfo(19666)] = { 8000, 19666 }, -- Silver Skeleton Key
    [GetSpellInfo(2576)] = { 3200, 2576 }, -- Mining
    [GetSpellInfo(18420)] = { 60000, 18420 }, -- Brightcloth Cloak
    [GetSpellInfo(7151)] = { 45000, 7151 }, -- Barbaric Shoulders
    [GetSpellInfo(25748)] = { 2000, 25748 }, -- Poison Stinger
    [GetSpellInfo(30001)] = { 1500, 30001 }, -- Copy of Fear
    [GetSpellInfo(10529)] = { 60000, 10529 }, -- Wild Leather Shoulders
    [GetSpellInfo(15728)] = { 2500, 15728 }, -- Plague Cloud
    [GetSpellInfo(19066)] = { 60000, 19066 }, -- Frostsaber Boots
    [GetSpellInfo(23229)] = { 3000, 23229 }, -- Swift Brown Steed
    [GetSpellInfo(10679)] = { 1000, 10679 }, -- Summon White Kitten
    [GetSpellInfo(3277)] = { 3000, 3277 }, -- Wool Bandage
    [GetSpellInfo(9931)] = { 60000, 9931 }, -- Mithril Scale Pants
    [GetSpellInfo(22808)] = { 3000, 22808 }, -- Elixir of Greater Water Breathing
    [GetSpellInfo(18159)] = { 2000, 18159 }, -- Curse of the Fallen Magram
    [GetSpellInfo(10097)] = { 3000, 10097 }, -- Smelt Mithril
    [GetSpellInfo(3761)] = { 12500, 3761 }, -- Fine Leather Tunic
    [GetSpellInfo(8000)] = { 3000, 8000 }, -- Area Burn
    [GetSpellInfo(18711)] = { 5000, 18711 }, -- Forging
    [GetSpellInfo(26417)] = { 5125, 26417 }, -- Small Green Rocket
    [GetSpellInfo(3864)] = { 45000, 3864 }, -- Star Belt
    [GetSpellInfo(19062)] = { 60000, 19062 }, -- Ironfeather Shoulders
    [GetSpellInfo(17155)] = { 6000, 17155 }, -- Sprinkling Purified Water
    [GetSpellInfo(13564)] = { 5000, 13564 }, -- Opening Dark Coffer
    [GetSpellInfo(21913)] = { 25000, 21913 }, -- Edge of Winter
    [GetSpellInfo(25662)] = { 3000, 25662 }, -- Copy of Nightfin Soup
    [GetSpellInfo(22799)] = { 1000, 22799 }, -- King of the Gordok
    [GetSpellInfo(11758)] = { 3500, 11758 }, -- Dowsing
    [GetSpellInfo(17045)] = { 1500, 17045 }, -- Dawn's Gambit
    [GetSpellInfo(12509)] = { 1000, 12509 }, -- Teleport to Azshara Tower
    [GetSpellInfo(22434)] = { 25000, 22434 }, -- Charged Scale of Onyxia
    [GetSpellInfo(16971)] = { 60000, 16971 }, -- Huge Thorium Battleaxe
    [GetSpellInfo(8366)] = { 12500, 8366 }, -- Ironforge Chain
    [GetSpellInfo(23507)] = { 12500, 23507 }, -- Snake Burst Firework
    [GetSpellInfo(26001)] = { 1000, 26001 }, -- Reputation - Ahn'Qiraj Temple Boss
    [GetSpellInfo(509)] = { 1000, 509 }, -- Feeblemind II
    [GetSpellInfo(18153)] = { 5000, 18153 }, -- Kodo Kombobulator
    [GetSpellInfo(15533)] = { 3000, 15533 }, -- Stoned - Channel Cast Visual
    [GetSpellInfo(9928)] = { 60000, 9928 }, -- Heavy Mithril Gauntlet
    [GetSpellInfo(9197)] = { 45000, 9197 }, -- Green Whelp Armor
    [GetSpellInfo(16997)] = { 1500, 16997 }, -- Gargoyle Strike
    [GetSpellInfo(22923)] = { 60000, 22923 }, -- Swift Flight Bracers
    [GetSpellInfo(12079)] = { 60000, 12079 }, -- Red Mageweave Bag
    [GetSpellInfo(18242)] = { 3000, 18242 }, -- Hot Smoked Bass
    [GetSpellInfo(14814)] = { 500, 14814 }, -- Throw Dark Iron Ale
    [GetSpellInfo(3308)] = { 3000, 3308 }, -- Smelt Gold
    [GetSpellInfo(2160)] = { 12500, 2160 }, -- Embossed Leather Vest
    [GetSpellInfo(13565)] = { 5000, 13565 }, -- Opening Secure Safe
    [GetSpellInfo(21950)] = { 3000, 21950 }, -- Recite Words of Celebras
    [GetSpellInfo(2828)] = { 3000, 2828 }, -- Sharpen Blade
    [GetSpellInfo(19668)] = { 8000, 19668 }, -- Truesilver Skeleton Key
    [GetSpellInfo(9010)] = { 2000, 9010 }, -- Create Filled Containment Coffer
    [GetSpellInfo(16724)] = { 60000, 16724 }, -- Whitesoul Helm
    [GetSpellInfo(22870)] = { 60000, 22870 }, -- Cloak of Warding
    [GetSpellInfo(7183)] = { 3000, 7183 }, -- Elixir of Minor Defense
    [GetSpellInfo(17016)] = { 2300, 17016 }, -- Placing Beacon Torch
    [GetSpellInfo(3207)] = { 3000, 3207 }, -- Sol U
    [GetSpellInfo(10841)] = { 3000, 10841 }, -- Heavy Mageweave Bandage
    [GetSpellInfo(11547)] = { 2000, 11547 }, -- Drive Nimboya's Laden Pike
    [GetSpellInfo(3356)] = { 1000, 3356 }, -- Flame Lash
    [GetSpellInfo(28615)] = { 500, 28615 }, -- Spike Volley
    [GetSpellInfo(10326)] = { 1500, 10326 }, -- Turn Undead
    [GetSpellInfo(6898)] = { 3000, 6898 }, -- White Ram
    [GetSpellInfo(11548)] = { 10000, 11548 }, -- Summon Spider God
    [GetSpellInfo(27572)] = { 1000, 27572 }, -- Smitten
    [GetSpellInfo(14250)] = { 3000, 14250 }, -- Capture Grark
    [GetSpellInfo(1849)] = { 1000, 1849 }, -- Beast Claws II
    [GetSpellInfo(26424)] = { 5125, 26424 }, -- Green Rocket Cluster
    [GetSpellInfo(3491)] = { 25000, 3491 }, -- Big Bronze Knife
    [GetSpellInfo(25309)] = { 2000, 25309 }, -- Immolate
    [GetSpellInfo(7076)] = { 4000, 7076 }, -- Summon Tervosh's Minion
    [GetSpellInfo(16987)] = { 60000, 16987 }, -- Darkspear
    [GetSpellInfo(3334)] = { 25000, 3334 }, -- Green Iron Boots
    [GetSpellInfo(25183)] = { 5000, 25183 }, -- Shadow Weakness
    [GetSpellInfo(11048)] = { 3000, 11048 }, -- Perm. Illusion Bishop Tyriona
    [GetSpellInfo(10681)] = { 1000, 10681 }, -- Summon Cockatoo
    [GetSpellInfo(24365)] = { 3000, 24365 }, -- Mageblood Potion
    [GetSpellInfo(11416)] = { 10000, 11416 }, -- Portal: Ironforge
    [GetSpellInfo(23628)] = { 60000, 23628 }, -- Heavy Timbermaw Belt
    [GetSpellInfo(10798)] = { 3000, 10798 }, -- Obsidian Raptor
    [GetSpellInfo(8802)] = { 60000, 8802 }, -- Crimson Silk Robe
    [GetSpellInfo(24703)] = { 60000, 24703 }, -- Dreamscale Breastplate
    [GetSpellInfo(6700)] = { 2000, 6700 }, -- Dimensional Portal
    [GetSpellInfo(7624)] = { 8000, 7624 }, -- White Linen Robe
    [GetSpellInfo(16336)] = { 2000, 16336 }, -- Haunting Phantoms
    [GetSpellInfo(15915)] = { 3000, 15915 }, -- Spiced Chili Crab
    [GetSpellInfo(10228)] = { 3000, 10228 }, -- Greater Invisibility
    [GetSpellInfo(23653)] = { 60000, 23653 }, -- Nightfall
    [GetSpellInfo(11443)] = { 3000, 11443 }, -- Cripple
    [GetSpellInfo(11435)] = { 3000, 11435 }, -- Create Mallet of Zul'Farrak
    [GetSpellInfo(21646)] = { 10000, 21646 }, -- Conjure Circle of Calling
    [GetSpellInfo(3396)] = { 1500, 3396 }, -- Corrosive Poison
    [GetSpellInfo(20757)] = { 3000, 20757 }, -- Create Soulstone (Major)
    [GetSpellInfo(3337)] = { 8000, 3337 }, -- Heavy Grinding Stone
    [GetSpellInfo(16644)] = { 60000, 16644 }, -- Thorium Bracers
    [GetSpellInfo(25178)] = { 5000, 25178 }, -- Frost Weakness
    [GetSpellInfo(5784)] = { 3000, 5784 }, -- Summon Felsteed
    [GetSpellInfo(19794)] = { 45000, 19794 }, -- Spellpower Goggles Xtreme Plus
    [GetSpellInfo(461)] = { 4000, 461 }, -- Righteous Flame On
    [GetSpellInfo(3763)] = { 8000, 3763 }, -- Fine Leather Belt
    [GetSpellInfo(16084)] = { 3000, 16084 }, -- Mottled Red Raptor
    [GetSpellInfo(10533)] = { 60000, 10533 }, -- Tough Scorpid Bracers
    [GetSpellInfo(8677)] = { 5000, 8677 }, -- Summon Effect
    [GetSpellInfo(21355)] = { 5000, 21355 }, -- Planting Guse's Beacon
    [GetSpellInfo(9595)] = { 2000, 9595 }, -- Attach Shaft to Medallion
    [GetSpellInfo(17235)] = { 1000, 17235 }, -- Raise Undead Scarab
    [GetSpellInfo(15050)] = { 5000, 15050 }, -- Psychometry
    [GetSpellInfo(9920)] = { 8000, 9920 }, -- Solid Grinding Stone
    [GetSpellInfo(10568)] = { 60000, 10568 }, -- Tough Scorpid Leggings
    [GetSpellInfo(30297)] = { 1000, 30297 }, -- Heightened Senses
    [GetSpellInfo(8348)] = { 2000, 8348 }, -- Julie's Blessing
    [GetSpellInfo(7124)] = { 2500, 7124 }, -- Arugal's Gift
    [GetSpellInfo(10793)] = { 3000, 10793 }, -- Striped Nightsaber
    [GetSpellInfo(7638)] = { 2000, 7638 }, -- Potion Toss
    [GetSpellInfo(10207)] = { 1500, 10207 }, -- Scorch
    [GetSpellInfo(5273)] = { 2000, 5273 }, -- Dark Iron Dwarf Disguise
    [GetSpellInfo(24137)] = { 60000, 24137 }, -- Bloodsoul Shoulders
    [GetSpellInfo(2641)] = { 5000, 2641 }, -- Dismiss Pet
    [GetSpellInfo(3171)] = { 3000, 3171 }, -- Elixir of Wisdom
    [GetSpellInfo(468)] = { 3000, 468 }, -- White Stallion
    [GetSpellInfo(18444)] = { 60000, 18444 }, -- Runecloth Headband
    [GetSpellInfo(1940)] = { 3000, 1940 }, -- Rocket Blast
    [GetSpellInfo(23251)] = { 3000, 23251 }, -- Swift Timber Wolf
    [GetSpellInfo(9208)] = { 45000, 9208 }, -- Swift Boots
    [GetSpellInfo(22567)] = { 2500, 22567 }, -- Summon Ar'lia
    [GetSpellInfo(18658)] = { 1500, 18658 }, -- Hibernate
    [GetSpellInfo(16562)] = { 2000, 16562 }, -- Urok Minions Vanish
    [GetSpellInfo(15276)] = { 5000, 15276 }, -- Opening Bar Door
    [GetSpellInfo(18239)] = { 3000, 18239 }, -- Cooked Glossy Mightfish
    [GetSpellInfo(15910)] = { 3000, 15910 }, -- Heavy Kodo Stew
    [GetSpellInfo(8238)] = { 3000, 8238 }, -- Savory Deviate Delight
    [GetSpellInfo(9232)] = { 2000, 9232 }, -- Scarlet Resurrection
    [GetSpellInfo(22990)] = { 1000, 22990 }, -- The Forming
    [GetSpellInfo(6905)] = { 2000, 6905 }, -- Summon Illusionary Nightmare
    [GetSpellInfo(12759)] = { 12500, 12759 }, -- Gnomish Death Ray
    [GetSpellInfo(2840)] = { 3000, 2840 }, -- Creeping Anguish
    [GetSpellInfo(6196)] = { 2000, 6196 }, -- Far Sight
    [GetSpellInfo(3863)] = { 45000, 3863 }, -- Spider Belt
    [GetSpellInfo(20041)] = { 1300, 20041 }, -- Tammra Sapling
    [GetSpellInfo(10001)] = { 60000, 10001 }, -- Big Black Mace
    [GetSpellInfo(20748)] = { 2000, 20748 }, -- Rebirth
    [GetSpellInfo(13524)] = { 1000, 13524 }, -- Curse of Stalvan
    [GetSpellInfo(3924)] = { 5125, 3924 }, -- Copper Tube
    [GetSpellInfo(21143)] = { 3000, 21143 }, -- Gingerbread Cookie
    [GetSpellInfo(23707)] = { 60000, 23707 }, -- Lava Belt
    [GetSpellInfo(28207)] = { 60000, 28207 }, -- Glacial Vest
    [GetSpellInfo(8598)] = { 3200, 8598 }, -- Lightning Blast
    [GetSpellInfo(9201)] = { 45000, 9201 }, -- Dusky Bracers
    [GetSpellInfo(23432)] = { 1000, 23432 }, -- Summon Hawksbill Snapjaw
    [GetSpellInfo(28482)] = { 60000, 28482 }, -- Sylvan Shoulders
    [GetSpellInfo(17014)] = { 500, 17014 }, -- Bone Shards
    [GetSpellInfo(17777)] = { 1000, 17777 }, -- Create Commission
    [GetSpellInfo(20201)] = { 45000, 20201 }, -- Arcanite Rod
    [GetSpellInfo(21960)] = { 5000, 21960 }, -- Manifest Spirit
    [GetSpellInfo(28224)] = { 60000, 28224 }, -- Icy Scale Bracers
    [GetSpellInfo(3764)] = { 25000, 3764 }, -- Hillman's Leather Gloves
    [GetSpellInfo(19079)] = { 60000, 19079 }, -- Stormshroud Armor
    [GetSpellInfo(7084)] = { 2000, 7084 }, -- Damage Car
    [GetSpellInfo(12906)] = { 25000, 12906 }, -- Gnomish Battle Chicken
    [GetSpellInfo(3133)] = { 1000, 3133 }, -- Beast Claws III
    [GetSpellInfo(23012)] = { 1000, 23012 }, -- Summon Orphan
    [GetSpellInfo(17576)] = { 3000, 17576 }, -- Greater Nature Protection Potion
    [GetSpellInfo(23071)] = { 8000, 23071 }, -- Truesilver Transformer
    [GetSpellInfo(2335)] = { 3000, 2335 }, -- Swiftness Potion
    [GetSpellInfo(7220)] = { 3000, 7220 }, -- Weapon Chain
    [GetSpellInfo(15125)] = { 1500, 15125 }, -- Scarshield Portal
    [GetSpellInfo(8762)] = { 25000, 8762 }, -- Silk Headband
    [GetSpellInfo(5412)] = { 10000, 5412 }, -- Balance of Nature Failure
    [GetSpellInfo(7221)] = { 25000, 7221 }, -- Iron Shield Spike
    [GetSpellInfo(9858)] = { 2000, 9858 }, -- Regrowth
    [GetSpellInfo(11448)] = { 3000, 11448 }, -- Greater Mana Potion
    [GetSpellInfo(18238)] = { 3000, 18238 }, -- Spotted Yellowtail
    [GetSpellInfo(25952)] = { 8000, 25952 }, -- Reindeer Dust Effect
    [GetSpellInfo(2741)] = { 12500, 2741 }, -- Bronze Axe
    [GetSpellInfo(16655)] = { 60000, 16655 }, -- Fiery Plate Gauntlets
    [GetSpellInfo(9456)] = { 750, 9456 }, -- Tharnariun Cure 1
    [GetSpellInfo(6982)] = { 2000, 6982 }, -- Gust of Wind
    [GetSpellInfo(3757)] = { 12500, 3757 }, -- Woolen Bag
    [GetSpellInfo(23004)] = { 250, 23004 }, -- Summon Alarm-o-Bot
    [GetSpellInfo(28806)] = { 500, 28806 }, -- Toss Fuel on Bonfire
    [GetSpellInfo(10054)] = { 3000, 10054 }, -- Conjure Mana Ruby
    [GetSpellInfo(8799)] = { 25000, 8799 }, -- Crimson Silk Pantaloons
    [GetSpellInfo(24885)] = { 1500, 24885 }, -- Create Crest of Beckoning: Air
    [GetSpellInfo(24221)] = { 1000, 24221 }, -- Quest - Teleport Spawn-out
    [GetSpellInfo(3758)] = { 12500, 3758 }, -- Green Woolen Bag
    [GetSpellInfo(470)] = { 3000, 470 }, -- Black Stallion
    [GetSpellInfo(3958)] = { 8000, 3958 }, -- Iron Strut
    [GetSpellInfo(18666)] = { 2000, 18666 }, -- Corrupt Redpath
    [GetSpellInfo(26403)] = { 45000, 26403 }, -- Festive Red Dress
    [GetSpellInfo(25181)] = { 5000, 25181 }, -- Arcane Weakness
    [GetSpellInfo(8483)] = { 25000, 8483 }, -- White Swashbuckler's Shirt
    [GetSpellInfo(9912)] = { 2000, 9912 }, -- Wrath
    [GetSpellInfo(459)] = { 3000, 459 }, -- Gray Wolf
    [GetSpellInfo(2540)] = { 3000, 2540 }, -- Roasted Boar Meat
    [GetSpellInfo(22681)] = { 500, 22681 }, -- Shadowblink
    [GetSpellInfo(16075)] = { 1000, 16075 }, -- Throw Axe
    [GetSpellInfo(8606)] = { 10000, 8606 }, -- Summon Cyclonian
    [GetSpellInfo(20269)] = { 5000, 20269 }, -- Enchanted Gaea Seed
    [GetSpellInfo(23312)] = { 2000, 23312 }, -- Time Lapse
    [GetSpellInfo(5275)] = { 2000, 5275 }, -- South Seas Pirate Disguise
    [GetSpellInfo(19873)] = { 3000, 19873 }, -- Destroy Egg
    [GetSpellInfo(19057)] = { 3000, 19057 }, -- Armor +40
    [GetSpellInfo(28394)] = { 1000, 28394 }, -- Reputation - Ratchet +500
    [GetSpellInfo(3921)] = { 3000, 3921 }, -- Deprecated Solid Shot
    [GetSpellInfo(26054)] = { 3000, 26054 }, -- Summon Red Qiraji Battle Tank
    [GetSpellInfo(6949)] = { 2200, 6949 }, -- Weak Frostbolt
    [GetSpellInfo(19059)] = { 60000, 19059 }, -- Volcanic Leggings
    [GetSpellInfo(10869)] = { 2000, 10869 }, -- Summon Embers
    [GetSpellInfo(15048)] = { 1000, 15048 }, -- Summon Bomb
    [GetSpellInfo(19055)] = { 60000, 19055 }, -- Runic Leather Gauntlets
    [GetSpellInfo(28393)] = { 1000, 28393 }, -- Reputation - Booty Bay +500
    [GetSpellInfo(18449)] = { 60000, 18449 }, -- Runecloth Shoulders
    [GetSpellInfo(19093)] = { 60000, 19093 }, -- Onyxia Scale Cloak
    [GetSpellInfo(6576)] = { 1000, 6576 }, -- Intimidating Growl
    [GetSpellInfo(17580)] = { 3000, 17580 }, -- Major Mana Potion
    [GetSpellInfo(24649)] = { 250, 24649 }, -- Thousand Blades
    [GetSpellInfo(6414)] = { 3000, 6414 }, -- Roasted Kodo Meat
    [GetSpellInfo(10796)] = { 3000, 10796 }, -- Turquoise Raptor
    [GetSpellInfo(22756)] = { 3000, 22756 }, -- Sharpen Weapon - Critical
    [GetSpellInfo(8986)] = { 2000, 8986 }, -- Summon Illusionary Phantasm
    [GetSpellInfo(9657)] = { 1000, 9657 }, -- Shadow Shell
    [GetSpellInfo(8139)] = { 3000, 8139 }, -- Fevered Fatigue
    [GetSpellInfo(6758)] = { 1000, 6758 }, -- Party Fever
    [GetSpellInfo(7421)] = { 10000, 7421 }, -- Runed Copper Rod
    [GetSpellInfo(5213)] = { 2000, 5213 }, -- Molten Metal
    [GetSpellInfo(20770)] = { 10000, 20770 }, -- Resurrection
    [GetSpellInfo(3399)] = { 3000, 3399 }, -- Tasty Lion Steak
    [GetSpellInfo(3326)] = { 5125, 3326 }, -- Coarse Grinding Stone
    [GetSpellInfo(10318)] = { 2000, 10318 }, -- Holy Wrath
    [GetSpellInfo(13262)] = { 3000, 13262 }, -- Disenchant
    [GetSpellInfo(11202)] = { 3000, 11202 }, -- Crippling Poison
    [GetSpellInfo(16138)] = { 3000, 16138 }, -- Sharpen Blade V
    [GetSpellInfo(11790)] = { 1000, 11790 }, -- Poison Cloud
    [GetSpellInfo(2399)] = { 8000, 2399 }, -- Green Woolen Vest
    [GetSpellInfo(26181)] = { 2000, 26181 }, -- Strike
    [GetSpellInfo(12062)] = { 60000, 12062 }, -- Stormcloth Pants
    [GetSpellInfo(23241)] = { 3000, 23241 }, -- Swift Blue Raptor
    [GetSpellInfo(20513)] = { 5000, 20513 }, -- Enchanted Resonite Crystal
    [GetSpellInfo(3762)] = { 12500, 3762 }, -- Hillman's Leather Vest
    [GetSpellInfo(12088)] = { 60000, 12088 }, -- Cindercloth Boots
    [GetSpellInfo(26423)] = { 5125, 26423 }, -- Blue Rocket Cluster
    [GetSpellInfo(26087)] = { 60000, 26087 }, -- Core Felcloth Bag
    [GetSpellInfo(25807)] = { 2000, 25807 }, -- Great Heal
    [GetSpellInfo(15699)] = { 7000, 15699 }, -- Filling Empty Jar
    [GetSpellInfo(25120)] = { 3000, 25120 }, -- Lesser Mana Oil
    [GetSpellInfo(13548)] = { 1000, 13548 }, -- Summon Farm Chicken
    [GetSpellInfo(28740)] = { 1000, 28740 }, -- Summon Whiskers
    [GetSpellInfo(3562)] = { 10000, 3562 }, -- Teleport: Ironforge
    [GetSpellInfo(17556)] = { 3000, 17556 }, -- Major Healing Potion
    [GetSpellInfo(3498)] = { 45000, 3498 }, -- Massive Iron Axe
    [GetSpellInfo(2397)] = { 8000, 2397 }, -- Reinforced Linen Cape
    [GetSpellInfo(23189)] = { 2000, 23189 }, -- Frost Burn
    [GetSpellInfo(19094)] = { 60000, 19094 }, -- Black Dragonscale Shoulders
    [GetSpellInfo(6755)] = { 2000, 6755 }, -- Tell Joke
    [GetSpellInfo(13399)] = { 10000, 13399 }, -- Cultivate Packet of Seeds
    [GetSpellInfo(2664)] = { 8000, 2664 }, -- Runed Copper Bracers
    [GetSpellInfo(4980)] = { 1500, 4980 }, -- Quick Frost Ward
    [GetSpellInfo(17455)] = { 3000, 17455 }, -- Purple Mechanostrider
    [GetSpellInfo(23079)] = { 25000, 23079 }, -- Major Recombobulator
    [GetSpellInfo(10705)] = { 1000, 10705 }, -- Summon Eagle Owl
    [GetSpellInfo(8435)] = { 2000, 8435 }, -- Forked Lightning
    [GetSpellInfo(15648)] = { 1000, 15648 }, -- Summon Corrupted Kitten
    [GetSpellInfo(24368)] = { 3000, 24368 }, -- Major Troll's Blood Potion
    [GetSpellInfo(17632)] = { 60000, 17632 }, -- Alchemist's Stone
    [GetSpellInfo(12900)] = { 25000, 12900 }, -- Mobile Alarm
    [GetSpellInfo(22846)] = { 4000, 22846 }, -- Arcanum of Protection
    [GetSpellInfo(16988)] = { 60000, 16988 }, -- Hammer of the Titans
    [GetSpellInfo(23136)] = { 2000, 23136 }, -- Release J'eevee
    [GetSpellInfo(4526)] = { 1000, 4526 }, -- Mass Dispell
    [GetSpellInfo(25808)] = { 1000, 25808 }, -- Dispel
    [GetSpellInfo(11131)] = { 1500, 11131 }, -- Icicle
    [GetSpellInfo(28163)] = { 4000, 28163 }, -- Ice Guard
    [GetSpellInfo(7135)] = { 25000, 7135 }, -- Dark Leather Pants
    [GetSpellInfo(23190)] = { 8000, 23190 }, -- Heavy Leather Ball
    [GetSpellInfo(23629)] = { 60000, 23629 }, -- Heavy Timbermaw Boots
    [GetSpellInfo(11085)] = { 2500, 11085 }, -- Chain Bolt
    [GetSpellInfo(28898)] = { 3000, 28898 }, -- Blessed Wizard Oil
    [GetSpellInfo(10482)] = { 12500, 10482 }, -- Cured Thick Hide
    [GetSpellInfo(16429)] = { 2000, 16429 }, -- Piercing Shadow
    [GetSpellInfo(10795)] = { 3000, 10795 }, -- Ivory Raptor
    [GetSpellInfo(18436)] = { 60000, 18436 }, -- Robe of Winter Night
    [GetSpellInfo(8880)] = { 8000, 8880 }, -- Copper Dagger
    [GetSpellInfo(5106)] = { 2000, 5106 }, -- Crystal Flash
    [GetSpellInfo(3115)] = { 5125, 3115 }, -- Rough Weightstone
    [GetSpellInfo(3230)] = { 3000, 3230 }, -- Elixir of Minor Agility
    [GetSpellInfo(12534)] = { 3000, 12534 }, -- Flames of Retribution
    [GetSpellInfo(6201)] = { 3000, 6201 }, -- Create Healthstone (Minor)
    [GetSpellInfo(693)] = { 3000, 693 }, -- Create Soulstone (Minor)
    [GetSpellInfo(9074)] = { 8000, 9074 }, -- Nimble Leather Gloves
    [GetSpellInfo(428)] = { 2000, 428 }, -- Teleport Moonbrook
    [GetSpellInfo(18952)] = { 5000, 18952 }, -- Opening Termite Barrel
    [GetSpellInfo(3944)] = { 12500, 3944 }, -- Flame Deflector
    [GetSpellInfo(3595)] = { 3000, 3595 }, -- Frost Oil
    [GetSpellInfo(16732)] = { 60000, 16732 }, -- Runic Plate Leggings
    [GetSpellInfo(5407)] = { 3000, 5407 }, -- Segra Darkthorn Effect
    [GetSpellInfo(23706)] = { 60000, 23706 }, -- Golden Mantle of the Dawn
    [GetSpellInfo(3407)] = { 5000, 3407 }, -- Rune of Opening
    [GetSpellInfo(6487)] = { 5000, 6487 }, -- Ilkrud's Guardians
    [GetSpellInfo(10564)] = { 60000, 10564 }, -- Tough Scorpid Shoulders
    [GetSpellInfo(20804)] = { 7000, 20804 }, -- Triage
    [GetSpellInfo(5107)] = { 5000, 5107 }, -- Opening Booty Chest
    [GetSpellInfo(8776)] = { 5125, 8776 }, -- Linen Belt
    [GetSpellInfo(6627)] = { 1000, 6627 }, -- Remote Detonate
    [GetSpellInfo(24141)] = { 60000, 24141 }, -- Darksoul Shoulders
    [GetSpellInfo(23193)] = { 10000, 23193 }, -- Forming Lok'delar
    [GetSpellInfo(8272)] = { 2000, 8272 }, -- Mind Tremor
    [GetSpellInfo(3552)] = { 3000, 3552 }, -- Conjure Mana Jade
    [GetSpellInfo(23077)] = { 45000, 23077 }, -- Gyrofreeze Ice Reflector
    [GetSpellInfo(26427)] = { 5125, 26427 }, -- Large Green Rocket Cluster
    [GetSpellInfo(11802)] = { 1000, 11802 }, -- Dark Iron Land Mine
    [GetSpellInfo(2385)] = { 5125, 2385 }, -- Brown Linen Vest
    [GetSpellInfo(11467)] = { 3000, 11467 }, -- Elixir of Greater Agility
    [GetSpellInfo(11468)] = { 3000, 11468 }, -- Elixir of Dream Vision
    [GetSpellInfo(8040)] = { 2500, 8040 }, -- Druid's Slumber
    [GetSpellInfo(2658)] = { 3000, 2658 }, -- Smelt Silver
    [GetSpellInfo(12458)] = { 300000, 12458 }, -- Evil God Counterspell
    [GetSpellInfo(22727)] = { 25000, 22727 }, -- Core Armor Kit
    [GetSpellInfo(24302)] = { 3000, 24302 }, -- Eternium Fishing Line
    [GetSpellInfo(2963)] = { 3000, 2963 }, -- Bolt of Linen Cloth
    [GetSpellInfo(110)] = { 1000, 110 }, -- Spell Deflection (NYI)
    [GetSpellInfo(3933)] = { 8000, 3933 }, -- Small Seaforium Charge
    [GetSpellInfo(457)] = { 1000, 457 }, -- Feeblemind
    [GetSpellInfo(6899)] = { 3000, 6899 }, -- Brown Ram
    [GetSpellInfo(11792)] = { 5000, 11792 }, -- Opening Cage
    [GetSpellInfo(11021)] = { 3000, 11021 }, -- Flamespit
    [GetSpellInfo(10509)] = { 45000, 10509 }, -- Turtle Scale Gloves
    [GetSpellInfo(18451)] = { 60000, 18451 }, -- Felcloth Robe
    [GetSpellInfo(16965)] = { 60000, 16965 }, -- Bleakwood Hew
    [GetSpellInfo(9206)] = { 45000, 9206 }, -- Dusky Belt
    [GetSpellInfo(7643)] = { 25000, 7643 }, -- Greater Adept's Robe
    [GetSpellInfo(3175)] = { 3000, 3175 }, -- Limited Invulnerability Potion
    [GetSpellInfo(7437)] = { 2000, 7437 }, -- Break Stuff
    [GetSpellInfo(3865)] = { 8000, 3865 }, -- Bolt of Mageweave
    [GetSpellInfo(24024)] = { 3000, 24024 }, -- Unstable Concoction
    [GetSpellInfo(17572)] = { 3000, 17572 }, -- Purification Potion
    [GetSpellInfo(12899)] = { 25000, 12899 }, -- Gnomish Shrink Ray
    [GetSpellInfo(3756)] = { 8000, 3756 }, -- Embossed Leather Gloves
    [GetSpellInfo(24399)] = { 60000, 24399 }, -- Dark Iron Boots
    [GetSpellInfo(19815)] = { 8000, 19815 }, -- Delicate Arcanite Converter
    [GetSpellInfo(24898)] = { 3000, 24898 }, -- Create Scepter of Beckoning: Water
    [GetSpellInfo(17474)] = { 5000, 17474 }, -- Find Relic Fragment
    [GetSpellInfo(3131)] = { 250, 3131 }, -- Frost Breath
    [GetSpellInfo(16728)] = { 60000, 16728 }, -- Helm of the Great Chief
    [GetSpellInfo(15049)] = { 1000, 15049 }, -- Summon Robot
    [GetSpellInfo(16053)] = { 3000, 16053 }, -- Dominion of Soul
    [GetSpellInfo(24194)] = { 2000, 24194 }, -- Uther's Tribute
    [GetSpellInfo(10418)] = { 2000, 10418 }, -- Arugal spawn-in spell
    [GetSpellInfo(24923)] = { 1000, 24923 }, -- Honor Points +398
    [GetSpellInfo(10684)] = { 1000, 10684 }, -- Summon Senegal
    [GetSpellInfo(3488)] = { 3000, 3488 }, -- Felstrom Resurrection
    [GetSpellInfo(16983)] = { 60000, 16983 }, -- Serenity
    [GetSpellInfo(3243)] = { 1000, 3243 }, -- Life Harvest
    [GetSpellInfo(12081)] = { 60000, 12081 }, -- Admiral's Hat
    [GetSpellInfo(20549)] = { 500, 20549 }, -- War Stomp
    [GetSpellInfo(23509)] = { 3000, 23509 }, -- Frostwolf Howler
    [GetSpellInfo(3307)] = { 3000, 3307 }, -- Smelt Iron
    [GetSpellInfo(27146)] = { 2000, 27146 }, -- Left Piece of Lord Valthalak's Amulet
    [GetSpellInfo(9070)] = { 12500, 9070 }, -- Black Whelp Cloak
    [GetSpellInfo(11761)] = { 3000, 11761 }, -- Scorpid Sample
    [GetSpellInfo(5262)] = { 1000, 5262 }, -- Fanatic Blade
    [GetSpellInfo(3919)] = { 5125, 3919 }, -- Rough Dynamite
    [GetSpellInfo(11759)] = { 3000, 11759 }, -- Basilisk Sample
    [GetSpellInfo(9771)] = { 3000, 9771 }, -- Radiation Bolt
    [GetSpellInfo(18990)] = { 3000, 18990 }, -- Brown Kodo
    [GetSpellInfo(25031)] = { 3000, 25031 }, -- Shoot Missile
    [GetSpellInfo(19092)] = { 60000, 19092 }, -- Wicked Leather Belt
    [GetSpellInfo(16665)] = { 60000, 16665 }, -- Runic Plate Boots
    [GetSpellInfo(5026)] = { 5000, 5026 }, -- Create Water of the Seers
    [GetSpellInfo(18419)] = { 60000, 18419 }, -- Felcloth Pants
    [GetSpellInfo(15119)] = { 2500, 15119 }, -- Apply Seduction Gland
    [GetSpellInfo(6471)] = { 5000, 6471 }, -- Tiny Iron Key
    [GetSpellInfo(3914)] = { 5125, 3914 }, -- Brown Linen Pants
    [GetSpellInfo(22723)] = { 3000, 22723 }, -- Black War Tiger
    [GetSpellInfo(9961)] = { 60000, 9961 }, -- Mithril Coif
    [GetSpellInfo(25030)] = { 3000, 25030 }, -- Shoot Rocket
    [GetSpellInfo(4506)] = { 4000, 4506 }, -- CHU's QUEST SPELL
    [GetSpellInfo(2053)] = { 2500, 2053 }, -- Lesser Heal
    [GetSpellInfo(1936)] = { 2000, 1936 }, -- Teleport Anvilmar
    [GetSpellInfo(17563)] = { 25000, 17563 }, -- Transmute: Undeath to Water
    [GetSpellInfo(17923)] = { 1500, 17923 }, -- Searing Pain
    [GetSpellInfo(6064)] = { 3000, 6064 }, -- Heal
    [GetSpellInfo(18447)] = { 60000, 18447 }, -- Mooncloth Vest
    [GetSpellInfo(19795)] = { 8000, 19795 }, -- Thorium Tube
    [GetSpellInfo(4954)] = { 750, 4954 }, -- Break Tool
    [GetSpellInfo(9148)] = { 25000, 9148 }, -- Pilferer's Gloves
    [GetSpellInfo(24242)] = { 3000, 24242 }, -- Swift Razzashi Raptor
    [GetSpellInfo(26656)] = { 3000, 26656 }, -- Summon Black Qiraji Battle Tank
    [GetSpellInfo(7133)] = { 25000, 7133 }, -- Fine Leather Pants
    [GetSpellInfo(7218)] = { 3000, 7218 }, -- Weapon Counterweight
    [GetSpellInfo(24848)] = { 60000, 24848 }, -- Spitfire Breastplate
    [GetSpellInfo(8795)] = { 45000, 8795 }, -- Azure Shoulders
    [GetSpellInfo(11840)] = { 4000, 11840 }, -- Summon Edana Hatetalon
    [GetSpellInfo(10015)] = { 60000, 10015 }, -- Truesilver Champion
    [GetSpellInfo(271)] = { 3000, 271 }, -- Call of the Void
    [GetSpellInfo(867)] = { 1000, 867 }, -- Fumble III
    [GetSpellInfo(13028)] = { 3000, 13028 }, -- Goldthorn Tea
    [GetSpellInfo(18976)] = { 5000, 18976 }, -- Self Resurrection
    [GetSpellInfo(3294)] = { 12500, 3294 }, -- Thick War Axe
    [GetSpellInfo(28352)] = { 2000, 28352 }, -- Breath of Sargeras
    [GetSpellInfo(1056)] = { 1000, 1056 }, -- Slow Poison II
    [GetSpellInfo(19435)] = { 60000, 19435 }, -- Mooncloth Boots
    [GetSpellInfo(2168)] = { 12500, 2168 }, -- Dark Leather Cloak
    [GetSpellInfo(2738)] = { 5125, 2738 }, -- Copper Axe
    [GetSpellInfo(26010)] = { 1000, 26010 }, -- Summon Tranquil Mechanical Yeti
    [GetSpellInfo(16989)] = { 2300, 16989 }, -- Planting Banner
    [GetSpellInfo(25298)] = { 3500, 25298 }, -- Starfire
    [GetSpellInfo(8489)] = { 25000, 8489 }, -- Red Swashbuckler's Shirt
    [GetSpellInfo(6412)] = { 3000, 6412 }, -- Kaldorei Spider Kabob
    [GetSpellInfo(29333)] = { 1000, 29333 }, -- Midsummer Sausage
    [GetSpellInfo(31)] = { 2000, 31 }, -- Teleport Goldshire
    [GetSpellInfo(24421)] = { 5000, 24421 }, -- Zandalar Signet of Mojo
    [GetSpellInfo(3774)] = { 45000, 3774 }, -- Green Leather Belt
    [GetSpellInfo(3964)] = { 3000, 3964 }, -- Deprecated BKP "Impact" Shot
    [GetSpellInfo(16992)] = { 60000, 16992 }, -- Frostguard
    [GetSpellInfo(2392)] = { 5125, 2392 }, -- Red Linen Shirt
    [GetSpellInfo(26055)] = { 3000, 26055 }, -- Summon Yellow Qiraji Battle Tank
    [GetSpellInfo(4075)] = { 5000, 4075 }, -- Large Seaforium Charge
    [GetSpellInfo(2660)] = { 5125, 2660 }, -- Rough Sharpening Stone
    [GetSpellInfo(13628)] = { 30000, 13628 }, -- Runed Golden Rod
    [GetSpellInfo(23192)] = { 10000, 23192 }, -- Forming Rhok'delar
    [GetSpellInfo(3496)] = { 45000, 3496 }, -- Moonsteel Broadsword
    [GetSpellInfo(6626)] = { 5000, 6626 }, -- Set NG-5 Charge (Blue)
    [GetSpellInfo(7630)] = { 12500, 7630 }, -- Blue Linen Vest
    [GetSpellInfo(19074)] = { 60000, 19074 }, -- Frostsaber Leggings
    [GetSpellInfo(8690)] = { 10000, 8690 }, -- Hearthstone
    [GetSpellInfo(26085)] = { 60000, 26085 }, -- Soul Pouch
    [GetSpellInfo(19791)] = { 8000, 19791 }, -- Thorium Widget
    [GetSpellInfo(27890)] = { 2500, 27890 }, -- Clone
    [GetSpellInfo(3817)] = { 8000, 3817 }, -- Cured Medium Hide
    [GetSpellInfo(16629)] = { 2000, 16629 }, -- Attuned Dampener
    [GetSpellInfo(19075)] = { 60000, 19075 }, -- Heavy Scorpid Leggings
    [GetSpellInfo(22313)] = { 4000, 22313 }, -- Purple Hands
    [GetSpellInfo(474)] = { 1000, 474 }, -- Fumble
    [GetSpellInfo(18421)] = { 60000, 18421 }, -- Wizardweave Leggings
    [GetSpellInfo(23338)] = { 3000, 23338 }, -- Swift Stormsaber
    [GetSpellInfo(24913)] = { 60000, 24913 }, -- Darkrune Helm
    [GetSpellInfo(12073)] = { 60000, 12073 }, -- Black Mageweave Boots
    [GetSpellInfo(17567)] = { 1000, 17567 }, -- Summon Blood Parrot
    [GetSpellInfo(26277)] = { 3000, 26277 }, -- Elixir of Greater Firepower
    [GetSpellInfo(1179)] = { 1000, 1179 }, -- Beast Claws
    [GetSpellInfo(513)] = { 3000, 513 }, -- Earth Elemental
    [GetSpellInfo(10709)] = { 1000, 10709 }, -- Summon Prairie Dog
    [GetSpellInfo(4068)] = { 1000, 4068 }, -- Iron Grenade
    [GetSpellInfo(10617)] = { 10000, 10617 }, -- Release Rageclaw
    [GetSpellInfo(16662)] = { 60000, 16662 }, -- Thorium Leggings
    [GetSpellInfo(9993)] = { 60000, 9993 }, -- Heavy Mithril Axe
    [GetSpellInfo(10837)] = { 1000, 10837 }, -- Goblin Land Mine
    [GetSpellInfo(23220)] = { 3000, 23220 }, -- Swift Dawnsaber
    [GetSpellInfo(12589)] = { 8000, 12589 }, -- Mithril Tube
    [GetSpellInfo(1453)] = { 1000, 1453 }, -- Arcane Spirit V
    [GetSpellInfo(15649)] = { 3000, 15649 }, -- Collect Corrupted Water
    [GetSpellInfo(7893)] = { 12500, 7893 }, -- Stylish Green Shirt
    [GetSpellInfo(28732)] = { 500, 28732 }, -- Widow's Embrace
    [GetSpellInfo(443)] = { 2000, 443 }, -- Teleport Barracks
    [GetSpellInfo(2835)] = { 3000, 2835 }, -- Deadly Poison
    [GetSpellInfo(15865)] = { 3000, 15865 }, -- Mystery Stew
    [GetSpellInfo(23666)] = { 60000, 23666 }, -- Flarecore Robe
    [GetSpellInfo(507)] = { 1000, 507 }, -- Fumble II
    [GetSpellInfo(20829)] = { 1000, 20829 }, -- Arcane Bolt
    [GetSpellInfo(18241)] = { 3000, 18241 }, -- Filet of Redgill
    [GetSpellInfo(18113)] = { 4000, 18113 }, -- Manifestation Cleansing
    [GetSpellInfo(3449)] = { 3000, 3449 }, -- Shadow Oil
    [GetSpellInfo(12092)] = { 60000, 12092 }, -- Dreamweave Circlet
    [GetSpellInfo(3678)] = { 5000, 3678 }, -- Focusing
    [GetSpellInfo(12346)] = { 5000, 12346 }, -- Awaken the Soulflayer
    [GetSpellInfo(24266)] = { 3000, 24266 }, -- Gurubashi Mojo Madness
    [GetSpellInfo(28324)] = { 20000, 28324 }, -- Forming Frame of Atiesh
    [GetSpellInfo(28473)] = { 60000, 28473 }, -- Bramblewood Boots
    [GetSpellInfo(17557)] = { 3000, 17557 }, -- Elixir of Brute Force
    [GetSpellInfo(20874)] = { 60000, 20874 }, -- Dark Iron Bracers
    [GetSpellInfo(16660)] = { 60000, 16660 }, -- Dawnbringer Shoulders
    [GetSpellInfo(3859)] = { 25000, 3859 }, -- Azure Silk Vest
    [GetSpellInfo(27589)] = { 60000, 27589 }, -- Black Grasp of the Destroyer
    [GetSpellInfo(10701)] = { 1000, 10701 }, -- Summon Dart Frog
    [GetSpellInfo(10849)] = { 1000, 10849 }, -- Form of the Moonstalker (no invis)
    [GetSpellInfo(5206)] = { 5000, 5206 }, -- Plant Seeds
    [GetSpellInfo(2387)] = { 5125, 2387 }, -- Linen Cloak
    [GetSpellInfo(697)] = { 10000, 697 }, -- Summon Voidwalker
    [GetSpellInfo(28461)] = { 60000, 28461 }, -- Ironvine Breastplate
    [GetSpellInfo(12074)] = { 60000, 12074 }, -- Black Mageweave Shoulders
    [GetSpellInfo(3206)] = { 3000, 3206 }, -- Sol H
    [GetSpellInfo(19097)] = { 60000, 19097 }, -- Devilsaur Leggings
    [GetSpellInfo(12260)] = { 5125, 12260 }, -- Rough Copper Vest
    [GetSpellInfo(15463)] = { 4000, 15463 }, -- Legendary Arcane Amalgamation
    [GetSpellInfo(11343)] = { 3000, 11343 }, -- Instant Poison VI
    [GetSpellInfo(24896)] = { 3000, 24896 }, -- Create Scepter of Beckoning: Air
    [GetSpellInfo(11017)] = { 3000, 11017 }, -- Summon Witherbark Felhunter
    [GetSpellInfo(27241)] = { 1000, 27241 }, -- Summon Gurky
    [GetSpellInfo(6703)] = { 12500, 6703 }, -- Murloc Scale Breastplate
    [GetSpellInfo(7953)] = { 12500, 7953 }, -- Deviate Scale Cloak
    [GetSpellInfo(3839)] = { 5125, 3839 }, -- Bolt of Silk Cloth
    [GetSpellInfo(2333)] = { 3000, 2333 }, -- Elixir of Lesser Agility
    [GetSpellInfo(20873)] = { 60000, 20873 }, -- Fiery Chain Shoulders
    [GetSpellInfo(15303)] = { 2000, 15303 }, -- DEBUG Create Samophlange Manual
    [GetSpellInfo(3429)] = { 4000, 3429 }, -- Plague Mind
    [GetSpellInfo(10719)] = { 1000, 10719 }, -- Summon Ribbon Snake
    [GetSpellInfo(2547)] = { 3000, 2547 }, -- Redridge Goulash
    [GetSpellInfo(3953)] = { 5125, 3953 }, -- Bronze Framework
    [GetSpellInfo(2837)] = { 3000, 2837 }, -- Deadly Poison II
    [GetSpellInfo(19071)] = { 60000, 19071 }, -- Wicked Leather Headband
    [GetSpellInfo(11419)] = { 10000, 11419 }, -- Portal: Darnassus
    [GetSpellInfo(8617)] = { 2500, 8617 }, -- Skinning
    [GetSpellInfo(17646)] = { 2000, 17646 }, -- Summon Onyxia Whelp
    [GetSpellInfo(16647)] = { 60000, 16647 }, -- Imperial Plate Belt
    [GetSpellInfo(26416)] = { 5125, 26416 }, -- Small Blue Rocket
    [GetSpellInfo(11472)] = { 3000, 11472 }, -- Elixir of Giants
    [GetSpellInfo(4979)] = { 1500, 4979 }, -- Quick Flame Ward
    [GetSpellInfo(6753)] = { 1000, 6753 }, -- Backhand
    [GetSpellInfo(4069)] = { 1000, 4069 }, -- Big Iron Bomb
    [GetSpellInfo(12719)] = { 45000, 12719 }, -- Explosive Arrow
    [GetSpellInfo(9437)] = { 2000, 9437 }, -- Placing Bear Trap
    [GetSpellInfo(877)] = { 1000, 877 }, -- Elemental Fury
    [GetSpellInfo(7928)] = { 3000, 7928 }, -- Silk Bandage
    [GetSpellInfo(13982)] = { 10000, 13982 }, -- Bael'Gar's Fiery Essence
    [GetSpellInfo(19101)] = { 60000, 19101 }, -- Volcanic Shoulders
    [GetSpellInfo(9207)] = { 45000, 9207 }, -- Dusky Boots
    [GetSpellInfo(26442)] = { 12500, 26442 }, -- Firework Launcher
    [GetSpellInfo(25037)] = { 1000, 25037 }, -- Rumsey Rum Light
    [GetSpellInfo(6648)] = { 3000, 6648 }, -- Chestnut Mare
    [GetSpellInfo(6702)] = { 8000, 6702 }, -- Murloc Scale Belt
    [GetSpellInfo(3493)] = { 45000, 3493 }, -- Jade Serpentblade
    [GetSpellInfo(20897)] = { 60000, 20897 }, -- Dark Iron Destroyer
    [GetSpellInfo(3659)] = { 3000, 3659 }, -- Mage Sight
    [GetSpellInfo(20872)] = { 60000, 20872 }, -- Fiery Chain Girdle
    [GetSpellInfo(3504)] = { 45000, 3504 }, -- Green Iron Shoulders
    [GetSpellInfo(15033)] = { 2000, 15033 }, -- Summon Ancient Spirits
    [GetSpellInfo(21066)] = { 1500, 21066 }, -- Void Bolt
    [GetSpellInfo(19773)] = { 500, 19773 }, -- Elemental Fire
    [GetSpellInfo(28148)] = { 10000, 28148 }, -- Portal: Karazhan
    [GetSpellInfo(3721)] = { 2000, 3721 }, -- Teleport Altar of the Tides
    [GetSpellInfo(28891)] = { 3000, 28891 }, -- Consecrated Weapon
    [GetSpellInfo(12068)] = { 60000, 12068 }, -- Stormcloth Vest
    [GetSpellInfo(10013)] = { 60000, 10013 }, -- Ebon Shiv
    [GetSpellInfo(24091)] = { 60000, 24091 }, -- Bloodvine Vest
    [GetSpellInfo(4945)] = { 5000, 4945 }, -- Summon Dagun
    [GetSpellInfo(5166)] = { 5000, 5166 }, -- Harvest Silithid Egg
    [GetSpellInfo(20854)] = { 60000, 20854 }, -- Molten Helm
    [GetSpellInfo(10525)] = { 60000, 10525 }, -- Tough Scorpid Breastplate
    [GetSpellInfo(17015)] = { 2500, 17015 }, -- Destroy Tent
    [GetSpellInfo(2675)] = { 45000, 2675 }, -- Shining Silver Breastplate
    [GetSpellInfo(22906)] = { 3000, 22906 }, -- Plunging Blade into Onyxia
    [GetSpellInfo(12259)] = { 25000, 12259 }, -- Silvered Bronze Leggings
    [GetSpellInfo(17187)] = { 25000, 17187 }, -- Transmute: Arcanite
    [GetSpellInfo(3172)] = { 3000, 3172 }, -- Minor Magic Resistance Potion
    [GetSpellInfo(10005)] = { 60000, 10005 }, -- Dazzling Mithril Rapier
    [GetSpellInfo(3930)] = { 5125, 3930 }, -- Crafted Heavy Shot
    [GetSpellInfo(17561)] = { 25000, 17561 }, -- Transmute: Earth to Water
    [GetSpellInfo(24903)] = { 60000, 24903 }, -- Runed Stygian Boots
    [GetSpellInfo(5280)] = { 1000, 5280 }, -- Razor Mane
    [GetSpellInfo(15712)] = { 500, 15712 }, -- Linken's Boomerang
    [GetSpellInfo(23486)] = { 45000, 23486 }, -- Dimensional Ripper - Everlook
    [GetSpellInfo(11537)] = { 2000, 11537 }, -- Charge Stave of Equinex
    [GetSpellInfo(20777)] = { 10000, 20777 }, -- Ancestral Spirit
    [GetSpellInfo(10717)] = { 1000, 10717 }, -- Summon Crimson Snake
    [GetSpellInfo(2163)] = { 12500, 2163 }, -- White Leather Jerkin
    [GetSpellInfo(27588)] = { 60000, 27588 }, -- Light Obsidian Belt
    [GetSpellInfo(8797)] = { 45000, 8797 }, -- Earthen Silk Belt
    [GetSpellInfo(19047)] = { 12500, 19047 }, -- Cured Rugged Hide
    [GetSpellInfo(3569)] = { 3000, 3569 }, -- Smelt Steel
    [GetSpellInfo(8334)] = { 8000, 8334 }, -- Practice Lock
    [GetSpellInfo(17166)] = { 2000, 17166 }, -- Release Umi's Yeti
    [GetSpellInfo(7181)] = { 3000, 7181 }, -- Greater Healing Potion
    [GetSpellInfo(8211)] = { 3000, 8211 }, -- Chain Burn
    [GetSpellInfo(20752)] = { 3000, 20752 }, -- Create Soulstone (Lesser)
    [GetSpellInfo(7487)] = { 1300, 7487 }, -- Call Bleak Worg
    [GetSpellInfo(8600)] = { 4500, 8600 }, -- Fevered Plague
    [GetSpellInfo(18244)] = { 3000, 18244 }, -- Poached Sunscale Salmon
    [GetSpellInfo(26103)] = { 1500, 26103 }, -- Sweep
    [GetSpellInfo(8398)] = { 2000, 8398 }, -- Frostbolt Volley
    [GetSpellInfo(7837)] = { 5000, 7837 }, -- Fire Oil
    [GetSpellInfo(8919)] = { 2000, 8919 }, -- Fill Jennea's Flask
    [GetSpellInfo(20530)] = { 2000, 20530 }, -- Bind Chapter 2
    [GetSpellInfo(13895)] = { 4000, 13895 }, -- Summon Spawn of Bael'Gar
    [GetSpellInfo(4153)] = { 3000, 4153 }, -- Guile of the Raptor
    [GetSpellInfo(11433)] = { 2000, 11433 }, -- Death & Decay
    [GetSpellInfo(3776)] = { 45000, 3776 }, -- Green Leather Bracers
    [GetSpellInfo(968)] = { 3000, 968 }, -- Feral Spirit II
    [GetSpellInfo(22810)] = { 5000, 22810 }, -- Opening - No Text
    [GetSpellInfo(3765)] = { 25000, 3765 }, -- Dark Leather Gloves
    [GetSpellInfo(23453)] = { 10000, 23453 }, -- Gnomish Transporter
    [GetSpellInfo(23339)] = { 1000, 23339 }, -- Wing Buffet
    [GetSpellInfo(19774)] = { 10000, 19774 }, -- Summon Ragnaros
    [GetSpellInfo(25849)] = { 1000, 25849 }, -- Summon Baby Shark
    [GetSpellInfo(2662)] = { 5125, 2662 }, -- Copper Chain Pants
    [GetSpellInfo(21943)] = { 45000, 21943 }, -- Gloves of the Greatfather
    [GetSpellInfo(15114)] = { 1000, 15114 }, -- Summon Illusionary Dreamwatchers
    [GetSpellInfo(24162)] = { 4000, 24162 }, -- Falcon's Call
    [GetSpellInfo(3845)] = { 12500, 3845 }, -- Soft-soled Linen Boots
    [GetSpellInfo(18809)] = { 6000, 18809 }, -- Pyroblast
    [GetSpellInfo(9743)] = { 4000, 9743 }, -- Delete Me
    [GetSpellInfo(555)] = { 3000, 555 }, -- Feral Spirit
    [GetSpellInfo(3858)] = { 45000, 3858 }, -- Shadow Hood
    [GetSpellInfo(66)] = { 3000, 66 }, -- Lesser Invisibility
    [GetSpellInfo(9060)] = { 5125, 9060 }, -- Light Leather Quiver
    [GetSpellInfo(11661)] = { 3000, 11661 }, -- Shadow Bolt
    [GetSpellInfo(15292)] = { 45000, 15292 }, -- Dark Iron Pulverizer
    [GetSpellInfo(3848)] = { 12500, 3848 }, -- Double-stitched Woolen Shoulders
    [GetSpellInfo(3655)] = { 5000, 3655 }, -- Summon Shield Guard
    [GetSpellInfo(5512)] = { 5000, 5512 }, -- Fill Phial
    [GetSpellInfo(3856)] = { 25000, 3856 }, -- Spider Silk Slippers
    [GetSpellInfo(24377)] = { 4000, 24377 }, -- Destroy Bijou
    [GetSpellInfo(13229)] = { 3000, 13229 }, -- Wound Poison III
    [GetSpellInfo(6250)] = { 2000, 6250 }, -- Fire Cannon
    [GetSpellInfo(18446)] = { 60000, 18446 }, -- Wizardweave Robe
    [GetSpellInfo(6257)] = { 3000, 6257 }, -- Torch Toss
    [GetSpellInfo(3871)] = { 25000, 3871 }, -- Formal White Shirt
    [GetSpellInfo(9614)] = { 2000, 9614 }, -- Rift Beacon
    [GetSpellInfo(3952)] = { 12500, 3952 }, -- Minor Recombobulator
    [GetSpellInfo(7951)] = { 2500, 7951 }, -- Toxic Spit
    [GetSpellInfo(7967)] = { 2000, 7967 }, -- Naralex's Nightmare
    [GetSpellInfo(28209)] = { 60000, 28209 }, -- Glacial Wrists
    [GetSpellInfo(2368)] = { 5000, 2368 }, -- Herb Gathering
    [GetSpellInfo(13608)] = { 500, 13608 }, -- Hooked Net
    [GetSpellInfo(7279)] = { 3000, 7279 }, -- Black Sludge
    [GetSpellInfo(11654)] = { 10000, 11654 }, -- Call of Sul'thraze
    [GetSpellInfo(22732)] = { 3000, 22732 }, -- Major Rejuvenation Potion
    [GetSpellInfo(15748)] = { 500, 15748 }, -- Freeze Rookery Egg
    [GetSpellInfo(21100)] = { 1000, 21100 }, -- Conjure Elegant Letter
    [GetSpellInfo(7155)] = { 2000, 7155 }, -- CreatureSpecial
    [GetSpellInfo(2671)] = { 12500, 2671 }, -- Rough Bronze Bracers
    [GetSpellInfo(22902)] = { 60000, 22902 }, -- Mooncloth Robe
    [GetSpellInfo(1122)] = { 2000, 1122 }, -- Inferno
    [GetSpellInfo(18974)] = { 3000, 18974 }, -- Summon Lunaclaw
    [GetSpellInfo(10699)] = { 1000, 10699 }, -- Summon Bronze Whelpling
    [GetSpellInfo(7918)] = { 1000, 7918 }, -- Shoot Gun
    [GetSpellInfo(12667)] = { 4000, 12667 }, -- Soul Consumption
    [GetSpellInfo(3873)] = { 25000, 3873 }, -- Black Swashbuckler's Shirt
    [GetSpellInfo(8286)] = { 1500, 8286 }, -- Summon Boar Spirit
    [GetSpellInfo(6517)] = { 25000, 6517 }, -- Pearl-handled Dagger
    [GetSpellInfo(34)] = { 2000, 34 }, -- Teleport Duskwood
    [GetSpellInfo(24964)] = { 1000, 24964 }, -- Honor Points +378
    [GetSpellInfo(15549)] = { 1800, 15549 }, -- Chained Bolt
    [GetSpellInfo(12614)] = { 45000, 12614 }, -- Mithril Heavy-bore Rifle
    [GetSpellInfo(3319)] = { 5125, 3319 }, -- Copper Chain Boots
    [GetSpellInfo(11458)] = { 3000, 11458 }, -- Wildvine Potion
    [GetSpellInfo(10149)] = { 3500, 10149 }, -- Fireball
    [GetSpellInfo(21047)] = { 3000, 21047 }, -- Corrosive Acid Spit
    [GetSpellInfo(23140)] = { 2000, 23140 }, -- J'eevee summons object
    [GetSpellInfo(21559)] = { 2000, 21559 }, -- Shredder Armor Melt
    [GetSpellInfo(22909)] = { 2000, 22909 }, -- Eye of Immol'thar
    [GetSpellInfo(8766)] = { 45000, 8766 }, -- Azure Silk Belt
    [GetSpellInfo(24706)] = { 2000, 24706 }, -- Toss Stink Bomb
    [GetSpellInfo(20693)] = { 1000, 20693 }, -- Summon Lost Amulet
    [GetSpellInfo(20626)] = { 3000, 20626 }, -- Undermine Clam Chowder
    [GetSpellInfo(23315)] = { 2000, 23315 }, -- Ignite Flesh
    [GetSpellInfo(23530)] = { 1000, 23530 }, -- Summon Tiny Red Dragon
    [GetSpellInfo(15972)] = { 45000, 15972 }, -- Glinting Steel Dagger
    [GetSpellInfo(18402)] = { 60000, 18402 }, -- Runecloth Belt
    [GetSpellInfo(17924)] = { 6000, 17924 }, -- Soul Fire
    [GetSpellInfo(427)] = { 2000, 427 }, -- Teleport Monastery
    [GetSpellInfo(20733)] = { 2000, 20733 }, -- Black Arrow
    [GetSpellInfo(5269)] = { 2000, 5269 }, -- Defias Disguise
    [GetSpellInfo(3371)] = { 3000, 3371 }, -- Blood Sausage
    [GetSpellInfo(12897)] = { 45000, 12897 }, -- Gnomish Goggles
    [GetSpellInfo(22599)] = { 5000, 22599 }, -- Chromatic Mantle of the Dawn
    [GetSpellInfo(27725)] = { 60000, 27725 }, -- Satchel of Cenarius
    [GetSpellInfo(3117)] = { 5125, 3117 }, -- Heavy Weightstone
    [GetSpellInfo(12044)] = { 5125, 12044 }, -- Simple Linen Pants
    [GetSpellInfo(21652)] = { 10000, 21652 }, -- Closing
    [GetSpellInfo(3929)] = { 5125, 3929 }, -- Coarse Blasting Powder
    [GetSpellInfo(24874)] = { 1500, 24874 }, -- Create Crest of Beckoning: Fire
    [GetSpellInfo(8786)] = { 45000, 8786 }, -- Azure Silk Cloak
    [GetSpellInfo(5514)] = { 2000, 5514 }, -- Darken Vision
    [GetSpellInfo(2542)] = { 3000, 2542 }, -- Goretusk Liver Pie
    [GetSpellInfo(28614)] = { 500, 28614 }, -- Pointy Spike
    [GetSpellInfo(20528)] = { 1300, 20528 }, -- Mor'rogal Enchant
    [GetSpellInfo(12279)] = { 2000, 12279 }, -- Curse of Blood
    [GetSpellInfo(23665)] = { 60000, 23665 }, -- Argent Shoulders
    [GetSpellInfo(3851)] = { 25000, 3851 }, -- Phoenix Pants
    [GetSpellInfo(3957)] = { 12500, 3957 }, -- Ice Deflector
    [GetSpellInfo(19081)] = { 60000, 19081 }, -- Chimeric Vest
    [GetSpellInfo(7259)] = { 3000, 7259 }, -- Nature Protection Potion
    [GetSpellInfo(9744)] = { 4500, 9744 }, -- Jarkal's Translation
    [GetSpellInfo(895)] = { 3000, 895 }, -- Fire Elemental
    [GetSpellInfo(27830)] = { 60000, 27830 }, -- Persuader
    [GetSpellInfo(31364)] = { 500, 31364 }, -- Spice Mortar
    [GetSpellInfo(24366)] = { 3000, 24366 }, -- Greater Dreamless Sleep Potion
    [GetSpellInfo(4971)] = { 2000, 4971 }, -- Healing Ward
    [GetSpellInfo(1124)] = { 3000, 1124 }, -- Hellfire II
    [GetSpellInfo(24123)] = { 60000, 24123 }, -- Primal Batskin Bracers
    [GetSpellInfo(14532)] = { 2000, 14532 }, -- Creeper Venom
    [GetSpellInfo(16642)] = { 60000, 16642 }, -- Thorium Armor
    [GetSpellInfo(19470)] = { 5000, 19470 }, -- Gem of the Serpent
    [GetSpellInfo(7791)] = { 1000, 7791 }, -- Teleport
    [GetSpellInfo(20876)] = { 60000, 20876 }, -- Dark Iron Leggings
    [GetSpellInfo(22647)] = { 500, 22647 }, -- Empower Pet
    [GetSpellInfo(20436)] = { 2000, 20436 }, -- Drunken Pit Crew
    [GetSpellInfo(17636)] = { 25000, 17636 }, -- Flask of Distilled Wisdom
    [GetSpellInfo(24887)] = { 1500, 24887 }, -- Create Crest of Beckoning: Earth
    [GetSpellInfo(982)] = { 10000, 982 }, -- Revive Pet
    [GetSpellInfo(3718)] = { 3000, 3718 }, -- Syndicate Bomb
    [GetSpellInfo(8142)] = { 1000, 8142 }, -- Grasping Vines
    [GetSpellInfo(19103)] = { 60000, 19103 }, -- Runic Leather Shoulders
    [GetSpellInfo(18434)] = { 60000, 18434 }, -- Cindercloth Pants
    [GetSpellInfo(23231)] = { 5000, 23231 }, -- Binding Volume I
    [GetSpellInfo(10873)] = { 3000, 10873 }, -- Red Mechanostrider
    [GetSpellInfo(20875)] = { 1000, 20875 }, -- Rumsey Rum
    [GetSpellInfo(18411)] = { 60000, 18411 }, -- Frostweave Gloves
    [GetSpellInfo(6725)] = { 3000, 6725 }, -- Flame Spike
    [GetSpellInfo(18410)] = { 60000, 18410 }, -- Ghostweave Belt
    [GetSpellInfo(19084)] = { 60000, 19084 }, -- Devilsaur Gauntlets
    [GetSpellInfo(10697)] = { 1000, 10697 }, -- Summon Crimson Whelpling
    [GetSpellInfo(24264)] = { 2000, 24264 }, -- Extinguish
    [GetSpellInfo(15057)] = { 2000, 15057 }, -- Mechanical Patch Kit
    [GetSpellInfo(10686)] = { 1000, 10686 }, -- Summon Prairie Chicken
    [GetSpellInfo(932)] = { 3000, 932 }, -- Replenish Spirit II
    [GetSpellInfo(7841)] = { 3000, 7841 }, -- Swim Speed Potion
    [GetSpellInfo(24189)] = { 1000, 24189 }, -- Force Punch
    [GetSpellInfo(9064)] = { 5125, 9064 }, -- Rugged Leather Pants
    [GetSpellInfo(8804)] = { 60000, 8804 }, -- Crimson Silk Gloves
    [GetSpellInfo(10605)] = { 2500, 10605 }, -- Chain Lightning
    [GetSpellInfo(4962)] = { 2000, 4962 }, -- Encasing Webs
    [GetSpellInfo(4981)] = { 30000, 4981 }, -- Inducing Vision
    [GetSpellInfo(12619)] = { 8000, 12619 }, -- Hi-Explosive Bomb
    [GetSpellInfo(22562)] = { 3000, 22562 }, -- Fill Amethyst Phial
    [GetSpellInfo(9146)] = { 25000, 9146 }, -- Herbalist's Gloves
    [GetSpellInfo(7077)] = { 1000, 7077 }, -- Simple Teleport
    [GetSpellInfo(18408)] = { 60000, 18408 }, -- Cindercloth Vest
    [GetSpellInfo(15781)] = { 3000, 15781 }, -- Steel Mechanostrider
    [GetSpellInfo(12087)] = { 60000, 12087 }, -- Stormcloth Shoulders
    [GetSpellInfo(21923)] = { 3000, 21923 }, -- Elixir of Frost Power
    [GetSpellInfo(7364)] = { 5000, 7364 }, -- Light Torch
    [GetSpellInfo(5668)] = { 3000, 5668 }, -- Peasant Disguise
    [GetSpellInfo(25314)] = { 3000, 25314 }, -- Greater Heal
    [GetSpellInfo(9942)] = { 60000, 9942 }, -- Mithril Scale Gloves
    [GetSpellInfo(2672)] = { 12500, 2672 }, -- Patterned Bronze Bracers
    [GetSpellInfo(11477)] = { 3000, 11477 }, -- Elixir of Demonslaying
    [GetSpellInfo(25159)] = { 10000, 25159 }, -- Call Prismatic Barrier
    [GetSpellInfo(3947)] = { 5125, 3947 }, -- Crafted Solid Shot
    [GetSpellInfo(2336)] = { 3000, 2336 }, -- Elixir of Tongues
    [GetSpellInfo(2362)] = { 5000, 2362 }, -- Create Spellstone
    [GetSpellInfo(24239)] = { 1000, 24239 }, -- Hammer of Wrath
    [GetSpellInfo(2659)] = { 3000, 2659 }, -- Smelt Bronze
    [GetSpellInfo(13899)] = { 2000, 13899 }, -- Fire Storm
    [GetSpellInfo(25783)] = { 2000, 25783 }, -- Place Arcanite Buoy
    [GetSpellInfo(24576)] = { 3000, 24576 }, -- Chromatic Mount
    [GetSpellInfo(10706)] = { 1000, 10706 }, -- Summon Hawk Owl
    [GetSpellInfo(28697)] = { 1000, 28697 }, -- Forgiveness
    [GetSpellInfo(2601)] = { 1000, 2601 }, -- Fire Shield III
    [GetSpellInfo(22718)] = { 3000, 22718 }, -- Black War Kodo
    [GetSpellInfo(25841)] = { 1000, 25841 }, -- Prayer of Elune
    [GetSpellInfo(16798)] = { 1000, 16798 }, -- Enchanting Lullaby
    [GetSpellInfo(5265)] = { 3000, 5265 }, -- Stonesplinter Trogg Disguise
    [GetSpellInfo(16596)] = { 1000, 16596 }, -- Flames of Shahram
    [GetSpellInfo(20755)] = { 3000, 20755 }, -- Create Soulstone
    [GetSpellInfo(8681)] = { 3000, 8681 }, -- Instant Poison
    [GetSpellInfo(6693)] = { 45000, 6693 }, -- Green Silk Pack
    [GetSpellInfo(28353)] = { 2000, 28353 }, -- Raise Dead
    [GetSpellInfo(30021)] = { 3000, 30021 }, -- Crystal Infused Bandage
    [GetSpellInfo(15293)] = { 45000, 15293 }, -- Dark Iron Mail
    [GetSpellInfo(8809)] = { 1000, 8809 }, -- Slave Drain
    [GetSpellInfo(3275)] = { 3000, 3275 }, -- Linen Bandage
    [GetSpellInfo(28222)] = { 60000, 28222 }, -- Icy Scale Breastplate
    [GetSpellInfo(28208)] = { 60000, 28208 }, -- Glacial Cloak
    [GetSpellInfo(26011)] = { 60000, 26011 }, -- Tranquil Mechanical Yeti
    [GetSpellInfo(4130)] = { 1000, 4130 }, -- Banish Burning Exile
    [GetSpellInfo(2329)] = { 3000, 2329 }, -- Elixir of Lion's Strength
    [GetSpellInfo(13478)] = { 5000, 13478 }, -- Opening Relic Coffer
    [GetSpellInfo(13583)] = { 2000, 13583 }, -- Curse of the Deadwood
    [GetSpellInfo(18571)] = { 250, 18571 }, -- Breath
    [GetSpellInfo(8090)] = { 5000, 8090 }, -- Bright Baubles
    [GetSpellInfo(17505)] = { 1000, 17505 }, -- Curse of Timmy
    [GetSpellInfo(9095)] = { 2000, 9095 }, -- Cantation of Manifestation
    [GetSpellInfo(3950)] = { 8000, 3950 }, -- Big Bronze Bomb
    [GetSpellInfo(3979)] = { 25000, 3979 }, -- Accurate Scope
    [GetSpellInfo(23082)] = { 45000, 23082 }, -- Ultra-Flash Shadow Reflector
    [GetSpellInfo(3651)] = { 1000, 3651 }, -- Shield of Reflection
    [GetSpellInfo(20650)] = { 8000, 20650 }, -- Thick Leather
    [GetSpellInfo(10675)] = { 1000, 10675 }, -- Summon Maine Coon
    [GetSpellInfo(512)] = { 1300, 512 }, -- Chains of Ice
    [GetSpellInfo(15869)] = { 2000, 15869 }, -- Superior Healing Ward
    [GetSpellInfo(2403)] = { 25000, 2403 }, -- Gray Woolen Robe
    [GetSpellInfo(5884)] = { 2000, 5884 }, -- Banshee Curse
    [GetSpellInfo(2401)] = { 12500, 2401 }, -- Woolen Boots
    [GetSpellInfo(12090)] = { 60000, 12090 }, -- Stormcloth Boots
    [GetSpellInfo(3940)] = { 25000, 3940 }, -- Shadow Goggles
    [GetSpellInfo(22813)] = { 60000, 22813 }, -- Gordok Ogre Suit
    [GetSpellInfo(10685)] = { 1000, 10685 }, -- Summon Ancona
    [GetSpellInfo(14125)] = { 5000, 14125 }, -- Opening Secret Safe
    [GetSpellInfo(15933)] = { 3000, 15933 }, -- Monster Omelet
    [GetSpellInfo(10451)] = { 10000, 10451 }, -- Implosion
    [GetSpellInfo(23081)] = { 45000, 23081 }, -- Hyper-Radiant Flame Reflector
    [GetSpellInfo(7355)] = { 10000, 7355 }, -- Stuck
    [GetSpellInfo(24962)] = { 1000, 24962 }, -- Honor Points +138
    [GetSpellInfo(12755)] = { 12500, 12755 }, -- Goblin Bomb Dispenser
    [GetSpellInfo(2386)] = { 8000, 2386 }, -- Linen Boots
    [GetSpellInfo(6814)] = { 2000, 6814 }, -- Sludge Toxin
    [GetSpellInfo(4094)] = { 3000, 4094 }, -- Barbecued Buzzard Wing
    [GetSpellInfo(11464)] = { 3000, 11464 }, -- Invisibility Potion
    [GetSpellInfo(28462)] = { 60000, 28462 }, -- Ironvine Gloves
    [GetSpellInfo(10850)] = { 2000, 10850 }, -- Powerful Smelling Salts
    [GetSpellInfo(16664)] = { 60000, 16664 }, -- Runic Plate Shoulders
    [GetSpellInfo(16978)] = { 60000, 16978 }, -- Blazing Rapier
    [GetSpellInfo(16381)] = { 10000, 16381 }, -- Summon Rockwing Gargoyles
    [GetSpellInfo(2153)] = { 5125, 2153 }, -- Handstitched Leather Pants
    [GetSpellInfo(3421)] = { 3000, 3421 }, -- Crippling Poison II
    [GetSpellInfo(25121)] = { 3000, 25121 }, -- Wizard Oil
    [GetSpellInfo(7258)] = { 3000, 7258 }, -- Frost Protection Potion
    [GetSpellInfo(18831)] = { 3000, 18831 }, -- Conjure Lily Root
    [GetSpellInfo(6441)] = { 5000, 6441 }, -- Explosive Shells
    [GetSpellInfo(24418)] = { 3000, 24418 }, -- Heavy Crocolisk Stew
    [GetSpellInfo(855)] = { 1000, 855 }, -- Feeblemind III
    [GetSpellInfo(3372)] = { 3000, 3372 }, -- Murloc Fin Soup
    [GetSpellInfo(17560)] = { 25000, 17560 }, -- Transmute: Fire to Earth
    [GetSpellInfo(10507)] = { 60000, 10507 }, -- Nightscape Headband
    [GetSpellInfo(21097)] = { 2000, 21097 }, -- Manastorm
    [GetSpellInfo(24890)] = { 2000, 24890 }, -- Create Signet of Beckoning: Air
    [GetSpellInfo(9937)] = { 60000, 9937 }, -- Mithril Scale Bracers
    [GetSpellInfo(10516)] = { 45000, 10516 }, -- Nightscape Shoulders
    [GetSpellInfo(9987)] = { 12500, 9987 }, -- Bronze Battle Axe
    [GetSpellInfo(21648)] = { 10000, 21648 }, -- Call to Ivus
    [GetSpellInfo(11437)] = { 5000, 11437 }, -- Opening Chest
    [GetSpellInfo(18457)] = { 60000, 18457 }, -- Robe of the Archmage
    [GetSpellInfo(2396)] = { 8000, 2396 }, -- Green Linen Shirt
    [GetSpellInfo(5669)] = { 3000, 5669 }, -- Peon Disguise
    [GetSpellInfo(3333)] = { 25000, 3333 }, -- Silvered Bronze Gauntlets
    [GetSpellInfo(2657)] = { 3000, 2657 }, -- Smelt Copper
    [GetSpellInfo(22717)] = { 3000, 22717 }, -- Black War Steed
    [GetSpellInfo(27871)] = { 1500, 27871 }, -- Lightwell
    [GetSpellInfo(21154)] = { 500, 21154 }, -- Might of Ragnaros
    [GetSpellInfo(7949)] = { 1500, 7949 }, -- Summon Viper
    [GetSpellInfo(18541)] = { 10000, 18541 }, -- Ritual of Doom Effect
    [GetSpellInfo(18987)] = { 1000, 18987 }, -- Create Relic Bundle
    [GetSpellInfo(12699)] = { 2000, 12699 }, -- Summon Screecher Spirit
    [GetSpellInfo(5159)] = { 1500, 5159 }, -- Melt Ore
    [GetSpellInfo(24160)] = { 4000, 24160 }, -- Syncretist's Sigil
    [GetSpellInfo(19063)] = { 60000, 19063 }, -- Chimeric Boots
    [GetSpellInfo(3109)] = { 1000, 3109 }, -- Presence of Death
    [GetSpellInfo(5781)] = { 1000, 5781 }, -- Threatening Growl
    [GetSpellInfo(28480)] = { 60000, 28480 }, -- Sylvan Vest
    [GetSpellInfo(8780)] = { 25000, 8780 }, -- Hands of Darkness
    [GetSpellInfo(3450)] = { 5000, 3450 }, -- Elixir of Fortitude
    [GetSpellInfo(17462)] = { 3000, 17462 }, -- Red Skeletal Horse
    [GetSpellInfo(24967)] = { 500, 24967 }, -- Gong
    [GetSpellInfo(33)] = { 2000, 33 }, -- Teleport Westfall
    [GetSpellInfo(28304)] = { 3000, 28304 }, -- Copy of Healing Wave
    [GetSpellInfo(3918)] = { 5125, 3918 }, -- Rough Blasting Powder
    [GetSpellInfo(9995)] = { 60000, 9995 }, -- Blue Glittering Axe
    [GetSpellInfo(21180)] = { 10000, 21180 }, -- Summon Thunderstrike
    [GetSpellInfo(25954)] = { 3000, 25954 }, -- Sagefish Delight
    [GetSpellInfo(23531)] = { 1000, 23531 }, -- Summon Tiny Green Dragon
    [GetSpellInfo(19054)] = { 60000, 19054 }, -- Red Dragonscale Breastplate
    [GetSpellInfo(16153)] = { 3000, 16153 }, -- Smelt Thorium
    [GetSpellInfo(6624)] = { 3000, 6624 }, -- Free Action Potion
    [GetSpellInfo(10680)] = { 1000, 10680 }, -- Summon Cockatiel
    [GetSpellInfo(27660)] = { 60000, 27660 }, -- Big Bag of Enchantment
    [GetSpellInfo(17496)] = { 1000, 17496 }, -- Crest of Retribution
    [GetSpellInfo(9979)] = { 60000, 9979 }, -- Ornate Mithril Boots
    [GetSpellInfo(13912)] = { 10000, 13912 }, -- Princess Summons Portal
    [GetSpellInfo(2831)] = { 3000, 2831 }, -- Armor +8
    [GetSpellInfo(9065)] = { 5125, 9065 }, -- Light Leather Bracers
    [GetSpellInfo(2670)] = { 12500, 2670 }, -- Rough Bronze Cuirass
    [GetSpellInfo(24139)] = { 60000, 24139 }, -- Darksoul Breastplate
    [GetSpellInfo(2539)] = { 3000, 2539 }, -- Spiced Wolf Meat
    [GetSpellInfo(5316)] = { 5000, 5316 }, -- Raptor Feather
    [GetSpellInfo(25150)] = { 2000, 25150 }, -- Molten Rain
    [GetSpellInfo(24654)] = { 60000, 24654 }, -- Blue Dragonscale Leggings
    [GetSpellInfo(24121)] = { 60000, 24121 }, -- Primal Batskin Jerkin
    [GetSpellInfo(4221)] = { 1000, 4221 }, -- Healing Tongue II
    [GetSpellInfo(3959)] = { 12500, 3959 }, -- Discombobulator Ray
    [GetSpellInfo(19250)] = { 3000, 19250 }, -- Placing Smokey's Explosives
    [GetSpellInfo(18417)] = { 60000, 18417 }, -- Runecloth Gloves
    [GetSpellInfo(20702)] = { 1500, 20702 }, -- Summon Treant Allies
    [GetSpellInfo(4062)] = { 1000, 4062 }, -- Heavy Dynamite
    [GetSpellInfo(26428)] = { 5125, 26428 }, -- Large Red Rocket Cluster
    [GetSpellInfo(20274)] = { 5000, 20274 }, -- Capturing Termites
    [GetSpellInfo(11975)] = { 1500, 11975 }, -- Arcane Explosion
    [GetSpellInfo(11438)] = { 2000, 11438 }, -- Join Map Fragments
    [GetSpellInfo(3205)] = { 3000, 3205 }, -- Sol M
    [GetSpellInfo(23392)] = { 2000, 23392 }, -- Boulder
    [GetSpellInfo(16554)] = { 2500, 16554 }, -- Toxic Bolt
    [GetSpellInfo(6518)] = { 25000, 6518 }, -- Iridescent Hammer
    [GetSpellInfo(23662)] = { 60000, 23662 }, -- Wisdom of the Timbermaw
    [GetSpellInfo(3511)] = { 45000, 3511 }, -- Golden Scale Cuirass
    [GetSpellInfo(18647)] = { 1500, 18647 }, -- Banish
    [GetSpellInfo(10007)] = { 60000, 10007 }, -- Phantom Blade
    [GetSpellInfo(21939)] = { 1500, 21939 }, -- Create Scepter of Celebras
    [GetSpellInfo(23667)] = { 60000, 23667 }, -- Flarecore Leggings
    [GetSpellInfo(10558)] = { 60000, 10558 }, -- Nightscape Boots
    [GetSpellInfo(10619)] = { 60000, 10619 }, -- Dragonscale Gauntlets
    [GetSpellInfo(24163)] = { 4000, 24163 }, -- Vodouisant's Vigilant Embrace
    [GetSpellInfo(10166)] = { 10000, 10166 }, -- Khadgar's Unlocking
    [GetSpellInfo(8593)] = { 10000, 8593 }, -- Symbol of Life
    [GetSpellInfo(7153)] = { 45000, 7153 }, -- Guardian Cloak
    [GetSpellInfo(17181)] = { 12500, 17181 }, -- Enchanted Leather
    [GetSpellInfo(22927)] = { 60000, 22927 }, -- Hide of the Wild
    [GetSpellInfo(8243)] = { 8000, 8243 }, -- Flash Bomb
    [GetSpellInfo(4097)] = { 45000, 4097 }, -- Raptor Hide Belt
    [GetSpellInfo(24367)] = { 3000, 24367 }, -- Living Action Potion
    [GetSpellInfo(12621)] = { 8000, 12621 }, -- Mithril Gyro-Shot
    [GetSpellInfo(25839)] = { 1000, 25839 }, -- Mass Healing
    [GetSpellInfo(23125)] = { 1000, 23125 }, -- Orcish Orphan Whistle
    [GetSpellInfo(10715)] = { 1000, 10715 }, -- Summon Blue Racer
    [GetSpellInfo(16613)] = { 5000, 16613 }, -- Displacing Temporal Rift
    [GetSpellInfo(2548)] = { 3000, 2548 }, -- Succulent Pork Ribs
    [GetSpellInfo(5161)] = { 3000, 5161 }, -- Revive Dig Rat
    [GetSpellInfo(16502)] = { 1000, 16502 }, -- Release Winna's Kitten
    [GetSpellInfo(785)] = { 500, 785 }, -- True Fulfillment
    [GetSpellInfo(16990)] = { 60000, 16990 }, -- Arcanite Champion
    [GetSpellInfo(25292)] = { 2500, 25292 }, -- Holy Light
    [GetSpellInfo(27552)] = { 1000, 27552 }, -- Cupid's Arrow
    [GetSpellInfo(10396)] = { 3000, 10396 }, -- Healing Wave
    [GetSpellInfo(9143)] = { 2000, 9143 }, -- Bomb
    [GetSpellInfo(9269)] = { 12500, 9269 }, -- Gnomish Universal Remote
    [GetSpellInfo(9900)] = { 3000, 9900 }, -- Sharpen Blade IV
    [GetSpellInfo(8770)] = { 60000, 8770 }, -- Robe of Power
    [GetSpellInfo(7488)] = { 1300, 7488 }, -- Call Slavering Worg
    [GetSpellInfo(26234)] = { 1500, 26234 }, -- Submerge Visual
    [GetSpellInfo(18405)] = { 60000, 18405 }, -- Runecloth Bag
    [GetSpellInfo(12189)] = { 500, 12189 }, -- Summon Echeyakee
    [GetSpellInfo(6529)] = { 5000, 6529 }, -- Opening Benedict's Chest
    [GetSpellInfo(17618)] = { 2000, 17618 }, -- Summon Risen Lackey
    [GetSpellInfo(29334)] = { 1000, 29334 }, -- Toasted Smorc
    [GetSpellInfo(12077)] = { 25000, 12077 }, -- Simple Black Dress
    [GetSpellInfo(16984)] = { 60000, 16984 }, -- Volcanic Hammer
    [GetSpellInfo(16967)] = { 60000, 16967 }, -- Inlaid Thorium Hammer
    [GetSpellInfo(23675)] = { 100, 23675 }, -- Minigun
    [GetSpellInfo(16590)] = { 2000, 16590 }, -- Summon Zombie
    [GetSpellInfo(11605)] = { 1500, 11605 }, -- Slam
    [GetSpellInfo(17680)] = { 500, 17680 }, -- Spirit Spawn-out
    [GetSpellInfo(24846)] = { 60000, 24846 }, -- Spitfire Bracers
    [GetSpellInfo(14227)] = { 2500, 14227 }, -- Signing
    [GetSpellInfo(10346)] = { 500, 10346 }, -- Machine Gun
    [GetSpellInfo(19091)] = { 60000, 19091 }, -- Runic Leather Pants
    [GetSpellInfo(6278)] = { 3000, 6278 }, -- Creeping Mold
    [GetSpellInfo(24891)] = { 2000, 24891 }, -- Create Signet of Beckoning: Earth
    [GetSpellInfo(3842)] = { 12500, 3842 }, -- Handstitched Linen Britches
    [GetSpellInfo(23650)] = { 60000, 23650 }, -- Ebon Hand
    [GetSpellInfo(7098)] = { 1000, 7098 }, -- Curse of Mending
    [GetSpellInfo(28205)] = { 60000, 28205 }, -- Glacial Gloves
    [GetSpellInfo(24122)] = { 60000, 24122 }, -- Primal Batskin Gloves
    [GetSpellInfo(3233)] = { 1500, 3233 }, -- Evil Eye
    [GetSpellInfo(24140)] = { 60000, 24140 }, -- Darksoul Leggings
    [GetSpellInfo(17551)] = { 3000, 17551 }, -- Stonescale Oil
    [GetSpellInfo(18969)] = { 2000, 18969 }, -- Taelan Death
    [GetSpellInfo(10560)] = { 60000, 10560 }, -- Big Voodoo Pants
    [GetSpellInfo(3436)] = { 2000, 3436 }, -- Wandering Plague
    [GetSpellInfo(16869)] = { 1500, 16869 }, -- Ice Tomb
    [GetSpellInfo(12716)] = { 25000, 12716 }, -- Goblin Mortar
    [GetSpellInfo(10674)] = { 1000, 10674 }, -- Summon Cornish Rex
    [GetSpellInfo(26279)] = { 60000, 26279 }, -- Stormshroud Gloves
    [GetSpellInfo(15647)] = { 2000, 15647 }, -- Summon Common Kitten
    [GetSpellInfo(21945)] = { 25000, 21945 }, -- Green Holiday Shirt
    [GetSpellInfo(19788)] = { 8000, 19788 }, -- Dense Blasting Powder
    [GetSpellInfo(12599)] = { 8000, 12599 }, -- Mithril Casing
    [GetSpellInfo(7892)] = { 12500, 7892 }, -- Stylish Blue Shirt
    [GetSpellInfo(2737)] = { 5125, 2737 }, -- Copper Mace
    [GetSpellInfo(24314)] = { 2000, 24314 }, -- Threatening Gaze
    [GetSpellInfo(8912)] = { 600, 8912 }, -- Forge Verigan's Fist
    [GetSpellInfo(26299)] = { 2000, 26299 }, -- Create Cluster Rocket Launcher
    [GetSpellInfo(14887)] = { 3000, 14887 }, -- Shadow Bolt Volley
    [GetSpellInfo(455)] = { 3000, 455 }, -- Replenish Spirit
    [GetSpellInfo(25659)] = { 3000, 25659 }, -- Dirge's Kickin' Chimaerok Chops
    [GetSpellInfo(24940)] = { 12500, 24940 }, -- Black Whelp Tunic
    [GetSpellInfo(11534)] = { 2000, 11534 }, -- Leper Cure!
    [GetSpellInfo(19067)] = { 60000, 19067 }, -- Stormshroud Pants
    [GetSpellInfo(9921)] = { 5125, 9921 }, -- Solid Weightstone
    [GetSpellInfo(18401)] = { 12500, 18401 }, -- Bolt of Runecloth
    [GetSpellInfo(5395)] = { 3000, 5395 }, -- Death Capsule
    [GetSpellInfo(16729)] = { 60000, 16729 }, -- Lionheart Helm
    [GetSpellInfo(25722)] = { 1000, 25722 }, -- Rumsey Rum Dark
    [GetSpellInfo(9457)] = { 500, 9457 }, -- Tharnariun's Heal
    [GetSpellInfo(17952)] = { 3000, 17952 }, -- Create Firestone (Greater)
    [GetSpellInfo(445)] = { 2000, 445 }, -- Teleport Darkshire
    [GetSpellInfo(7257)] = { 3000, 7257 }, -- Fire Protection Potion
    [GetSpellInfo(17950)] = { 1000, 17950 }, -- Shadow Portal
    [GetSpellInfo(10570)] = { 60000, 10570 }, -- Tough Scorpid Helm
    [GetSpellInfo(6115)] = { 2000, 6115 }, -- Far Sight (PT)
    [GetSpellInfo(6894)] = { 2000, 6894 }, -- Death Bed
    [GetSpellInfo(14380)] = { 8000, 14380 }, -- Truesilver Rod
    [GetSpellInfo(6252)] = { 5000, 6252 }, -- Southsea Cannon Fire
    [GetSpellInfo(3121)] = { 3000, 3121 }, -- Kev
    [GetSpellInfo(17465)] = { 3000, 17465 }, -- Green Skeletal Warhorse
    [GetSpellInfo(7992)] = { 1000, 7992 }, -- Slowing Poison
    [GetSpellInfo(12151)] = { 1000, 12151 }, -- Summon Atal'ai Skeleton
    [GetSpellInfo(2162)] = { 8000, 2162 }, -- Embossed Leather Cloak
    [GetSpellInfo(24124)] = { 60000, 24124 }, -- Blood Tiger Breastplate
    [GetSpellInfo(8682)] = { 2000, 8682 }, -- Fake Shot
    [GetSpellInfo(10546)] = { 60000, 10546 }, -- Wild Leather Helmet
    [GetSpellInfo(23151)] = { 10000, 23151 }, -- Balance of Light and Shadow
    [GetSpellInfo(10216)] = { 3000, 10216 }, -- Flamestrike
    [GetSpellInfo(27608)] = { 1500, 27608 }, -- Flash Heal
    [GetSpellInfo(17169)] = { 2000, 17169 }, -- Summon Carrion Scarab
    [GetSpellInfo(8277)] = { 1000, 8277 }, -- Voodoo Hex
    [GetSpellInfo(134)] = { 1000, 134 }, -- Fire Shield
    [GetSpellInfo(14379)] = { 8000, 14379 }, -- Golden Rod
    [GetSpellInfo(5137)] = { 2000, 5137 }, -- Call of the Grave
    [GetSpellInfo(22761)] = { 3000, 22761 }, -- Runn Tum Tuber Surprise
    [GetSpellInfo(23636)] = { 60000, 23636 }, -- Dark Iron Helm
    [GetSpellInfo(19943)] = { 1500, 19943 }, -- Flash of Light
    [GetSpellInfo(18702)] = { 2000, 18702 }, -- Curse of the Darkmaster
    [GetSpellInfo(26425)] = { 5125, 26425 }, -- Red Rocket Cluster
    [GetSpellInfo(16531)] = { 10000, 16531 }, -- Summon Frail Skeleton
    [GetSpellInfo(9814)] = { 45000, 9814 }, -- Barbaric Iron Helm
    [GetSpellInfo(16663)] = { 60000, 16663 }, -- Imperial Plate Chest
    [GetSpellInfo(3297)] = { 25000, 3297 }, -- Mighty Iron Hammer
    [GetSpellInfo(17231)] = { 1000, 17231 }, -- Summon Illusory Wraith
    [GetSpellInfo(18424)] = { 60000, 18424 }, -- Frostweave Pants
    [GetSpellInfo(3321)] = { 8000, 3321 }, -- Copper Chain Vest
    [GetSpellInfo(6692)] = { 25000, 6692 }, -- Robes of Arcana
    [GetSpellInfo(12061)] = { 45000, 12061 }, -- Orange Mageweave Shirt
    [GetSpellInfo(17570)] = { 3000, 17570 }, -- Greater Stoneshield Potion
    [GetSpellInfo(4239)] = { 5000, 4239 }, -- Activating Defenses
    [GetSpellInfo(25004)] = { 2000, 25004 }, -- Throw Nightmare Object
    [GetSpellInfo(11420)] = { 10000, 11420 }, -- Portal: Thunder Bluff
    [GetSpellInfo(23067)] = { 5125, 23067 }, -- Blue Firework
    [GetSpellInfo(19072)] = { 60000, 19072 }, -- Runic Leather Belt
    [GetSpellInfo(17820)] = { 1500, 17820 }, -- Veil of Shadow
    [GetSpellInfo(8322)] = { 12500, 8322 }, -- Moonglow Vest
    [GetSpellInfo(18404)] = { 60000, 18404 }, -- Frostweave Robe
    [GetSpellInfo(10459)] = { 10000, 10459 }, -- Sacrifice Spinneret
    [GetSpellInfo(25316)] = { 3000, 25316 }, -- Prayer of Healing
    [GetSpellInfo(6957)] = { 1000, 6957 }, -- Frostmane Strength
    [GetSpellInfo(6897)] = { 3000, 6897 }, -- Blue Ram
    [GetSpellInfo(3941)] = { 8000, 3941 }, -- Small Bronze Bomb
    [GetSpellInfo(16168)] = { 1500, 16168 }, -- Flame Buffet
    [GetSpellInfo(9636)] = { 1500, 9636 }, -- Summon Swamp Spirit
    [GetSpellInfo(6695)] = { 45000, 6695 }, -- Black Silk Pack
    [GetSpellInfo(12620)] = { 45000, 12620 }, -- Sniper Scope
    [GetSpellInfo(21425)] = { 1000, 21425 }, -- Ryson's Eye in the Sky
    [GetSpellInfo(12624)] = { 45000, 12624 }, -- Mithril Mechanical Dragonling
    [GetSpellInfo(27662)] = { 1000, 27662 }, -- Throw Cupid's Dart
    [GetSpellInfo(9513)] = { 3000, 9513 }, -- Thistle Tea
    [GetSpellInfo(19800)] = { 8000, 19800 }, -- Thorium Shells
    [GetSpellInfo(9985)] = { 12500, 9985 }, -- Bronze Warhammer
    [GetSpellInfo(23680)] = { 3000, 23680 }, -- Portals Deck
    [GetSpellInfo(28220)] = { 60000, 28220 }, -- Polar Gloves
    [GetSpellInfo(3969)] = { 45000, 3969 }, -- Mechanical Dragonling
    [GetSpellInfo(17574)] = { 3000, 17574 }, -- Greater Fire Protection Potion
    [GetSpellInfo(16994)] = { 60000, 16994 }, -- Arcanite Reaper
    [GetSpellInfo(7149)] = { 45000, 7149 }, -- Barbaric Leggings
    [GetSpellInfo(16597)] = { 1000, 16597 }, -- Curse of Shahram
    [GetSpellInfo(3561)] = { 10000, 3561 }, -- Teleport: Stormwind
    [GetSpellInfo(7623)] = { 8000, 7623 }, -- Brown Linen Robe
    [GetSpellInfo(23243)] = { 3000, 23243 }, -- Swift Orange Raptor
    [GetSpellInfo(17527)] = { 3000, 17527 }, -- Mighty Rage Potion
    [GetSpellInfo(6620)] = { 3000, 6620 }, -- Place Toxic Fogger
    [GetSpellInfo(2546)] = { 3000, 2546 }, -- Dry Pork Ribs
    [GetSpellInfo(11480)] = { 25000, 11480 }, -- Transmute: Mithril to Truesilver
    [GetSpellInfo(19814)] = { 12500, 19814 }, -- Masterwork Target Dummy
    [GetSpellInfo(8793)] = { 45000, 8793 }, -- Crimson Silk Shoulders
    [GetSpellInfo(10344)] = { 3000, 10344 }, -- Armor +32
    [GetSpellInfo(12046)] = { 5125, 12046 }, -- Simple Kilt
    [GetSpellInfo(16639)] = { 8000, 16639 }, -- Dense Grinding Stone
    [GetSpellInfo(9268)] = { 1000, 9268 }, -- Teleport to Darnassus - Event
    [GetSpellInfo(29116)] = { 2500, 29116 }, -- Toast Smorc
    [GetSpellInfo(16742)] = { 60000, 16742 }, -- Enchanted Thorium Helm
    [GetSpellInfo(26063)] = { 1500, 26063 }, -- Ouro Submerge Visual
    [GetSpellInfo(21161)] = { 60000, 21161 }, -- Sulfuron Hammer
    [GetSpellInfo(11451)] = { 3000, 11451 }, -- Oil of Immolation
    [GetSpellInfo(19830)] = { 60000, 19830 }, -- Arcanite Dragonling
    [GetSpellInfo(3332)] = { 1000, 3332 }, -- Slow Poison
    [GetSpellInfo(17553)] = { 3000, 17553 }, -- Superior Mana Potion
    [GetSpellInfo(3954)] = { 25000, 3954 }, -- Moonsight Rifle
    [GetSpellInfo(3767)] = { 25000, 3767 }, -- Hillman's Belt
    [GetSpellInfo(9196)] = { 45000, 9196 }, -- Dusky Leather Armor
    [GetSpellInfo(20568)] = { 2900, 20568 }, -- Ragnaros Emerge
    [GetSpellInfo(18453)] = { 60000, 18453 }, -- Felcloth Shoulders
    [GetSpellInfo(15296)] = { 45000, 15296 }, -- Dark Iron Plate
    [GetSpellInfo(7935)] = { 3000, 7935 }, -- Strong Anti-Venom
    [GetSpellInfo(16980)] = { 60000, 16980 }, -- Rune Edge
    [GetSpellInfo(10096)] = { 3000, 10096 }, -- Shrink
    [GetSpellInfo(18559)] = { 5000, 18559 }, -- Demon Pick
    [GetSpellInfo(7761)] = { 1500, 7761 }, -- Shared Bonds
    [GetSpellInfo(23000)] = { 1000, 23000 }, -- Ez-Thro Dynamite
    [GetSpellInfo(18450)] = { 60000, 18450 }, -- Wizardweave Turban
    [GetSpellInfo(3204)] = { 5000, 3204 }, -- Sapper Explode
    [GetSpellInfo(9783)] = { 3000, 9783 }, -- Mithril Spurs
    [GetSpellInfo(9194)] = { 12500, 9194 }, -- Heavy Leather Ammo Pouch
    [GetSpellInfo(3961)] = { 8000, 3961 }, -- Gyrochronatom
    [GetSpellInfo(8532)] = { 5000, 8532 }, -- Aquadynamic Fish Lens
    [GetSpellInfo(7994)] = { 2000, 7994 }, -- Nullify Mana
    [GetSpellInfo(8001)] = { 5000, 8001 }, -- Placing Pendant
    [GetSpellInfo(8352)] = { 2000, 8352 }, -- Adjust Attitude
    [GetSpellInfo(12064)] = { 45000, 12064 }, -- Orange Martial Shirt
    [GetSpellInfo(7395)] = { 2000, 7395 }, -- Deadmines Dynamite
    [GetSpellInfo(16731)] = { 60000, 16731 }, -- Runic Breastplate
    [GetSpellInfo(3363)] = { 3000, 3363 }, -- Summon Riding Gryphon
    [GetSpellInfo(12421)] = { 1000, 12421 }, -- Mithril Frag Bomb
    [GetSpellInfo(16960)] = { 60000, 16960 }, -- Thorium Greatsword
    [GetSpellInfo(22661)] = { 1500, 22661 }, -- Enervate
    [GetSpellInfo(10702)] = { 1000, 10702 }, -- Summon Island Frog
    [GetSpellInfo(11760)] = { 3000, 11760 }, -- Hyena Sample
    [GetSpellInfo(12808)] = { 3000, 12808 }, -- Getting Tide Pool Sample #4
    [GetSpellInfo(30081)] = { 2000, 30081 }, -- Retching Plague
    [GetSpellInfo(11410)] = { 1500, 11410 }, -- Whirling Barrage
    [GetSpellInfo(28463)] = { 60000, 28463 }, -- Ironvine Belt
    [GetSpellInfo(3505)] = { 45000, 3505 }, -- Golden Scale Shoulders
    [GetSpellInfo(21537)] = { 5000, 21537 }, -- Planting Ryson's Beacon
    [GetSpellInfo(12607)] = { 45000, 12607 }, -- Catseye Ultra Goggles
    [GetSpellInfo(22795)] = { 60000, 22795 }, -- Core Marksman Rifle
    [GetSpellInfo(6310)] = { 1500, 6310 }, -- Divining Scroll Spell
    [GetSpellInfo(11730)] = { 3000, 11730 }, -- Create Healthstone (Major)
    [GetSpellInfo(3563)] = { 10000, 3563 }, -- Teleport: Undercity
    [GetSpellInfo(23246)] = { 3000, 23246 }, -- Purple Skeletal Warhorse
    [GetSpellInfo(18455)] = { 60000, 18455 }, -- Bottomless Bag
    [GetSpellInfo(7821)] = { 2000, 7821 }, -- Transform Victim
    [GetSpellInfo(11513)] = { 2000, 11513 }, -- Empty Phial
    [GetSpellInfo(3915)] = { 5125, 3915 }, -- Brown Linen Shirt
    [GetSpellInfo(2602)] = { 1000, 2602 }, -- Fire Shield IV
    [GetSpellInfo(6418)] = { 3000, 6418 }, -- Crispy Lizard Tail
    [GetSpellInfo(15495)] = { 1000, 15495 }, -- Explosive Shot
    [GetSpellInfo(3296)] = { 25000, 3296 }, -- Heavy Bronze Mace
    [GetSpellInfo(6535)] = { 3000, 6535 }, -- Lightning Cloud
    [GetSpellInfo(29480)] = { 5000, 29480 }, -- Fortitude of the Scourge
    [GetSpellInfo(12049)] = { 60000, 12049 }, -- Black Mageweave Leggings
    [GetSpellInfo(26167)] = { 5000, 26167 }, -- Colossal Smash
    [GetSpellInfo(9058)] = { 5125, 9058 }, -- Handstitched Leather Cloak
    [GetSpellInfo(3753)] = { 5125, 3753 }, -- Handstitched Leather Belt
    [GetSpellInfo(20737)] = { 500, 20737 }, -- Summon Karang's Banner
    [GetSpellInfo(24960)] = { 1000, 24960 }, -- Honor Points +50
    [GetSpellInfo(2673)] = { 25000, 2673 }, -- Silvered Bronze Breastplate
    [GetSpellInfo(6354)] = { 2000, 6354 }, -- Venom's Bane
    [GetSpellInfo(21953)] = { 1000, 21953 }, -- The Feast of Winter Veil
    [GetSpellInfo(22790)] = { 1000, 22790 }, -- Kreeg's Stout Beatdown
    [GetSpellInfo(9916)] = { 25000, 9916 }, -- Steel Breastplate
    [GetSpellInfo(8901)] = { 1000, 8901 }, -- Gas Bomb
    [GetSpellInfo(9059)] = { 5125, 9059 }, -- Handstitched Leather Bracers
    [GetSpellInfo(16069)] = { 1000, 16069 }, -- Nefarius Attack 001
    [GetSpellInfo(15628)] = { 25000, 15628 }, -- Pet Bombling
    [GetSpellInfo(26381)] = { 1000, 26381 }, -- Burrow
    [GetSpellInfo(22721)] = { 3000, 22721 }, -- Black War Raptor
    [GetSpellInfo(16995)] = { 60000, 16995 }, -- Heartseeker
    [GetSpellInfo(9935)] = { 45000, 9935 }, -- Steel Plate Helm
    [GetSpellInfo(27794)] = { 2500, 27794 }, -- Cleave
    [GetSpellInfo(2389)] = { 8000, 2389 }, -- Red Linen Robe
    [GetSpellInfo(23489)] = { 45000, 23489 }, -- Ultrasafe Transporter - Gadgetzan
    [GetSpellInfo(9795)] = { 4500, 9795 }, -- Talvash's Necklace Repair
    [GetSpellInfo(21403)] = { 1000, 21403 }, -- Ryson's All Seeing Eye
    [GetSpellInfo(12086)] = { 60000, 12086 }, -- Shadoweave Mask
    [GetSpellInfo(23061)] = { 3000, 23061 }, -- Fix Ritual Node
    [GetSpellInfo(28474)] = { 60000, 28474 }, -- Bramblewood Belt
    [GetSpellInfo(16643)] = { 60000, 16643 }, -- Thorium Belt
    [GetSpellInfo(24897)] = { 3000, 24897 }, -- Create Scepter of Beckoning: Earth
    [GetSpellInfo(22922)] = { 60000, 22922 }, -- Mongoose Boots
    [GetSpellInfo(1090)] = { 1500, 1090 }, -- Sleep
    [GetSpellInfo(9145)] = { 25000, 9145 }, -- Fletcher's Gloves
    [GetSpellInfo(10531)] = { 60000, 10531 }, -- Big Voodoo Mask
    [GetSpellInfo(6199)] = { 4000, 6199 }, -- Nostalgia
    [GetSpellInfo(19068)] = { 60000, 19068 }, -- Warbear Harness
    [GetSpellInfo(25793)] = { 3000, 25793 }, -- Demon Summoning Torch
    [GetSpellInfo(7057)] = { 2000, 7057 }, -- Haunting Spirits
    [GetSpellInfo(7489)] = { 1300, 7489 }, -- Call Lupine Horror
    [GetSpellInfo(15207)] = { 3000, 15207 }, -- Lightning Bolt
    [GetSpellInfo(22594)] = { 5000, 22594 }, -- Frost Mantle of the Dawn
    [GetSpellInfo(23042)] = { 1000, 23042 }, -- Call Benediction
    [GetSpellInfo(16659)] = { 60000, 16659 }, -- Radiant Circlet
    [GetSpellInfo(15906)] = { 3000, 15906 }, -- Dragonbreath Chili
    [GetSpellInfo(10544)] = { 60000, 10544 }, -- Wild Leather Vest
    [GetSpellInfo(24961)] = { 1000, 24961 }, -- Honor Points +82
    [GetSpellInfo(9220)] = { 1000, 9220 }, -- "Plucky" Resumes Chicken Form
    [GetSpellInfo(24258)] = { 30000, 24258 }, -- Quest - Troll Hero Summon Visual
    [GetSpellInfo(2667)] = { 12500, 2667 }, -- Runed Copper Breastplate
    [GetSpellInfo(25311)] = { 2000, 25311 }, -- Corruption
    [GetSpellInfo(26137)] = { 3000, 26137 }, -- Rotate Trigger
    [GetSpellInfo(8772)] = { 45000, 8772 }, -- Crimson Silk Belt
    [GetSpellInfo(19098)] = { 60000, 19098 }, -- Wicked Leather Armor
    [GetSpellInfo(14810)] = { 10000, 14810 }, -- Greater Mystic Wand
    [GetSpellInfo(15118)] = { 2500, 15118 }, -- Place Threshadon Carcass
    [GetSpellInfo(23069)] = { 5125, 23069 }, -- EZ-Thro Dynamite II
    [GetSpellInfo(7633)] = { 12500, 7633 }, -- Blue Linen Robe
    [GetSpellInfo(10718)] = { 1000, 10718 }, -- Summon Green Water Snake
    [GetSpellInfo(19076)] = { 60000, 19076 }, -- Volcanic Breastplate
    [GetSpellInfo(19089)] = { 60000, 19089 }, -- Blue Dragonscale Shoulders
    [GetSpellInfo(26421)] = { 5125, 26421 }, -- Large Green Rocket
    [GetSpellInfo(11449)] = { 3000, 11449 }, -- Elixir of Agility
    [GetSpellInfo(20648)] = { 8000, 20648 }, -- Medium Leather
    [GetSpellInfo(23811)] = { 1000, 23811 }, -- Summon Jubling
    [GetSpellInfo(25719)] = { 10000, 25719 }, -- Bind Draconic For Dummies
    [GetSpellInfo(8604)] = { 3000, 8604 }, -- Herb Baked Egg
    [GetSpellInfo(28354)] = { 20000, 28354 }, -- Exorcise Atiesh
    [GetSpellInfo(21358)] = { 1000, 21358 }, -- Aqual Quintessence - Dowse Molten Core Rune
    [GetSpellInfo(12717)] = { 25000, 12717 }, -- Goblin Mining Helmet
    [GetSpellInfo(1540)] = { 3000, 1540 }, -- Volley
    [GetSpellInfo(2674)] = { 5125, 2674 }, -- Heavy Sharpening Stone
    [GetSpellInfo(2832)] = { 3000, 2832 }, -- Armor +16
    [GetSpellInfo(3932)] = { 8000, 3932 }, -- Target Dummy
    [GetSpellInfo(24357)] = { 60000, 24357 }, -- Bloodvine Lens
    [GetSpellInfo(18245)] = { 3000, 18245 }, -- Lobster Stew
    [GetSpellInfo(9172)] = { 2000, 9172 }, -- Lift Seal
    [GetSpellInfo(7639)] = { 8000, 7639 }, -- Blue Overalls
    [GetSpellInfo(22724)] = { 3000, 22724 }, -- Black War Wolf
    [GetSpellInfo(23428)] = { 1000, 23428 }, -- Summon Albino Snapjaw
    [GetSpellInfo(3937)] = { 8000, 3937 }, -- Large Copper Bomb
    [GetSpellInfo(21371)] = { 5000, 21371 }, -- Planting Mulverick's Beacon
    [GetSpellInfo(15855)] = { 3000, 15855 }, -- Roast Raptor
    [GetSpellInfo(26298)] = { 2000, 26298 }, -- Create Firework Rocket Launcher
    [GetSpellInfo(20006)] = { 1000, 20006 }, -- Unholy Curse
    [GetSpellInfo(2169)] = { 12500, 2169 }, -- Dark Leather Tunic
    [GetSpellInfo(19086)] = { 60000, 19086 }, -- Ironfeather Breastplate
    [GetSpellInfo(7106)] = { 2000, 7106 }, -- Dark Restore
    [GetSpellInfo(16646)] = { 60000, 16646 }, -- Imperial Plate Shoulders
    [GetSpellInfo(29059)] = { 3000, 29059 }, -- Skeletal Steed
    [GetSpellInfo(18412)] = { 60000, 18412 }, -- Cindercloth Gloves
    [GetSpellInfo(18441)] = { 60000, 18441 }, -- Ghostweave Pants
    [GetSpellInfo(8552)] = { 1000, 8552 }, -- Curse of Weakness
    [GetSpellInfo(7795)] = { 30000, 7795 }, -- Runed Silver Rod
    [GetSpellInfo(9157)] = { 4000, 9157 }, -- Create Mage's Robe
    [GetSpellInfo(18438)] = { 60000, 18438 }, -- Runecloth Pants
    [GetSpellInfo(3773)] = { 45000, 3773 }, -- Guardian Armor
    [GetSpellInfo(3965)] = { 12500, 3965 }, -- Advanced Target Dummy
    [GetSpellInfo(3922)] = { 5125, 3922 }, -- Handful of Copper Bolts
    [GetSpellInfo(9980)] = { 60000, 9980 }, -- Ornate Mithril Helm
    [GetSpellInfo(18247)] = { 3000, 18247 }, -- Baked Salmon
    [GetSpellInfo(15935)] = { 3000, 15935 }, -- Crispy Bat Wing
    [GetSpellInfo(3650)] = { 1000, 3650 }, -- Sling Mud
    [GetSpellInfo(12594)] = { 45000, 12594 }, -- Fire Goggles
    [GetSpellInfo(1096)] = { 3000, 1096 }, -- Firebolt IV
    [GetSpellInfo(9092)] = { 5000, 9092 }, -- Flesh Eating Worm
    [GetSpellInfo(6270)] = { 30000, 6270 }, -- Serpentine Cleansing
    [GetSpellInfo(3770)] = { 45000, 3770 }, -- Toughened Leather Gloves
    [GetSpellInfo(15633)] = { 25000, 15633 }, -- Lil' Smoky
    [GetSpellInfo(11450)] = { 3000, 11450 }, -- Elixir of Greater Defense
    [GetSpellInfo(18375)] = { 500, 18375 }, -- Aynasha's Arrow
    [GetSpellInfo(3850)] = { 25000, 3850 }, -- Heavy Woolen Pants
    [GetSpellInfo(11397)] = { 2000, 11397 }, -- Diseased Shot
    [GetSpellInfo(28223)] = { 60000, 28223 }, -- Icy Scale Gauntlets
    [GetSpellInfo(11461)] = { 3000, 11461 }, -- Arcane Elixir
    [GetSpellInfo(23238)] = { 3000, 23238 }, -- Swift Brown Ram
    [GetSpellInfo(7955)] = { 25000, 7955 }, -- Deviate Scale Belt
    [GetSpellInfo(12069)] = { 60000, 12069 }, -- Cindercloth Robe
    [GetSpellInfo(19064)] = { 60000, 19064 }, -- Heavy Scorpid Gauntlets
    [GetSpellInfo(22926)] = { 60000, 22926 }, -- Chromatic Cloak
    [GetSpellInfo(4132)] = { 1000, 4132 }, -- Banish Thundering Exile
    [GetSpellInfo(6458)] = { 12500, 6458 }, -- Ornate Spyglass
    [GetSpellInfo(25158)] = { 3000, 25158 }, -- Time Stop
    [GetSpellInfo(7954)] = { 25000, 7954 }, -- Deviate Scale Gloves
    [GetSpellInfo(11457)] = { 3000, 11457 }, -- Superior Healing Potion
    [GetSpellInfo(8774)] = { 45000, 8774 }, -- Green Silken Shoulders
    [GetSpellInfo(9079)] = { 3000, 9079 }, -- Create Rift
    [GetSpellInfo(28487)] = { 1000, 28487 }, -- Summon Terky
    [GetSpellInfo(14891)] = { 3000, 14891 }, -- Smelt Dark Iron
    [GetSpellInfo(26134)] = { 2000, 26134 }, -- Eye Beam
    [GetSpellInfo(12564)] = { 1500, 12564 }, -- Summon Treasure Horde Visual
    [GetSpellInfo(19080)] = { 60000, 19080 }, -- Warbear Woolies
    [GetSpellInfo(16)] = { 3000, 16 }, -- Fear (NYI)
    [GetSpellInfo(23431)] = { 1000, 23431 }, -- Summon Leatherback Snapjaw
    [GetSpellInfo(19720)] = { 3000, 19720 }, -- Combine Pendants
    [GetSpellInfo(9926)] = { 60000, 9926 }, -- Heavy Mithril Shoulder
    [GetSpellInfo(12512)] = { 1000, 12512 }, -- Kalaran Conjures Torch
    [GetSpellInfo(25953)] = { 3000, 25953 }, -- Summon Blue Qiraji Battle Tank
    [GetSpellInfo(28739)] = { 1000, 28739 }, -- Summon Mr. Wiggles
    [GetSpellInfo(9052)] = { 2000, 9052 }, -- Fill Deino's Flask
    [GetSpellInfo(8394)] = { 3000, 8394 }, -- Striped Frostsaber
    [GetSpellInfo(21884)] = { 4000, 21884 }, -- Collect Orange Crystal Liquid
    [GetSpellInfo(16649)] = { 60000, 16649 }, -- Imperial Plate Bracers
    [GetSpellInfo(18115)] = { 1000, 18115 }, -- Viewing Room Student Transform - Effect
    [GetSpellInfo(1538)] = { 5000, 1538 }, -- Charging
    [GetSpellInfo(10566)] = { 60000, 10566 }, -- Wild Leather Boots
    [GetSpellInfo(2665)] = { 5125, 2665 }, -- Coarse Sharpening Stone
    [GetSpellInfo(5244)] = { 8000, 5244 }, -- Kodo Hide Bag
    [GetSpellInfo(15066)] = { 2000, 15066 }, -- Create PX83-Enigmatron
    [GetSpellInfo(5252)] = { 3000, 5252 }, -- Voidwalker Guardian
    [GetSpellInfo(3779)] = { 45000, 3779 }, -- Barbaric Belt
    [GetSpellInfo(4977)] = { 10000, 4977 }, -- Cleanse Thunderhorn Well
    [GetSpellInfo(10673)] = { 1000, 10673 }, -- Summon Bombay
    [GetSpellInfo(10720)] = { 1000, 10720 }, -- Summon Scarlet Snake
    [GetSpellInfo(22967)] = { 10000, 22967 }, -- Smelt Elementium
    [GetSpellInfo(2152)] = { 5125, 2152 }, -- Light Armor Kit
    [GetSpellInfo(2156)] = { 3000, 2156 }, -- Light Winter Cloak
    [GetSpellInfo(15973)] = { 25000, 15973 }, -- Searing Golden Blade
    [GetSpellInfo(19069)] = { 2000, 19069 }, -- Plant Magic Beans
    [GetSpellInfo(5809)] = { 2500, 5809 }, -- Create Scrying Bowl
    [GetSpellInfo(23096)] = { 25000, 23096 }, -- Alarm-O-Bot
    [GetSpellInfo(12554)] = { 1500, 12554 }, -- Summon Treasure Horde
    [GetSpellInfo(16970)] = { 60000, 16970 }, -- Dawn's Edge
    [GetSpellInfo(10499)] = { 60000, 10499 }, -- Nightscape Tunic
    [GetSpellInfo(3938)] = { 5125, 3938 }, -- Bronze Tube
    [GetSpellInfo(12806)] = { 3000, 12806 }, -- Getting Tide Pool Sample #3
    [GetSpellInfo(17481)] = { 3000, 17481 }, -- Deathcharger
    [GetSpellInfo(6654)] = { 3000, 6654 }, -- Brown Wolf
    [GetSpellInfo(849)] = { 1000, 849 }, -- Elemental Armor
    [GetSpellInfo(23240)] = { 3000, 23240 }, -- Swift White Ram
    [GetSpellInfo(13702)] = { 30000, 13702 }, -- Runed Truesilver Rod
    [GetSpellInfo(27720)] = { 1000, 27720 }, -- Buttermilk Delight
    [GetSpellInfo(10542)] = { 60000, 10542 }, -- Tough Scorpid Gloves
    [GetSpellInfo(24892)] = { 2000, 24892 }, -- Create Signet of Beckoning: Water
    [GetSpellInfo(11963)] = { 2000, 11963 }, -- Enfeeble
    [GetSpellInfo(11476)] = { 3000, 11476 }, -- Elixir of Shadow Power
    [GetSpellInfo(3771)] = { 25000, 3771 }, -- Barbaric Gloves
    [GetSpellInfo(2402)] = { 8000, 2402 }, -- Woolen Cape
}

-- Note: value[1] here is casttime in seconds not ms, might change it to ms later
namespace.channeledSpells = {
    -- MISC
    [GetSpellInfo(746)] = { 7, 746 },         -- First Aid
    [GetSpellInfo(13278)] = { 4, 13278 },     -- Gnomish Death Ray
    [GetSpellInfo(20577)] = { 10, 20577 },    -- Cannibalize
    [GetSpellInfo(10797)] = { 6, 10797 },     -- Starshards

    -- DRUID
    [GetSpellInfo(17401)] = { 9.5, 17401 },   -- Hurricane
    [GetSpellInfo(740)] = { 9.5, 740 },       -- Tranquility

    -- HUNTER
    [GetSpellInfo(6197)] = { 60, 6197 },      -- Eagle Eye
    [GetSpellInfo(1002)] = { 60, 1002 },      -- Eyes of the Beast
    [GetSpellInfo(1510)] = { 6, 1510 },       -- Volley

    -- MAGE
    [GetSpellInfo(5143)] = { 4.5, 5143, },     -- Arcane Missiles
    [GetSpellInfo(10)] = { 7.5, 10 },          -- Blizzard
    [GetSpellInfo(12051)] = { 8, 12051 },      -- Evocation

    -- PRIEST
    [GetSpellInfo(15407)] = { 3, 15407 },     -- Mind Flay
    [GetSpellInfo(2096)] = { 60, 2096 },      -- Mind Vision
    [GetSpellInfo(605)] = { 3, 605 },         -- Mind Control

    -- WARLOCK
    [GetSpellInfo(126)] = { 45, 126 },        -- Eye of Kilrogg
    [GetSpellInfo(689)] = { 4.5, 689 },       -- Drain Life
    [GetSpellInfo(5138)] = { 4.5, 5138 },     -- Drain Mana
    [GetSpellInfo(1120)] = { 14.5, 1120 },    -- Drain Soul
    [GetSpellInfo(5740)] = { 7.5, 5740 },     -- Rain of Fire
    [GetSpellInfo(1949)] = { 15, 1949 },      -- Hellfire
    [GetSpellInfo(755)] = { 10, 755 },        -- Health Funnel
}

-- List of abilities that makes cast time slower.
-- Value here is the slow percentage.
-- TODO: check if these also affect Aimed Shot/Volley + bosses
namespace.castTimeIncreases = {
    -- WARLOCK
    [GetSpellInfo(1714)] = 60,    -- Curse of Tongues
    [GetSpellInfo(1098)] = 30,    -- Enslave Demon Rank 1

    -- ROGUE
    [GetSpellInfo(5760)] = 40,    -- Mind-Numbing Poison Rank 1

    -- ITEMS
    [GetSpellInfo(17331)] = 10,   -- Fang of the Crystal Spider

    -- NPCS
    [GetSpellInfo(7127)] = 20,    -- Wavering Will
    [GetSpellInfo(7102)] = 25,    -- Contagion of Rot
    [GetSpellInfo(3603)] = 35,    -- Distracting Pain
    [GetSpellInfo(8140)] = 50,    -- Befuddlement
    [GetSpellInfo(8272)] = 20,    -- Mind Tremor
    [GetSpellInfo(12255)] = 15,   -- Curse of Tuten'kash
    [GetSpellInfo(10651)] = 20,   -- Curse of the Eye
    [GetSpellInfo(14538)] = 35,   -- Aural Shock
    [GetSpellInfo(22247)] = 80,   -- Suppression Aura
    [GetSpellInfo(22642)] = 50,   -- Brood Power: Bronze
    [GetSpellInfo(23153)] = 50,   -- Brood Power: Blue
    [GetSpellInfo(24415)] = 50,   -- Slow
    [GetSpellInfo(19365)] = 50,   -- Ancient Dread
    [GetSpellInfo(28732)] = 25,   -- Widow's Embrace
    [GetSpellInfo(22909)] = 50,   -- Eye of Immol'thar
}

-- Spells that often have cast time reduced by talents.
-- Value here is not the actual cast time, but instead how
-- many seconds a talent reduces the cast time.
-- Note: We don't add these to 'namespace.castedSpells' since we want
-- to only apply these values for players in the CLEU event.
-- (Some NPC spells have same name as player spells)
namespace.castTimeTalentDecreases = {
    [GetSpellInfo(403)] = 1,        -- Lightning Bolt
    [GetSpellInfo(421)] = 1,        -- Chain Lightning
    [GetSpellInfo(6353)] = 2,       -- Soul Fire
    [GetSpellInfo(116)] = 0.5,      -- Frostbolt
--  [GetSpellInfo(133)] = 0.5,      -- Fireball (many people skip this talent)
    [GetSpellInfo(686)] = 0.5,      -- Shadow Bolt
    [GetSpellInfo(348)] = 0.5,      -- Immolate
    [GetSpellInfo(331)] = 0.5,      -- Healing Wave
    [GetSpellInfo(585)] = 0.5,      -- Smite
    [GetSpellInfo(14914)] = 0.5,    -- Holy Fire
    [GetSpellInfo(2054)] = 0.5,     -- Heal
    [GetSpellInfo(25314)] = 0.5,    -- Greater Heal
    [GetSpellInfo(8129)] = 0.5,     -- Mana Burn
    [GetSpellInfo(5176)] = 0.5,     -- Wrath
    [GetSpellInfo(2912)] = 0.5,     -- Starfire
    [GetSpellInfo(5185)] = 0.5,     -- Healing Touch
    [GetSpellInfo(2645)] = 2,       -- Ghost Wolf
    [GetSpellInfo(691)] = 4,        -- Summon Felhunter
    [GetSpellInfo(688)] = 4,        -- Summon Imp
    [GetSpellInfo(697)] = 4,        -- Summon Voidwalker
    [GetSpellInfo(712)] = 4,        -- Summon Succubus
}

-- List of crowd controls.
-- We want to stop the castbar when these auras are detected
-- as SPELL_CAST_FAILED is not triggered when an unit gets CC'ed.
namespace.crowdControls = {
    [GetSpellInfo(5211)] = 1,       -- Bash
    [GetSpellInfo(24394)] = 1,      -- Intimidation
    [GetSpellInfo(853)] = 1,        -- Hammer of Justice
    [GetSpellInfo(22703)] = 1,      -- Inferno Effect (Summon Infernal)
    [GetSpellInfo(408)] = 1,        -- Kidney Shot
    [GetSpellInfo(12809)] = 1,      -- Concussion Blow
    [GetSpellInfo(20253)] = 1,      -- Intercept Stun
    [GetSpellInfo(20549)] = 1,      -- War Stomp
    [GetSpellInfo(2637)] = 1,       -- Hibernate
    [GetSpellInfo(3355)] = 1,       -- Freezing Trap
    [GetSpellInfo(19386)] = 1,      -- Wyvern Sting
    [GetSpellInfo(118)] = 1,        -- Polymorph
    [GetSpellInfo(28271)] = 1,      -- Polymorph: Turtle
    [GetSpellInfo(28272)] = 1,      -- Polymorph: Pig
    [GetSpellInfo(20066)] = 1,      -- Repentance
    [GetSpellInfo(1776)] = 1,       -- Gouge
    [GetSpellInfo(6770)] = 1,       -- Sap
    [GetSpellInfo(1513)] = 1,       -- Scare Beast
    [GetSpellInfo(8122)] = 1,       -- Psychic Scream
    [GetSpellInfo(2094)] = 1,       -- Blind
    [GetSpellInfo(5782)] = 1,       -- Fear
    [GetSpellInfo(5484)] = 1,       -- Howl of Terror
    [GetSpellInfo(6358)] = 1,       -- Seduction
    [GetSpellInfo(5246)] = 1,       -- Intimidating Shout
    [GetSpellInfo(6789)] = 1,       -- Death Coil
    [GetSpellInfo(9005)] = 1,       -- Pounce
    [GetSpellInfo(1833)] = 1,       -- Cheap Shot
    [GetSpellInfo(16922)] = 1,      -- Improved Starfire
    [GetSpellInfo(19410)] = 1,      -- Improved Concussive Shot
    [GetSpellInfo(12355)] = 1,      -- Impact
    [GetSpellInfo(20170)] = 1,      -- Seal of Justice Stun
    [GetSpellInfo(15269)] = 1,      -- Blackout
    [GetSpellInfo(18093)] = 1,      -- Pyroclasm
    [GetSpellInfo(12798)] = 1,      -- Revenge Stun
    [GetSpellInfo(5530)] = 1,       -- Mace Stun
    [GetSpellInfo(19503)] = 1,      -- Scatter Shot
    [GetSpellInfo(605)] = 1,        -- Mind Control
    [GetSpellInfo(7922)] = 1,       -- Charge Stun
    [GetSpellInfo(18469)] = 1,      -- Counterspell - Silenced
    [GetSpellInfo(15487)] = 1,      -- Silence
    [GetSpellInfo(18425)] = 1,      -- Kick - Silenced
    [GetSpellInfo(24259)] = 1,      -- Spell Lock
    [GetSpellInfo(18498)] = 1,      -- Shield Bash - Silenced

    -- ITEMS
    [GetSpellInfo(13327)] = 1,      -- Reckless Charge
    [GetSpellInfo(1090)] = 1,       -- Sleep
    [GetSpellInfo(5134)] = 1,       -- Flash Bomb Fear
    [GetSpellInfo(19821)] = 1,      -- Arcane Bomb Silence
    [GetSpellInfo(4068)] = 1,       -- Iron Grenade
    [GetSpellInfo(19769)] = 1,      -- Thorium Grenade
    [GetSpellInfo(13808)] = 1,      -- M73 Frag Grenade
    [GetSpellInfo(4069)] = 1,       -- Big Iron Bomb
    [GetSpellInfo(12543)] = 1,      -- Hi-Explosive Bomb
    [GetSpellInfo(4064)] = 1,       -- Rough Copper Bomb
    [GetSpellInfo(12421)] = 1,      -- Mithril Frag Bomb
    [GetSpellInfo(19784)] = 1,      -- Dark Iron Bomb
    [GetSpellInfo(4067)] = 1,       -- Big Bronze Bomb
    [GetSpellInfo(4066)] = 1,       -- Small Bronze Bomb
    [GetSpellInfo(4065)] = 1,       -- Large Copper Bomb
    [GetSpellInfo(13237)] = 1,      -- Goblin Mortar
    [GetSpellInfo(835)] = 1,        -- Tidal Charm
    [GetSpellInfo(13181)] = 1,      -- Gnomish Mind Control Cap
    [GetSpellInfo(12562)] = 1,      -- The Big One
    [GetSpellInfo(15283)] = 1,      -- Stunning Blow (Weapon Proc)
    [GetSpellInfo(56)] = 1,         -- Stun (Weapon Proc)
    [GetSpellInfo(26108)] = 1,      -- Glimpse of Madness
}

-- Addon Savedvariables
namespace.defaultConfig = {
    version = "5", -- settings version
    pushbackDetect = false,
    locale = GetLocale(),

    nameplate = {
        enabled = true,
        width = 120,
        height = 11,
        iconSize = 14,
        showCastInfoOnly = false,
        showTimer = false,
        showSpellRank = false,
        autoPosition = true,
        simpleStyle = false,
        castFont = _G.STANDARD_TEXT_FONT,
        castFontSize = 8,
        castStatusBar = "Interface\\TargetingFrame\\UI-StatusBar",
        castBorder = "Interface\\CastingBar\\UI-CastingBar-Border-Small",
        position = { "CENTER", 0.2, -23.1 },
    },

    target = {
        enabled = true,
        width = 150,
        height = 15,
        iconSize = 16,
        showCastInfoOnly = false,
        showTimer = false,
        showSpellRank = false,
        autoPosition = true,
        simpleStyle = false,
        castFont = _G.STANDARD_TEXT_FONT,
        castFontSize = 10,
        castStatusBar = "Interface\\TargetingFrame\\UI-StatusBar",
        castBorder = "Interface\\CastingBar\\UI-CastingBar-Border-Small",
        position = { "CENTER", -18, -87 },
    },
}
