;|*********************************************************************************************;
: Highflybird                                                                          ;
;: ΪAutoCAD LISPƵһЩ㷨ͺ                                                 ;
ڵص: 2012.12.29                                                                       ;
: AutoLISP,Visual LISP               ;
汾:   Ver. 1.0.121212               ;
===============================================================================================;
ΪԴ: ǿԴ:                                              
-----------------------------------------------------------------------------------------------;
ҳGPLЭ鿪Դ룬ɴ޸ģԼǰ:   
            
һ. ֻҪڱԴÿһԺǡسȨִ֤ûе
𣬲ͳһÿĳһ֤ĸͿκý帴ƺͷյ
ԭʼĳԴ롣ҲΪתøʵжȡһãȵõͬ⡣  
                   
. ޸ıԴһ򼸸κβ֣ԴγɻڳƷֻҪͬʱ
Ϳ԰ǰһҪƺͷһ޸ĵĳƷ    
1.޸ĵļиȷ˵: ޸һļ޸ڡ   
2.ʹ㷢Ʒȫһ֣ɳȫ򲿷Ʒ
  Ϊ尴֤ʹá        
3.޸ĵĳʱԽʽȡʹڿʼ볣Ľʹ÷ʽʱӡʾ
  : ʵİȨûеṩû԰֤·
  ˵ûοһ֤ĸ: ԭʼԽʽ
  ӡĻڳƷҲͲôӡ                   
            
. ֻҪѭһ涨ͿʹòԴ룬ԭⲻرԭϢ  
===============================================================================================;
**********************************************************************************************|;

;;;----------------------------------------------------;
;;;һԪη̵Ľ                                    ;
;;;f(x) = a*x^2+b*x+c = 0                              ;
;;;Input: the coefficients a, b, c are real numbers    ;
;;;Output: when a /= 0,one or Two solutions,all of them;
;;;        like this: (x y),means: x + y * i,if it's a ;
;;;        real number,then y = 0.                     ;
;;;        Otherwise , return a real number or nil     ;
;;;Ref: http://en.wikipedia.org/wiki/Quadratic_equation;
;;;----------------------------------------------------;
(defun Math:Quadratic_Equation (a b c / d e g)
  (if (zerop a)
      (if (not (zerop b))
          (list (list (/ (- c) (float b)) 0))
      )
      (progn
        (setq a (float a))
        (or (equal a 1 1e-14)
            (setq b (/ b a)
                  c (/ c a)
            )
        )
        (setq d (- (* b b) (* 4 c)) e (* b -0.5))
        (cond
             ( (equal d 0 1e-14) (list (list e 0) (list e 0)))
             ( (> d 0)
               (setq g (* (sqrt d) -0.5))
               (list (list (- e g) 0) (list (+ e g) 0))
             )
             ( (< d 0)
               (setq g (* (sqrt (- d)) -0.5))
               (list (list e (- g)) (list e g))
             )
        )
      )
  )
)

;;;----------------------------------------------------;
;;;һԪη̵Ľ                                    ;
;;;f(x) = a*x^3+b*x^2+c*x+d = 0                        ;
;;;Input: the coefficients a, b, c, d are real numbers ;
;;;Output: when a /= 0,Three solutions,all of them like;
;;;        this: (x y),means: x + y * i,if it's a real ;
;;;        number,then y = 0;                          ;
;;;        otherwise goto "Math:Quadratic_Equation"    ;
;;;Ref: http://en.wikipedia.org/wiki/Cubic_function    ;
;;;----------------------------------------------------;
(defun Math:Cubic_Equation (a b c d / e f g h u w x y)
  (cond
    ( (zerop a)
      (Math:Quadratic_Equation b c d)
    )
    ( (zerop d)
      (cons '(0 0) (Math:Quadratic_Equation a b c))
    )
    (t
      (setq b (/ b 3. a)
            c (/ c 6. a)
            d (/ d 2. a)
            e (- (* b (- (+ c c c) (* b b))) d)  ;Alpha
            f (- (* b b) c c)    ;Beta
            g (- (* e e) (* f f f))   ;Delta,The nature of the roots
      )
      (cond
        ( (equal g 0 1e-14)
          (setq u (MATH:CubeRoot e))
          (list (list (- (+ u u) b) 0.)
                (list (- (+ b u)) 0.)
                (list (- (+ b u)) 0.)
          )
        )
        ( (> g 0)
          (setq h (sqrt g)
                u (MATH:CubeRoot (+ e h))
                w (MATH:CubeRoot (- e h))
                x (- (+ b (* (+ u w) 0.5)))
                y (* (sqrt 3) (- u w) 0.5)
          )
          (list (list (+ u w (- b)) 0)
                (list x y)
                (list x (- y))
          )
        )
        ( (< g 0)
          (setq x (/ e f (sqrt f))
                y (sqrt (abs (- 1 (* x x))))
                u (/ (atan y x) 3)
                w (/ (+ pi pi) 3)
                h (* 2 (sqrt f))
          )
          (list (list (- (* (cos u) h) b) 0)
                (list (- (* (cos (+ u w)) h) b) 0)
                (list (- (* (cos (- u w)) h) b) 0)
          )
        )
      )
    )
  )
)

;;;----------------------------------------------------;
;;;һԪĴη̵Ľ                                    ;
;;;f(x) = a*x^4+b*x^3+c*x^2+d*x+e= 0                   ;
;;;Input: the coefficients a,b,c,d,e are real numbers. ;
;;;Output: when a /= 0,Three solutions,all of them like;
;;;        this: (x y),means: x + y * i,if it's a real ;
;;;        number,then y = 0;                          ;
;;;        otherwise goto "Math:Quadratic_Equation"    ;
;;;Ref: http://en.wikipedia.org/wiki/Quartic_function  ;
;;;----------------------------------------------------;
(defun Math:Quartic_Equation (a b c d e / B2 B3 B4 EPS F G H P Q R V W X Y Z S)
  (setq eps 1e-8)
  (cond
    ( (equal a 0 eps)
      (Math:Cubic_Equation b c d e)
    )
    ( (equal e 0 eps)
      (cons '(0 0) (Math:Cubic_Equation a b c d))
    )
    ( (and (equal b 0 eps) (equal d 0 eps))
      (foreach x (Math:Quadratic_Equation a c e) 
       (foreach y (Math:CSqrt x) (setq s (cons y s)))
      )
    )  
    ( (setq a (float a)
            b (/ b a)
            c (/ c a)
            d (/ d a)
            e (/ e a)
            b2 (* b b)
            b3 (* b2 b)
            b4 (* b3 b)
            f (+ (* b2 -0.375) c)        ;alpha
            g (+ (* b3 0.125) (* b c -0.5) d)  ;beta
            h (+ (* -0.01171875 b4) (* 0.0625 c b2) (* -0.25 b d) e)
      )
      (if (equal g 0 eps)
          (progn 
              (setq x (* b -0.25))
              (mapcar
                 '(lambda (e) (list (+ (car e) x) (cadr e)))
                 (Math:Quartic_Equation 1 0 f 0 h)           ;Recursion 
              )
          )
          (progn 
              (setq p (- (* f f 2) h)
                    q (- (* f f f 0.5) (* f h 0.5) (* g g 0.125))
                    r (Math:Cubic_Equation 1 (* 2.5 f) p q)
              )
              (while (not (equal (cadar r) 0 eps)) (setq r (cdr r)))
              (setq r (caar r) w (sqrt (abs (+ f r r))))
              (foreach i (list + -)
                  (foreach j (list + -)
                     (setq x (i (* b -0.25) (* w 0.5))
                           y (- (+ f f f r r (i (/ g 0.5 w))))
                           z (j (* (sqrt (abs y)) 0.5))
                           z (if (< y 0) (list x z) (list (+ x z) 0))
                           S (cons z S)
                     )
                  )
              )
          )
      )
    )
  )
)

;;;----------------------------------------------------;
;;;תΪ;
;;;----------------------------------------------------;
(defun MATH:2c (x / y)
  (setq y (type x))
  (cond ((member y ('int 'real)) (list x 0))
        ((= y 'list) (list (cond ((car x)) (0)) (cond ((cadr x)) (0))))
  )
)


;;;----------------------------------------------------;
;;;ΪκĴη̱дΪexptһ;
;;;Ϊ                                      ;
;;;룺x ʵ                                        ;
;;;x                                     ;
;;;----------------------------------------------------;
(defun MATH:CubeRoot (x)
  (if (< x 0)
    (- (expt (- x) 0.33333333333333333333333))
    (expt x 0.33333333333333333333333)
  )
)

;;;----------------------------------------------------;
;;;Ӹ                                          ;
;;;룺Z1--Z2--                            ;
;;;ʵӵĽ                          ;
;;;----------------------------------------------------;
(defun Math:C+C (z1 z2)
  (mapcar '+ (MATH:2c z1) (MATH:2c z2))
)

;;;----------------------------------------------------;
;;;                                          ;
;;;룺Z1--Z2--                            ;
;;;ʵĽ                          ;
;;;----------------------------------------------------;
(defun math:C-C (z1 z2)
  (mapcar '- (MATH:2c z1) (MATH:2c z2))
)

;;;----------------------------------------------------;
;;;˸                                          ;
;;;룺Z1--Z2--                            ;
;;;ʵ˵Ľ                          ;
;;;----------------------------------------------------;
(defun Math:C*C (Z1 Z2)
  (setq z1 (MATH:2c z1) z2 (MATH:2c z2))
  (list
    (- (* (car Z1) (car z2)) (* (cadr z1) (cadr z2)))
    (+ (* (car Z1) (cadr Z2)) (* (cadr z1) (car Z2)))
  )
)

;;;----------------------------------------------------;
;;;Ը                                        ;
;;;룺Z1--Z2--                            ;
;;;ʵĽ                          ;
;;;----------------------------------------------------;
(defun Math:C/C (Z1 Z2 / a b c d N)
  (mapcar 'set '(a b) (MATH:2c z1))
  (mapcar 'set '(c d) (MATH:2c z2))
  (setq N (float (+ (* c c) (* d d))))
  (if (not (zerop N))
    (list
      (/ (+ (* a c) (* b d)) N)
      (/ (- (* b c) (* a d)) N)
    )
  )
)

;;;----------------------------------------------------;
;;;ģ                                            ;
;;;룺Z --                                      ;
;;;ģʸ                ;
;;;----------------------------------------------------;
(defun MATH:CNormal (Z)
  (distance '(0 0) Z)
)

;;;----------------------------------------------------;
;;;ƽ                                        ;
;;;룺Z --                                      ;
;;;ƽԸʽ        ;
;;;----------------------------------------------------;
(defun Math:CSqrt (Z / x y a r)
  (setq x (car z) y (cadr z))
  (if (equal y 0 1e-14)
     (if (> x 0)
         (list (list (setq x (sqrt x)) 0) (list (- x) 0))
         (list (list 0 (setq y (sqrt (- x)))) (list 0 (- y)))
     )
     (progn
        (setq a (* (atan y x) 0.5)
              r (sqrt (distance '(0 0) Z))
              x (* r (cos a))
              y (* r (sin a))
        )
        (list (list x y) (list (- x) (- y)))
    )
  )
)

;;;----------------------------------------------------;
;;;ķ                                          ;
;;;룺Z --, n --                          ;
;;;nηԸʽn⡣      ;
;;;----------------------------------------------------;
(defun MATH:CRoot (Z n / r a b i s 2Pi)
  (if (and (= (type n) 'INT) (> n 0))
      (progn
          (setq r (expt (distance '(0 0) z) (/ 1. n))
                a (atan (cadr z) (car z))
                i 0
                2Pi (+ pi pi)
          )
          (repeat n
              (setq b (/ (+ a (* i 2Pi)) n)
                    s (cons (list (* r (cos b)) (* r (sin b))) s)
                    i (1+ i)
              )
          )
          (reverse s)
      )
  )
)

;;;----------------------------------------------------;
;;;ʵָ                                      ;
;;;룺Z --, x -- ʵ                           ;
;;;Z xݣԸʽ               ;
;;;----------------------------------------------------;
(defun MATH:CRPower (Z x / a r)
  (setq a (atan (cadr Z) (car Z))
        r (expt (distance '(0 0) Z) x)
  )
  (list (* r (cos (* a x))) (* r (sin (* a x))))
)

;;;----------------------------------------------------;
;;;ĸָ                                      ;
;;;룺Z1 --, Z2 --                          ;
;;;Z1Z2ݣԸʽ              ;
;;;----------------------------------------------------;
(defun MATH:CRPower (Z1 Z2 / a r x y k)
  (if (> (setq r (distance '(0 0) Z1)) 1e-20)
      (progn 
         (setq a (atan (cadr Z1) (car Z1))
               x (car z2)
               y (cadr z2)
               k (log r)
               r (exp (- (* k x) (* y a)))
               a (+ (* k y) (* x a))
         )
         (list (* r (cos a)) (* r (sin a)))
      )
  )
)

;;;----------------------------------------------------;
;;;Ȼ                                      ;
;;;룺Z --                                      ;
;;;Z ȻԸʽ            ;
;;;----------------------------------------------------;
(defun MATH:CExp (Z / r)
  (if (> (setq r (distance '(0 0) Z)) 1e-20)
    (list (log r) (atan (cadr Z) (car Z)))
  )
)

;;;----------------------------------------------------;
;;;                                          ;
;;;룺Z --                                      ;
;;;Z ңԸʽ                ;
;;;----------------------------------------------------;
(defun MATH:CCOS (Z / x y c s u v)
  (setq x (car z) y (cadr z))
  (if (equal y 0 1e-20)
      (list (cos x) 0)
        (progn
           (setq c (* 0.5 (cos x))
                 s (* 0.5 (sin x))
                 u (exp y)
                 v (exp (- y))
           )
           (list (* c (+ v u)) (* s (- v u)))
        )
  )
)

;;;----------------------------------------------------;
;;;                                          ;
;;;룺Z --                                      ;
;;;Z ңԸʽ                ;
;;;----------------------------------------------------;
(defun MATH:CSIN (Z / x y c s u v)
  (setq x (car z) y (cadr z))
  (if (equal y 0 1e-20)
    (list (sin x) 0)
    (progn
      (setq s (* 0.5 (sin x))
            c (* 0.5 (cos x))
            u (exp (- y))
            v (exp y)
      )
      (list (* s (+ v u)) (* c (- v u)))
    )
  )
)

;;;----------------------------------------------------;
;;;                                          ;
;;;룺Z --                                      ;
;;;Z УԸʽ                ;
;;;----------------------------------------------------;
(defun MATH:CTAN (Z / x y c s u v)
  (MATH:C/C (MATH:CSIN Z) (MATH:CCOS Z))
)

;;;----------------------------------------------------;
;;;ʵϵĸʽ                              ;
;;;룺Z --, RealNumbers --ʵϵб            ;
;;;ʵϵʽֵøʾ      ;
;;;----------------------------------------------------;
(defun MATH:CReal_Polynomial (Z RealNumbers / f)
  (cond
    ( (cdr RealNumbers) 
      (setq f (Math:C*C Z (car RealNumbers)))
      (repeat (- (length RealNumbers) 2)
        (setq RealNumbers (cdr RealNumbers)
              f (Math:C+C f (car RealNumbers))
              f (MATH:C*C f Z)
        )
      )
      (setq f (Math:C+C f (cadr RealNumbers)))
    )
    ( (car RealNumbers) (list (car RealNumbers) 0))
  )
)

;;;----------------------------------------------------;
;;;ϵĸʽ                              ;
;;;룺Z --, ImaginaryNumbers--ϵб        ;
;;;ݸϵʽֵøʾ      ;
;;;----------------------------------------------------;
(defun MATH:CImaginary_Polynomial (Z ImaginaryNumbers / f)
  (if (setq f (car ImaginaryNumbers))
    (progn
      (repeat (1- (length ImaginaryNumbers))
        (setq ImaginaryNumbers (cdr ImaginaryNumbers)
              f (MATH:C*C f Z)
              f (MATH:C+C f (car ImaginaryNumbers))
        )
      )
      f
    )
  )
)

;;;----------------------------------------------------;
;;;³Ϊ:                                   ;
;;;Test for "Math:Quartic_Equation"                    ;
;;;If the difference between the Coefficients is big,it;
;;;will  make some float point error.                  ;
;;;----------------------------------------------------;
(defun C:test (/ a b c d e S z z1 z2 z3 z4)
  (initget 1)
  (setq a (getreal "\nCoefficient a:"))
  (initget 1)
  (setq b (getreal "\nCoefficient b:"))
  (initget 1)
  (setq c (getreal "\nCoefficient c:"))
  (initget 1)
  (setq d (getreal "\nCoefficient d:"))
  (initget 1)
  (setq e (getreal "\nCoefficient e:"))
  ;(MISC:test 1000 '((Math:Quartic_Equation a b c d e)))
  (setq S (Math:Quartic_Equation a b c d e))  ;get the solutions
  (foreach z S
    (princ "\n")
    (princ (mapcar '(lambda (x) (rtos x 2 20)) z)) ;print them.
  )
  (foreach z S      ;Check every solution
    (setq f (MATH:CReal_Polynomial z (list a b c d e)))
    (if (not (equal f '(0 0) 1e-6))   ;if f(z) /= 0.0,maybe it's caused by floating point operation;
      (alert
 (strcat
   "Maybe it's a Wrong solution: f("
   (vl-princ-to-string z)
   ") = "
   (VL-PRINC-TO-STRING f)
 )
      )
    )
  )
  (princ)
)

(vl-load-com)
(princ "\nThe command is : test.")
(princ)
