#version 330
in mat4 localToWorldAttrib;
uniform mat4 worldToView;
uniform mat4 viewToProjection;
in vec4 instanceColorAttrib;

uniform vec4 universal_color;

out vec3 cameraToFragment;
in vec4 vertex;
in vec3 normal;
in vec4 color;
in vec2 texcoord;

out vec4 frontColor;
out vec4 worldPosition;
out vec4 localPosition;

#ifdef TEXTURE
out vec2 texcoord_out;
#endif

#ifdef LIT
// out vec4 diffuse;
// out vec4 ambient;
out vec3 fragNormal;
// out vec3 lightDir;
// out vec3 halfVector;
//
struct lightSourceParameters
{
	vec4 ambient;              // Aclarri
	vec4 diffuse;              // Dcli
	vec4 specular;             // Scli
	vec3 position;             // Ppli
	vec3 halfVector;           // Derived: Hi
};

uniform lightSourceParameters lightSource[4];

#endif // LIT

void main(void)
{
#ifdef TEXTURE
	texcoord_out = texcoord;
#endif // TEXTURE

	frontColor = instanceColorAttrib * color * universal_color;
	//gl_Position    = ftransform();
	localPosition = vertex;
	worldPosition = localToWorldAttrib * vertex;
	gl_Position = viewToProjection * worldToView * worldPosition;

#ifdef LIT
	/* first transform the normal into world space and
	   normalize the result */
	fragNormal = normalize((localToWorldAttrib * vec4(normal,0.0)).xyz);

	/* currently hardcoded to directional light, so the position field is
	 * actually direction */
	// lightDir = normalize(vec3(1.0,1.0,1.0));
	// lightDir = normalize(vec3(lightSource[0].position));

	/* Normalize the halfVector to pass it to the fragment shader */
	//halfVector = normalize(lightSource[0].halfVector.xyz);

	/* Compute the diffuse, ambient and globalAmbient terms */
	// diffuse = color * lightSource[0].diffuse;
	// ambient = color * lightSource[0].ambient;
	// ambient = vec4(0.1,0.1,0.1,1.0); //lightSource[0].ambient;
	/* ambient += gl_LightModel.ambient * gl_FrontMaterial.ambient; */

#endif // LIT

	cameraToFragment = vec3(gl_Position);
}
