#version 330
uniform mat4 worldToView;
uniform mat4 viewToProjection;

in mat4 localToWorldAttrib;
in vec4 instanceColorAttrib;
in vec2 texcoord;
in vec4 vertex;
in vec4 color;

out vec4 worldPosition;
out vec2 texcoord_out;
out vec4 frontColor;

void main(void)
{
	frontColor = instanceColorAttrib * color;
	worldPosition = localToWorldAttrib * vertex;
	texcoord_out = texcoord;
	gl_Position = viewToProjection * worldToView * worldPosition;
}

