#version 330
uniform bool fog;
uniform float fogDensity;
// uniform mat4 localToWorld;
in mat4 localToWorldAttrib;
uniform mat4 worldToView;
uniform mat4 viewToProjection;
uniform float globalTime;
in vec4 instanceColorAttrib;

// out float fogFactor;
out vec3 cameraToFragment;
in vec4 vertex;
in vec3 normal;
in vec4 color;

out vec4 frontColor;
out vec4 worldPosition;
out vec4 viewPosition;
// out vec4 shadowCoord;
out vec3 local_light_pos;
out vec3 local_normal;

#ifdef TEXTURE
in vec2 texcoord;
out vec2 texcoord_out;
#endif

#ifdef LIT
// out vec4 diffuse;
// out vec4 ambient;
out vec3 fragNormal;
// out vec3 lightDir;
// out vec3 halfVector;
//
struct lightSourceParameters
{
	vec4 ambient;              // Aclarri
	vec4 diffuse;              // Dcli
	vec4 specular;             // Scli
	vec3 position;             // Ppli
	vec3 halfVector;           // Derived: Hi
};

uniform lightSourceParameters lightSource[4];

#endif // LIT

vec3 hsv2rgb(vec3 c)
{
	vec4 K = vec4(1,2.0/3.0, 1.0/3.0, 3.0);
	vec3 p = abs(fract(c.rrr + K.xyz) * 6.0 - K.www);
	return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.g);
}

void main(void)
{
#ifdef TEXTURE
	texcoord_out = texcoord;
#endif // TEXTURE

	// frontColor.rgb = vec3(0.31,0.1,0.3);
	frontColor.rgb = hsv2rgb( vec3(0.1 * globalTime, 0.5, 0.4) );
	frontColor.rgb = mix(frontColor.rgb, instanceColorAttrib.rgb, instanceColorAttrib.a);
	// frontColor = color;
	frontColor.a = color.a;
	//gl_Position    = ftransform();
	worldPosition = localToWorldAttrib * vertex;
	vec4 worldNormal = localToWorldAttrib * vec4(normal,0);
	// shadowCoord = worldToLight * (worldPosition + (worldNormal * 1.5));
	vec4 camToFragment = worldToView * worldPosition;
	cameraToFragment = camToFragment.rgb;
	gl_Position = viewToProjection * camToFragment;
	viewPosition = gl_Position;
	// gl_Position = vertex * localToWorld * worldToView * viewToProjection;
	//
#ifdef LIT
	/* first transform the normal into world space and
	   normalize the result */
	fragNormal = normalize((localToWorldAttrib * vec4(normal,0.0)).xyz);

	/* currently hardcoded to directional light, so the position field is
	 * actually direction */
	// lightDir = normalize(vec3(1.0,1.0,1.0));
	// lightDir = normalize(vec3(lightSource[0].position));

	/* Normalize the halfVector to pass it to the fragment shader */
	//halfVector = normalize(lightSource[0].halfVector.xyz);

	/* Compute the diffuse, ambient and globalAmbient terms */
	// diffuse = color * lightSource[0].diffuse;
	// ambient = color * lightSource[0].ambient;
	// ambient = vec4(0.1,0.1,0.1,1.0); //lightSource[0].ambient;
	/* ambient += gl_LightModel.ambient * gl_FrontMaterial.ambient; */

	local_light_pos = normalize(worldToView * vec4(lightSource[0].position.xyz, 0.0)).xyz;
	local_normal = (worldToView * vec4(fragNormal,0.0)).xyz;

#endif // LIT

	// fogFactor = 1.0;
	// if ( fog )
	// {
	// 	vec3 vVertex = vec3(gl_Position);
	// 	fragmentDistance = length(vVertex);
	// }
}


