#version 330
in vec2 texcoord_out;

uniform vec2 resolution;
uniform vec2 mouse;
uniform float globalTime;
uniform vec4 rezColor = vec4(0.0,1.0,1.0,0.5);


in vec4 frontColor;
out vec4 fragColor[2];

/////////////////////////////////////////////////////////////////////////////////
// The following are from https://www.shadertoy.com/view/4dS3Wd
float hash(float n) { return fract(sin(n) * 1e4); }
float hash(vec2 p) { return fract(1e4 * sin(17.0 * p.x + p.y * 0.1) * (0.1 + abs(sin(p.y * 13.0 + p.x)))); }
float noise(float x) { float i = floor(x); float f = fract(x); float u = f * f * (3.0 - 2.0 * f); return mix(hash(i), hash(i + 1.0), u); }
float noise(vec2 x) { vec2 i = floor(x); vec2 f = fract(x); float a = hash(i); float b = hash(i + vec2(1.0, 0.0)); float c = hash(i + vec2(0.0, 1.0)); float d = hash(i + vec2(1.0, 1.0)); vec2 u = f * f * (3.0 - 2.0 * f); return mix(a, b, u.x) + (c - a) * u.y * (1.0 - u.x) + (d - b) * u.x * u.y; }
float noise(vec3 x) { const vec3 step = vec3(110, 241, 171); vec3 i = floor(x); vec3 f = fract(x); float n = dot(i, step); vec3 u = f * f * (3.0 - 2.0 * f); return mix(mix(mix( hash(n + dot(step, vec3(0, 0, 0))), hash(n + dot(step, vec3(1, 0, 0))), u.x), mix( hash(n + dot(step, vec3(0, 1, 0))), hash(n + dot(step, vec3(1, 1, 0))), u.x), u.y), mix(mix( hash(n + dot(step, vec3(0, 0, 1))), hash(n + dot(step, vec3(1, 0, 1))), u.x), mix( hash(n + dot(step, vec3(0, 1, 1))), hash(n + dot(step, vec3(1, 1, 1))), u.x), u.y), u.z); }

void main()
{
	float rezExpandTime = 0.2;
	float rezFadeTime = 0.4;

	vec4 color = frontColor;
	vec3 glowColor = frontColor.rgb;
	vec3 finalColor = color.rgb;

	float time = mod(globalTime,10.0);

	float gridDims = 1.0;
	float delayPerGrid = 0.02;
	float halfGridDims = gridDims * 0.5;
	vec2 relativePosition = texcoord_out.st;
	relativePosition.s *= 4.0;
	relativePosition.t *= 4.0;

	uint xGridSquare = uint(floor(relativePosition.x / gridDims));
	uint yGridSquare = uint(floor(relativePosition.y / gridDims));
	vec2 gridCenter = vec2( (float(xGridSquare))*gridDims, (float(yGridSquare))*gridDims );
	float xGridPos = relativePosition.x - xGridSquare*gridDims;
	float yGridPos = relativePosition.y - yGridSquare*gridDims;

	float distanceFromGridEdge = min( xGridPos, yGridPos );
	distanceFromGridEdge = min( distanceFromGridEdge, gridDims - xGridPos );
	distanceFromGridEdge = min( distanceFromGridEdge, gridDims - yGridPos );
	distanceFromGridEdge = distanceFromGridEdge / halfGridDims; // [0..1] for 'grid edge' to 'center'

	// effect moves across the ground from +y to -y

	float extraDelay = noise( vec2(xGridSquare,yGridSquare) );
	extraDelay *= extraDelay * extraDelay;
	extraDelay *= 0.3; // rezExtraDelay

	finalColor.rgb *= 0.5 + (0.5 * smoothstep(0.0, 0.2, distanceFromGridEdge));
	vec4 thisRezColor = rezColor;
	thisRezColor.rgb *= 0.5 + (0.5 * smoothstep(0.0, 0.2, distanceFromGridEdge));

	float delay = (delayPerGrid * float(yGridSquare)) + extraDelay;

	float delta = time - delay;
	delta = mod(delta,2.0);

	if ( delta < 0 )
	{
	}
	else if ( delta < rezExpandTime )
	{
		float f = delta * (1.0 / rezExpandTime);
		// f = 3.0 * f * f - 2.0 * f * f * f;
		if ( f < 0 )
		{
			fragColor[0].rgba = vec4(1,0,0,1);
			fragColor[1].rgba = vec4(0);
			return;
		}

		/* f = 3.0 * f * f - 2.0 * f * f * f; */
		float distanceFromCenter = 1.0 - distanceFromGridEdge;
		if ( distanceFromCenter > f )
		{
			/* fragColor[1].rgba = vec4(0.0, 1.0-f, 1.0-f, color.a * 0.5 * (1.0-f)); */
			vec4 a = vec4(thisRezColor.rgb, thisRezColor.a * color.a);
			vec4 b = vec4(glowColor, color.a);
			fragColor[1].rgba = mix(a, b, f);
		}
		else
		{
			fragColor[1].rgba = vec4(glowColor, color.a);
		}
		fragColor[0].rgba = vec4(finalColor.rgb,color.a);
		return;
	}
	else if ( delta < rezFadeTime )
	{
		float thisPhaseTime = delta - rezExpandTime;
		thisPhaseTime = thisPhaseTime / (rezFadeTime - rezExpandTime);
		float f = 1.0 - thisPhaseTime;
		/* f = 3.0 * f * f - 2.0 * f * f * f; */
		/* float distanceFromCenter = 1.0 - distanceFromGridEdge; */
		if ( distanceFromGridEdge > f )
		{
			/* fragColor[1].rgba = vec4(0.0, 1.0-f, 1.0-f, color.a * 0.5 * (1.0-f)); */
			vec4 a = vec4(thisRezColor.rgb, thisRezColor.a * color.a);
			vec4 b = vec4(glowColor, color.a);
			fragColor[1].rgba = mix(a, b, f);
		}
		else
		{
			fragColor[1].rgba = vec4(glowColor, color.a);
		}
		fragColor[0].rgba = vec4(finalColor.rgb,color.a);
		return;
	}
	fragColor[0].rgba = vec4(finalColor, color.a);
	// fragColor[0].r = float(distanceFromGridEdge);//mod(relativePosition.y,1.0);
	fragColor[1].rgba = vec4(0.0);
	// fragColor = vec4(1.0,0.0,0.0,1.0);
}



