#version 330
in mat4 localToWorldAttrib;
uniform mat4 worldToView;
uniform mat4 viewToProjection;
in vec4 instanceColorAttrib;

uniform vec4 universal_color;

out vec3 cameraToFragment;
in vec4 vertex;
in vec3 normal;
in vec4 color;
in vec2 texcoord;

out vec4 frontColor;
out vec4 worldPosition;
out vec4 localPosition;
out vec2 texcoord_out;

void main(void)
{
	texcoord_out = texcoord;

	frontColor = instanceColorAttrib * color * universal_color;
	localPosition = vertex;
	worldPosition = localToWorldAttrib * vertex;
	gl_Position = viewToProjection * worldToView * worldPosition;
	cameraToFragment = vec3(gl_Position);
}

