#version 330
uniform float worldScale;
in vec4 worldPosition;
in vec2 texcoord_out;
out vec4 fragColor;

void main(void)
{
	vec2 worldTexel = worldPosition.xz / worldScale;

	// texcoord_out.x 0..1 is left to right across this path.

	float maskGrass = 2.0 * abs(0.5 - texcoord_out.x);
	maskGrass = clamp(maskGrass, 0.0, 1.0);

	vec4 color;
	color.rgb = vec3(1);
	color.a = maskGrass;
	fragColor.rgba = color;
}





