#version 330
#ifdef TEXTURE
uniform sampler2D textures[8];
in vec2 texcoord_out;
uniform float alphaRef;
#endif // TEXTURE

// in float fogFactor;
uniform float fogDensity;
uniform bool fog;
uniform float fade = 0.0;
in vec3 cameraToFragment;
// in float fragmentDistance;
uniform vec3 fogColor;
uniform bool glow;

in vec4 frontColor;
out vec4 fragColor[3];

in vec4 worldPosition;

// We have the originx and originy values from the rez2D_h include file.
// uniform float rezOriginX;
// uniform float rezOriginY;
// uniform bool rezReverse;
uniform float rezDestX;
uniform float rezDestY;

uniform float windowOriginX;
uniform float windowOriginY;
uniform float windowDimsX;
uniform float windowDimsY;

#include "rez2D_h.glsl"

void main(void)
{
	vec4 color = frontColor;
#ifdef TEXTURE
	vec4 textureSample = texture(textures[0], texcoord_out.st);
	if ( textureSample.a < alphaRef )
		discard;
	color *= textureSample;
#endif // TEXTURE

	float rezHeight = rezDestY - rezOriginY;

	// need to scale that position from pixels to [0..1]
	vec2 relativePositionInWindow = worldPosition.xy - vec2(windowOriginX, windowOriginY);
	relativePositionInWindow.xy /= vec2(windowDimsX, windowDimsY);

	// if ( rezReverse ) // bah.  Simpler to cope with this here than to change how rezReverse works
	// {
	// 	relativePositionInWindow.y = (worldPosition.y - rezDestY) / (rezOriginY - rezDestY);
    //
	// }

	// TODO:  These colors should be uniforms

	vec4 bright = vec4(0.023529, 0.313725, 0.560784, 1.f);
	vec4 dark = vec4(0.031373, 0.168627, 0.278431, 1.f);
	// vec4 dark = vec4(0.031373, 0.168627, 0.278431, 1.f);
	// vec4 bright = vec4(0.015686, 0.196078, 0.329412, 1.f);
	// vec4 dark = vec4(0.066667, 0.145098, 0.243137, 1.f);
	// vec4 bright = vec4(0.12f, 0.4f, 0.7f, 1.f);
	// vec4 dark = vec4(0.10f, 0.20f, 0.5f, 1.f);
	float gradientFraction = relativePositionInWindow.y; // [0..1]
	gradientFraction *= 2.0; // [0..2]
	gradientFraction -= 1.0; // [-1..1]
	gradientFraction = pow(abs(gradientFraction), 2.0);
	// gradientFraction *= gradientFraction;
	// gradientFraction = abs(gradientFraction); //[ 1 .. 0 .. 1]

	color.rgb = mix(dark,bright,gradientFraction).rgb;

	color.a *= (1.0-fade);

	if ( false )
	{
		float fragmentDistance = length(cameraToFragment);
		const float LOG2 = 1.442695;
		float fogFactor = exp2( -fogDensity *
				fogDensity *
				fragmentDistance *
				fragmentDistance *
				LOG2 );
		fogFactor = clamp(fogFactor,0.0,1.0);
		color.rgb = mix(fogColor.rgb, color.rgb, fogFactor );
	}
	vec4 glowColor = vec4(vec3(0.0),color.a);
	if ( glow )
		glowColor = color;


	vec4 finalColor;
	vec4 finalGlow;
	rez2D( worldPosition, color, glowColor, finalColor, finalGlow );

	fragColor[0].rgba = finalColor;
	fragColor[1].rgba = finalGlow;
	fragColor[2].rgba = vec4(0.0);
}


