#version 330
#ifdef TEXTURE
uniform sampler2D textures[8];
in vec2 texcoord_out;
uniform float alphaRef;
#endif // TEXTURE

// in float fogFactor;
uniform float fogDensity;
uniform bool fog;
in vec3 cameraToFragment;
// in float fragmentDistance;
uniform vec3 fogColor;
uniform bool rezEffect;
uniform float rezTime;
uniform float rezGridDims;
uniform float rezDelayPerGrid;
uniform float rezOriginX;
uniform float rezOriginY;
uniform float rezDuration;
uniform float rezDestX;
uniform float rezDestY;
uniform bool rezReverse;
uniform bool glow;

#ifdef LIT
struct lightSourceParameters
{
	vec4 ambient;              // Aclarri
	vec4 diffuse;              // Dcli
	vec4 specular;             // Scli
	vec3 position;             // Ppli
	vec3 halfVector;           // Derived: Hi
};

uniform lightSourceParameters lightSource[4];
in vec3 fragNormal;
#endif // LIT

in vec4 frontColor;
out vec4 fragColor[2];

in vec4 worldPosition;

void main(void)
{
	vec4 color = frontColor;
#ifdef TEXTURE
	vec4 textureSample = texture(textures[0], texcoord_out.st);
	if ( textureSample.a < alphaRef )
		discard;
	color *= textureSample;
#endif // TEXTURE

#ifdef LIT
	vec3 n = normalize(fragNormal);
	float NdotL = max(dot(n,lightSource[0].position)+1.0,0.0) * 0.5;

	if ( NdotL < 0.4 )
		NdotL = 0.2;

	vec4 ambientPart = color * lightSource[0].ambient;
	vec4 diffusePart = color * lightSource[0].diffuse * NdotL;
	color = ambientPart + diffusePart;
#endif // LIT

	vec3 finalColor = color.rgb;
	if ( fog )
	{
		float fragmentDistance = length(cameraToFragment);
		const float LOG2 = 1.442695;
		float fogFactor = exp2( -fogDensity *
				fogDensity *
				fragmentDistance *
				fragmentDistance *
				LOG2 );
		fogFactor = clamp(fogFactor, 0.0, 1.0);
		finalColor = mix(fogColor.rgb, color.rgb, fogFactor );
	}
	vec3 glowColor = vec3(0.0);
	if ( glow )
		glowColor = finalColor;

	if ( rezEffect )
	{
		float time = rezTime;//mod(rezTime,15.0);

		vec2 rezOrigin = vec2(rezOriginX, rezOriginY);
		vec2 rezDestination = vec2(rezDestX, rezDestY);

		float totalDistance = abs(rezDestX-rezOriginX) + abs(rezDestY-rezOriginY);
		float fadeDistance = totalDistance;
		float totalDuration = rezDuration;
		float rezSpeed = 2.0 * (totalDistance + fadeDistance) / totalDuration;
		float finishTime = (totalDistance + fadeDistance) / rezSpeed;
		if ( rezReverse )
		{
			float timeAtWhichWeFinish = totalDistance / rezSpeed;
			time = time - (rezDuration-finishTime);
			// rezOrigin.y = rezDestination.y;
			// rezDestination.y = rezOriginY;

			// time = totalDuration - time;
			/* relativePosition = rezDestination - worldPosition.xy; */
			/* time = rezDuration - time; */
			// time = rezTime - waitTimeAtEnd;
			// if ( rezDistance > thisDistance )
			// 	discard;
			// discard;
            //
			// float distanceSinceRez = rezDistance - thisDistance;
			// if ( distanceSinceRez > fadeDistance )
			// {
			// 	float bright = smoothstep( fadeDistance, 0.0, distanceSinceRez );
			// 	bright *= bright;
			// 	fragColor[0].rgba = vec4(finalColor, color.a);
			// 	fragColor[1].rgba = vec4(0.05,0.5,1.0, bright);
			// 	return;
			// }
		}
		vec2 relativePosition = worldPosition.xy - rezOrigin;
		float waitTimeAtEnd = totalDuration - finishTime;

		float rezDistance = time * rezSpeed;
		float thisDistance = relativePosition.x + relativePosition.y;

		// else
		{
			if ( rezDistance < thisDistance )
				discard;

			float distanceSinceRez = rezDistance - thisDistance;
			if ( distanceSinceRez < fadeDistance )
			{
				float bright = smoothstep( fadeDistance, 0.0, distanceSinceRez );
				if ( rezReverse )
					bright = 1.0 - bright;
				bright *= bright;
				fragColor[0].rgba = vec4(finalColor, color.a);
				fragColor[1].rgba = vec4(0.05,0.5,1.0, bright);
				return;
			}
		}




	}

	fragColor[0].rgba = vec4(finalColor, color.a);
	fragColor[1].rgba = vec4(glowColor, color.a);
	// fragColor = vec4(1.0,0.0,0.0,1.0);
}


