#version 330
uniform sampler2D height;
uniform float mapScale;
uniform float sampleOffset;

out vec4 fragColor;

in vec4 worldPosition;

void main(void)
{
	vec4 color = vec4(1);

	float off = sampleOffset / mapScale;
	vec2 worldTexel = worldPosition.xz / mapScale;

	float north = texture(height, worldTexel + vec2(0,off)).r;
	float south = texture(height, worldTexel + vec2(0,-off)).r;
	float west = texture(height, worldTexel + vec2(-off,0)).r;
	float east = texture(height, worldTexel + vec2(off,0)).r;

	vec3 eDir = vec3( sampleOffset * 2.0, east-west, 0.0 );
	vec3 nDir = vec3( 0.0, north-south, sampleOffset * 2.0 );

	eDir = normalize(eDir);
	nDir = normalize(nDir);

	vec3 normal = cross(nDir,eDir);
	// now we need to adjust from [-1..1] -> [0..1]

	normal = (normal + vec3(1.0)) * 0.5;

	fragColor.rgba = vec4( normal.xyz, 1.0 );
}


