#version 330
uniform sampler2D textures[8];
uniform float worldScale;
uniform float innerRadius;
uniform float outerRadius;
uniform vec3 center;
in vec4 worldPosition;
in vec2 texcoord_out;
out vec4 fragColor;

void main(void)
{
	vec2 worldTexel = worldPosition.xz / worldScale;
	// vec4 color = texture( textures[0],  worldTexel );

	vec2 delta = (worldPosition.xz - center.xz);
	float d = length(delta);

	float f = smoothstep(innerRadius, outerRadius, d);

	vec4 color;
	color.rgb = vec3(1);
	color.a = f;
	fragColor.rgba = color;
}

