#version 330
uniform sampler2D textures[8];
in vec2 texcoord_out;
uniform float alphaRef;

uniform samplerBuffer bufferTexture;

// in float fogFactor;
uniform float fogDensity;
uniform bool fog;
uniform vec3 cameraDirection;
// in float fragmentDistance;
uniform vec3 fogColor;
uniform bool glow;
uniform float globalTime;
uniform vec4 bandwidthColor;
uniform vec4 selectedColor;
uniform vec4 tint;
uniform bool cable;

in vec3 fragNormal;

in vec4 frontColor;
out vec4 fragColor[2];

in vec4 worldPosition;

/////////////////////////////////////////////////////////////////////////////////
// The following are from https://www.shadertoy.com/view/4dS3Wd
float hash(float n) { return fract(sin(n) * 1e4); }
float hash(vec2 p) { return fract(1e4 * sin(17.0 * p.x + p.y * 0.1) * (0.1 + abs(sin(p.y * 13.0 + p.x)))); }
float noise(float x) { float i = floor(x); float f = fract(x); float u = f * f * (3.0 - 2.0 * f); return mix(hash(i), hash(i + 1.0), u); }
float noise(vec2 x) { vec2 i = floor(x); vec2 f = fract(x); float a = hash(i); float b = hash(i + vec2(1.0, 0.0)); float c = hash(i + vec2(0.0, 1.0)); float d = hash(i + vec2(1.0, 1.0)); vec2 u = f * f * (3.0 - 2.0 * f); return mix(a, b, u.x) + (c - a) * u.y * (1.0 - u.x) + (d - b) * u.x * u.y; }
float noise(vec3 x) { const vec3 step = vec3(110, 241, 171); vec3 i = floor(x); vec3 f = fract(x); float n = dot(i, step); vec3 u = f * f * (3.0 - 2.0 * f); return mix(mix(mix( hash(n + dot(step, vec3(0, 0, 0))), hash(n + dot(step, vec3(1, 0, 0))), u.x), mix( hash(n + dot(step, vec3(0, 1, 0))), hash(n + dot(step, vec3(1, 1, 0))), u.x), u.y), mix(mix( hash(n + dot(step, vec3(0, 0, 1))), hash(n + dot(step, vec3(1, 0, 1))), u.x), mix( hash(n + dot(step, vec3(0, 1, 1))), hash(n + dot(step, vec3(1, 1, 1))), u.x), u.y), u.z); }

void main(void)
{
	vec4 color = frontColor * bandwidthColor;
// #ifdef TEXTURE
	// vec4 textureSample = texture(textures[0], texcoord_out.st);
	// if ( textureSample.a < alphaRef )
	// 	discard;
	// color *= textureSample;
	float bandwidthValueA = texelFetch(bufferTexture, int(floor(texcoord_out.t)) - 1).r;
	float bandwidthValueB = texelFetch(bufferTexture, int(floor(texcoord_out.t))).r;

	float abmix = fract(texcoord_out.t);
	float bandwidthValue = mix( bandwidthValueA, bandwidthValueB, abmix);
	// float bandwidthValue = texelFetch(bufferTexture, int(1)).r;

	vec3 zeroBandwidthColor = vec3(0.06,0.025,0.15);
	vec3 partialBandwidthColor = vec3(0.125,0.22,0.25);
	vec3 fullBandwidthColor = vec3(0.5,0.9,1.0);
	// bandwidthValue = clamp(bandwidthValue, 0.1, 0.9);

	zeroBandwidthColor.rgb = mix( zeroBandwidthColor.rgb, tint.rgb, tint.a );
	partialBandwidthColor.rgb = mix( partialBandwidthColor.rgb, tint.rgb, tint.a );
	fullBandwidthColor.rgb = mix( fullBandwidthColor.rgb, tint.rgb, tint.a );

	bandwidthValue = clamp(bandwidthValue, 0.0, 1.0);
	color.rgb = zeroBandwidthColor;

	vec3 normal = normalize(fragNormal);
	vec3 glowColor = color.rgb;

	// color.rgb = mix( zeroBandwidthColor, fullBandwidthColor, bandwidthValue );

	// if ( cable )
	{
		float threshhold = mix(0.95, 0.5, bandwidthValue);
		if ( normal.y > threshhold )
			glowColor.rgb = color.rgb = fullBandwidthColor;
		else if ( normal.y > 0.5 )
			glowColor.rgb = color.rgb = partialBandwidthColor;
	}
	// else
	if ( !cable )
	{
		if ( abmix > 0.8 )
		{
			color.rgb = zeroBandwidthColor;
			glowColor.rgb = vec3(0,0,0);
		}
		// if ( normal.y > 0.98 )
		// 	color.rgb = fullBandwidthColor;
		// else if ( normal.y > 0.6 && normal.y < 0.8 )
		// 	color.rgb = fullBandwidthColor;
	}

	// if ( normal.y > threshhold )
	// 		color.rgb = fullBandwidthColor;
	// if ( normal.y > 0.99f )
	// 		color.rgb = fullBandwidthColor;
	// if ( normal.y > 0.7f && normal.y < 0.8f )
	// 		color.rgb = fullBandwidthColor;

	// if ( texcoord_out.s > 6.0 && texcoord_out.s < 8.0 )
	// 	color.rgb = fullBandwidthColor;
	color.a = 1.0;
	color.rgb += selectedColor.rgb;
// #endif // TEXTURE


#ifdef LIT
	// vec3 n = normalize(fragNormal);
	// float NdotL = max(dot(n,lightSource[0].position)+1.0,0.0) * 0.5;

	// if ( NdotL < 0.4 )
	// 	NdotL = 0.2;

	// vec4 ambientPart = color * lightSource[0].ambient;
	// vec4 diffusePart = color * lightSource[0].diffuse * NdotL;
	// color = ambientPart + diffusePart;
#endif // LIT

	vec3 finalColor = color.rgb;
	// if ( fog )
	// {
	// 	float fragmentDistance = length(cameraToFragment);
	// 	const float LOG2 = 1.442695;
	// 	float fogFactor = exp2( -fogDensity *
	// 			fogDensity *
	// 			fragmentDistance *
	// 			fragmentDistance *
	// 			LOG2 );
	// 	fogFactor = clamp(fogFactor,0.0,1.0);
	// 	finalColor = mix(fogColor.rgb, color.rgb, fogFactor );
	// }

	float f = sin(mod(globalTime,3.1415)) * 0.2;

	// fragColor[0].rgba = vec4(1);
	fragColor[0].rgba = vec4(finalColor, color.a);
	fragColor[1].rgba = vec4(mix(vec3(0),glowColor,f), color.a);
	// fragColor = vec4(1.0,0.0,0.0,1.0);
}


