#version 330
uniform sampler2D textures[8];
in vec2 texcoord_out;
uniform float alphaRef;

// in float fogFactor;
uniform float fogDensity;
uniform bool fog;
in vec3 cameraToFragment;
// in float fragmentDistance;
uniform vec3 fogColor;
uniform float zNear;
uniform float zFar;
uniform float fade;

out vec4 fragColor[2];

in vec4 worldPosition;

/////////////////////////////////////////////////////////////////////////////////
// The following are from https://www.shadertoy.com/view/4dS3Wd
float hash(float n) { return fract(sin(n) * 1e4); }
float hash(vec2 p) { return fract(1e4 * sin(17.0 * p.x + p.y * 0.1) * (0.1 + abs(sin(p.y * 13.0 + p.x)))); }
float noise(float x) { float i = floor(x); float f = fract(x); float u = f * f * (3.0 - 2.0 * f); return mix(hash(i), hash(i + 1.0), u); }
float noise(vec2 x) { vec2 i = floor(x); vec2 f = fract(x); float a = hash(i); float b = hash(i + vec2(1.0, 0.0)); float c = hash(i + vec2(0.0, 1.0)); float d = hash(i + vec2(1.0, 1.0)); vec2 u = f * f * (3.0 - 2.0 * f); return mix(a, b, u.x) + (c - a) * u.y * (1.0 - u.x) + (d - b) * u.x * u.y; }
float noise(vec3 x) { const vec3 step = vec3(110, 241, 171); vec3 i = floor(x); vec3 f = fract(x); float n = dot(i, step); vec3 u = f * f * (3.0 - 2.0 * f); return mix(mix(mix( hash(n + dot(step, vec3(0, 0, 0))), hash(n + dot(step, vec3(1, 0, 0))), u.x), mix( hash(n + dot(step, vec3(0, 1, 0))), hash(n + dot(step, vec3(1, 1, 0))), u.x), u.y), mix(mix( hash(n + dot(step, vec3(0, 0, 1))), hash(n + dot(step, vec3(1, 0, 1))), u.x), mix( hash(n + dot(step, vec3(0, 1, 1))), hash(n + dot(step, vec3(1, 1, 1))), u.x), u.y), u.z); }

float linearDepth(float z)
{
	float Z = zFar * zNear / (zFar - z*(zFar-zNear));
	return Z;
}

void main(void)
{
	vec4 color = texture(textures[0], texcoord_out.st);
	vec4 glow = texture(textures[1], texcoord_out.st);
	float myDepthTex = texture(textures[2], texcoord_out.st).r;
	float worldDepthTex = texture(textures[3], texcoord_out.st).r;

	float myDepth = linearDepth(myDepthTex);
	float worldDepth = linearDepth(worldDepthTex);

	float min_depth_delta = 0.0;
	float max_depth_delta = 60.0 * smoothstep(0,1,fade);
	float f = myDepth - worldDepth;
	f = 1.0 - smoothstep(min_depth_delta, max_depth_delta, f);

	f = f * f;
	f = f * fade;// * fade;

	color.a *= f;
	glow.a *= f;

	fragColor[0] = color;
	fragColor[1] = glow;
}


