#version 330
uniform samplerBuffer polygons;
uniform int polygonsBufferSize;
uniform float mapScale;
uniform float mapOffset;
uniform float maxDistance;

in vec4 worldPosition;
in vec2 texcoord_out;
out vec4 fragColor;

float sqLength( vec2 vector )
{
	return dot(vector,vector);
}

void weight_here( vec2 position, vec2 a, vec2 b, out float sqDist, out float thickness )
{
	vec2 edgeDirection = vec2(b-a);
	float edgeLength = length(edgeDirection);
	edgeDirection *= (1.0 / edgeLength);

	vec2 delta = position - a;
	float projection = dot(delta, edgeDirection);
	projection = clamp(projection, 0.0, edgeLength);
	vec2 positionOnEdge = a + projection * edgeDirection;

	float sqMaxDistance = maxDistance * maxDistance;
	// First thing, let's see how close I am to either vertex.
	float sqDistanceFromVertex = min( sqLength(position-a), sqLength(position-b) );
	float edgeThicknessF = clamp(sqDistanceFromVertex / sqMaxDistance, 0.0, 1.0);//smoothstep( 0.0, maxDistance, distanceFromVertex );
	float edgeThicknessHere = mix( maxDistance*0.5, maxDistance*0.35, edgeThicknessF );

	sqDist = sqLength(position-positionOnEdge);
	thickness = edgeThicknessHere;
}

void main(void)
{
	int ind = 0;

	vec2 prev;
	vec2 next;
	float sqDistanceHere = maxDistance*maxDistance;
	float thicknessHere = 0.f;
	bool inside = false;

	vec2 posHere = worldPosition.xz;

	while ( ind < polygonsBufferSize )
	{
		prev.x = texelFetch(polygons, ind++).r;
		prev.y = texelFetch(polygons, ind++).r;
		next.x = texelFetch(polygons, ind++).r;
		next.y = texelFetch(polygons, ind++).r;

		float sqDist;
		float thickness;

		weight_here(posHere, prev, next, sqDist, thickness);

		sqDistanceHere = min( sqDistanceHere, sqDist );
		thicknessHere = max( thicknessHere, thickness );
	}

	float result = 0.0;
	if ( sqDistanceHere < thicknessHere * thicknessHere )
	{
		float distanceHere = sqrt(sqDistanceHere);

		float ff = clamp(0.f, distanceHere / thicknessHere, 1.f);
		ff = (3.0*ff*ff)-(2.0*ff*ff*ff);
		result = 1.0 - ff;
	}

	// vec2 foo = posHere / mapScale.x;
	fragColor.rgba = vec4(result, result, result, 1.0);
}




