#version 330

// uniform vec2 resolution;
uniform vec3 dims;// = vec2(500,500);
uniform vec2 mouse;
uniform float globalTime;

in vec4 frontColor;
in vec2 texcoord_out;
in vec4 worldPosition;
out vec4 fragColor[2];

uniform vec4 liquidColor;
uniform float timeOffset;
uniform float fill;

float noise(vec2 p, float time)
{
	return sin(p.x*10.) * sin(p.y*(3. + sin(time/11.))) + .2;
}

mat2 rotate(float angle)
{
	return mat2(cos(angle), -sin(angle), sin(angle), cos(angle));
}


float fbm(vec2 p, float time)
{
	float f = 0.;
	float amp = .5;
	for( int i = 0; i < 3; i++) {
		mat2 modify = rotate(time/50. * float(i*i));
		f += amp*noise(p, time);
		p = modify * p;
		p *= 2.;
		amp /= 2.2;
	}
	return f;
}

float pattern(vec2 p, out vec2 q, out vec2 r, float time) {
	q = vec2( fbm(p + vec2(1.), time),
			fbm(rotate(.1*time)*p + vec2(3.), time));
	r = vec2( fbm(rotate(.2)*q + vec2(0.), time),
			fbm(q + vec2(0.), time));
	return fbm(p + 1.0*r, time);
}

#include "rez2D_h.glsl"

float swirl( vec2 fragCoord, float time )
{
	vec2 p = fragCoord.xy * 0.001;
	p *= 3.0;
	p.y -= time * 0.002;
	vec2 q;
	vec2 r;
	float f = pattern(p, q, r, time);
	return f;
}

#define PI (3.1415927)
#define HALFPI (PI * 0.5)

void main()
{
	vec4 color = liquidColor;
	vec2 coord = texcoord_out;

	color.rgb = mix( color.rgb, color.rgb * 0.7, coord.x );

	vec3 outlineColor = liquidColor.rgb * 1.2;

	if ( coord.x < 1.0/dims.x )
		color.rgb = outlineColor;
	else if ( coord.x > 1.0 - (1.0/dims.x) )
		color.rgb = outlineColor;

	if ( coord.y < 1.0/dims.y )
		color.rgb = outlineColor;
	// if ( coord.y > 1.0 - (1.0/dims.y) )
	// 	color.rgb = outlineColor;

	float fillf = fill;

	if ( coord.y > fillf - (1.0/dims.y) )
	{
		if ( coord.y > fillf )
			color.rgb = mix( vec3(0.05), vec3(0.12), coord.x );
		else
			color.rgb = outlineColor;
	}

	// convert to cylindrical
	// coord.x = (2.0 * coord.x) - 1.0; // -1 .. 1
	// float angle = asin(coord.x); // -pi/2 .. pi/2
	// coord.x = (angle + HALFPI) / PI; // 0 .. 1
    //
	// vec2 fdims = dims.xy;
	// // if ( fdims == vec2(0) ) // TEMP, FOR TESTING!
	// // 	fdims = vec2(400.0);
    //
	// float fillf = fill;
	// // if ( fillf == 0.0 ) // TEMP, FOR TESTING!
	// // 	fillf = 0.5;
    //
	// float time = (globalTime + timeOffset) * 0.08;
	// // time = 0.0;
	// vec3 lcolor = liquidColor.rgb;
	// if ( lcolor == vec3(0) )
	// 	lcolor = vec3(0,0,0.4);
    //
	// vec3 highlightColor = lcolor * 1.0 + vec3(0.1);
    //
	// float froth = 1.0 / fdims.y + 0.5 / fdims.y * sin(37.0 * coord.x + globalTime) + 0.75 / fdims.y * sin(12.0 * coord.x - globalTime);
	// float distanceDownFromFroth = (fillf+froth) - (1.0-coord.y);
	// if ( distanceDownFromFroth > 0.0 )
	// {
    //
	// 	float result = swirl( -coord.yx * fdims.yx + vec2(0,-0.0 * globalTime), time );
    //
	// 	result = clamp(0.0,result,1.0);
	// 	result = pow(result,1.2);
    //
	// 	// color = vec4(vec3(result),1);
	// 	// result = result * result;
	// 	if ( result < 0.5 )
	// 	{
	// 		result = (result * 2.0);
	// 		color.rgb = mix( lcolor * 0.7, lcolor, result );
	// 		color.a = 1;
	// 	}
	// 	else
	// 	{
	// 		result = ((result - 0.5)* 2.0);
	// 		color = mix( vec4(lcolor * 0.8,1), vec4(highlightColor,1), result );
	// 	}
	// }
	// else
	// {
	// 	color = vec4(0.1,0.1,0.1,1.0);
	// }
    //
	// float nearSurface = smoothstep( 8.0 / fdims.y, 0.0, abs(distanceDownFromFroth) );
	// color.rgb += nearSurface * highlightColor * 0.2;
    //
	// nearSurface = smoothstep( 0.15, 0.0, abs(distanceDownFromFroth) );
	// color.rgb += nearSurface * highlightColor * 0.2;
	// nearSurface = smoothstep( 0.10, 0.0, abs(distanceDownFromFroth) );
	// color.rgb += nearSurface * highlightColor * 0.3;
    //
	// float nearBottom = smoothstep( 0.25, 0.0, abs((1.0 - coord.y) - (fillf*0.35) ) );
	// color.rgb += nearBottom * highlightColor * 0.3;
    //
	// // color.rgb = bubble(coord, fdims, color.rgb, time);
    //
	// float shadow = (0.5-coord.x) * 0.3;// / dims.y; //sin( 3.14159 * texcoord_out.y / (dims.y) );
    //
	// // if ( fract(coord.x * 3.0) > 0.5 )
	// // 	color.rgb += vec3(0.2);
    //
	// if ( coord.x < 0.5 )
	// 	color.rgb += vec3(shadow);//vec4((shadow) * 0.4);//mix( color, vec4(1,1,1,1), smoothstep(0.5, 0.0, shadow) * 0.5 );
	// // else
	// // 	color = mix( color, vec4(0,0,0,1), smoothstep(0.5, 0.0, shadow) * 0.5 );
    //
	// // fragColor[0] = vec4(vec3(result), 1.0);


	vec4 finalColor;
	vec4 finalGlow;
	rez2D( worldPosition, color, vec4(0,0,0,1), finalColor, finalGlow );
	// vec4 finalColor = color;
	// vec4 finalGlow = vec4(0,0,0,1);

	fragColor[0].rgba = finalColor;
	fragColor[1].rgba = finalGlow;

}


