#version 330
uniform sampler2D key;
uniform sampler2D map[4];
uniform float mapScale[4];
uniform vec3 origin;
uniform float texelSizeX;
uniform float texelSizeZ;

out vec4 fragColor;

in vec4 worldPosition;

void main(void)
{
	vec4 color = vec4(1);

	vec2 keyTexel = (worldPosition.xz - origin.xz) / vec2(texelSizeX,texelSizeZ);
	vec4 heights;

	vec4 key = texture(key, keyTexel);
	color *= key;

	vec2 worldTexel = worldPosition.xz;

	heights.r = texture(map[0], worldTexel / mapScale[0]).r;
	heights.g = texture(map[1], worldTexel / mapScale[1]).r;
	heights.b = texture(map[2], worldTexel / mapScale[2]).r;
	heights.a = texture(map[3], worldTexel / mapScale[3]).r;

	float result = (heights.r * key.r) +
		(heights.g * key.g) +
		(heights.b * key.b) +
		(heights.a * key.a);

	// HACK FOR VISIBILITY IN EXPORTED FILES:  TO REMOVE BEFORE USING THIS FOR REAL!
	// result = result / 400.0;

	// if ( worldPosition.x > worldPosition.z )
	// 	result = 600.0;
    //
	// if ( isinf(result) || isnan(result) )
	// 	result = 200.0;
    //
	// if ( result < 20.0 )
	// 	result = 20.0;
    //
	fragColor.rgba = vec4( vec3(result), 1.0 );
}


