#version 330
uniform bool glow;

in vec4 frontColor;
out vec4 fragColor[2];

in vec4 localPosition;
in vec4 worldPosition;

uniform float rowHeight;

#include "rez2D_h.glsl"

void main(void)
{
	vec4 color = frontColor;

	int x = int( floor((localPosition.y) / rowHeight) );
	if ( (x & 0x1) == 0 )
		discard;

	vec4 glowColor = vec4(vec3(0.0),color.a);
	if ( glow )
		glowColor = color;

	vec4 finalColor;
	vec4 finalGlow;
	rez2D( worldPosition, color, glowColor, finalColor, finalGlow );

	fragColor[0].rgba = finalColor;
	fragColor[1].rgba = finalGlow;
}


