#version 330
uniform sampler2D textures[8];
uniform float worldScale;
uniform float innerRadius;
uniform float outerRadius;
uniform vec3 center;
in vec4 worldPosition;
in vec2 texcoord_out;
out vec4 fragColor;

void main(void)
{
	vec2 worldTexel = center.xz / worldScale;
	float height = texture( textures[0],  worldTexel ).r;

	vec2 delta = (worldPosition.xz - center.xz);
	float d = length(delta);

	float f = smoothstep(outerRadius, innerRadius, d);
	// float f = 1.0 - clamp(0.0,1.0,(d - innerRadius) / (outerRadius - innerRadius));
	// float f = 0.0;
	// if ( d < innerRadius )
	// 	f = 1.0;
	// else if ( d < outerRadius )
	// 	f = 0.05;

	fragColor.rgba = vec4(vec3(height),f);
}






