#version 330
in mat4 localToWorldAttrib;
uniform mat4 worldToView;
uniform mat4 viewToProjection;
in vec4 instanceColorAttrib;
out vec4 worldPosition;

in vec4 vertex;
in vec4 color;

out vec4 frontColor;

void main(void)
{
	frontColor = instanceColorAttrib * color;
	worldPosition = localToWorldAttrib * vertex;
	gl_Position = viewToProjection * worldToView * worldPosition;
}

