#version 330
uniform vec2 resolution;
uniform vec2 mouse;
uniform float globalTime;

in vec4 frontColor;
in vec2 screenPosition;
out vec4 fragColor[2];

void main()
{
	const float gridSpacing = 200.0;
	const float lineWidth = 3.0;

	vec4 color = frontColor;
	vec4 glow = vec4(0,0,0,1);

	vec2 nowPos = screenPosition + vec2(globalTime * -20.0);

	if ( mod( nowPos.x + 50.0, gridSpacing ) < lineWidth ||
			mod( nowPos.y + 50.0, gridSpacing ) < lineWidth )
	{
		// color.rgb = vec3(0.5, 0.18, 0.0);
		glow = vec4(0.06, 0.02, 0.0, 1.0);
		// glow = color;
	}

	fragColor[0] = color;
	fragColor[1] = glow;
}


