#version 330
uniform sampler2D textures[8];
uniform vec3 overlayOrigin;
uniform float overlayDimensions;
in vec2 texcoord_out;

out vec4 fragColor[2];

void main(void)
{
	vec4 color;
	vec4 a = texture(textures[0], texcoord_out.st);

	// Okay.  texture 0 is the overlay.  We want to use all of it!
	// 'texture 1', on the other hand, is the whole world.  It uses coords [0-1]
	// to represent a [0..16384] area.  So let's scale the texture coordinates:

	vec2 worldStart = overlayOrigin.xz / 16384.0;
	float worldDimensions = overlayDimensions / 16384.0;

	vec2 worldTexcoord;
	worldTexcoord.s = worldStart.s + worldDimensions * texcoord_out.s;
	worldTexcoord.t = worldStart.t + worldDimensions * texcoord_out.t;

	vec4 b = texture(textures[1], worldTexcoord.st);

	// Okay, mix the colors
	color.a = b.a + (1.0 - b.a) * a.a;
	color.rgb = (b.a/color.a) * b.rgb + (a.a/color.a) * a.rgb;

	fragColor[0].rgba = color;
	// fragColor[0].rgba = vec4(1);
	// fragColor[0].r = worldTexcoord.s;
	// fragColor[0].a = 1.0;
	fragColor[1].rgba = vec4(0);
	// fragColor = vec4(1.0,0.0,0.0,1.0);
}


