#ifdef TEXTURE
uniform sampler2D source;
#endif // TEXTURE

uniform vec2 resolution;
uniform vec2 mouse;
uniform float globalTime;

uniform float alphaRef;
varying vec4 baseColor;

void main()
{	
	/* The ambient term will always be present */
	vec4 color = baseColor;

#ifdef TEXTURE
	vec4 textureSample = texture2D(source, gl_TexCoord[0].st - vec2(0.0,globalTime) );
	color *= textureSample;
#endif // TEXTURE
	if ( color.a < alphaRef )
		discard;

	gl_FragColor.rgba = color.rgba;

}

