#version 330
uniform bool fog;
uniform float fogDensity;
uniform mat4 localToWorld;
uniform mat4 worldToView;
uniform mat4 viewToProjection;
uniform float worldOffset;
uniform float invWorldDims;
uniform vec3 cameraPosition;

// out float fogFactor;
out vec3 cameraToFragment;
out vec3 reflectDirection;
out vec3 local_light_pos;
out vec3 local_normal;
out vec4 viewPosition;
in vec4 vertex;
/* in vec3 normal; */
uniform vec4 universal_color;

uniform float globalTime;
out vec2 fragTexCoord[4];
out vec4 frontColor;
out vec2 texel;
out float lightingAlpha;
out vec4 worldPosition;

struct lightSourceParameters
{
	vec4 ambient;              // Aclarri
	vec4 diffuse;              // Dcli
	vec4 specular;             // Scli
	vec3 position;             // Ppli
	vec3 halfVector;           // Derived: Hi
};

uniform lightSourceParameters lightSource[4];

void main(void)
{
	frontColor = universal_color;

	worldPosition = localToWorld * vertex;
	gl_Position = viewToProjection * worldToView * worldPosition;
	viewPosition = gl_Position;

	float off = 0.5/256.0;
	texel = (worldPosition.xz - vec2(worldOffset)) * invWorldDims + vec2(off);

	vec4 camToFragment = worldToView * worldPosition;
	cameraToFragment = camToFragment.rgb;
	float f = smoothstep( 4000.0, 10.0, cameraPosition.y );
	lightingAlpha = f * 0.2;

	local_light_pos = normalize(worldToView * vec4(lightSource[0].position.xyz, 0.0)).xyz;

	fragTexCoord[0] = worldPosition.xz * 0.0002 + vec2(-1.0,-4.0) * globalTime * 0.005;
	fragTexCoord[1] = worldPosition.zx * 0.0001 + vec2(-1.5,-2.5) * globalTime * 0.005;
	fragTexCoord[2] = worldPosition.xz * 0.004 + vec2(1.0,4.0) * globalTime * 0.01;
	fragTexCoord[3] = worldPosition.zx * 0.003 + vec2(5.0,2.0) * globalTime * 0.01;
}

