#version 330
uniform sampler2D textures[8];
in vec2 fragTexCoord[4];
uniform float fogDensity;
uniform bool fog;
in vec3 cameraToFragment;
in vec4 viewPosition;
uniform vec3 fogColor;
uniform float rezAlpha;
uniform float rezGlow;
uniform float darken;
uniform float worldOffset;
uniform float invWorldDims;
uniform float invMapDims;
uniform mat4 worldToView;

uniform float globalTime; // temp

uniform bool rezEffect;
uniform float rezTime;
uniform float rezGridDims = 400.0;
uniform float rezDelayPerGrid = 0.05;
uniform float rezOriginX = 0.0;
uniform float rezOriginY = 0.0;
uniform float rezOriginZ = 0.0;
uniform float rezExpandTime = 0.5;
uniform float rezFadeTime = 2.0;
uniform float rezRandomExtraDelay = 2.0;

in vec2 texel;

struct lightSourceParameters
{
	vec4 ambient;              // Aclarri
	vec4 diffuse;              // Dcli
	vec4 specular;             // Scli
	vec3 position;             // Ppli
	vec3 halfVector;           // Derived: Hi
};

uniform lightSourceParameters lightSource[4];

in float lightingAlpha;
in vec4 frontColor;
in vec4 worldPosition;
out vec4 fragColor[3];
in vec3 local_light_pos;
in vec3 local_normal;

/////////////////////////////////////////////////////////////////////////////////
// The following are from https://www.shadertoy.com/view/4dS3Wd
float hash(float n) { return fract(sin(n) * 1e4); }
float hash(vec2 p) { return fract(1e4 * sin(17.0 * p.x + p.y * 0.1) * (0.1 + abs(sin(p.y * 13.0 + p.x)))); }
float noise(float x) { float i = floor(x); float f = fract(x); float u = f * f * (3.0 - 2.0 * f); return mix(hash(i), hash(i + 1.0), u); }
float noise(vec2 x) { vec2 i = floor(x); vec2 f = fract(x); float a = hash(i); float b = hash(i + vec2(1.0, 0.0)); float c = hash(i + vec2(0.0, 1.0)); float d = hash(i + vec2(1.0, 1.0)); vec2 u = f * f * (3.0 - 2.0 * f); return mix(a, b, u.x) + (c - a) * u.y * (1.0 - u.x) + (d - b) * u.x * u.y; }
float noise(vec3 x) { const vec3 step = vec3(110, 241, 171); vec3 i = floor(x); vec3 f = fract(x); float n = dot(i, step); vec3 u = f * f * (3.0 - 2.0 * f); return mix(mix(mix( hash(n + dot(step, vec3(0, 0, 0))), hash(n + dot(step, vec3(1, 0, 0))), u.x), mix( hash(n + dot(step, vec3(0, 1, 0))), hash(n + dot(step, vec3(1, 1, 0))), u.x), u.y), mix(mix( hash(n + dot(step, vec3(0, 0, 1))), hash(n + dot(step, vec3(1, 0, 1))), u.x), mix( hash(n + dot(step, vec3(0, 1, 1))), hash(n + dot(step, vec3(1, 1, 1))), u.x), u.y), u.z); }

#ifdef LIT
#include "shade_h.glsl"
#include "shadow_h.glsl"
#endif // LIT

void main(void)
{
	vec4 color = frontColor;
	vec3 n = (2.0 * texture(textures[0], fragTexCoord[0].st).xzy) - vec3(1.0);
	n += (2.0 * texture(textures[0], fragTexCoord[1].st).xzy) - vec3(1.0);
	vec3 foon = n;
	n = mix( n, vec3(0.0,1.0,0.0), 0.9 );
	n = normalize(n);

	// Okay.  'distanceToLand' implies our basic color band.
	float distanceToLand = texture(textures[2], clamp( texel.st, vec2(0), vec2(1))).r * 10000.0;

	vec2 worldTexel = (worldPosition.xz + vec2(4.0)) * invMapDims;
	float heightAtPoint = texture(textures[3], clamp(worldTexel.st, vec2(0), vec2(1))).r;
	// We adjust it by the 'normal' so that it will tend to 'wobble' a bit as the normal
	// map moves over it.
	distanceToLand -= ((n.x + n.z) * 0.5);

	// if ( heightAtPoint < -5.0 )
	// 	discard;

	// float foamAmt = smoothstep(-0.92, -0.90, heightAtPoint + (foon.x + foon.z) * 0.4);
	float foamAmt = smoothstep(-0.92, -0.90, heightAtPoint + (foon.x + foon.z) * 0.4);

	// vec3 deepColor = vec3(1.0);
	vec3 deepColor = vec3( 0.082353, 0.45098, 0.517647 );
	// vec3 deepColor = vec3( 0.192157, 0.27451, 0.341176 );
	vec3 shallowColor = vec3( 0.094118, 0.464706, 0.558824 );
	// vec3 shallowColor = vec3(0.0);
	// float foamAmt = smoothstep( 200.0, 0.0, distanceToLand);
	float shallowAmt = smoothstep( 500.0, 1.0, distanceToLand);
	float deepAmt = smoothstep( 800.0, 6000.0, distanceToLand );
	// deepAmt *= deepAmt;
	float midAmt = 1.0 - (shallowAmt + deepAmt);// + foamAmt);

	// vec3 outerLight = vec3( 0.082353, 0.454902, 0.541176 );
	vec3 outerLight = vec3( 0.102941, 0.387647, 0.481765 );
	vec3 outerMid = vec3( 0.152941, 0.317647, 0.411765 );
	vec3 outerDark = vec3( 0.192157, 0.27451, 0.341176 );
	vec3 outerColor;

	{
		float t = deepAmt;
		float tSquared = deepAmt * deepAmt;
		float tCubed = tSquared * t;

		vec3 outerStartVel = outerMid - outerLight;
		vec3 outerEndVel = outerDark - outerMid;
		float a = 2.0 * tCubed - 3.0 * tSquared + 1.0;
		float b = tCubed - 2.0 * tSquared + t;
		float c = -2.0 * tCubed + 3.0 * tSquared;
		float d = tCubed - tSquared;

		outerColor = a * outerLight + b * outerStartVel + c * outerDark + d * outerEndVel;
	}
	color.rgb = mix( outerColor, shallowColor, shallowAmt );
	color.rgb = mix( color.rgb, vec3(1), foamAmt );

	// color.rgb = mix( color.rgb, color.rgb * 0.5, darken );

	// float f = smoothstep( 0.0, -10.0, heightAtPoint );
	// color.r = f;

	// blue channel <- green
	vec3 na = (2.0 * texture(textures[0], fragTexCoord[2].st).xzy) - vec3(1.0);
	// na = mix(na, vec3(0.0,1.0,0.0), 0.0);
	vec3 nb = (2.0 * texture(textures[0], fragTexCoord[3].st).xzy) - vec3(1.0);

	vec3 totN = normalize(na + nb);
	totN = mix( n, totN, lightingAlpha );

#if 0
	// float NdotL = max(dot(totN,lightSource[0].position)+1.0,0.0) * 0.5;
	float NdotL = max(dot(totN,lightSource[0].position)+1.0,0.0) * 0.5;
	// float NdotL = max(dot(totN,lightSource[0].position),0.0);

	/* if ( NdotL < 0.4 ) */
	/* 	NdotL = 0.2; */

	/* NdotL = mix( 1.0, NdotL, lightingAlpha ); */
	vec4 ambientPart = color * lightSource[0].ambient;
	vec4 diffusePart = color * lightSource[0].diffuse * NdotL; //mix(color, color * lightSource[0].diffuse * NdotL, 0.1);

	/* NdotL = dot(n, lightSource[0].position); */
	/* if (NdotL > 0.0) */
	{
		float specPower = 1000.0;
		vec3 cameraV = normalize(cameraToFragment);
		vec3 halfVector = normalize(lightSource[0].position) - cameraV;
		vec3 halfV = normalize(halfVector);
		float NdotHV = max(dot(totN,halfV),0.0);


		float base = 1.0 - dot(totN, -cameraV);
		float exponent = pow(base,5);
		float fresnel = exponent;// + 0.0 * (1.0 - exponent);

		diffusePart.rgb += 0.1 * NdotL * pow(NdotHV, specPower) * lightSource[0].specular.rgb;
		diffusePart.rgb += fresnel * vec3(0.1);
	}
	/* color.rgb = n; */
	color = ambientPart + diffusePart;
	/* color.rgb = normalize(cameraToFragment.rgb); */
	vec3 finalColor = color.rgb;
	if ( fog )
	{
		float fragmentDistance = length(cameraToFragment);
		const float LOG2 = 1.442695;
		float fogFactor = exp2( -fogDensity *
				fogDensity *
				fragmentDistance *
				fragmentDistance *
				LOG2 );
		fogFactor = clamp(fogFactor, 0.0, 1.0);
		finalColor = mix(fogColor.rgb, finalColor.rgb, mix(fogFactor,1.0,0.98) );
	}

#else

	float fogFactor = 1.0;
	if ( fog )
	{
		float fragmentDistance = length(cameraToFragment);
		const float LOG2 = 1.442695;
		fogFactor = exp2( -fogDensity *
				fogDensity *
				fragmentDistance *
				fragmentDistance *
				LOG2 );
		fogFactor = clamp(fogFactor, 0.0, 1.0);
		// finalColor = mix(fogColor.rgb, color.rgb, fogFactor );
	}
	vec3 N = normalize( (worldToView * vec4(totN,0.0)).xyz );
	// vec3 N = normalize( (worldToView * vec4(0,1,0,0.0)).xyz );
	// vec3 N = normalize(local_normal);
    vec3 L = normalize(local_light_pos);
    vec3 V = normalize(-cameraToFragment);
    vec3 H = normalize(L + V);


	float illuminated = calculate_shadow_illumination(worldPosition, dot(N,L));


// vec3 shade(vec3 color,
// 		vec3 N, vec3 L, vec3 V, vec3 H, float illuminated,
// 		float specular, float rimSpecular, float roughness, float specRoughness,
// 		vec3 fogColor, float fogAmt)
	float specular = 0.05;
	float rimSpecular = 1.0;
	float roughness = 0.5;
	float specRoughness = 0.4;
	float subsurface = 0.0;
	float clearcoat = 0.0;
	vec3 linearColor;
	vec3 finalColor = shade(color.rgb, linearColor, N, L, V, H, illuminated,
			specular, rimSpecular, roughness, specRoughness, subsurface, clearcoat,
			fogColor, 1.0 - fogFactor, false);
#endif

	if ( rezEffect )
	{
		float time = rezTime;
		/* float time = mod( globalTime, 8.0 ); */

		float gridDims = rezGridDims;
		float delayPerGrid = rezDelayPerGrid;
		float halfGridDims = gridDims * 0.5;
		float expandTime = rezExpandTime;
		float fadeTime = rezFadeTime;
		float randomExtraDelay = rezRandomExtraDelay;
		float originX = rezOriginX;
		float originY = rezOriginY;
		float originZ = rezOriginZ;
		vec3 relativePosition = worldPosition.xyz - vec3(originX, originY, originZ);

		float xGridSquare = floor(relativePosition.x / gridDims);
		float yGridSquare = floor(relativePosition.y / gridDims);
		float zGridSquare = floor(relativePosition.z / gridDims);

		// these positions are my position WITHIN MY GRID SQUARE.
		float xGridPos = relativePosition.x - xGridSquare*gridDims;
		float yGridPos = relativePosition.y - yGridSquare*gridDims;
		float zGridPos = relativePosition.z - zGridSquare*gridDims;

		// now I want the position of the grid square.
		vec2 gridCellPosition = vec2(
				xGridSquare * gridDims + originX,
				zGridSquare * gridDims + originZ );

		float off = 0.5/256.0;
		vec2 gridTexel = (gridCellPosition - vec2(worldOffset)) * invWorldDims + vec2(off);
		float distanceToLand = texture(textures[2], clamp( gridTexel.st, vec2(0), vec2(1))).r * 10000.0;
		/* distanceToLand *= 0.0001; */
		/* distanceToLand *= 0.01; */
		distanceToLand *= (1.0 / gridDims);

		/* fragColor[0].rgba = vec4(vec3(worldPosition) * invWorldDims, 1.0); */
		/* fragColor[0].rgba = vec4(vec3(float(xGridSquare) / 10.0,float(zGridSquare) / 10.0,0.0), 1.0); */
		/* fragColor[0].rgba = vec4(vec3(float(xGridSquare) / 10000.0,float(zGridSquare) / 10000.0,0.0), 1.0); */
		/* fragColor[0].rgba = vec4(vec3(distanceToLand), 1.0); */
		/* fragColor[1].rgba = vec4(vec3(0.0), 1.0); */
		/* return; */

		float distanceFromGridEdge = min( xGridPos, zGridPos);
		distanceFromGridEdge = min( distanceFromGridEdge, gridDims - xGridPos );
		distanceFromGridEdge = min( distanceFromGridEdge, gridDims - zGridPos );
		distanceFromGridEdge = distanceFromGridEdge / halfGridDims; // [0..1] for 'grid edge' to 'center'

		float extraDelay = noise( vec3(xGridSquare,yGridSquare, zGridSquare) );
		/* float extraDelay = float(munge) / 4294967295.0; */
		extraDelay *= extraDelay * extraDelay;
		extraDelay *= randomExtraDelay;

		// effect moves across the ground from -x to +x and -y to +y.
		float delay = (delayPerGrid * distanceToLand) + extraDelay;

		float delta = time - delay;

		if ( delta < 0 )
		{
			/* fragColor[0].rgba = vec4(1,0,0,1); */
			/* fragColor[1].rgba = vec4(0,0,0,1); */
			discard;
		}
		else if ( delta < expandTime )
		{
			float f = delta * (1.0 / expandTime);
			f = 3.0 * f * f - 2.0 * f * f * f;
			if ( distanceFromGridEdge > f )
				discard;

			fragColor[0].rgba = vec4(finalColor.rgb,f);
			fragColor[1].rgba = vec4(0.0, 1.0, 1.0, 0.5 * f);
			return;
		}
		else if ( delta < fadeTime )
		{
			float thisPhaseTime = delta - expandTime;
			thisPhaseTime = thisPhaseTime / (fadeTime - expandTime);
			float f = thisPhaseTime;
			f = 3.0 * f * f - 2.0 * f * f * f;
			float distanceFromCenter = 1.0 - distanceFromGridEdge;
			if ( distanceFromCenter > f )
			{
				fragColor[1].rgba = vec4(0.0, 1.0-f, 1.0-f, 0.5 * (1.0-f));
				/* fragColor[1].rgba = mix(vec4(0.0,1.0,1.0,0.5), vec4(finalColor.rgb * glow, 1.0), f); */
			}
			else
			{
				fragColor[1].rgba = vec4(finalColor.rgb * 0.0, 1.0);
			}
			fragColor[0].rgba = vec4(finalColor.rgb,1.0);
			return;
		}
	}

	if ( rezAlpha <= 0 )
		discard;

	fragColor[0].rgba = vec4(finalColor, 1.0);
	fragColor[1].rgba = vec4(vec3(rezGlow), rezGlow);
	fragColor[2].rgba = vec4(0.0,0.0,0.0,1.0);
}


