#version 330
#ifdef TEXTURE
uniform sampler2D textures[8];
in vec2 texcoord_out;
uniform float alphaRef;
#endif // TEXTURE

// in float fogFactor;
uniform float fogDensity;
uniform bool fog;
in vec3 cameraToFragment;
// in float fragmentDistance;
uniform vec3 fogColor;
uniform bool glow;
uniform vec4 tint;

#ifdef LIT
struct lightSourceParameters
{
	vec4 ambient;              // Aclarri
	vec4 diffuse;              // Dcli
	vec4 specular;             // Scli
	vec3 position;             // Ppli
	vec3 halfVector;           // Derived: Hi
};

uniform lightSourceParameters lightSource[4];
in vec3 fragNormal;
#endif // LIT

in vec4 frontColor;
out vec4 fragColor[3];

in vec4 worldPosition;

#include "rez2D_h.glsl"

void main(void)
{
	vec4 color = frontColor;
#ifdef TEXTURE
	vec4 textureSample = texture(textures[0], texcoord_out.st);
	if ( textureSample.a < alphaRef )
		discard;
	color *= textureSample;
#endif // TEXTURE
	color = mix( color, tint, tint.a );

#ifdef LIT
	vec3 n = normalize(fragNormal);
	float NdotL = max(dot(n,lightSource[0].position)+1.0,0.0) * 0.5;

	if ( NdotL < 0.4 )
		NdotL = 0.2;

	vec3 ambientPart = color.rgb * lightSource[0].ambient.rgb;
	vec3 diffusePart = color.rgb * lightSource[0].diffuse.rgb * NdotL;
	color.rgb = ambientPart + diffusePart;
#endif // LIT

	if ( false )
	{
		float fragmentDistance = length(cameraToFragment);
		const float LOG2 = 1.442695;
		float fogFactor = exp2( -fogDensity *
				fogDensity *
				fragmentDistance *
				fragmentDistance *
				LOG2 );
		fogFactor = clamp(fogFactor,0.0,1.0);
		color.rgb = mix(fogColor.rgb, color.rgb, fogFactor );
	}
	vec4 glowColor = vec4(vec3(0.0),color.a);
	if ( glow )
		glowColor = color;

#ifdef LIT
	fragColor[2].rgba = vec4(n,1.0);
#else
	fragColor[2].rgba = vec4(0.0);
#endif

	vec4 finalColor;
	vec4 finalGlow;
	rez2D( worldPosition, color, glowColor, finalColor, finalGlow );

	fragColor[0].rgba = finalColor;
	fragColor[1].rgba = finalGlow;
}


