#version 330
// This is the shader I used for big title text in the original Greenlight trailer.
//
#ifdef TEXTURE
uniform sampler2D textures[8];
in vec2 texcoord_out;
uniform float alphaRef;
uniform mat4 worldToView;
#endif // TEXTURE

// in float fogFactor;
uniform float fogDensity;
uniform bool fog;
in vec3 cameraToFragment;
// in float fragmentDistance;
uniform vec3 fogColor;
uniform bool glow;
uniform float globalTime;

in vec3 view_normal;

#ifdef LIT
struct lightSourceParameters
{
	vec4 ambient;              // Aclarri
	vec4 diffuse;              // Dcli
	vec4 specular;             // Scli
	vec3 position;             // Ppli
	vec3 halfVector;           // Derived: Hi
};

uniform lightSourceParameters lightSource[4];
in vec3 fragNormal;
in vec3 localPosition;
in vec3 local_light_pos;
#endif // LIT
in vec3 localNormal;

in vec4 frontColor;
out vec4 fragColor[3];

in vec4 worldPosition;

#include "rez3D_h.glsl"
#include "shade_h.glsl"

void main(void)
{
	vec4 color = vec4(1.0);
	if ( abs(localNormal.z) < 0.1 )
		color = vec4(0.4,0.0,0.0,1.0);
	else if ( abs(localNormal.z) > 0.9 )
		color = vec4(0.7,0.7,0.8,1.0);
	color *= frontColor;
#ifdef TEXTURE
	float env = texture(textures[0], texcoord_out.st).r;
	/* env = mix(env, 0.6, 1.0); */
	// color.rgb *= mix(1.0,env,0.01);
	color.rgb *= env;
#endif // TEXTURE

#ifdef LIT
	// vec3 n = normalize(fragNormal);
	// // n.y *= -1.0;
	// float NdotL = max(dot(n,lightSource[0].position)+1.0,0.0) * 0.5;
    //
	// if ( NdotL < 0.4 )
	// 	NdotL = 0.2;
    //
	// vec4 ambientPart = color * lightSource[0].ambient;
	// vec4 diffusePart = color * lightSource[0].diffuse * NdotL;
	// color = ambientPart + diffusePart;

	float fogFactor = 1.0;
	if ( fog )
	{
		float fragmentDistance = length(cameraToFragment);
		const float LOG2 = 1.442695;
		fogFactor = exp2( -fogDensity *
				fogDensity *
				fragmentDistance *
				fragmentDistance *
				LOG2 );
		fogFactor = clamp(fogFactor, 0.0, 1.0);
		// finalColor = mix(fogColor.rgb, color.rgb, fogFactor );
	}
	// vec3 N = normalize(localNormal);
	// vec3 L = normalize(local_light_pos);

	// NO!  N is in localspace, L (despite being called "local_light_pos") is in
	// viewspace, and V is also in viewspace.  That can't ever work properly!

	vec3 N = normalize(view_normal);
	vec3 L = normalize(local_light_pos);
	vec3 V = normalize(-cameraToFragment);
	vec3 H = normalize(L + V);
	float specular = min( length(color.rgb), 0.11 );
	float rimSpecular = 0.30;
	float roughness = 0.01;
	float subsurface = 0.0;
	float clearcoat = 0.5;
	vec3 linearColor;
	float illuminated = 1.0; // TODO:  Shadow here?

	color.rgb = shade(color.rgb, linearColor, N,L,V,H,
			illuminated, specular, rimSpecular, roughness, roughness,
			subsurface, clearcoat, fogColor.rgb, 1.0 - fogFactor, true);
	float nowGlow = max( 0.0, (length(linearColor.rgb) - 9.0)/10.0 );

#endif // LIT

	vec4 finalColor;
	vec4 finalGlow;
	rez3D( color, nowGlow, finalColor, finalGlow );

	fragColor[0].rgba = finalColor;
	fragColor[1].rgba = finalGlow;
	fragColor[2].rgba = vec4(0,0,0,1);
	// fragColor = vec4(1.0,0.0,0.0,1.0);
}


