#version 330
#ifdef TEXTURE
uniform sampler2D diffuse;
in vec2 texcoord_out;
uniform float alphaRef;
#endif // TEXTURE

// in float fogFactor;
uniform float fogDensity;
uniform float ssao_size;
uniform bool fog;
in vec3 cameraToFragment;
// in float fragmentDistance;
uniform vec3 fogColor;
uniform float glow;
uniform mat4 worldToView;
in vec4 viewPosition;
in vec3 local_light_pos;
in vec3 local_normal;
// in float rezThrough;


#ifdef LIT
struct lightSourceParameters
{
	vec4 ambient;              // Aclarri
	vec4 diffuse;              // Dcli
	vec4 specular;             // Scli
	vec3 position;             // Ppli
	vec3 halfVector;           // Derived: Hi
};

uniform lightSourceParameters lightSource[4];
in vec3 fragNormal;
#endif // LIT

in vec4 frontColor;
out vec4 fragColor[3];

in vec4 worldPosition;


#include "rez3D_h.glsl"
#ifdef LIT
#include "shade_h.glsl"
#include "shadow_h.glsl"
#endif // LIT

void main(void)
{
	// fragColor = vec4(1.0,0.0,0.0,1.0);
	vec4 color = frontColor;
#ifdef TEXTURE
	vec4 textureSample = texture(diffuse, texcoord_out.st);
	if ( textureSample.a < alphaRef )
		discard;
	color *= textureSample;
#endif // TEXTURE

	float fogFactor = 1.0;
	if ( fog )
	{
		float fragmentDistance = length(cameraToFragment);
		const float LOG2 = 1.442695;
		fogFactor = exp2( -fogDensity *
				fogDensity *
				fragmentDistance *
				fragmentDistance *
				LOG2 );
		fogFactor = clamp(fogFactor, 0.0, 1.0);
		// finalColor = mix(fogColor.rgb, color.rgb, fogFactor );
	}
#ifdef LIT
	vec3 n = normalize(fragNormal);
	float rawNdotL = dot(n,lightSource[0].position);
	float illuminated = calculate_shadow_illumination(worldPosition, rawNdotL);

	vec3 N = normalize(local_normal);
	vec3 L = normalize(local_light_pos);
	vec3 V = normalize(-cameraToFragment);
	vec3 H = normalize(L + V);
	float specular = min( length(color.rgb), 0.11 );
	float rimSpecular = 0.30;
	float roughness = 0.8;
	float subsurface = 0.0;
	float clearcoat = 0.1;
	vec3 linearColor;
	color.rgb = shade(color.rgb, linearColor, N,L,V,H,
			illuminated, specular, rimSpecular, roughness, roughness,
			subsurface, clearcoat, fogColor.rgb, 1.0 - fogFactor, true);
	float nowGlow = max( glow, (length(linearColor.rgb) - 9.0)/10.0 );
	// nowGlow = min(0.00001, nowGlow);
	// nowGlow = nowGlow * nowGlow;//sqrt(nowGlow);
	// nowGlow = sqrt(nowGlow);

#else // !LIT
	color.rgb = mix(fogColor.rgb, color.rgb, fogFactor );
	float nowGlow = 0.0;
#endif

	// float lum = dot(color.rgb, vec3(0.2989, 0.5870, 0.1140));

	vec4 finalColor;
	vec4 finalGlow;
	rez3D( color, nowGlow, finalColor, finalGlow );

	// float rezThrough = smoothstep( 3.0, 5.0, cameraToFragment.z );
	// float rezThrough = smoothstep( 7.0, 14.0, length(cameraToFragment.xyz) );
	// finalColor.a *= rezThrough;
	// if ( finalColor.a < 0.2 )
	// 	discard;

	fragColor[0].rgba = finalColor;
	fragColor[1].rgba = finalGlow;

#ifdef LIT
	// vec3 dx = dFdx( cameraToFragment );
	// vec3 dy = dFdy( cameraToFragment );
	// vec3 triangleN = -normalize(cross(dx,dy));

	// assume ssao_size is [0.1-5.0]
	vec3 mungedN =  N * (ssao_size/10.0);
	mungedN = (0.5 * mungedN) + vec3(0.5);
	fragColor[2].rgba = vec4( mungedN, 1.0);

	// fragColor[2].rgba = vec4( ssao_size * vec3(N), 1.0);
#else
	fragColor[2].rgba = vec4(0,0,0,1);
#endif // LIT
}


