#version 330
in vec2 texcoord_out;
in vec4 worldPosition;

uniform vec3 center;
uniform float timer;
uniform float duration;
uniform float gridDims;
uniform float radius;

out vec4 fragColor[2];

/////////////////////////////////////////////////////////////////////////////////
// The following are from https://www.shadertoy.com/view/4dS3Wd
float hash(float n) { return fract(sin(n) * 1e4); }
float hash(vec2 p) { return fract(1e4 * sin(17.0 * p.x + p.y * 0.1) * (0.1 + abs(sin(p.y * 13.0 + p.x)))); }
float noise(float x) { float i = floor(x); float f = fract(x); float u = f * f * (3.0 - 2.0 * f); return mix(hash(i), hash(i + 1.0), u); }
float noise(vec2 x) { vec2 i = floor(x); vec2 f = fract(x); float a = hash(i); float b = hash(i + vec2(1.0, 0.0)); float c = hash(i + vec2(0.0, 1.0)); float d = hash(i + vec2(1.0, 1.0)); vec2 u = f * f * (3.0 - 2.0 * f); return mix(a, b, u.x) + (c - a) * u.y * (1.0 - u.x) + (d - b) * u.x * u.y; }
// float noise(vec3 x) { const vec3 step = vec3(110, 241, 171); vec3 i = floor(x); vec3 f = fract(x); float n = dot(i, step); vec3 u = f * f * (3.0 - 2.0 * f); return mix(mix(mix( hash(n + dot(step, vec3(0, 0, 0))), hash(n + dot(step, vec3(1, 0, 0))), u.x), mix( hash(n + dot(step, vec3(0, 1, 0))), hash(n + dot(step, vec3(1, 1, 0))), u.x), u.y), mix(mix( hash(n + dot(step, vec3(0, 0, 1))), hash(n + dot(step, vec3(1, 0, 1))), u.x), mix( hash(n + dot(step, vec3(0, 1, 1))), hash(n + dot(step, vec3(1, 1, 1))), u.x), u.y), u.z); }

void rezcircle( in vec4 color, in float glow, out vec4 outcolor, out vec4 outglow )
{
	outcolor = color;
	outglow = vec4(color.rgb*glow, color.a);
	{
		float time = timer;
		/* float time = mod(globalTime,20.0); */

		float rezExpandTime = 0.15;
		float rezFadeTime = 0.4;

		// float gridDims = 8.0;//rezGridDims;
		float halfGridDims = gridDims * 0.5;
		vec3 relativePosition = worldPosition.xyz - center;

		float xGridSquare = floor(relativePosition.x / gridDims);
		float zGridSquare = floor(relativePosition.z / gridDims);
		float xGridPos = relativePosition.x - xGridSquare*gridDims;
		float zGridPos = relativePosition.z - zGridSquare*gridDims;

		float distanceFromGridEdge = min( xGridPos, zGridPos);
		distanceFromGridEdge = min( distanceFromGridEdge, gridDims - xGridPos );
		distanceFromGridEdge = min( distanceFromGridEdge, gridDims - zGridPos );
		distanceFromGridEdge = distanceFromGridEdge / halfGridDims; // [0..1] for 'grid edge' to 'center'

		float extraDelay = noise( vec2(xGridSquare,zGridSquare) );
		extraDelay *= extraDelay * extraDelay;
		extraDelay *= 0.5;//rezRandomExtraDelay;

		vec3 gridCellCenter = vec3(xGridSquare*gridDims, 0.0, zGridSquare*gridDims);
		float lengthFromCenter = length( gridCellCenter );
		float gridsFromCenter = lengthFromCenter / gridDims;

		// effect moves across the ground from -x to +x and -y to +y.
		float delay = 0.01 * gridsFromCenter + extraDelay;

		float delta = time - delay;

		// vec3 foo = relativePosition * 0.001;
		// vec3 foo = vec3(delta * 10000.0);
		// vec3 foo = vec3(lengthFromCenter * 0.001);
		// outcolor = vec4(foo,1.0);
		// //outcolor = vec4(delta,delta,delta,1.0);
		// outglow = vec4(delta,delta,delta,0.0);
		// return;

		vec3 rezColor = vec3(0.0,1.0,1.0);

		{
			// display grid structure.
			// fragColor[0].rgba = vec4(vec3(distanceFromGridEdge),1.0);
			// fragColor[1].rgba = vec4(0.0,0.0,0.0,1.0);
			// return;

				if ( distanceFromGridEdge > 0.5 )
					discard;

			if ( delta < 0 )
				discard;
			if ( delta < rezExpandTime )
			{
				float f = delta / rezExpandTime;
				// float f = smoothstep( 0.0, rezExpandTime, delta );
				// f = 3.0 * f * f - 2.0 * f * f * f;
				if ( distanceFromGridEdge > f )
					discard;

				outcolor.rgba = vec4(color.rgb,color.a * f);
				outglow.rgba = vec4(rezColor, 0.5 * color.a * f);
				return;
			}
			else if ( delta < rezFadeTime )
			{
				float thisPhaseTime = delta - rezExpandTime;
				thisPhaseTime = thisPhaseTime / (rezFadeTime - rezExpandTime);
				float f = thisPhaseTime;
				f = 3.0 * f * f - 2.0 * f * f * f;
				float distanceFromCenter = 1.0 - distanceFromGridEdge;
				if ( distanceFromCenter > f )
				{
					outglow.rgba = mix(vec4(rezColor,color.a*0.5), vec4(color.rgb, color.a), f);
					// discard;
				}
				else
				{
					// outglow.rgba = vec4(color.rgb*glow, color.a);
					discard;
				}
				outcolor.rgba = color;
				// return;
			}
			else
				discard;
		}
	}
}

void main(void)
{
	vec4 color = vec4(1.0);
	vec4 glowColor = vec4(vec3(1.0),color.a);

	// Okay.  Let's just draw a circle.

	float d = length( center.xz - worldPosition.xz );

	float circleDistance = 500.0 * timer;
	float visibility = 1.0;

	// if ( d > circleDistance )
	// 	visibility = smoothstep( circleDistance + 10.0, circleDistance, d );
	// else
	// 	visibility = smoothstep( circleDistance - 10.0, circleDistance, d );
    //
	// visibility *= (duration - timer) / duration;

	color.a = visibility;
	glowColor.a = visibility;

	vec4 finalColor;
	vec4 finalGlow;

	rezcircle( color, visibility, finalColor, finalGlow );

	float alpha = 1.0 - (d / radius);
	alpha = smoothstep(0.0,1.0,alpha);
	// alpha *= 0.1;
	finalColor.a *= alpha * 0.40;
	finalGlow.a *= alpha * 0.20;

	fragColor[0].rgba = finalColor;
	fragColor[1].rgba = finalGlow;
}


