#version 330
uniform sampler2D terrainHeightTexture;
uniform bool fog;
uniform float fogDensity;
in mat4 localToWorldAttrib;
uniform mat4 worldToView;
uniform mat4 viewToProjection;
uniform float invWorldDims;
uniform vec3 worldOffset;

out float fogFactor;
out vec4 worldPosition;
out vec4 viewPosition;
out vec3 cameraToFragment;
in vec3 vertex;

out vec2 fragTexcoord;
out vec2 microTexcoord;
out vec3 local_light_pos;

struct lightSourceParameters
{
	vec4 ambient;              // Aclarri
	vec4 diffuse;              // Dcli
	vec4 specular;             // Scli
	vec3 position;             // Ppli
	vec3 halfVector;           // Derived: Hi
};

uniform lightSourceParameters lightSource[4];

void main()
{
	worldPosition = localToWorldAttrib * vec4(vertex.xyz,1);

	vec3 worldOffsetHere = worldOffset;
	// worldOffsetHere.xz -= vec2(200);

	fragTexcoord = (worldPosition.xz + worldOffsetHere.xz) * invWorldDims;
	microTexcoord = fragTexcoord * 1024.0;

	worldPosition.y = texture(terrainHeightTexture, fragTexcoord.st).r;

	vec4 camToFragment = worldToView * worldPosition;
	cameraToFragment = camToFragment.rgb;
	gl_Position = viewToProjection * camToFragment;
	viewPosition = gl_Position;

	local_light_pos = (worldToView * vec4(lightSource[0].position.xyz, 0.0)).xyz;

	fogFactor = 1.0;
	if ( fog )
	{
		const float LOG2 = 1.442695;
		vec3 vVertex = vec3(gl_Position);
		float distance = length(vVertex);
		fogFactor = exp2( -fogDensity *
				fogDensity *
				distance *
				distance *
				LOG2 );
		fogFactor = clamp(fogFactor, 0.0, 1.0);
	}
}

