#version 330 core

#define SMAA_INCLUDE_PS 0
#include "smaa_config.glsl"
#include "smaa_h.glsl"

in mat4 localToWorldAttrib;
uniform mat4 worldToView;
uniform mat4 viewToProjection;
in vec4 vertex;
in vec2 texcoord;
out vec2 texcoord_out;
out vec4 offset;

void main()
{
	SMAANeighborhoodBlendingVS(texcoord, offset);
	texcoord_out = texcoord;
	vec4 worldPosition = localToWorldAttrib * vertex;
	gl_Position = viewToProjection * worldToView * worldPosition;
}

